/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.conf;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.service.ServiceTestUtils;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.ConfigFile;
import org.apache.hadoop.yarn.service.api.records.Configuration;
import org.apache.hadoop.yarn.service.api.records.Resource;
import org.apache.hadoop.yarn.service.api.records.ResourceInformation;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.conf.ExampleAppJson;
import org.apache.hadoop.yarn.service.utils.ServiceApiUtil;
import org.apache.hadoop.yarn.service.utils.SliderFileSystem;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAppJsonResolve {
    protected static final Logger LOG = LoggerFactory.getLogger(TestAppJsonResolve.class);

    @Test
    public void testOverride() throws Throwable {
        Service orig = ExampleAppJson.loadResource("app-override.json");
        Configuration global = orig.getConfiguration();
        Assertions.assertEquals((Object)"a", (Object)global.getProperty("g1"));
        Assertions.assertEquals((Object)"b", (Object)global.getProperty("g2"));
        Assertions.assertEquals((int)2, (int)global.getFiles().size());
        Configuration simple = orig.getComponent("simple").getConfiguration();
        Assertions.assertEquals((int)0, (int)simple.getProperties().size());
        Assertions.assertEquals((int)1, (int)simple.getFiles().size());
        Configuration master = orig.getComponent("master").getConfiguration();
        Assertions.assertEquals((Object)"m", (Object)master.getProperty("name"));
        Assertions.assertEquals((Object)"overridden", (Object)master.getProperty("g1"));
        Assertions.assertEquals((int)0, (int)master.getFiles().size());
        Configuration worker = orig.getComponent("worker").getConfiguration();
        LOG.info("worker = {}", (Object)worker);
        Assertions.assertEquals((int)3, (int)worker.getProperties().size());
        Assertions.assertEquals((int)0, (int)worker.getFiles().size());
        Assertions.assertEquals((Object)"worker", (Object)worker.getProperty("name"));
        Assertions.assertEquals((Object)"overridden-by-worker", (Object)worker.getProperty("g1"));
        Assertions.assertNull((Object)worker.getProperty("g2"));
        Assertions.assertEquals((Object)"1000", (Object)worker.getProperty("timeout"));
        SliderFileSystem sfs = ServiceTestUtils.initMockFs();
        ServiceApiUtil.validateAndResolveService((Service)orig, (SliderFileSystem)sfs, (org.apache.hadoop.conf.Configuration)new YarnConfiguration());
        global = orig.getConfiguration();
        LOG.info("global = {}", (Object)global);
        Assertions.assertEquals((Object)"a", (Object)global.getProperty("g1"));
        Assertions.assertEquals((Object)"b", (Object)global.getProperty("g2"));
        Assertions.assertEquals((int)2, (int)global.getFiles().size());
        simple = orig.getComponent("simple").getConfiguration();
        Assertions.assertEquals((int)2, (int)simple.getProperties().size());
        Assertions.assertEquals((Object)"a", (Object)simple.getProperty("g1"));
        Assertions.assertEquals((Object)"b", (Object)simple.getProperty("g2"));
        Assertions.assertEquals((int)2, (int)simple.getFiles().size());
        HashSet<ConfigFile> files = new HashSet<ConfigFile>();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("k1", "overridden");
        props.put("k2", "v2");
        files.add(new ConfigFile().destFile("file1").type(ConfigFile.TypeEnum.PROPERTIES).properties(props));
        files.add(new ConfigFile().destFile("file2").type(ConfigFile.TypeEnum.XML).properties(Collections.singletonMap("k3", "v3")));
        Assertions.assertTrue((boolean)files.contains(simple.getFiles().get(0)));
        Assertions.assertTrue((boolean)files.contains(simple.getFiles().get(1)));
        master = orig.getComponent("master").getConfiguration();
        LOG.info("master = {}", (Object)master);
        Assertions.assertEquals((int)3, (int)master.getProperties().size());
        Assertions.assertEquals((Object)"m", (Object)master.getProperty("name"));
        Assertions.assertEquals((Object)"overridden", (Object)master.getProperty("g1"));
        Assertions.assertEquals((Object)"b", (Object)master.getProperty("g2"));
        Assertions.assertEquals((int)2, (int)master.getFiles().size());
        props.put("k1", "v1");
        files.clear();
        files.add(new ConfigFile().destFile("file1").type(ConfigFile.TypeEnum.PROPERTIES).properties(props));
        files.add(new ConfigFile().destFile("file2").type(ConfigFile.TypeEnum.XML).properties(Collections.singletonMap("k3", "v3")));
        Assertions.assertTrue((boolean)files.contains(master.getFiles().get(0)));
        Assertions.assertTrue((boolean)files.contains(master.getFiles().get(1)));
        worker = orig.getComponent("worker").getConfiguration();
        LOG.info("worker = {}", (Object)worker);
        Assertions.assertEquals((int)4, (int)worker.getProperties().size());
        Assertions.assertEquals((Object)"worker", (Object)worker.getProperty("name"));
        Assertions.assertEquals((Object)"overridden-by-worker", (Object)worker.getProperty("g1"));
        Assertions.assertEquals((Object)"b", (Object)worker.getProperty("g2"));
        Assertions.assertEquals((Object)"1000", (Object)worker.getProperty("timeout"));
        Assertions.assertEquals((int)2, (int)worker.getFiles().size());
        Assertions.assertTrue((boolean)files.contains(worker.getFiles().get(0)));
        Assertions.assertTrue((boolean)files.contains(worker.getFiles().get(1)));
    }

    @Test
    public void testOverrideExternalConfiguration() throws IOException {
        Service orig = ExampleAppJson.loadResource("external1.json");
        Configuration global = orig.getConfiguration();
        Assertions.assertEquals((int)0, (int)global.getProperties().size());
        Assertions.assertEquals((int)3, (int)orig.getComponents().size());
        Configuration simple = orig.getComponent("simple").getConfiguration();
        Assertions.assertEquals((int)0, (int)simple.getProperties().size());
        Configuration master = orig.getComponent("master").getConfiguration();
        Assertions.assertEquals((int)1, (int)master.getProperties().size());
        Assertions.assertEquals((Object)"is-overridden", (Object)master.getProperty("g3"));
        Configuration other = orig.getComponent("other").getConfiguration();
        Assertions.assertEquals((int)0, (int)other.getProperties().size());
        SliderFileSystem sfs = ServiceTestUtils.initMockFs();
        Service ext = ExampleAppJson.loadResource("app.json");
        ServiceApiUtil.validateAndResolveService((Service)ext, (SliderFileSystem)sfs, (org.apache.hadoop.conf.Configuration)new YarnConfiguration());
        sfs = ServiceTestUtils.initMockFs(ext);
        ServiceApiUtil.validateAndResolveService((Service)orig, (SliderFileSystem)sfs, (org.apache.hadoop.conf.Configuration)new YarnConfiguration());
        global = orig.getConfiguration();
        Assertions.assertEquals((int)0, (int)global.getProperties().size());
        Assertions.assertEquals((int)4, (int)orig.getComponents().size());
        simple = orig.getComponent("simple").getConfiguration();
        Assertions.assertEquals((int)3, (int)simple.getProperties().size());
        Assertions.assertEquals((Object)"a", (Object)simple.getProperty("g1"));
        Assertions.assertEquals((Object)"b", (Object)simple.getProperty("g2"));
        Assertions.assertEquals((Object)"60", (Object)simple.getProperty("yarn.service.failure-count-reset.window"));
        master = orig.getComponent("master").getConfiguration();
        Assertions.assertEquals((int)5, (int)master.getProperties().size());
        Assertions.assertEquals((Object)"512M", (Object)master.getProperty("jvm.heapsize"));
        Assertions.assertEquals((Object)"overridden", (Object)master.getProperty("g1"));
        Assertions.assertEquals((Object)"b", (Object)master.getProperty("g2"));
        Assertions.assertEquals((Object)"is-overridden", (Object)master.getProperty("g3"));
        Assertions.assertEquals((Object)"60", (Object)simple.getProperty("yarn.service.failure-count-reset.window"));
        Configuration worker = orig.getComponent("worker").getConfiguration();
        LOG.info("worker = {}", (Object)worker);
        Assertions.assertEquals((int)4, (int)worker.getProperties().size());
        Assertions.assertEquals((Object)"512M", (Object)worker.getProperty("jvm.heapsize"));
        Assertions.assertEquals((Object)"overridden-by-worker", (Object)worker.getProperty("g1"));
        Assertions.assertEquals((Object)"b", (Object)worker.getProperty("g2"));
        Assertions.assertEquals((Object)"60", (Object)worker.getProperty("yarn.service.failure-count-reset.window"));
        Resource workerResource = orig.getComponent("worker").getResource();
        Assertions.assertEquals((int)1, (int)workerResource.getCpus());
        Assertions.assertEquals((long)1024L, (long)workerResource.calcMemoryMB());
        Assertions.assertNotNull((Object)workerResource.getAdditional());
        Assertions.assertEquals((int)2, (int)workerResource.getAdditional().size());
        Assertions.assertEquals((long)3333L, (long)((ResourceInformation)workerResource.getAdditional().get("resource-1")).getValue());
        Assertions.assertEquals((Object)"Gi", (Object)((ResourceInformation)workerResource.getAdditional().get("resource-1")).getUnit());
        Assertions.assertEquals((long)5L, (long)((ResourceInformation)workerResource.getAdditional().get("yarn.io/gpu")).getValue());
        Assertions.assertEquals((Object)"", (Object)((ResourceInformation)workerResource.getAdditional().get("yarn.io/gpu")).getUnit());
        other = orig.getComponent("other").getConfiguration();
        Assertions.assertEquals((int)0, (int)other.getProperties().size());
    }

    @Test
    public void testSetResourceAttributes() throws IOException {
        Service orig = ExampleAppJson.loadResource("external3.json");
        Component component = orig.getComponent("volume-service");
        Assertions.assertNotNull((Object)component);
        Map adResource = component.getResource().getAdditional();
        Assertions.assertNotNull((Object)adResource);
        Assertions.assertEquals((int)1, (int)adResource.size());
        Map.Entry volume = adResource.entrySet().iterator().next();
        Assertions.assertEquals((Object)"yarn.io/csi-volume", volume.getKey());
        Assertions.assertEquals((long)100L, (long)((ResourceInformation)volume.getValue()).getValue());
        Assertions.assertEquals((int)2, (int)((ResourceInformation)volume.getValue()).getAttributes().size());
        Assertions.assertEquals((int)1, (int)((ResourceInformation)volume.getValue()).getTags().size());
    }
}

