/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.component.instance;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalizationState;
import org.apache.hadoop.yarn.service.MockRunningServiceContext;
import org.apache.hadoop.yarn.service.ServiceContext;
import org.apache.hadoop.yarn.service.ServiceScheduler;
import org.apache.hadoop.yarn.service.ServiceTestUtils;
import org.apache.hadoop.yarn.service.TestServiceManager;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.ConfigFile;
import org.apache.hadoop.yarn.service.api.records.Configuration;
import org.apache.hadoop.yarn.service.api.records.Container;
import org.apache.hadoop.yarn.service.api.records.LocalizationStatus;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.component.Component;
import org.apache.hadoop.yarn.service.component.ComponentEvent;
import org.apache.hadoop.yarn.service.component.ComponentEventType;
import org.apache.hadoop.yarn.service.component.TestComponent;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceEvent;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceEventType;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceState;
import org.apache.hadoop.yarn.service.utils.ServiceUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestComponentInstance {
    @RegisterExtension
    private ServiceTestUtils.ServiceFSWatcher rule = new ServiceTestUtils.ServiceFSWatcher();

    @Test
    public void testContainerUpgrade() throws Exception {
        MockRunningServiceContext context = TestComponent.createTestContext(this.rule, "testContainerUpgrade");
        Component component = (Component)context.scheduler.getAllComponents().entrySet().iterator().next().getValue();
        this.upgradeComponent(component);
        ComponentInstance instance = (ComponentInstance)component.getAllComponentInstances().iterator().next();
        ComponentInstanceEvent instanceEvent = new ComponentInstanceEvent(instance.getContainer().getId(), ComponentInstanceEventType.UPGRADE);
        instance.handle(instanceEvent);
        Container containerSpec = component.getComponentSpec().getContainer(instance.getContainer().getId().toString());
        Assertions.assertEquals((Object)org.apache.hadoop.yarn.service.api.records.ContainerState.UPGRADING, (Object)containerSpec.getState(), (String)"instance not upgrading");
    }

    @Test
    public void testContainerReadyAfterUpgrade() throws Exception {
        MockRunningServiceContext context = TestComponent.createTestContext(this.rule, "testContainerReadyAfterUpgrade");
        Component component = (Component)context.scheduler.getAllComponents().entrySet().iterator().next().getValue();
        this.upgradeComponent(component);
        ComponentInstance instance = (ComponentInstance)component.getAllComponentInstances().iterator().next();
        ComponentInstanceEvent instanceEvent = new ComponentInstanceEvent(instance.getContainer().getId(), ComponentInstanceEventType.UPGRADE);
        instance.handle(instanceEvent);
        instance.handle(new ComponentInstanceEvent(instance.getContainer().getId(), ComponentInstanceEventType.START));
        Assertions.assertEquals((Object)org.apache.hadoop.yarn.service.api.records.ContainerState.RUNNING_BUT_UNREADY, (Object)component.getComponentSpec().getContainer(instance.getContainer().getId().toString()).getState(), (String)"instance not running");
        instance.handle(new ComponentInstanceEvent(instance.getContainer().getId(), ComponentInstanceEventType.BECOME_READY));
        Assertions.assertEquals((Object)org.apache.hadoop.yarn.service.api.records.ContainerState.READY, (Object)component.getComponentSpec().getContainer(instance.getContainer().getId().toString()).getState(), (String)"instance not ready");
    }

    @Test
    public void testContainerUpgradeFailed() throws Exception {
        MockRunningServiceContext context = TestComponent.createTestContext(this.rule, "testContainerUpgradeFailed");
        Component component = (Component)context.scheduler.getAllComponents().entrySet().iterator().next().getValue();
        this.upgradeComponent(component);
        ComponentInstance instance = (ComponentInstance)component.getAllComponentInstances().iterator().next();
        ComponentInstanceEvent upgradeEvent = new ComponentInstanceEvent(instance.getContainer().getId(), ComponentInstanceEventType.UPGRADE);
        instance.handle(upgradeEvent);
        ContainerStatus containerStatus = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        Mockito.when((Object)containerStatus.getExitStatus()).thenReturn((Object)-100);
        ComponentInstanceEvent stopEvent = new ComponentInstanceEvent(instance.getContainer().getId(), ComponentInstanceEventType.STOP).setStatus(containerStatus);
        instance.handle(stopEvent);
        Assertions.assertEquals((Object)org.apache.hadoop.yarn.service.api.records.ContainerState.FAILED_UPGRADE, (Object)component.getComponentSpec().getContainer(instance.getContainer().getId().toString()).getState(), (String)"instance did not fail");
    }

    @Test
    public void testFailureAfterReinit() throws Exception {
        MockRunningServiceContext context = TestComponent.createTestContext(this.rule, "testContainerUpgradeFailed");
        Component component = (Component)context.scheduler.getAllComponents().entrySet().iterator().next().getValue();
        this.upgradeComponent(component);
        ComponentInstance instance = (ComponentInstance)component.getAllComponentInstances().iterator().next();
        ComponentInstanceEvent upgradeEvent = new ComponentInstanceEvent(instance.getContainer().getId(), ComponentInstanceEventType.UPGRADE);
        instance.handle(upgradeEvent);
        instance.handle(new ComponentInstanceEvent(instance.getContainer().getId(), ComponentInstanceEventType.START));
        Assertions.assertEquals((Object)org.apache.hadoop.yarn.service.api.records.ContainerState.RUNNING_BUT_UNREADY, (Object)component.getComponentSpec().getContainer(instance.getContainer().getId().toString()).getState(), (String)"instance not running");
        ContainerStatus containerStatus = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        Mockito.when((Object)containerStatus.getExitStatus()).thenReturn((Object)-100);
        ComponentInstanceEvent stopEvent = new ComponentInstanceEvent(instance.getContainer().getId(), ComponentInstanceEventType.STOP).setStatus(containerStatus);
        instance.handle(stopEvent);
        Assertions.assertEquals((Object)org.apache.hadoop.yarn.service.api.records.ContainerState.FAILED_UPGRADE, (Object)component.getComponentSpec().getContainer(instance.getContainer().getId().toString()).getState(), (String)"instance did not fail");
    }

    @Test
    public void testCancelNothingToUpgrade() throws Exception {
        MockRunningServiceContext context = TestComponent.createTestContext(this.rule, "testCancelUpgradeWhenContainerReady");
        Component component = (Component)context.scheduler.getAllComponents().entrySet().iterator().next().getValue();
        this.cancelCompUpgrade(component);
        ComponentInstance instance = (ComponentInstance)component.getAllComponentInstances().iterator().next();
        ComponentInstanceEvent cancelEvent = new ComponentInstanceEvent(instance.getContainer().getId(), ComponentInstanceEventType.CANCEL_UPGRADE);
        instance.handle(cancelEvent);
        Assertions.assertEquals((Object)org.apache.hadoop.yarn.service.api.records.ContainerState.READY, (Object)component.getComponentSpec().getContainer(instance.getContainer().getId().toString()).getState(), (String)"instance not ready");
    }

    @Test
    public void testCancelUpgradeFailed() throws Exception {
        MockRunningServiceContext context = TestComponent.createTestContext(this.rule, "testCancelUpgradeFailed");
        Component component = (Component)context.scheduler.getAllComponents().entrySet().iterator().next().getValue();
        this.cancelCompUpgrade(component);
        ComponentInstance instance = (ComponentInstance)component.getAllComponentInstances().iterator().next();
        ComponentInstanceEvent cancelEvent = new ComponentInstanceEvent(instance.getContainer().getId(), ComponentInstanceEventType.CANCEL_UPGRADE);
        instance.handle(cancelEvent);
        instance.handle(new ComponentInstanceEvent(instance.getContainer().getId(), ComponentInstanceEventType.STOP));
        Assertions.assertEquals((Object)ComponentInstanceState.INIT, (Object)instance.getState(), (String)"instance not init");
    }

    @Test
    public void testCancelAfterCompProcessedCancel() throws Exception {
        MockRunningServiceContext context = TestComponent.createTestContext(this.rule, "testCancelAfterCompProcessedCancel");
        Component component = (Component)context.scheduler.getAllComponents().entrySet().iterator().next().getValue();
        this.upgradeComponent(component);
        this.cancelCompUpgrade(component);
        ComponentInstance instance = (ComponentInstance)component.getAllComponentInstances().iterator().next();
        ComponentInstanceEvent upgradeEvent = new ComponentInstanceEvent(instance.getContainer().getId(), ComponentInstanceEventType.UPGRADE);
        instance.handle(upgradeEvent);
        Assertions.assertEquals((Object)org.apache.hadoop.yarn.service.api.records.ContainerState.NEEDS_UPGRADE, (Object)component.getComponentSpec().getContainer(instance.getContainer().getId().toString()).getState(), (String)"instance should start upgrading");
    }

    @Test
    public void testCancelWhileUpgradeWithSuccess() throws Exception {
        this.validateCancelWhileUpgrading(true, true);
    }

    @Test
    public void testCancelWhileUpgradeWithFailure() throws Exception {
        this.validateCancelWhileUpgrading(false, true);
    }

    @Test
    public void testCancelFailedWhileUpgradeWithSuccess() throws Exception {
        this.validateCancelWhileUpgrading(true, false);
    }

    @Test
    public void testCancelFailedWhileUpgradeWithFailure() throws Exception {
        this.validateCancelWhileUpgrading(false, false);
    }

    @Test
    public void testUpdateLocalizationStatuses() throws Exception {
        Service def = TestServiceManager.createBaseDef("testUpdateLocalizationStatuses");
        String file1 = this.rule.getServiceBasePath().toString() + "/file1";
        Files.write(Paths.get(file1, new String[0]), "test file".getBytes(), StandardOpenOption.CREATE_NEW);
        org.apache.hadoop.yarn.service.api.records.Component compDef = (org.apache.hadoop.yarn.service.api.records.Component)def.getComponents().iterator().next();
        ConfigFile configFile1 = new ConfigFile();
        configFile1.setType(ConfigFile.TypeEnum.STATIC);
        configFile1.setSrcFile(file1);
        compDef.setConfiguration(new Configuration().files((List)Lists.newArrayList((Object[])new ConfigFile[]{configFile1})));
        MockRunningServiceContext context = new MockRunningServiceContext(this.rule, def);
        Component component = (Component)context.scheduler.getAllComponents().get(compDef.getName());
        ComponentInstance instance = (ComponentInstance)component.getAllComponentInstances().iterator().next();
        org.apache.hadoop.yarn.api.records.LocalizationStatus status = org.apache.hadoop.yarn.api.records.LocalizationStatus.newInstance((String)"file1", (LocalizationState)LocalizationState.PENDING);
        instance.updateLocalizationStatuses((List)Lists.newArrayList((Object[])new org.apache.hadoop.yarn.api.records.LocalizationStatus[]{status}));
        Assertions.assertTrue((boolean)instance.isLclRetrieverActive(), (String)"retriever should still be active");
        Container container = instance.getContainerSpec();
        Assertions.assertTrue((container.getLocalizationStatuses() != null ? 1 : 0) != 0);
        Assertions.assertEquals((Object)((LocalizationStatus)container.getLocalizationStatuses().get(0)).getDestFile(), (Object)status.getResourceKey(), (String)"dest file");
        Assertions.assertEquals((Object)((LocalizationStatus)container.getLocalizationStatuses().get(0)).getState(), (Object)status.getLocalizationState(), (String)"state");
        status = org.apache.hadoop.yarn.api.records.LocalizationStatus.newInstance((String)"file1", (LocalizationState)LocalizationState.COMPLETED);
        instance.updateLocalizationStatuses((List)Lists.newArrayList((Object[])new org.apache.hadoop.yarn.api.records.LocalizationStatus[]{status}));
        Assertions.assertTrue((!instance.isLclRetrieverActive() ? 1 : 0) != 0, (String)"retriever should not be active");
        Assertions.assertTrue((container.getLocalizationStatuses() != null ? 1 : 0) != 0);
        Assertions.assertEquals((Object)((LocalizationStatus)container.getLocalizationStatuses().get(0)).getDestFile(), (Object)status.getResourceKey(), (String)"dest file");
        Assertions.assertEquals((Object)((LocalizationStatus)container.getLocalizationStatuses().get(0)).getState(), (Object)status.getLocalizationState(), (String)"state");
    }

    private void validateCancelWhileUpgrading(boolean upgradeSuccessful, boolean cancelUpgradeSuccessful) throws Exception {
        MockRunningServiceContext context = TestComponent.createTestContext(this.rule, "testCancelWhileUpgrading");
        Component component = (Component)context.scheduler.getAllComponents().entrySet().iterator().next().getValue();
        this.upgradeComponent(component);
        ComponentInstance instance = (ComponentInstance)component.getAllComponentInstances().iterator().next();
        ComponentInstanceEvent upgradeEvent = new ComponentInstanceEvent(instance.getContainer().getId(), ComponentInstanceEventType.UPGRADE);
        instance.handle(upgradeEvent);
        Assertions.assertEquals((Object)org.apache.hadoop.yarn.service.api.records.ContainerState.UPGRADING, (Object)component.getComponentSpec().getContainer(instance.getContainer().getId().toString()).getState(), (String)"instance should be upgrading");
        this.cancelCompUpgrade(component);
        ComponentInstanceEvent cancelEvent = new ComponentInstanceEvent(instance.getContainer().getId(), ComponentInstanceEventType.CANCEL_UPGRADE);
        instance.handle(cancelEvent);
        if (upgradeSuccessful) {
            instance.handle(new ComponentInstanceEvent(instance.getContainer().getId(), ComponentInstanceEventType.START));
            instance.handle(new ComponentInstanceEvent(instance.getContainer().getId(), ComponentInstanceEventType.BECOME_READY));
        } else {
            instance.handle(new ComponentInstanceEvent(instance.getContainer().getId(), ComponentInstanceEventType.STOP));
        }
        Assertions.assertEquals((Object)org.apache.hadoop.yarn.service.api.records.ContainerState.UPGRADING, (Object)component.getComponentSpec().getContainer(instance.getContainer().getId().toString()).getState(), (String)"instance not upgrading");
        if (cancelUpgradeSuccessful) {
            instance.handle(new ComponentInstanceEvent(instance.getContainer().getId(), ComponentInstanceEventType.START));
            instance.handle(new ComponentInstanceEvent(instance.getContainer().getId(), ComponentInstanceEventType.BECOME_READY));
        } else {
            instance.handle(new ComponentInstanceEvent(instance.getContainer().getId(), ComponentInstanceEventType.STOP));
        }
        if (cancelUpgradeSuccessful) {
            Assertions.assertEquals((Object)org.apache.hadoop.yarn.service.api.records.ContainerState.READY, (Object)component.getComponentSpec().getContainer(instance.getContainer().getId().toString()).getState(), (String)"instance not ready");
        } else {
            Assertions.assertEquals((Object)ComponentInstanceState.INIT, (Object)instance.getState(), (String)"instance not init");
        }
    }

    private void upgradeComponent(Component component) {
        component.handle(new ComponentEvent(component.getName(), ComponentEventType.UPGRADE).setTargetSpec(component.getComponentSpec()).setUpgradeVersion("v2"));
    }

    private void cancelCompUpgrade(Component component) {
        component.handle(new ComponentEvent(component.getName(), ComponentEventType.CANCEL_UPGRADE).setTargetSpec(component.getComponentSpec()).setUpgradeVersion("v1"));
    }

    private Component createComponent(ServiceScheduler scheduler, Component.RestartPolicyEnum restartPolicy, int nSucceededInstances, int nFailedInstances, int totalAsk, int componentId) {
        ComponentInstance componentInstance;
        int i;
        assert (nSucceededInstances + nFailedInstances <= totalAsk);
        Component comp = (Component)Mockito.mock(Component.class);
        org.apache.hadoop.yarn.service.api.records.Component componentSpec = (org.apache.hadoop.yarn.service.api.records.Component)Mockito.mock(org.apache.hadoop.yarn.service.api.records.Component.class);
        Mockito.when((Object)componentSpec.getRestartPolicy()).thenReturn((Object)restartPolicy);
        Configuration conf = new Configuration();
        Mockito.when((Object)componentSpec.getConfiguration()).thenReturn((Object)conf);
        Mockito.when((Object)comp.getRestartPolicyHandler()).thenReturn((Object)Component.getRestartPolicyHandler((Component.RestartPolicyEnum)restartPolicy));
        Mockito.when((Object)componentSpec.getNumberOfContainers()).thenReturn((Object)totalAsk);
        Mockito.when((Object)comp.getComponentSpec()).thenReturn((Object)componentSpec);
        Mockito.when((Object)comp.getScheduler()).thenReturn((Object)scheduler);
        ConcurrentHashMap<String, ComponentInstance> succeeded = new ConcurrentHashMap<String, ComponentInstance>();
        ConcurrentHashMap<String, ComponentInstance> failed = new ConcurrentHashMap<String, ComponentInstance>();
        scheduler.getAllComponents().put("comp" + componentId, comp);
        HashMap<String, ComponentInstance> componentInstances = new HashMap<String, ComponentInstance>();
        for (i = 0; i < nSucceededInstances; ++i) {
            componentInstance = this.createComponentInstance(comp, i);
            componentInstances.put(componentInstance.getCompInstanceName(), componentInstance);
            succeeded.put(componentInstance.getCompInstanceName(), componentInstance);
        }
        for (i = 0; i < nFailedInstances; ++i) {
            componentInstance = this.createComponentInstance(comp, i + nSucceededInstances);
            componentInstances.put(componentInstance.getCompInstanceName(), componentInstance);
            failed.put(componentInstance.getCompInstanceName(), componentInstance);
        }
        int delta = totalAsk - nFailedInstances - nSucceededInstances;
        for (int i2 = 0; i2 < delta; ++i2) {
            ComponentInstance componentInstance2 = this.createComponentInstance(comp, i2 + nSucceededInstances + nFailedInstances);
            componentInstances.put(componentInstance2.getCompInstanceName(), componentInstance2);
        }
        Mockito.when((Object)comp.getAllComponentInstances()).thenReturn(componentInstances.values());
        Mockito.when((Object)comp.getSucceededInstances()).thenReturn(succeeded.values());
        Mockito.when((Object)comp.getFailedInstances()).thenReturn(failed.values());
        return comp;
    }

    private Component createComponent(ServiceScheduler scheduler, Component.RestartPolicyEnum restartPolicy, int totalAsk, int componentId) {
        Component comp = (Component)Mockito.mock(Component.class);
        org.apache.hadoop.yarn.service.api.records.Component componentSpec = (org.apache.hadoop.yarn.service.api.records.Component)Mockito.mock(org.apache.hadoop.yarn.service.api.records.Component.class);
        Mockito.when((Object)componentSpec.getRestartPolicy()).thenReturn((Object)restartPolicy);
        Configuration conf = new Configuration();
        Mockito.when((Object)componentSpec.getConfiguration()).thenReturn((Object)conf);
        Mockito.when((Object)comp.getRestartPolicyHandler()).thenReturn((Object)Component.getRestartPolicyHandler((Component.RestartPolicyEnum)restartPolicy));
        Mockito.when((Object)componentSpec.getNumberOfContainers()).thenReturn((Object)totalAsk);
        Mockito.when((Object)comp.getComponentSpec()).thenReturn((Object)componentSpec);
        Mockito.when((Object)comp.getScheduler()).thenReturn((Object)scheduler);
        scheduler.getAllComponents().put("comp" + componentId, comp);
        HashMap<String, ComponentInstance> componentInstances = new HashMap<String, ComponentInstance>();
        for (int i = 0; i < totalAsk; ++i) {
            ComponentInstance componentInstance = this.createComponentInstance(comp, i);
            componentInstances.put(componentInstance.getCompInstanceName(), componentInstance);
        }
        Mockito.when((Object)comp.getAllComponentInstances()).thenReturn(componentInstances.values());
        return comp;
    }

    private ComponentInstance createComponentInstance(Component component, int instanceId) {
        ComponentInstance componentInstance = (ComponentInstance)Mockito.mock(ComponentInstance.class);
        Mockito.when((Object)componentInstance.getComponent()).thenReturn((Object)component);
        Mockito.when((Object)componentInstance.getCompInstanceName()).thenReturn((Object)("compInstance" + instanceId));
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)componentInstance.getContainerSpec()).thenReturn((Object)container);
        ServiceUtils.ProcessTerminationHandler terminationHandler = (ServiceUtils.ProcessTerminationHandler)Mockito.mock(ServiceUtils.ProcessTerminationHandler.class);
        Mockito.when((Object)component.getScheduler().getTerminationHandler()).thenReturn((Object)terminationHandler);
        return componentInstance;
    }

    @Test
    public void testComponentRestartPolicy() {
        HashMap allComponents = new HashMap();
        Service mockService = (Service)Mockito.mock(Service.class);
        ServiceContext serviceContext = (ServiceContext)Mockito.mock(ServiceContext.class);
        Mockito.when((Object)serviceContext.getService()).thenReturn((Object)mockService);
        ServiceScheduler serviceSchedulerInstance = new ServiceScheduler(serviceContext);
        ServiceScheduler serviceScheduler = (ServiceScheduler)Mockito.spy((Object)serviceSchedulerInstance);
        Mockito.when((Object)serviceScheduler.getAllComponents()).thenReturn(allComponents);
        ((ServiceScheduler)Mockito.doNothing().when((Object)serviceScheduler)).setGracefulStop((FinalApplicationStatus)ArgumentMatchers.any(FinalApplicationStatus.class));
        String containerDiag = "Container succeeded";
        ComponentInstanceEvent componentInstanceEvent = (ComponentInstanceEvent)Mockito.mock(ComponentInstanceEvent.class);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1234L, (int)1), (int)1), (long)1L);
        ContainerStatus containerStatus = ContainerStatus.newInstance((ContainerId)containerId, (ContainerState)ContainerState.COMPLETE, (String)"Container succeeded", (int)0);
        Mockito.when((Object)componentInstanceEvent.getStatus()).thenReturn((Object)containerStatus);
        Component comp = this.createComponent(serviceScheduler, Component.RestartPolicyEnum.ALWAYS, 1, 0, 1, 0);
        ComponentInstance componentInstance = (ComponentInstance)comp.getAllComponentInstances().iterator().next();
        ComponentInstance.handleComponentInstanceRelaunch((ComponentInstance)componentInstance, (ComponentInstanceEvent)componentInstanceEvent, (boolean)false, (String)"Container succeeded");
        ((Component)Mockito.verify((Object)comp, (VerificationMode)Mockito.never())).markAsSucceeded((ComponentInstance)ArgumentMatchers.any(ComponentInstance.class));
        ((Component)Mockito.verify((Object)comp, (VerificationMode)Mockito.never())).markAsFailed((ComponentInstance)ArgumentMatchers.any(ComponentInstance.class));
        ((Component)Mockito.verify((Object)comp, (VerificationMode)Mockito.times((int)1))).reInsertPendingInstance((ComponentInstance)ArgumentMatchers.any(ComponentInstance.class));
        ((ServiceUtils.ProcessTerminationHandler)Mockito.verify((Object)serviceScheduler.getTerminationHandler(), (VerificationMode)Mockito.never())).terminate(ArgumentMatchers.anyInt());
        comp = this.createComponent(serviceScheduler, Component.RestartPolicyEnum.ALWAYS, 0, 1, 1, 0);
        componentInstance = (ComponentInstance)comp.getAllComponentInstances().iterator().next();
        containerStatus.setExitStatus(1);
        ComponentInstance.handleComponentInstanceRelaunch((ComponentInstance)componentInstance, (ComponentInstanceEvent)componentInstanceEvent, (boolean)false, (String)"Container succeeded");
        ((Component)Mockito.verify((Object)comp, (VerificationMode)Mockito.never())).markAsSucceeded((ComponentInstance)ArgumentMatchers.any(ComponentInstance.class));
        ((Component)Mockito.verify((Object)comp, (VerificationMode)Mockito.never())).markAsFailed((ComponentInstance)ArgumentMatchers.any(ComponentInstance.class));
        ((Component)Mockito.verify((Object)comp, (VerificationMode)Mockito.times((int)1))).reInsertPendingInstance((ComponentInstance)ArgumentMatchers.any(ComponentInstance.class));
        ((ServiceUtils.ProcessTerminationHandler)Mockito.verify((Object)serviceScheduler.getTerminationHandler(), (VerificationMode)Mockito.never())).terminate(ArgumentMatchers.anyInt());
        comp = this.createComponent(serviceScheduler, Component.RestartPolicyEnum.NEVER, 1, 0, 1, 0);
        componentInstance = (ComponentInstance)comp.getAllComponentInstances().iterator().next();
        containerStatus.setExitStatus(0);
        HashMap<String, ComponentInstance> succeededInstances = new HashMap<String, ComponentInstance>();
        succeededInstances.put(componentInstance.getCompInstanceName(), componentInstance);
        Mockito.when((Object)comp.getSucceededInstances()).thenReturn(succeededInstances.values());
        Mockito.when((Object)comp.getNumSucceededInstances()).thenReturn((Object)new Long(1L));
        ComponentInstance.handleComponentInstanceRelaunch((ComponentInstance)componentInstance, (ComponentInstanceEvent)componentInstanceEvent, (boolean)false, (String)"Container succeeded");
        ((Component)Mockito.verify((Object)comp, (VerificationMode)Mockito.times((int)1))).markAsSucceeded((ComponentInstance)ArgumentMatchers.any(ComponentInstance.class));
        ((Component)Mockito.verify((Object)comp, (VerificationMode)Mockito.never())).markAsFailed((ComponentInstance)ArgumentMatchers.any(ComponentInstance.class));
        ((Component)Mockito.verify((Object)comp, (VerificationMode)Mockito.times((int)0))).reInsertPendingInstance((ComponentInstance)ArgumentMatchers.any(ComponentInstance.class));
        ((ServiceUtils.ProcessTerminationHandler)Mockito.verify((Object)serviceScheduler.getTerminationHandler(), (VerificationMode)Mockito.times((int)1))).terminate(ArgumentMatchers.eq((int)0));
        comp = this.createComponent(serviceScheduler, Component.RestartPolicyEnum.NEVER, 0, 1, 1, 0);
        componentInstance = (ComponentInstance)comp.getAllComponentInstances().iterator().next();
        containerStatus.setExitStatus(-1);
        Mockito.when((Object)comp.getNumFailedInstances()).thenReturn((Object)new Long(1L));
        ComponentInstance.handleComponentInstanceRelaunch((ComponentInstance)componentInstance, (ComponentInstanceEvent)componentInstanceEvent, (boolean)false, (String)"Container succeeded");
        ((Component)Mockito.verify((Object)comp, (VerificationMode)Mockito.never())).markAsSucceeded((ComponentInstance)ArgumentMatchers.any(ComponentInstance.class));
        ((Component)Mockito.verify((Object)comp, (VerificationMode)Mockito.times((int)1))).markAsFailed((ComponentInstance)ArgumentMatchers.any(ComponentInstance.class));
        ((Component)Mockito.verify((Object)comp, (VerificationMode)Mockito.times((int)0))).reInsertPendingInstance((ComponentInstance)ArgumentMatchers.any(ComponentInstance.class));
        ((ServiceUtils.ProcessTerminationHandler)Mockito.verify((Object)serviceScheduler.getTerminationHandler(), (VerificationMode)Mockito.times((int)1))).terminate(ArgumentMatchers.eq((int)-1));
        comp = this.createComponent(serviceScheduler, Component.RestartPolicyEnum.ON_FAILURE, 0, 1, 1, 0);
        componentInstance = (ComponentInstance)comp.getAllComponentInstances().iterator().next();
        containerStatus.setExitStatus(1);
        ComponentInstance.handleComponentInstanceRelaunch((ComponentInstance)componentInstance, (ComponentInstanceEvent)componentInstanceEvent, (boolean)false, (String)"Container succeeded");
        ((Component)Mockito.verify((Object)comp, (VerificationMode)Mockito.never())).markAsSucceeded((ComponentInstance)ArgumentMatchers.any(ComponentInstance.class));
        ((Component)Mockito.verify((Object)comp, (VerificationMode)Mockito.never())).markAsFailed((ComponentInstance)ArgumentMatchers.any(ComponentInstance.class));
        ((Component)Mockito.verify((Object)comp, (VerificationMode)Mockito.times((int)1))).reInsertPendingInstance((ComponentInstance)ArgumentMatchers.any(ComponentInstance.class));
        ((ServiceUtils.ProcessTerminationHandler)Mockito.verify((Object)serviceScheduler.getTerminationHandler(), (VerificationMode)Mockito.times((int)0))).terminate(ArgumentMatchers.anyInt());
        comp = this.createComponent(serviceScheduler, Component.RestartPolicyEnum.NEVER, 0, 1, 3, 0);
        componentInstance = (ComponentInstance)comp.getAllComponentInstances().iterator().next();
        containerStatus.setExitStatus(1);
        ComponentInstance.handleComponentInstanceRelaunch((ComponentInstance)componentInstance, (ComponentInstanceEvent)componentInstanceEvent, (boolean)false, (String)"Container succeeded");
        ((Component)Mockito.verify((Object)comp, (VerificationMode)Mockito.never())).markAsSucceeded((ComponentInstance)ArgumentMatchers.any(ComponentInstance.class));
        ((Component)Mockito.verify((Object)comp, (VerificationMode)Mockito.times((int)1))).markAsFailed((ComponentInstance)ArgumentMatchers.any(ComponentInstance.class));
        ((Component)Mockito.verify((Object)comp, (VerificationMode)Mockito.times((int)0))).reInsertPendingInstance((ComponentInstance)ArgumentMatchers.any(ComponentInstance.class));
        ((ServiceUtils.ProcessTerminationHandler)Mockito.verify((Object)serviceScheduler.getTerminationHandler(), (VerificationMode)Mockito.times((int)0))).terminate(ArgumentMatchers.anyInt());
        comp = this.createComponent(serviceScheduler, Component.RestartPolicyEnum.ON_FAILURE, 0, 1, 3, 0);
        Iterator iter = comp.getAllComponentInstances().iterator();
        containerStatus.setExitStatus(1);
        ComponentInstance commponentInstance = (ComponentInstance)iter.next();
        ComponentInstance.handleComponentInstanceRelaunch((ComponentInstance)commponentInstance, (ComponentInstanceEvent)componentInstanceEvent, (boolean)false, (String)"Container succeeded");
        ((Component)Mockito.verify((Object)comp, (VerificationMode)Mockito.never())).markAsSucceeded((ComponentInstance)ArgumentMatchers.any(ComponentInstance.class));
        ((Component)Mockito.verify((Object)comp, (VerificationMode)Mockito.never())).markAsFailed((ComponentInstance)ArgumentMatchers.any(ComponentInstance.class));
        ((Component)Mockito.verify((Object)comp, (VerificationMode)Mockito.times((int)1))).reInsertPendingInstance((ComponentInstance)ArgumentMatchers.any(ComponentInstance.class));
        ((ServiceUtils.ProcessTerminationHandler)Mockito.verify((Object)serviceScheduler.getTerminationHandler(), (VerificationMode)Mockito.times((int)0))).terminate(ArgumentMatchers.anyInt());
        comp = this.createComponent(serviceScheduler, Component.RestartPolicyEnum.NEVER, 2, 0);
        Collection component1Instances = comp.getAllComponentInstances();
        containerStatus.setExitStatus(-1);
        Component comp2 = this.createComponent(componentInstance.getComponent().getScheduler(), Component.RestartPolicyEnum.NEVER, 2, 1);
        Collection component2Instances = comp2.getAllComponentInstances();
        HashMap<String, Object> failed2Instances = new HashMap<String, Object>();
        for (Object component2Instance : component2Instances) {
            failed2Instances.put(component2Instance.getCompInstanceName(), component2Instance);
            Mockito.when((Object)component2Instance.getComponent().getFailedInstances()).thenReturn(failed2Instances.values());
            Mockito.when((Object)component2Instance.getComponent().getNumFailedInstances()).thenReturn((Object)new Long(failed2Instances.size()));
            ComponentInstance.handleComponentInstanceRelaunch((ComponentInstance)component2Instance, (ComponentInstanceEvent)componentInstanceEvent, (boolean)false, (String)"Container succeeded");
        }
        HashMap<String, ComponentInstance> failed1Instances = new HashMap<String, ComponentInstance>();
        for (Object component1Instance : component1Instances) {
            failed1Instances.put(component1Instance.getCompInstanceName(), (ComponentInstance)component1Instance);
            Mockito.when((Object)component1Instance.getComponent().getFailedInstances()).thenReturn(failed1Instances.values());
            Mockito.when((Object)component1Instance.getComponent().getNumFailedInstances()).thenReturn((Object)new Long(failed1Instances.size()));
            ComponentInstance.handleComponentInstanceRelaunch((ComponentInstance)component1Instance, (ComponentInstanceEvent)componentInstanceEvent, (boolean)false, (String)"Container succeeded");
        }
        ((Component)Mockito.verify((Object)comp, (VerificationMode)Mockito.never())).markAsSucceeded((ComponentInstance)ArgumentMatchers.any(ComponentInstance.class));
        ((Component)Mockito.verify((Object)comp, (VerificationMode)Mockito.times((int)2))).markAsFailed((ComponentInstance)ArgumentMatchers.any(ComponentInstance.class));
        ((Component)Mockito.verify((Object)comp, (VerificationMode)Mockito.times((int)0))).reInsertPendingInstance((ComponentInstance)ArgumentMatchers.any(ComponentInstance.class));
        ((ServiceUtils.ProcessTerminationHandler)Mockito.verify((Object)serviceScheduler.getTerminationHandler(), (VerificationMode)Mockito.times((int)1))).terminate(ArgumentMatchers.eq((int)-1));
        containerStatus.setExitStatus(0);
        comp = this.createComponent(serviceScheduler, Component.RestartPolicyEnum.ON_FAILURE, 2, 0);
        component1Instances = comp.getAllComponentInstances();
        comp2 = this.createComponent(componentInstance.getComponent().getScheduler(), Component.RestartPolicyEnum.ON_FAILURE, 2, 1);
        component2Instances = comp2.getAllComponentInstances();
        HashMap<String, ComponentInstance> succeeded2Instances = new HashMap<String, ComponentInstance>();
        for (ComponentInstance component2Instance : component2Instances) {
            succeeded2Instances.put(component2Instance.getCompInstanceName(), component2Instance);
            Mockito.when((Object)component2Instance.getComponent().getSucceededInstances()).thenReturn(succeeded2Instances.values());
            Mockito.when((Object)component2Instance.getComponent().getNumSucceededInstances()).thenReturn((Object)new Long(succeeded2Instances.size()));
            ComponentInstance.handleComponentInstanceRelaunch((ComponentInstance)component2Instance, (ComponentInstanceEvent)componentInstanceEvent, (boolean)false, (String)"Container succeeded");
        }
        HashMap<String, ComponentInstance> succeeded1Instances = new HashMap<String, ComponentInstance>();
        for (ComponentInstance component1Instance : component1Instances) {
            succeeded1Instances.put(component1Instance.getCompInstanceName(), component1Instance);
            Mockito.when((Object)component1Instance.getComponent().getSucceededInstances()).thenReturn(succeeded1Instances.values());
            Mockito.when((Object)component1Instance.getComponent().getNumSucceededInstances()).thenReturn((Object)new Long(succeeded1Instances.size()));
            ComponentInstance.handleComponentInstanceRelaunch((ComponentInstance)component1Instance, (ComponentInstanceEvent)componentInstanceEvent, (boolean)false, (String)"Container succeeded");
        }
        ((Component)Mockito.verify((Object)comp, (VerificationMode)Mockito.times((int)2))).markAsSucceeded((ComponentInstance)ArgumentMatchers.any(ComponentInstance.class));
        ((Component)Mockito.verify((Object)comp, (VerificationMode)Mockito.never())).markAsFailed((ComponentInstance)ArgumentMatchers.any(ComponentInstance.class));
        ((Component)Mockito.verify((Object)componentInstance.getComponent(), (VerificationMode)Mockito.times((int)0))).reInsertPendingInstance((ComponentInstance)ArgumentMatchers.any(ComponentInstance.class));
        ((ServiceUtils.ProcessTerminationHandler)Mockito.verify((Object)serviceScheduler.getTerminationHandler(), (VerificationMode)Mockito.times((int)1))).terminate(ArgumentMatchers.eq((int)0));
        comp = this.createComponent(serviceScheduler, Component.RestartPolicyEnum.NEVER, 2, 0);
        component1Instances = comp.getAllComponentInstances();
        comp2 = this.createComponent(componentInstance.getComponent().getScheduler(), Component.RestartPolicyEnum.NEVER, 2, 1);
        component2Instances = comp2.getAllComponentInstances();
        for (ComponentInstance component2Instance : component2Instances) {
            ComponentInstance.handleComponentInstanceRelaunch((ComponentInstance)component2Instance, (ComponentInstanceEvent)componentInstanceEvent, (boolean)false, (String)"Container succeeded");
        }
        succeeded1Instances = new HashMap();
        for (ComponentInstance component1Instance : component1Instances) {
            succeeded1Instances.put(component1Instance.getCompInstanceName(), component1Instance);
            Mockito.when((Object)component1Instance.getComponent().getSucceededInstances()).thenReturn(succeeded1Instances.values());
            ComponentInstance.handleComponentInstanceRelaunch((ComponentInstance)component1Instance, (ComponentInstanceEvent)componentInstanceEvent, (boolean)false, (String)"Container succeeded");
        }
        ((Component)Mockito.verify((Object)comp, (VerificationMode)Mockito.times((int)2))).markAsSucceeded((ComponentInstance)ArgumentMatchers.any(ComponentInstance.class));
        ((Component)Mockito.verify((Object)comp, (VerificationMode)Mockito.never())).markAsFailed((ComponentInstance)ArgumentMatchers.any(ComponentInstance.class));
        ((Component)Mockito.verify((Object)componentInstance.getComponent(), (VerificationMode)Mockito.times((int)0))).reInsertPendingInstance((ComponentInstance)ArgumentMatchers.any(ComponentInstance.class));
        ((ServiceUtils.ProcessTerminationHandler)Mockito.verify((Object)serviceScheduler.getTerminationHandler(), (VerificationMode)Mockito.never())).terminate(ArgumentMatchers.eq((int)0));
    }
}

