/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.component;

import java.util.Iterator;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.service.MockRunningServiceContext;
import org.apache.hadoop.yarn.service.ServiceTestUtils;
import org.apache.hadoop.yarn.service.TestServiceManager;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.api.records.ServiceState;
import org.apache.hadoop.yarn.service.component.Component;
import org.apache.hadoop.yarn.service.component.ComponentEvent;
import org.apache.hadoop.yarn.service.component.ComponentEventType;
import org.apache.hadoop.yarn.service.component.ComponentState;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceEvent;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceEventType;
import org.apache.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestComponent {
    static final Logger LOG = Logger.getLogger(TestComponent.class);
    @RegisterExtension
    private ServiceTestUtils.ServiceFSWatcher rule = new ServiceTestUtils.ServiceFSWatcher();

    @Test
    public void testComponentUpgrade() throws Exception {
        MockRunningServiceContext context = TestComponent.createTestContext(this.rule, "testComponentUpgrade");
        Component comp = (Component)context.scheduler.getAllComponents().entrySet().iterator().next().getValue();
        ComponentEvent upgradeEvent = new ComponentEvent(comp.getName(), ComponentEventType.UPGRADE);
        comp.handle(upgradeEvent);
        Assertions.assertEquals((Object)org.apache.hadoop.yarn.service.api.records.ComponentState.NEEDS_UPGRADE, (Object)comp.getComponentSpec().getState(), (String)"component not in need upgrade state");
    }

    @Test
    public void testCheckState() throws Exception {
        String serviceName = "testCheckState";
        MockRunningServiceContext context = TestComponent.createTestContext(this.rule, serviceName);
        Component comp = (Component)context.scheduler.getAllComponents().entrySet().iterator().next().getValue();
        comp.handle(new ComponentEvent(comp.getName(), ComponentEventType.UPGRADE).setTargetSpec(TestComponent.createSpecWithEnv(serviceName, comp.getName(), "key1", "val1")).setUpgradeVersion("v2"));
        comp.getUpgradeStatus().decContainersThatNeedUpgrade();
        comp.handle(new ComponentEvent(comp.getName(), ComponentEventType.CHECK_STABLE));
        Assertions.assertEquals((Object)org.apache.hadoop.yarn.service.api.records.ComponentState.NEEDS_UPGRADE, (Object)comp.getComponentSpec().getState(), (String)"component not in need upgrade state");
        comp.getUpgradeStatus().decContainersThatNeedUpgrade();
        comp.handle(new ComponentEvent(comp.getName(), ComponentEventType.CHECK_STABLE));
        Assertions.assertEquals((Object)org.apache.hadoop.yarn.service.api.records.ComponentState.STABLE, (Object)comp.getComponentSpec().getState(), (String)"component not in stable state");
        Assertions.assertEquals((Object)"val1", (Object)comp.getComponentSpec().getConfiguration().getEnv("key1"), (String)"component did not upgrade successfully");
    }

    @Test
    public void testContainerCompletedWhenUpgrading() throws Exception {
        String serviceName = "testContainerCompletedWhenUpgrading";
        MockRunningServiceContext context = TestComponent.createTestContext(this.rule, serviceName);
        Component comp = (Component)context.scheduler.getAllComponents().entrySet().iterator().next().getValue();
        comp.handle(new ComponentEvent(comp.getName(), ComponentEventType.UPGRADE).setTargetSpec(TestComponent.createSpecWithEnv(serviceName, comp.getName(), "key1", "val1")).setUpgradeVersion("v2"));
        comp.getAllComponentInstances().forEach(instance -> instance.handle(new ComponentInstanceEvent(instance.getContainer().getId(), ComponentInstanceEventType.UPGRADE)));
        for (ComponentInstance instance2 : comp.getAllComponentInstances()) {
            ComponentEvent stopEvent = new ComponentEvent(comp.getName(), ComponentEventType.CONTAINER_COMPLETED).setInstance(instance2).setContainerId(instance2.getContainer().getId());
            comp.handle(stopEvent);
            instance2.handle(new ComponentInstanceEvent(instance2.getContainer().getId(), ComponentInstanceEventType.STOP));
        }
        comp.handle(new ComponentEvent(comp.getName(), ComponentEventType.CHECK_STABLE));
        Assertions.assertEquals((Object)org.apache.hadoop.yarn.service.api.records.ComponentState.NEEDS_UPGRADE, (Object)comp.getComponentSpec().getState(), (String)"component not in needs upgrade state");
    }

    @Test
    public void testCancelUpgrade() throws Exception {
        MockRunningServiceContext context = TestComponent.createTestContext(this.rule, "testCancelUpgrade");
        Component comp = (Component)context.scheduler.getAllComponents().entrySet().iterator().next().getValue();
        ComponentEvent upgradeEvent = new ComponentEvent(comp.getName(), ComponentEventType.CANCEL_UPGRADE);
        comp.handle(upgradeEvent);
        Assertions.assertEquals((Object)org.apache.hadoop.yarn.service.api.records.ComponentState.NEEDS_UPGRADE, (Object)comp.getComponentSpec().getState(), (String)"component not in need upgrade state");
        Assertions.assertEquals((Object)ComponentState.CANCEL_UPGRADING, (Object)comp.getState());
    }

    @Test
    public void testContainerCompletedCancelUpgrade() throws Exception {
        String serviceName = "testContainerCompletedCancelUpgrade";
        MockRunningServiceContext context = TestComponent.createTestContext(this.rule, serviceName);
        Component comp = (Component)context.scheduler.getAllComponents().entrySet().iterator().next().getValue();
        comp.handle(new ComponentEvent(comp.getName(), ComponentEventType.UPGRADE).setTargetSpec(TestComponent.createSpecWithEnv(serviceName, comp.getName(), "key1", "val1")).setUpgradeVersion("v2"));
        comp.getAllComponentInstances().forEach(instance -> instance.handle(new ComponentInstanceEvent(instance.getContainer().getId(), ComponentInstanceEventType.UPGRADE)));
        for (ComponentInstance instance2 : comp.getAllComponentInstances()) {
            instance2.handle(new ComponentInstanceEvent(instance2.getContainer().getId(), ComponentInstanceEventType.START));
            instance2.handle(new ComponentInstanceEvent(instance2.getContainer().getId(), ComponentInstanceEventType.BECOME_READY));
        }
        comp.handle(new ComponentEvent(comp.getName(), ComponentEventType.CANCEL_UPGRADE).setTargetSpec(TestComponent.createSpecWithEnv(serviceName, comp.getName(), "key1", "val0")).setUpgradeVersion("v1"));
        comp.getAllComponentInstances().forEach(instance -> instance.handle(new ComponentInstanceEvent(instance.getContainer().getId(), ComponentInstanceEventType.CANCEL_UPGRADE)));
        Iterator iter = comp.getAllComponentInstances().iterator();
        ComponentInstance instance1 = (ComponentInstance)iter.next();
        ComponentEvent stopEvent = new ComponentEvent(comp.getName(), ComponentEventType.CONTAINER_COMPLETED).setInstance(instance1).setContainerId(instance1.getContainer().getId());
        comp.handle(stopEvent);
        instance1.handle(new ComponentInstanceEvent(instance1.getContainer().getId(), ComponentInstanceEventType.STOP));
        Assertions.assertEquals((Object)ComponentState.CANCEL_UPGRADING, (Object)comp.getState());
        comp.handle(new ComponentEvent(comp.getName(), ComponentEventType.CHECK_STABLE));
        Assertions.assertEquals((Object)org.apache.hadoop.yarn.service.api.records.ComponentState.NEEDS_UPGRADE, (Object)comp.getComponentSpec().getState(), (String)"component not in needs upgrade state");
        Assertions.assertEquals((Object)ComponentState.CANCEL_UPGRADING, (Object)comp.getState());
        ComponentInstance instance2 = (ComponentInstance)iter.next();
        instance2.handle(new ComponentInstanceEvent(instance2.getContainer().getId(), ComponentInstanceEventType.START));
        instance2.handle(new ComponentInstanceEvent(instance2.getContainer().getId(), ComponentInstanceEventType.BECOME_READY));
        comp.handle(new ComponentEvent(comp.getName(), ComponentEventType.CHECK_STABLE));
        Assertions.assertEquals((Object)org.apache.hadoop.yarn.service.api.records.ComponentState.FLEXING, (Object)comp.getComponentSpec().getState(), (String)"component not in flexing state");
        context.assignNewContainer(context.attemptId, 10L, comp);
        comp.handle(new ComponentEvent(comp.getName(), ComponentEventType.CHECK_STABLE));
        Assertions.assertEquals((Object)org.apache.hadoop.yarn.service.api.records.ComponentState.STABLE, (Object)comp.getComponentSpec().getState(), (String)"component not in stable state");
        Assertions.assertEquals((Object)"val0", (Object)comp.getComponentSpec().getConfiguration().getEnv("key1"), (String)"cancel upgrade failed");
    }

    @Test
    public void testCancelUpgradeSuccessWhileUpgrading() throws Exception {
        String serviceName = "testCancelUpgradeWhileUpgrading";
        MockRunningServiceContext context = TestComponent.createTestContext(this.rule, serviceName);
        Component comp = (Component)context.scheduler.getAllComponents().entrySet().iterator().next().getValue();
        this.cancelUpgradeWhileUpgrading(context, comp);
        for (ComponentInstance instance : comp.getAllComponentInstances()) {
            instance.handle(new ComponentInstanceEvent(instance.getContainer().getId(), ComponentInstanceEventType.START));
            instance.handle(new ComponentInstanceEvent(instance.getContainer().getId(), ComponentInstanceEventType.BECOME_READY));
        }
        comp.handle(new ComponentEvent(comp.getName(), ComponentEventType.CHECK_STABLE));
        Assertions.assertEquals((Object)org.apache.hadoop.yarn.service.api.records.ComponentState.STABLE, (Object)comp.getComponentSpec().getState(), (String)"component not in stable state");
        Assertions.assertEquals((Object)"val0", (Object)comp.getComponentSpec().getConfiguration().getEnv("key1"), (String)"cancel upgrade failed");
    }

    @Test
    public void testCancelUpgradeFailureWhileUpgrading() throws Exception {
        String serviceName = "testCancelUpgradeFailureWhileUpgrading";
        MockRunningServiceContext context = TestComponent.createTestContext(this.rule, serviceName);
        Component comp = (Component)context.scheduler.getAllComponents().entrySet().iterator().next().getValue();
        this.cancelUpgradeWhileUpgrading(context, comp);
        for (ComponentInstance instance : comp.getAllComponentInstances()) {
            instance.handle(new ComponentInstanceEvent(instance.getContainer().getId(), ComponentInstanceEventType.STOP));
        }
        comp.handle(new ComponentEvent(comp.getName(), ComponentEventType.CHECK_STABLE));
        Assertions.assertEquals((Object)org.apache.hadoop.yarn.service.api.records.ComponentState.FLEXING, (Object)comp.getComponentSpec().getState(), (String)"component not in flexing state");
        for (ComponentInstance instance : comp.getAllComponentInstances()) {
            context.assignNewContainer(context.attemptId, 10L, comp);
        }
        comp.handle(new ComponentEvent(comp.getName(), ComponentEventType.CHECK_STABLE));
        Assertions.assertEquals((Object)org.apache.hadoop.yarn.service.api.records.ComponentState.STABLE, (Object)comp.getComponentSpec().getState(), (String)"component not in stable state");
        Assertions.assertEquals((Object)"val0", (Object)comp.getComponentSpec().getConfiguration().getEnv("key1"), (String)"cancel upgrade failed");
    }

    private void cancelUpgradeWhileUpgrading(MockRunningServiceContext context, Component comp) throws Exception {
        comp.handle(new ComponentEvent(comp.getName(), ComponentEventType.UPGRADE).setTargetSpec(TestComponent.createSpecWithEnv(context.service.getName(), comp.getName(), "key1", "val1")).setUpgradeVersion("v0"));
        Iterator iter = comp.getAllComponentInstances().iterator();
        ComponentInstance instance1 = (ComponentInstance)iter.next();
        instance1.handle(new ComponentInstanceEvent(instance1.getContainer().getId(), ComponentInstanceEventType.UPGRADE));
        comp.handle(new ComponentEvent(comp.getName(), ComponentEventType.CANCEL_UPGRADE).setTargetSpec(TestComponent.createSpecWithEnv(context.service.getName(), comp.getName(), "key1", "val0")).setUpgradeVersion("v0"));
        comp.getAllComponentInstances().forEach(instance -> instance.handle(new ComponentInstanceEvent(instance.getContainer().getId(), ComponentInstanceEventType.CANCEL_UPGRADE)));
        comp.handle(new ComponentEvent(comp.getName(), ComponentEventType.CONTAINER_COMPLETED).setInstance(instance1).setContainerId(instance1.getContainer().getId()));
        instance1.handle(new ComponentInstanceEvent(instance1.getContainer().getId(), ComponentInstanceEventType.STOP));
        Assertions.assertEquals((Object)ComponentState.CANCEL_UPGRADING, (Object)comp.getState());
        comp.handle(new ComponentEvent(comp.getName(), ComponentEventType.CHECK_STABLE));
        Assertions.assertEquals((Object)org.apache.hadoop.yarn.service.api.records.ComponentState.NEEDS_UPGRADE, (Object)comp.getComponentSpec().getState(), (String)"component not in needs upgrade state");
        Assertions.assertEquals((Object)ComponentState.CANCEL_UPGRADING, (Object)comp.getState());
    }

    @Test
    public void testComponentStateReachesStableStateWithTerminatingComponents() throws Exception {
        String serviceName = "testComponentStateUpdatesWithTerminatingComponents";
        Service testService = ServiceTestUtils.createTerminatingJobExample("testComponentStateUpdatesWithTerminatingComponents");
        TestServiceManager.createDef("testComponentStateUpdatesWithTerminatingComponents", testService);
        MockRunningServiceContext context = new MockRunningServiceContext(this.rule, testService);
        for (Component comp : context.scheduler.getAllComponents().values()) {
            Iterator instanceIter = comp.getAllComponentInstances().iterator();
            ComponentInstance componentInstance = (ComponentInstance)instanceIter.next();
            Container instanceContainer = componentInstance.getContainer();
            Assertions.assertEquals((long)0L, (long)comp.getNumSucceededInstances());
            Assertions.assertEquals((long)0L, (long)comp.getNumFailedInstances());
            Assertions.assertEquals((int)2, (int)comp.getNumRunningInstances());
            Assertions.assertEquals((int)2, (int)comp.getNumReadyInstances());
            Assertions.assertEquals((int)0, (int)comp.getPendingInstances().size());
            ContainerStatus containerStatus = ContainerStatus.newInstance((ContainerId)instanceContainer.getId(), (ContainerState)ContainerState.COMPLETE, (String)"successful", (int)0);
            comp.handle(new ComponentEvent(comp.getName(), ComponentEventType.CONTAINER_COMPLETED).setStatus(containerStatus).setContainerId(instanceContainer.getId()));
            componentInstance.handle(new ComponentInstanceEvent(componentInstance.getContainer().getId(), ComponentInstanceEventType.STOP).setStatus(containerStatus));
            Assertions.assertEquals((long)1L, (long)comp.getNumSucceededInstances());
            Assertions.assertEquals((long)0L, (long)comp.getNumFailedInstances());
            Assertions.assertEquals((int)1, (int)comp.getNumRunningInstances());
            Assertions.assertEquals((int)1, (int)comp.getNumReadyInstances());
            Assertions.assertEquals((int)0, (int)comp.getPendingInstances().size());
            ComponentState componentState = Component.checkIfStable((Component)comp);
            Assertions.assertEquals((Object)ComponentState.STABLE, (Object)componentState);
        }
    }

    @Test
    public void testComponentStateUpdatesWithTerminatingComponents() throws Exception {
        String serviceName = "testComponentStateUpdatesWithTerminatingComponents";
        Service testService = ServiceTestUtils.createTerminatingJobExample("testComponentStateUpdatesWithTerminatingComponents");
        TestServiceManager.createDef("testComponentStateUpdatesWithTerminatingComponents", testService);
        MockRunningServiceContext context = new MockRunningServiceContext(this.rule, testService);
        for (Component comp : context.scheduler.getAllComponents().values()) {
            for (ComponentInstance componentInstance : comp.getAllComponentInstances()) {
                Container instanceContainer = componentInstance.getContainer();
                ContainerStatus containerStatus = ContainerStatus.newInstance((ContainerId)instanceContainer.getId(), (ContainerState)ContainerState.COMPLETE, (String)"successful", (int)0);
                comp.handle(new ComponentEvent(comp.getName(), ComponentEventType.CONTAINER_COMPLETED).setStatus(containerStatus).setContainerId(instanceContainer.getId()));
                componentInstance.handle(new ComponentInstanceEvent(componentInstance.getContainer().getId(), ComponentInstanceEventType.STOP).setStatus(containerStatus));
            }
            org.apache.hadoop.yarn.service.api.records.ComponentState componentState = comp.getComponentSpec().getState();
            Assertions.assertEquals((Object)org.apache.hadoop.yarn.service.api.records.ComponentState.SUCCEEDED, (Object)componentState);
        }
        ServiceState serviceState = testService.getState();
        Assertions.assertEquals((Object)ServiceState.SUCCEEDED, (Object)serviceState);
    }

    @Test
    public void testComponentStateUpdatesWithTerminatingDominantComponents() throws Exception {
        String serviceName = "testComponentStateUpdatesWithTerminatingServiceStateComponents";
        Service testService = ServiceTestUtils.createTerminatingDominantComponentJobExample("testComponentStateUpdatesWithTerminatingServiceStateComponents");
        TestServiceManager.createDef("testComponentStateUpdatesWithTerminatingServiceStateComponents", testService);
        MockRunningServiceContext context = new MockRunningServiceContext(this.rule, testService);
        for (Component comp : context.scheduler.getAllComponents().values()) {
            boolean componentIsDominant = comp.getComponentSpec().getConfiguration().getPropertyBool("yarn.service.container-state-report-as-service-state", false);
            if (!componentIsDominant) continue;
            for (ComponentInstance componentInstance : comp.getAllComponentInstances()) {
                Container instanceContainer = componentInstance.getContainer();
                ContainerStatus containerStatus = ContainerStatus.newInstance((ContainerId)instanceContainer.getId(), (ContainerState)ContainerState.COMPLETE, (String)"successful", (int)0);
                comp.handle(new ComponentEvent(comp.getName(), ComponentEventType.CONTAINER_COMPLETED).setStatus(containerStatus).setContainerId(instanceContainer.getId()));
                componentInstance.handle(new ComponentInstanceEvent(componentInstance.getContainer().getId(), ComponentInstanceEventType.STOP).setStatus(containerStatus));
            }
            org.apache.hadoop.yarn.service.api.records.ComponentState componentState = comp.getComponentSpec().getState();
            Assertions.assertEquals((Object)org.apache.hadoop.yarn.service.api.records.ComponentState.SUCCEEDED, (Object)componentState);
        }
        ServiceState serviceState = testService.getState();
        Assertions.assertEquals((Object)ServiceState.SUCCEEDED, (Object)serviceState);
    }

    private static org.apache.hadoop.yarn.service.api.records.Component createSpecWithEnv(String serviceName, String compName, String key, String val) {
        Service service = TestServiceManager.createBaseDef(serviceName);
        org.apache.hadoop.yarn.service.api.records.Component spec = service.getComponent(compName);
        spec.getConfiguration().getEnv().put(key, val);
        return spec;
    }

    public static MockRunningServiceContext createTestContext(ServiceTestUtils.ServiceFSWatcher fsWatcher, String serviceName) throws Exception {
        return new MockRunningServiceContext(fsWatcher, TestServiceManager.createBaseDef(serviceName));
    }
}

