/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.client;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.client.cli.ApplicationCLI;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.client.ServiceClient;
import org.apache.hadoop.yarn.service.conf.ExampleAppJson;
import org.apache.hadoop.yarn.service.utils.ServiceApiUtil;
import org.apache.hadoop.yarn.service.utils.SliderFileSystem;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestServiceCLI {
    private static final Logger LOG = LoggerFactory.getLogger(TestServiceCLI.class);
    private Configuration conf = new YarnConfiguration();
    private SliderFileSystem fs;
    private ApplicationCLI cli;
    private File basedir;
    private String basedirProp;
    private File dependencyTarGzBaseDir;
    private Path dependencyTarGz;
    private String dependencyTarGzProp;
    private String yarnAdminNoneAclProp;
    private String dfsAdminAclProp;
    private static final String DUMMY_APP_TYPE = "dummy";

    private void createCLI() {
        this.cli = new ApplicationCLI();
        PrintStream sysOut = (PrintStream)Mockito.spy((Object)new PrintStream(new ByteArrayOutputStream()));
        PrintStream sysErr = (PrintStream)Mockito.spy((Object)new PrintStream(new ByteArrayOutputStream()));
        this.cli.setSysOutPrintStream(sysOut);
        this.cli.setSysErrPrintStream(sysErr);
        this.conf.set("yarn.application.admin.client.class.dummy", DummyServiceClient.class.getName());
        this.cli.setConf(this.conf);
    }

    private int runCLI(String[] args) throws Exception {
        LOG.info("running CLI: yarn {}", Arrays.asList(args));
        return ToolRunner.run((Tool)this.cli, (String[])ApplicationCLI.preProcessArgs((String[])args));
    }

    private void buildApp(String serviceName, String appDef) throws Throwable {
        String[] args = new String[]{"app", "-D", this.basedirProp, "-save", serviceName, ExampleAppJson.resourceName(appDef), "-appTypes", DUMMY_APP_TYPE};
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.runCLI(args));
    }

    private void buildApp(String serviceName, String appDef, String lifetime, String queue) throws Throwable {
        String[] args = new String[]{"app", "-D", this.basedirProp, "-save", serviceName, ExampleAppJson.resourceName(appDef), "-appTypes", DUMMY_APP_TYPE, "-updateLifetime", lifetime, "-changeQueue", queue};
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.runCLI(args));
    }

    private static Path getDependencyTarGz(File dir) {
        return new Path(new File(dir, "service-dep.tar.gz").getAbsolutePath());
    }

    @BeforeEach
    public void setup(@TempDir java.nio.file.Path tempDir) throws Throwable {
        this.basedir = new File("target", "apps");
        this.basedirProp = "yarn.service.base.path=" + this.basedir.getAbsolutePath();
        this.conf.set("yarn.service.base.path", this.basedir.getAbsolutePath());
        this.fs = new SliderFileSystem(this.conf);
        this.dependencyTarGzBaseDir = tempDir.toFile();
        this.fs.getFileSystem().setPermission(new Path(this.dependencyTarGzBaseDir.getAbsolutePath()), new FsPermission("755"));
        this.dependencyTarGz = TestServiceCLI.getDependencyTarGz(this.dependencyTarGzBaseDir);
        this.dependencyTarGzProp = "yarn.service.framework.path=" + this.dependencyTarGz.toString();
        this.conf.set("yarn.service.framework.path", this.dependencyTarGz.toString());
        if (this.basedir.exists()) {
            FileUtils.deleteDirectory((File)this.basedir);
        } else {
            this.basedir.mkdirs();
        }
        this.yarnAdminNoneAclProp = "yarn.admin.acl=none";
        this.dfsAdminAclProp = "dfs.cluster.administrators=" + UserGroupInformation.getCurrentUser();
        System.setProperty("service.libdir", this.basedir.getAbsolutePath());
        this.createCLI();
    }

    @AfterEach
    public void tearDown() throws IOException {
        if (this.basedir != null) {
            FileUtils.deleteDirectory((File)this.basedir);
        }
        this.cli.stop();
    }

    @Test
    @Timeout(value=180L)
    public void testFlexComponents() throws Throwable {
        String serviceName = "app-1";
        this.buildApp(serviceName, "app.json");
        this.checkApp(serviceName, "master", 1L, 3600L, null);
        serviceName = "app-2";
        this.buildApp(serviceName, "app.json", "1000", "qname");
        this.checkApp(serviceName, "master", 1L, 1000L, "qname");
    }

    @Test
    public void testInitiateServiceUpgrade() throws Exception {
        String[] args = new String[]{"app", "-upgrade", "app-1", "-initiate", ExampleAppJson.resourceName("app.json"), "-appTypes", DUMMY_APP_TYPE};
        int result = this.cli.run(ApplicationCLI.preProcessArgs((String[])args));
        Assertions.assertThat((int)result).isEqualTo(0);
    }

    @Test
    @Timeout(value=180L)
    public void testInitiateAutoFinalizeServiceUpgrade() throws Exception {
        String[] args = new String[]{"app", "-upgrade", "app-1", "-initiate", ExampleAppJson.resourceName("app.json"), "-autoFinalize", "-appTypes", DUMMY_APP_TYPE};
        int result = this.cli.run(ApplicationCLI.preProcessArgs((String[])args));
        Assertions.assertThat((int)result).isEqualTo(0);
    }

    @Test
    public void testUpgradeInstances() throws Exception {
        this.conf.set("yarn.application.admin.client.class.dummy", DummyServiceClient.class.getName());
        this.cli.setConf(this.conf);
        String[] args = new String[]{"app", "-upgrade", "app-1", "-instances", "comp1-0,comp1-1", "-appTypes", DUMMY_APP_TYPE};
        int result = this.cli.run(ApplicationCLI.preProcessArgs((String[])args));
        Assertions.assertThat((int)result).isEqualTo(0);
    }

    @Test
    public void testUpgradeComponents() throws Exception {
        this.conf.set("yarn.application.admin.client.class.dummy", DummyServiceClient.class.getName());
        this.cli.setConf(this.conf);
        String[] args = new String[]{"app", "-upgrade", "app-1", "-components", "comp1,comp2", "-appTypes", DUMMY_APP_TYPE};
        int result = this.cli.run(ApplicationCLI.preProcessArgs((String[])args));
        Assertions.assertThat((int)result).isEqualTo(0);
    }

    @Test
    public void testGetInstances() throws Exception {
        this.conf.set("yarn.application.admin.client.class.dummy", DummyServiceClient.class.getName());
        this.cli.setConf(this.conf);
        String[] args = new String[]{"container", "-list", "app-1", "-components", "comp1,comp2", "-appTypes", DUMMY_APP_TYPE};
        int result = this.cli.run(ApplicationCLI.preProcessArgs((String[])args));
        Assertions.assertThat((int)result).isEqualTo(0);
    }

    @Test
    public void testCancelUpgrade() throws Exception {
        this.conf.set("yarn.application.admin.client.class.dummy", DummyServiceClient.class.getName());
        this.cli.setConf(this.conf);
        String[] args = new String[]{"app", "-upgrade", "app-1", "-cancel", "-appTypes", DUMMY_APP_TYPE};
        int result = this.cli.run(ApplicationCLI.preProcessArgs((String[])args));
        Assertions.assertThat((int)result).isEqualTo(0);
    }

    @Test
    @Timeout(value=180L)
    public void testEnableFastLaunch() throws Exception {
        this.fs.getFileSystem().create(new Path(this.basedir.getAbsolutePath(), "test.jar")).close();
        Path defaultPath = new Path(this.dependencyTarGz.toString());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.fs.isFile(defaultPath), (String)"Dependency tarball should not exist before the test");
        String[] args = new String[]{"app", "-D", this.dependencyTarGzProp, "-enableFastLaunch", "-appTypes", DUMMY_APP_TYPE};
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.runCLI(args));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fs.isFile(defaultPath), (String)"Dependency tarball did not exist after the test");
        File secondBaseDir = new File(this.dependencyTarGzBaseDir, "2");
        Path secondTarGz = TestServiceCLI.getDependencyTarGz(secondBaseDir);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.fs.isFile(secondTarGz), (String)"Dependency tarball should not exist before the test");
        String[] args2 = new String[]{"app", "-D", this.yarnAdminNoneAclProp, "-D", this.dfsAdminAclProp, "-D", this.dependencyTarGzProp, "-enableFastLaunch", secondBaseDir.getAbsolutePath(), "-appTypes", DUMMY_APP_TYPE};
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.runCLI(args2));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fs.isFile(secondTarGz), (String)"Dependency tarball did not exist after the test");
    }

    @Test
    @Timeout(value=180L)
    public void testEnableFastLaunchUserPermissions() throws Exception {
        String[] args = new String[]{"app", "-D", this.yarnAdminNoneAclProp, "-D", this.dependencyTarGzProp, "-enableFastLaunch", "-appTypes", DUMMY_APP_TYPE};
        org.junit.jupiter.api.Assertions.assertEquals((int)41, (int)this.runCLI(args));
    }

    @Test
    @Timeout(value=180L)
    public void testEnableFastLaunchFilePermissions() throws Exception {
        File badDir = new File(this.dependencyTarGzBaseDir, "bad");
        badDir.mkdir();
        this.fs.getFileSystem().setPermission(new Path(badDir.getAbsolutePath()), new FsPermission("751"));
        String[] args = new String[]{"app", "-D", this.dependencyTarGzProp, "-enableFastLaunch", badDir.getAbsolutePath(), "-appTypes", DUMMY_APP_TYPE};
        org.junit.jupiter.api.Assertions.assertEquals((int)41, (int)this.runCLI(args));
        badDir = new File(badDir, "child");
        badDir.mkdir();
        this.fs.getFileSystem().setPermission(new Path(badDir.getAbsolutePath()), new FsPermission("755"));
        String[] args2 = new String[]{"app", "-D", this.dependencyTarGzProp, "-enableFastLaunch", badDir.getAbsolutePath(), "-appTypes", DUMMY_APP_TYPE};
        org.junit.jupiter.api.Assertions.assertEquals((int)41, (int)this.runCLI(args2));
        badDir = new File(this.dependencyTarGzBaseDir, "badx");
        badDir.mkdir();
        this.fs.getFileSystem().setPermission(new Path(badDir.getAbsolutePath()), new FsPermission("754"));
        String[] args3 = new String[]{"app", "-D", this.dependencyTarGzProp, "-enableFastLaunch", badDir.getAbsolutePath(), "-appTypes", DUMMY_APP_TYPE};
        org.junit.jupiter.api.Assertions.assertEquals((int)41, (int)this.runCLI(args3));
    }

    private void checkApp(String serviceName, String compName, long count, Long lifetime, String queue) throws IOException {
        Service service = ServiceApiUtil.loadService((SliderFileSystem)this.fs, (String)serviceName);
        org.junit.jupiter.api.Assertions.assertEquals((Object)serviceName, (Object)service.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Long)lifetime, (Long)service.getLifetime());
        org.junit.jupiter.api.Assertions.assertEquals((Object)queue, (Object)service.getQueue());
        List components = service.getComponents();
        for (Component component : components) {
            if (!component.getName().equals(compName)) continue;
            org.junit.jupiter.api.Assertions.assertEquals((long)count, (long)component.getNumberOfContainers());
            return;
        }
        org.junit.jupiter.api.Assertions.fail();
    }

    public static class DummyServiceClient
    extends ServiceClient {
        public int initiateUpgrade(String appName, String fileName, boolean autoFinalize) throws IOException, YarnException {
            return 0;
        }

        public int actionUpgradeInstances(String appName, List<String> componentInstances) throws IOException, YarnException {
            return 0;
        }

        public int actionUpgradeComponents(String appName, List<String> components) throws IOException, YarnException {
            return 0;
        }

        public String getInstances(String appName, List<String> components, String version, List<String> containerStates) throws IOException, YarnException {
            return "";
        }

        public int actionCancelUpgrade(String appName) throws IOException, YarnException {
            return 0;
        }
    }
}

