/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.registry.client.binding.RegistryPathUtils;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.Multimap;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.SignalContainerCommand;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.service.ServiceTestUtils;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.ComponentState;
import org.apache.hadoop.yarn.service.api.records.Configuration;
import org.apache.hadoop.yarn.service.api.records.Container;
import org.apache.hadoop.yarn.service.api.records.PlacementConstraint;
import org.apache.hadoop.yarn.service.api.records.PlacementPolicy;
import org.apache.hadoop.yarn.service.api.records.PlacementScope;
import org.apache.hadoop.yarn.service.api.records.PlacementType;
import org.apache.hadoop.yarn.service.api.records.Resource;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.api.records.ServiceState;
import org.apache.hadoop.yarn.service.client.ServiceClient;
import org.apache.hadoop.yarn.service.exceptions.SliderException;
import org.apache.hadoop.yarn.service.utils.ServiceApiUtil;
import org.apache.hadoop.yarn.service.utils.SliderFileSystem;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestYarnNativeServices
extends ServiceTestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TestYarnNativeServices.class);

    @BeforeEach
    public void setup() throws Exception {
        File tmpYarnDir = new File("target", "tmp");
        FileUtils.deleteQuietly((File)tmpYarnDir);
    }

    @AfterEach
    public void tearDown() throws IOException {
        this.shutdown();
    }

    @Test
    @Timeout(value=200L)
    public void testCreateFlexStopDestroyService() throws Exception {
        this.setupInternal(1);
        ServiceClient client = TestYarnNativeServices.createClient(this.getConf());
        Service exampleApp = TestYarnNativeServices.createExampleApplication();
        client.actionCreate(exampleApp);
        SliderFileSystem fileSystem = new SliderFileSystem(this.getConf());
        Path appDir = fileSystem.buildClusterDirPath(exampleApp.getName());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.getFS().exists(new Path(appDir, exampleApp.getName() + ".json")));
        this.waitForServiceToBeStable(client, exampleApp);
        this.flexComponents(client, exampleApp, 3L);
        this.waitForServiceToBeStable(client, exampleApp);
        this.checkCompInstancesInOrder(client, exampleApp);
        this.flexComponents(client, exampleApp, 1L);
        this.waitForServiceToBeStable(client, exampleApp);
        this.checkCompInstancesInOrder(client, exampleApp);
        this.flexComponents(client, exampleApp, 2L);
        this.waitForServiceToBeStable(client, exampleApp);
        this.checkCompInstancesInOrder(client, exampleApp);
        LOG.info("Stop the service");
        client.actionStop(exampleApp.getName(), true);
        ApplicationReport report = client.getYarnClient().getApplicationReport(ApplicationId.fromString((String)exampleApp.getId()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)YarnApplicationState.FINISHED, (Object)report.getYarnApplicationState());
        org.junit.jupiter.api.Assertions.assertEquals((Object)FinalApplicationStatus.ENDED, (Object)report.getFinalApplicationStatus());
        String serviceZKPath = RegistryUtils.servicePath((String)RegistryUtils.currentUser(), (String)"yarn-service", (String)exampleApp.getName());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.getCuratorService().zkPathExists(serviceZKPath), (String)"Registry ZK service path still exists after stop");
        LOG.info("Destroy the service");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)client.actionDestroy(exampleApp.getName()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.getFS().exists(appDir));
        org.junit.jupiter.api.Assertions.assertEquals((int)44, (int)client.actionDestroy(exampleApp.getName()));
    }

    @Test
    @Timeout(value=200L)
    public void testStopDestroySavedService() throws Exception {
        this.setupInternal(1);
        ServiceClient client = TestYarnNativeServices.createClient(this.getConf());
        Service exampleApp = TestYarnNativeServices.createExampleApplication();
        client.actionBuild(exampleApp);
        org.junit.jupiter.api.Assertions.assertEquals((int)40, (int)client.actionStop(exampleApp.getName()));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)client.actionDestroy(exampleApp.getName()));
    }

    @Test
    @Timeout(value=200L)
    public void testComponentStartOrder() throws Exception {
        this.setupInternal(1);
        ServiceClient client = TestYarnNativeServices.createClient(this.getConf());
        Service exampleApp = new Service();
        exampleApp.setName("teststartorder");
        exampleApp.setVersion("v1");
        exampleApp.addComponent(TestYarnNativeServices.createComponent("compa", 2L, "sleep 1000"));
        Component compb = TestYarnNativeServices.createComponent("compb", 2L, "sleep 1000");
        compb.setDependencies(Collections.singletonList("compa"));
        exampleApp.addComponent(compb);
        Component compc = TestYarnNativeServices.createComponent("compc", 2L, "sleep 1000");
        compc.setDependencies(Collections.singletonList("compb"));
        exampleApp.addComponent(compc);
        client.actionCreate(exampleApp);
        this.waitForServiceToBeStable(client, exampleApp);
        this.checkContainerLaunchDependencies(client, exampleApp, "compa", "compb", "compc");
        client.actionStop(exampleApp.getName(), true);
        client.actionDestroy(exampleApp.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=200L)
    public void testCreateServiceSameNameDifferentUser() throws Exception {
        String sameAppName = "same-name";
        String userA = "usera";
        String userB = "userb";
        this.setupInternal(1);
        ServiceClient client = TestYarnNativeServices.createClient(this.getConf());
        String origBasePath = this.getConf().get("yarn.service.base.path");
        Service userAApp = new Service();
        userAApp.setName(sameAppName);
        userAApp.setVersion("v1");
        userAApp.addComponent(TestYarnNativeServices.createComponent("comp", 1L, "sleep 1000"));
        Service userBApp = new Service();
        userBApp.setName(sameAppName);
        userBApp.setVersion("v1");
        userBApp.addComponent(TestYarnNativeServices.createComponent("comp", 1L, "sleep 1000"));
        File userABasePath = null;
        File userBBasePath = null;
        try {
            userABasePath = new File(origBasePath, userA);
            userABasePath.mkdirs();
            this.getConf().set("yarn.service.base.path", userABasePath.getAbsolutePath());
            client.actionCreate(userAApp);
            this.waitForServiceToBeStarted(client, userAApp);
            userBBasePath = new File(origBasePath, userB);
            userBBasePath.mkdirs();
            this.getConf().set("yarn.service.base.path", userBBasePath.getAbsolutePath());
            client.actionBuild(userBApp);
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail((String)("Exception should not be thrown - " + e.getLocalizedMessage()));
        }
        finally {
            if (userABasePath != null) {
                this.getConf().set("yarn.service.base.path", userABasePath.getAbsolutePath());
                client.actionStop(sameAppName, true);
                client.actionDestroy(sameAppName);
            }
            if (userBBasePath != null) {
                this.getConf().set("yarn.service.base.path", userBBasePath.getAbsolutePath());
                client.actionDestroy(sameAppName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=200L)
    public void testCreateServiceSameNameSameUser() throws Exception {
        Object expectedMsg;
        String sameAppName = "same-name";
        String user = UserGroupInformation.getCurrentUser().getUserName();
        System.setProperty("user.name", user);
        this.setupInternal(1);
        ServiceClient client = TestYarnNativeServices.createClient(this.getConf());
        Service appA = new Service();
        appA.setName(sameAppName);
        appA.setVersion("v1");
        appA.addComponent(TestYarnNativeServices.createComponent("comp", 1L, "sleep 1000"));
        Service appB = new Service();
        appB.setName(sameAppName);
        appB.setVersion("v1");
        appB.addComponent(TestYarnNativeServices.createComponent("comp", 1L, "sleep 1000"));
        try {
            client.actionBuild(appA);
            client.actionBuild(appB);
        }
        catch (Exception e) {
            expectedMsg = "Service Instance dir already exists:";
            if (e.getLocalizedMessage() != null) {
                Assertions.assertThat((String)e.getLocalizedMessage()).contains(new CharSequence[]{expectedMsg});
            } else {
                org.junit.jupiter.api.Assertions.fail((String)("Message cannot be null. It has to say - " + (String)expectedMsg));
            }
        }
        finally {
            client.actionDestroy(sameAppName);
        }
        try {
            client.actionCreate(appA);
            this.waitForServiceToBeStarted(client, appA);
            client.actionCreate(appB);
            this.waitForServiceToBeStarted(client, appB);
        }
        catch (Exception e) {
            expectedMsg = "Failed to create service " + sameAppName + ", because it already exists.";
            if (e.getLocalizedMessage() != null) {
                Assertions.assertThat((String)e.getLocalizedMessage()).contains(new CharSequence[]{expectedMsg});
            } else {
                org.junit.jupiter.api.Assertions.fail((String)("Message cannot be null. It has to say - " + (String)expectedMsg));
            }
        }
        finally {
            client.actionStop(sameAppName, true);
            client.actionDestroy(sameAppName);
        }
    }

    @Test
    @Timeout(value=200L)
    public void testRecoverComponentsAfterRMRestart() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        conf.setBoolean("yarn.resourcemanager.work-preserving-recovery.enabled", true);
        conf.setLong("yarn.nodemanager.resourcemanager.connect.retry-interval.ms", 500L);
        conf.setBoolean("yarn.minicluster.fixed.ports", true);
        conf.setBoolean("yarn.minicluster.use-rpc", true);
        conf.setInt("yarn.resourcemanager.max-completed-applications", 1000);
        this.setConf(conf);
        this.setupInternal(1);
        ServiceClient client = TestYarnNativeServices.createClient(this.getConf());
        Service exampleApp = TestYarnNativeServices.createExampleApplication();
        client.actionCreate(exampleApp);
        Multimap<String, String> containersBeforeFailure = this.waitForAllCompToBeReady(client, exampleApp);
        LOG.info("Restart the resource manager");
        this.getYarnCluster().restartResourceManager(this.getYarnCluster().getActiveRMIndex());
        GenericTestUtils.waitFor(() -> this.getYarnCluster().getResourceManager().getServiceState() == Service.STATE.STARTED, (long)2000L, (long)200000L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.getYarnCluster().waitForNodeManagersToConnect(5000L), (String)"node managers connected");
        ApplicationId exampleAppId = ApplicationId.fromString((String)exampleApp.getId());
        ApplicationAttemptId applicationAttemptId = client.getYarnClient().getApplicationReport(exampleAppId).getCurrentApplicationAttemptId();
        LOG.info("Fail the application attempt {}", (Object)applicationAttemptId);
        client.getYarnClient().failApplicationAttempt(applicationAttemptId);
        GenericTestUtils.waitFor(() -> {
            try {
                ApplicationReport ar = client.getYarnClient().getApplicationReport(exampleAppId);
                return ar.getCurrentApplicationAttemptId().getAttemptId() == 2 && ar.getYarnApplicationState() == YarnApplicationState.RUNNING;
            }
            catch (IOException | YarnException e) {
                throw new RuntimeException("while waiting", e);
            }
        }, (long)2000L, (long)200000L);
        Multimap<String, String> containersAfterFailure = this.waitForAllCompToBeReady(client, exampleApp);
        containersBeforeFailure.keys().forEach(compName -> org.junit.jupiter.api.Assertions.assertEquals((int)containersBeforeFailure.get(compName).size(), (int)(containersAfterFailure.get(compName) == null ? 0 : containersAfterFailure.get(compName).size()), (String)("num containers after by restart for " + compName)));
        LOG.info("Stop/destroy service {}", (Object)exampleApp);
        client.actionStop(exampleApp.getName(), true);
        client.actionDestroy(exampleApp.getName());
    }

    @Test
    @Timeout(value=200L)
    public void testUpgrade() throws Exception {
        this.setupInternal(1);
        this.getConf().setBoolean("yarn.service.upgrade.enabled", true);
        ServiceClient client = TestYarnNativeServices.createClient(this.getConf());
        Service service = TestYarnNativeServices.createExampleApplication();
        client.actionCreate(service);
        this.waitForServiceToBeStable(client, service);
        Component component = (Component)service.getComponents().iterator().next();
        service.setState(ServiceState.UPGRADING);
        service.setVersion("v2");
        component.getConfiguration().getEnv().put("key1", "val1");
        client.initiateUpgrade(service);
        this.waitForServiceToBeInState(client, service, ServiceState.UPGRADING);
        SliderFileSystem fs = new SliderFileSystem(this.getConf());
        Service fromFs = ServiceApiUtil.loadServiceUpgrade((SliderFileSystem)fs, (String)service.getName(), (String)service.getVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)service.getName(), (Object)fromFs.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)service.getVersion(), (Object)fromFs.getVersion());
        Service liveService = client.getStatus(service.getName());
        client.actionUpgrade(service, liveService.getComponent(component.getName()).getContainers());
        this.waitForAllCompToBeReady(client, service);
        client.actionStart(service.getName());
        this.waitForServiceToBeStable(client, service);
        Service active = client.getStatus(service.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ComponentState.STABLE, (Object)active.getComponent(component.getName()).getState(), (String)"component not stable");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"val1", (Object)active.getComponent(component.getName()).getConfiguration().getEnv("key1"), (String)"comp does not have new env");
        LOG.info("Stop/destroy service {}", (Object)service);
        client.actionStop(service.getName(), true);
        client.actionDestroy(service.getName());
    }

    @Test
    @Timeout(value=200L)
    public void testExpressUpgrade() throws Exception {
        this.setupInternal(1);
        this.getConf().setBoolean("yarn.service.upgrade.enabled", true);
        ServiceClient client = TestYarnNativeServices.createClient(this.getConf());
        Service service = TestYarnNativeServices.createExampleApplication();
        client.actionCreate(service);
        this.waitForServiceToBeStable(client, service);
        Component component = (Component)service.getComponents().iterator().next();
        service.setState(ServiceState.EXPRESS_UPGRADING);
        service.setVersion("v2");
        component.getConfiguration().getEnv().put("key1", "val1");
        Component component2 = service.getComponent("compb");
        component2.getConfiguration().getEnv().put("key2", "val2");
        client.actionUpgradeExpress(service);
        this.waitForServiceToBeExpressUpgrading(client, service);
        this.waitForServiceToBeStable(client, service);
        Service active = client.getStatus(service.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)service.getVersion(), (Object)active.getVersion(), (String)"version mismatch");
        org.junit.jupiter.api.Assertions.assertEquals((Object)ComponentState.STABLE, (Object)active.getComponent(component.getName()).getState(), (String)"component not stable");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"val1", (Object)active.getComponent(component.getName()).getConfiguration().getEnv("key1"), (String)"compa does not have new env");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"val2", (Object)active.getComponent(component2.getName()).getConfiguration().getEnv("key2"), (String)"compb does not have new env");
        LOG.info("Stop/destroy service {}", (Object)service);
        client.actionStop(service.getName(), true);
        client.actionDestroy(service.getName());
    }

    @Test
    @Timeout(value=200L)
    public void testCancelUpgrade() throws Exception {
        this.setupInternal(1);
        this.getConf().setBoolean("yarn.service.upgrade.enabled", true);
        ServiceClient client = TestYarnNativeServices.createClient(this.getConf());
        Service service = TestYarnNativeServices.createExampleApplication();
        Component component = (Component)service.getComponents().iterator().next();
        component.getConfiguration().getEnv().put("key1", "val0");
        client.actionCreate(service);
        this.waitForServiceToBeStable(client, service);
        service.setState(ServiceState.UPGRADING);
        service.setVersion("v2");
        component.getConfiguration().getEnv().put("key1", "val1");
        client.initiateUpgrade(service);
        this.waitForServiceToBeInState(client, service, ServiceState.UPGRADING);
        Service liveService = client.getStatus(service.getName());
        Container container = (Container)liveService.getComponent(component.getName()).getContainers().iterator().next();
        client.actionUpgrade(service, (List)Lists.newArrayList((Object[])new Container[]{container}));
        Thread.sleep(500L);
        client.actionCancelUpgrade(service.getName());
        this.waitForServiceToBeStable(client, service);
        Service active = client.getStatus(service.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ComponentState.STABLE, (Object)active.getComponent(component.getName()).getState(), (String)"component not stable");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"val0", (Object)active.getComponent(component.getName()).getConfiguration().getEnv("key1"), (String)"comp does not have new env");
        LOG.info("Stop/destroy service {}", (Object)service);
        client.actionStop(service.getName(), true);
        client.actionDestroy(service.getName());
    }

    @Test
    @Timeout(value=200L)
    public void testCreateServiceWithPlacementPolicy() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.resourcemanager.placement-constraints.handler", "scheduler");
        conf.setInt("yarn.resourcemanager.max-completed-applications", 1000);
        this.setConf(conf);
        this.setupInternal(3);
        ServiceClient client = TestYarnNativeServices.createClient(this.getConf());
        Service exampleApp = new Service();
        exampleApp.setName("example-app");
        exampleApp.setVersion("v1");
        Component comp = TestYarnNativeServices.createComponent("compa", 3L, "sleep 1000");
        PlacementPolicy pp = new PlacementPolicy();
        PlacementConstraint pc = new PlacementConstraint();
        pc.setName("CA1");
        pc.setTargetTags(Collections.singletonList("compa"));
        pc.setScope(PlacementScope.NODE);
        pc.setType(PlacementType.ANTI_AFFINITY);
        pp.setConstraints(Collections.singletonList(pc));
        comp.setPlacementPolicy(pp);
        exampleApp.addComponent(comp);
        client.actionCreate(exampleApp);
        this.waitForServiceToBeStable(client, exampleApp);
        Service service = client.getStatus(exampleApp.getName());
        Component component = service.getComponent("compa");
        org.junit.jupiter.api.Assertions.assertEquals((Object)ServiceState.STABLE, (Object)service.getState(), (String)"Service state should be STABLE");
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)component.getContainers().size(), (String)"3 containers are expected to be running");
        HashSet<String> nonAMContainerIdSet = new HashSet<String>();
        for (Container cont : component.getContainers()) {
            nonAMContainerIdSet.add(cont.getId());
        }
        HashSet<String> hosts = new HashSet<String>();
        ApplicationReport report = client.getYarnClient().getApplicationReport(ApplicationId.fromString((String)exampleApp.getId()));
        GetContainersRequest req = GetContainersRequest.newInstance((ApplicationAttemptId)report.getCurrentApplicationAttemptId());
        ResourceManager rm = this.getYarnCluster().getResourceManager();
        for (ContainerReport contReport : rm.getClientRMService().getContainers(req).getContainerList()) {
            if (!nonAMContainerIdSet.contains(contReport.getContainerId().toString())) continue;
            if (hosts.contains(contReport.getNodeHttpAddress())) {
                org.junit.jupiter.api.Assertions.fail((String)("Container " + contReport.getContainerId() + " came up in the same host as another container."));
                continue;
            }
            hosts.add(contReport.getNodeHttpAddress());
        }
        HashMap<String, Long> compCounts = new HashMap<String, Long>();
        compCounts.put("compa", 5L);
        exampleApp.getComponent("compa").setNumberOfContainers(Long.valueOf(5L));
        client.flexByRestService(exampleApp.getName(), compCounts);
        try {
            this.waitForServiceToBeStable(client, exampleApp, 10000);
            org.junit.jupiter.api.Assertions.fail((String)"Service should not be in a stable state. It should throw a timeout exception.");
        }
        catch (Exception e) {
            service = client.getStatus(exampleApp.getName());
            component = service.getComponent("compa");
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)ServiceState.STABLE, (Object)service.getState(), (String)"Service state should not be STABLE");
            org.junit.jupiter.api.Assertions.assertEquals((Object)ComponentState.FLEXING, (Object)component.getState(), (String)"Component state should be FLEXING");
            org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)component.getContainers().size(), (String)"3 containers are expected to be running");
        }
        compCounts = new HashMap();
        compCounts.put("compa", 4L);
        exampleApp.getComponent("compa").setNumberOfContainers(Long.valueOf(4L));
        client.flexByRestService(exampleApp.getName(), compCounts);
        try {
            this.waitForServiceToBeStable(client, exampleApp, 10000);
            org.junit.jupiter.api.Assertions.fail((String)"Service should not be in a stable state. It should throw a timeout exception.");
        }
        catch (Exception e) {
            service = client.getStatus(exampleApp.getName());
            component = service.getComponent("compa");
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)ServiceState.STABLE, (Object)service.getState(), (String)"Service state should not be STABLE");
            org.junit.jupiter.api.Assertions.assertEquals((Object)ComponentState.FLEXING, (Object)component.getState(), (String)"Component state should be FLEXING");
            org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)component.getContainers().size(), (String)"3 containers are expected to be running");
        }
        compCounts = new HashMap();
        compCounts.put("compa", 3L);
        exampleApp.getComponent("compa").setNumberOfContainers(Long.valueOf(3L));
        client.flexByRestService(exampleApp.getName(), compCounts);
        this.waitForServiceToBeStable(client, exampleApp);
        LOG.info("Stop/destroy service {}", (Object)exampleApp);
        client.actionStop(exampleApp.getName(), true);
        client.actionDestroy(exampleApp.getName());
    }

    @Test
    @Timeout(value=200L)
    public void testAMSigtermDoesNotKillApplication() throws Exception {
        this.runAMSignalTest(SignalContainerCommand.GRACEFUL_SHUTDOWN);
    }

    @Test
    @Timeout(value=200L)
    public void testAMSigkillDoesNotKillApplication() throws Exception {
        this.runAMSignalTest(SignalContainerCommand.FORCEFUL_SHUTDOWN);
    }

    public void runAMSignalTest(SignalContainerCommand signal) throws Exception {
        this.setupInternal(1);
        ServiceClient client = TestYarnNativeServices.createClient(this.getConf());
        Service exampleApp = TestYarnNativeServices.createExampleApplication();
        client.actionCreate(exampleApp);
        this.waitForServiceToBeStable(client, exampleApp);
        Service appStatus1 = client.getStatus(exampleApp.getName());
        ApplicationId exampleAppId = ApplicationId.fromString((String)appStatus1.getId());
        YarnClient yarnClient = TestYarnNativeServices.createYarnClient(this.getConf());
        ApplicationReport applicationReport = yarnClient.getApplicationReport(exampleAppId);
        ApplicationAttemptId firstAttemptId = applicationReport.getCurrentApplicationAttemptId();
        ApplicationAttemptReport attemptReport = yarnClient.getApplicationAttemptReport(firstAttemptId);
        yarnClient.signalToContainer(attemptReport.getAMContainerId(), signal);
        GenericTestUtils.waitFor(() -> {
            try {
                ApplicationReport ar = client.getYarnClient().getApplicationReport(exampleAppId);
                YarnApplicationState state = ar.getYarnApplicationState();
                org.junit.jupiter.api.Assertions.assertTrue((state == YarnApplicationState.RUNNING || state == YarnApplicationState.ACCEPTED ? 1 : 0) != 0);
                if (state != YarnApplicationState.RUNNING) {
                    return false;
                }
                if (ar.getCurrentApplicationAttemptId() == null || ar.getCurrentApplicationAttemptId().equals((Object)firstAttemptId)) {
                    return false;
                }
                Service appStatus2 = client.getStatus(exampleApp.getName());
                if (appStatus2.getState() != ServiceState.STABLE) {
                    return false;
                }
                org.junit.jupiter.api.Assertions.assertEquals((Object)TestYarnNativeServices.getSortedContainerIds(appStatus1).toString(), (Object)TestYarnNativeServices.getSortedContainerIds(appStatus2).toString());
                return true;
            }
            catch (IOException | YarnException e) {
                throw new RuntimeException("while waiting", e);
            }
        }, (long)2000L, (long)200000L);
    }

    private static List<String> getSortedContainerIds(Service s) {
        ArrayList<String> containerIds = new ArrayList<String>();
        for (Component component : s.getComponents()) {
            for (Container container : component.getContainers()) {
                containerIds.add(container.getId());
            }
        }
        Collections.sort(containerIds);
        return containerIds;
    }

    @Test
    @Timeout(value=200L)
    public void testComponentHealthThresholdMonitor() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.resourcemanager.placement-constraints.handler", "scheduler");
        conf.setInt("yarn.resourcemanager.max-completed-applications", 1000);
        conf.setInt("yarn.nodemanager.resource.cpu-vcores", 1);
        this.setConf(conf);
        this.setupInternal(3);
        ServiceClient client = TestYarnNativeServices.createClient(this.getConf());
        Service exampleApp = new Service();
        exampleApp.setName("example-app");
        exampleApp.setVersion("v1");
        Component comp = TestYarnNativeServices.createComponent("compa", 3L, "sleep 1000");
        PlacementPolicy pp = new PlacementPolicy();
        PlacementConstraint pc = new PlacementConstraint();
        pc.setName("CA1");
        pc.setTargetTags(Collections.singletonList("compa"));
        pc.setScope(PlacementScope.NODE);
        pc.setType(PlacementType.ANTI_AFFINITY);
        pp.setConstraints(Collections.singletonList(pc));
        comp.setPlacementPolicy(pp);
        Configuration config = new Configuration();
        config.setProperty("yarn.service.container-health-threshold.percent", "65");
        config.setProperty("yarn.service.container-health-threshold.window-secs", "3");
        config.setProperty("yarn.service.container-health-threshold.init-delay-secs", "0");
        config.setProperty("yarn.service.container-health-threshold.poll-frequency-secs", "1");
        config.setProperty("yarn.service.default-readiness-check.enabled", "false");
        comp.setConfiguration(config);
        exampleApp.addComponent(comp);
        Configuration serviceConfig = new Configuration();
        serviceConfig.setProperty("yarn.service.am-restart.max-attempts", "1");
        exampleApp.setConfiguration(serviceConfig);
        client.actionCreate(exampleApp);
        this.waitForServiceToBeStable(client, exampleApp);
        Service service = client.getStatus(exampleApp.getName());
        Component component = service.getComponent("compa");
        org.junit.jupiter.api.Assertions.assertEquals((Object)ServiceState.STABLE, (Object)service.getState(), (String)"Service state should be STABLE");
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)component.getContainers().size(), (String)"3 containers are expected to be running");
        HashMap<String, Long> compCounts = new HashMap<String, Long>();
        compCounts.put("compa", 4L);
        exampleApp.getComponent("compa").setNumberOfContainers(Long.valueOf(4L));
        client.flexByRestService(exampleApp.getName(), compCounts);
        try {
            this.waitForServiceToBeStable(client, exampleApp, 6000);
            org.junit.jupiter.api.Assertions.fail((String)"Service should not be in a stable state. It should throw a timeout exception.");
        }
        catch (Exception e) {
            service = client.getStatus(exampleApp.getName());
            component = service.getComponent("compa");
            org.junit.jupiter.api.Assertions.assertEquals((Object)ServiceState.STARTED, (Object)service.getState(), (String)"Service state should be STARTED");
            org.junit.jupiter.api.Assertions.assertEquals((Object)ComponentState.FLEXING, (Object)component.getState(), (String)"Component state should be FLEXING");
            org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)component.getContainers().size(), (String)"3 containers are expected to be running");
        }
        compCounts.put("compa", 5L);
        exampleApp.getComponent("compa").setNumberOfContainers(Long.valueOf(5L));
        client.flexByRestService(exampleApp.getName(), compCounts);
        try {
            this.waitForServiceToBeInState(client, exampleApp, ServiceState.FAILED, 14000);
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail((String)"Should not have thrown exception");
        }
        LOG.info("Destroy service {}", (Object)exampleApp);
        client.actionDestroy(exampleApp.getName());
    }

    private void checkContainerLaunchDependencies(ServiceClient client, Service exampleApp, String ... compOrder) throws IOException, YarnException {
        Service retrievedApp = client.getStatus(exampleApp.getName());
        ArrayList containerList = new ArrayList();
        for (Component component : retrievedApp.getComponents()) {
            containerList.addAll(component.getContainers());
        }
        containerList.sort((o1, o2) -> o1.getLaunchTime().compareTo(o2.getLaunchTime()));
        LOG.info("containerList: " + containerList);
        int index = 0;
        for (String comp : compOrder) {
            long num = retrievedApp.getComponent(comp).getNumberOfContainers();
            int i = 0;
            while ((long)i < num) {
                String compInstanceName = ((Container)containerList.get(index)).getComponentInstanceName();
                String compName = compInstanceName.substring(0, compInstanceName.lastIndexOf(45));
                org.junit.jupiter.api.Assertions.assertEquals((Object)comp, (Object)compName);
                ++index;
                ++i;
            }
        }
    }

    private Map<String, Long> flexComponents(ServiceClient client, Service exampleApp, long count) throws YarnException, IOException {
        HashMap<String, Long> compCounts = new HashMap<String, Long>();
        compCounts.put("compa", count);
        compCounts.put("compb", count);
        exampleApp.getComponent("compa").setNumberOfContainers(Long.valueOf(count));
        exampleApp.getComponent("compb").setNumberOfContainers(Long.valueOf(count));
        client.flexByRestService(exampleApp.getName(), compCounts);
        return compCounts;
    }

    private void checkCompInstancesInOrder(ServiceClient client, Service exampleApp) throws IOException, YarnException, TimeoutException, InterruptedException {
        this.waitForContainers(client, exampleApp);
        Service service = client.getStatus(exampleApp.getName());
        for (Component comp : service.getComponents()) {
            this.checkEachCompInstancesInOrder(comp, exampleApp.getName());
        }
    }

    private void waitForContainers(ServiceClient client, Service exampleApp) throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor(() -> {
            try {
                Service service = client.getStatus(exampleApp.getName());
                for (Component comp : service.getComponents()) {
                    if ((long)comp.getContainers().size() == comp.getNumberOfContainers()) continue;
                    return false;
                }
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }, (long)2000L, (long)200000L);
    }

    private void checkEachCompInstancesInOrder(Component component, String serviceName) throws TimeoutException, InterruptedException {
        TreeSet<String> instances = new TreeSet<String>();
        for (Container container : component.getContainers()) {
            instances.add(container.getComponentInstanceName());
            String componentZKPath = RegistryUtils.componentPath((String)RegistryUtils.currentUser(), (String)"yarn-service", (String)serviceName, (String)RegistryPathUtils.encodeYarnID((String)container.getId()));
            GenericTestUtils.waitFor(() -> {
                try {
                    return this.getCuratorService().zkPathExists(componentZKPath);
                }
                catch (IOException e) {
                    return false;
                }
            }, (long)1000L, (long)60000L);
        }
        int i = 0;
        for (String s : instances) {
            Assertions.assertThat((String)s).isEqualTo((Object)(component.getName() + "-" + i));
            ++i;
        }
    }

    @Test
    @Timeout(value=200L)
    public void testRestartServiceForNonExistingInRM() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.resourcemanager.max-completed-applications", 0);
        this.setConf(conf);
        this.setupInternal(1);
        ServiceClient client = TestYarnNativeServices.createClient(this.getConf());
        Service exampleApp = TestYarnNativeServices.createExampleApplication();
        client.actionCreate(exampleApp);
        this.waitForServiceToBeStable(client, exampleApp);
        try {
            client.actionStop(exampleApp.getName(), true);
        }
        catch (ApplicationNotFoundException e) {
            LOG.info("ignore ApplicationNotFoundException during stopping");
        }
        client.actionStart(exampleApp.getName());
        this.waitForServiceToBeStable(client, exampleApp);
        Service service = client.getStatus(exampleApp.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ServiceState.STABLE, (Object)service.getState(), (String)"Restarted service state should be STABLE");
    }

    @Test
    @Timeout(value=200L)
    public void testAMFailureValidity() throws Exception {
        this.setupInternal(1);
        ServiceClient client = TestYarnNativeServices.createClient(this.getConf());
        Service exampleApp = new Service();
        exampleApp.setName("example-app");
        exampleApp.setVersion("v1");
        exampleApp.addComponent(TestYarnNativeServices.createComponent("compa", 2L, "sleep 1000"));
        Configuration serviceConfig = new Configuration();
        serviceConfig.setProperty("yarn.service.am-restart.max-attempts", "2");
        serviceConfig.setProperty("yarn.service.am-failure.validity-interval-ms", "1000");
        exampleApp.setConfiguration(serviceConfig);
        client.actionCreate(exampleApp);
        this.waitForServiceToBeStable(client, exampleApp);
        Service appStatus1 = client.getStatus(exampleApp.getName());
        ApplicationId exampleAppId = ApplicationId.fromString((String)appStatus1.getId());
        YarnClient yarnClient = TestYarnNativeServices.createYarnClient(this.getConf());
        ApplicationReport applicationReport = yarnClient.getApplicationReport(exampleAppId);
        ApplicationAttemptReport attemptReport = yarnClient.getApplicationAttemptReport(applicationReport.getCurrentApplicationAttemptId());
        yarnClient.signalToContainer(attemptReport.getAMContainerId(), SignalContainerCommand.GRACEFUL_SHUTDOWN);
        this.waitForServiceToBeStable(client, exampleApp);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ServiceState.STABLE, (Object)client.getStatus(exampleApp.getName()).getState());
        Thread.sleep(2000L);
        applicationReport = yarnClient.getApplicationReport(exampleAppId);
        attemptReport = yarnClient.getApplicationAttemptReport(applicationReport.getCurrentApplicationAttemptId());
        yarnClient.signalToContainer(attemptReport.getAMContainerId(), SignalContainerCommand.GRACEFUL_SHUTDOWN);
        this.waitForServiceToBeStable(client, exampleApp);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ServiceState.STABLE, (Object)client.getStatus(exampleApp.getName()).getState());
    }

    public Service createServiceWithSingleComp(int memory) {
        Service service = new Service();
        service.setName("example-app");
        service.setVersion("v1");
        Component component = new Component();
        component.setName("sleep");
        component.setNumberOfContainers(Long.valueOf(1L));
        component.setLaunchCommand("sleep 1000");
        Resource resource = new Resource();
        resource.setMemory(Integer.toString(memory));
        resource.setCpus(Integer.valueOf(1));
        component.setResource(resource);
        service.addComponent(component);
        return service;
    }

    @Test
    @Timeout(value=200L)
    public void testServiceSameNameWithFailure() throws Exception {
        this.setupInternal(1);
        ServiceClient client = TestYarnNativeServices.createClient(this.getConf());
        try {
            client.actionCreate(this.createServiceWithSingleComp(1024000));
            org.junit.jupiter.api.Assertions.fail((String)"Service should throw YarnException as memory is configured as 1000GB, which is more than allowed");
        }
        catch (YarnException e) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)true);
        }
        Service service = this.createServiceWithSingleComp(128);
        try {
            client.actionCreate(service);
        }
        catch (SliderException e) {
            org.junit.jupiter.api.Assertions.fail((String)"Not able to submit service as the files related to failed service with same name are not cleared");
        }
        this.waitForServiceToBeStable(client, service);
        client.actionStop(service.getName(), true);
        client.actionDestroy(service.getName());
    }
}

