/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FileUtils;
import org.apache.curator.test.TestingCluster;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceTypes;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceTypeInfo;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.security.DockerCredentialTokenIdentifier;
import org.apache.hadoop.yarn.service.MockRunningServiceContext;
import org.apache.hadoop.yarn.service.MockServiceAM;
import org.apache.hadoop.yarn.service.ServiceContext;
import org.apache.hadoop.yarn.service.ServiceScheduler;
import org.apache.hadoop.yarn.service.ServiceTestUtils;
import org.apache.hadoop.yarn.service.api.records.Artifact;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.ResourceInformation;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.api.records.ServiceState;
import org.apache.hadoop.yarn.service.component.ComponentState;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceState;
import org.apache.hadoop.yarn.util.DockerClientConfigHandler;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestServiceAM
extends ServiceTestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TestServiceAM.class);
    private File basedir;
    YarnConfiguration conf = new YarnConfiguration();
    TestingCluster zkCluster;
    @RegisterExtension
    private ServiceTestUtils.ServiceFSWatcher rule = new ServiceTestUtils.ServiceFSWatcher();

    @BeforeEach
    public void setup() throws Exception {
        this.basedir = new File("target", "apps");
        if (this.basedir.exists()) {
            FileUtils.deleteDirectory((File)this.basedir);
        } else {
            this.basedir.mkdirs();
        }
        this.zkCluster = new TestingCluster(1);
        this.zkCluster.start();
        this.conf.set("hadoop.registry.zk.quorum", this.zkCluster.getConnectString());
        LOG.info("ZK cluster: {}", (Object)this.zkCluster.getConnectString());
    }

    @AfterEach
    public void tearDown() throws IOException {
        if (this.basedir != null) {
            FileUtils.deleteDirectory((File)this.basedir);
        }
        if (this.zkCluster != null) {
            this.zkCluster.stop();
        }
    }

    @Test
    public void testContainerCompleted() throws TimeoutException, InterruptedException {
        ApplicationId applicationId = ApplicationId.newInstance((long)123456L, (int)1);
        Service exampleApp = new Service();
        exampleApp.setId(applicationId.toString());
        exampleApp.setVersion("v1");
        exampleApp.setName("testContainerCompleted");
        exampleApp.addComponent(TestServiceAM.createComponent("compa", 1L, "pwd"));
        MockServiceAM am = new MockServiceAM(exampleApp);
        am.init((Configuration)this.conf);
        am.start();
        ComponentInstance compa0 = am.getCompInstance("compa", "compa-0");
        am.feedContainerToComp(exampleApp, 1, "compa");
        am.waitForCompInstanceState(compa0, ComponentInstanceState.STARTED);
        LOG.info("Fail the container 1");
        am.feedFailedContainerToComp(exampleApp, 1, "compa");
        am.feedContainerToComp(exampleApp, 2, "compa");
        am.waitForCompInstanceState(compa0, ComponentInstanceState.INIT);
        Assertions.assertEquals((int)1, (int)am.getComponent("compa").getPendingInstances().size());
        am.stop();
    }

    @Test
    @Timeout(value=200L)
    public void testContainersFromPreviousAttemptsWithRMRestart() throws Exception {
        ApplicationId applicationId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        Service exampleApp = new Service();
        exampleApp.setId(applicationId.toString());
        exampleApp.setVersion("v1");
        exampleApp.setName("testContainersRecovers");
        String comp1Name = "comp1";
        String comp1InstName = "comp1-0";
        Component compA = TestServiceAM.createComponent(comp1Name, 1L, "sleep");
        exampleApp.addComponent(compA);
        MockServiceAM am = new MockServiceAM(exampleApp);
        ContainerId containerId = am.createContainerId(1);
        am.feedRegistryComponent(containerId, comp1Name, comp1InstName);
        am.init((Configuration)this.conf);
        am.start();
        ComponentInstance comp10 = am.getCompInstance(comp1Name, comp1InstName);
        am.feedRecoveredContainer(containerId, comp1Name);
        am.waitForCompInstanceState(comp10, ComponentInstanceState.STARTED);
        Assertions.assertEquals((int)0, (int)am.getComponent(comp1Name).getPendingInstances().size());
        GenericTestUtils.waitFor(() -> am.getCompInstance(comp1Name, comp1InstName).getContainerStatus() != null, (long)2000L, (long)200000L);
        Assertions.assertEquals((Object)ContainerState.RUNNING, (Object)am.getCompInstance(comp1Name, comp1InstName).getContainerStatus().getState(), (String)"container state");
        am.stop();
    }

    @Test
    @Timeout(value=200L)
    public void testContainersReleasedWhenExpired() throws Exception {
        ApplicationId applicationId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        Service exampleApp = new Service();
        exampleApp.setId(applicationId.toString());
        exampleApp.setName("testContainersRecovers");
        exampleApp.setVersion("v1");
        String comp1Name = "comp1";
        String comp1InstName = "comp1-0";
        Component compA = TestServiceAM.createComponent(comp1Name, 1L, "sleep");
        exampleApp.addComponent(compA);
        MockServiceAM am = new MockServiceAM(exampleApp);
        ContainerId containerId = am.createContainerId(1);
        am.feedRegistryComponent(containerId, comp1Name, comp1InstName);
        this.conf.setLong("yarn.service.container-recovery.timeout.ms", 10L);
        am.init((Configuration)this.conf);
        am.start();
        Thread.sleep(100L);
        GenericTestUtils.waitFor(() -> am.getComponent(comp1Name).getState().equals((Object)ComponentState.FLEXING), (long)100L, (long)2000L);
        Assertions.assertEquals((int)1, (int)am.getComponent(comp1Name).getPendingInstances().size());
        am.feedContainerToComp(exampleApp, 2, comp1Name);
        GenericTestUtils.waitFor(() -> am.getCompInstance(comp1Name, comp1InstName).getContainerStatus() != null, (long)2000L, (long)200000L);
        Assertions.assertEquals((Object)ContainerState.RUNNING, (Object)am.getCompInstance(comp1Name, comp1InstName).getContainerStatus().getState(), (String)"container state");
    }

    @Test
    @Timeout(value=200L)
    public void testContainersFromDifferentApp() throws Exception {
        ApplicationId applicationId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        Service exampleApp = new Service();
        exampleApp.setId(applicationId.toString());
        exampleApp.setName("testContainersFromDifferentApp");
        exampleApp.setVersion("v1");
        String comp1Name = "comp1";
        String comp1InstName = "comp1-0";
        Component compA = TestServiceAM.createComponent(comp1Name, 1L, "sleep");
        exampleApp.addComponent(compA);
        MockServiceAM am = new MockServiceAM(exampleApp);
        ContainerId containerId = am.createContainerId(1);
        am.feedRegistryComponent(containerId, comp1Name, comp1InstName);
        ApplicationId changedAppId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)2);
        exampleApp.setId(changedAppId.toString());
        am.init((Configuration)this.conf);
        am.start();
        Assertions.assertEquals((int)1, (int)am.getComponent(comp1Name).getPendingInstances().size());
        am.feedContainerToComp(exampleApp, 1, comp1Name);
        GenericTestUtils.waitFor(() -> am.getCompInstance(comp1Name, comp1InstName).getContainerStatus() != null, (long)2000L, (long)200000L);
        Assertions.assertEquals((Object)ContainerState.RUNNING, (Object)am.getCompInstance(comp1Name, comp1InstName).getContainerStatus().getState(), (String)"container state");
        am.stop();
    }

    @Test
    public void testScheduleWithMultipleResourceTypes() throws TimeoutException, InterruptedException, IOException {
        ApplicationId applicationId = ApplicationId.newInstance((long)123456L, (int)1);
        Service exampleApp = new Service();
        exampleApp.setId(applicationId.toString());
        exampleApp.setName("testScheduleWithMultipleResourceTypes");
        exampleApp.setVersion("v1");
        ArrayList<ResourceTypeInfo> resourceTypeInfos = new ArrayList<ResourceTypeInfo>(ResourceUtils.getResourcesTypeInfo());
        resourceTypeInfos.add(ResourceTypeInfo.newInstance((String)"resource-1", (String)"", (ResourceTypes)ResourceTypes.COUNTABLE));
        ResourceUtils.reinitializeResources(resourceTypeInfos);
        Component serviceCompoent = TestServiceAM.createComponent("compa", 1L, "pwd");
        serviceCompoent.getResource().setResourceInformations((Map)ImmutableMap.of((Object)"resource-1", (Object)new ResourceInformation().value(Long.valueOf(3333L)).unit("Gi")));
        exampleApp.addComponent(serviceCompoent);
        MockServiceAM am = new MockServiceAM(exampleApp);
        am.init((Configuration)this.conf);
        am.start();
        ServiceScheduler serviceScheduler = am.context.scheduler;
        AMRMClientAsync amrmClientAsync = serviceScheduler.getAmRMClient();
        Collection rr = amrmClientAsync.getMatchingRequests(0L);
        Assertions.assertEquals((int)1, (int)rr.size());
        Resource capability = ((AMRMClient.ContainerRequest)rr.iterator().next()).getCapability();
        Assertions.assertEquals((long)3333L, (long)capability.getResourceValue("resource-1"));
        Assertions.assertEquals((Object)"Gi", (Object)capability.getResourceInformation("resource-1").getUnits());
        am.stop();
    }

    @Test
    public void testContainerCompletedEventProcessed() throws Exception {
        ServiceContext context = this.createServiceContext("abc");
        MockServiceScheduler scheduler = new MockServiceScheduler(context);
        scheduler.init((Configuration)this.conf);
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)0);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId1 = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)0L);
        ContainerStatus containerStatus1 = ContainerStatus.newInstance((ContainerId)containerId1, (ContainerState)ContainerState.COMPLETE, (String)"successful", (int)0);
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        ContainerStatus containerStatus2 = ContainerStatus.newInstance((ContainerId)containerId2, (ContainerState)ContainerState.COMPLETE, (String)"successful", (int)0);
        ComponentInstance instance = (ComponentInstance)Mockito.mock(ComponentInstance.class);
        ((ComponentInstance)Mockito.doReturn((Object)"componentInstance").when((Object)instance)).getCompName();
        scheduler.addLiveCompInstance(containerId2, instance);
        ArrayList<ContainerStatus> statuses = new ArrayList<ContainerStatus>();
        statuses.add(containerStatus1);
        scheduler.addLiveCompInstance(containerId2, instance);
        statuses.add(containerStatus2);
        scheduler.callbackHandler.onContainersCompleted(statuses);
        ((AsyncDispatcher)Mockito.verify((Object)scheduler.dispatcher, (VerificationMode)Mockito.times((int)1))).getEventHandler();
        DefaultMetricsSystem.shutdown();
    }

    private ServiceContext createServiceContext(String name) throws Exception {
        Artifact artifact = new Artifact();
        artifact.setId("1");
        artifact.setType(Artifact.TypeEnum.TARBALL);
        Service serviceDef = ServiceTestUtils.createExampleApplication();
        ApplicationId applicationId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        serviceDef.setId(applicationId.toString());
        serviceDef.setName(name);
        serviceDef.setState(ServiceState.STARTED);
        serviceDef.getComponents().forEach(component -> component.setArtifact(artifact));
        MockRunningServiceContext context = new MockRunningServiceContext(this.rule, serviceDef);
        context.scheduler.getDispatcher().setDrainEventsOnStop();
        context.scheduler.getDispatcher().start();
        return context;
    }

    @Test
    public void testRecordTokensForContainers() throws Exception {
        ApplicationId applicationId = ApplicationId.newInstance((long)123456L, (int)1);
        Service exampleApp = new Service();
        exampleApp.setId(applicationId.toString());
        exampleApp.setName("testContainerCompleted");
        exampleApp.addComponent(TestServiceAM.createComponent("compa", 1L, "pwd"));
        String json = "{\"auths\": {\"https://index.docker.io/v1/\": {\"auth\": \"foobarbaz\"},\"registry.example.com\": {\"auth\": \"bazbarfoo\"}}}";
        File dockerTmpDir = new File("target", "docker-tmp");
        FileUtils.deleteQuietly((File)dockerTmpDir);
        dockerTmpDir.mkdirs();
        String dockerConfig = dockerTmpDir + "/config.json";
        BufferedWriter bw = new BufferedWriter(new FileWriter(dockerConfig));
        bw.write(json);
        bw.close();
        Credentials dockerCred = DockerClientConfigHandler.readCredentialsFromConfigFile((Path)new Path(dockerConfig), (Configuration)this.conf, (String)applicationId.toString());
        MockServiceAM am = new MockServiceAM(exampleApp, dockerCred);
        ByteBuffer amCredBuffer = am.recordTokensForContainers();
        Credentials amCreds = DockerClientConfigHandler.getCredentialsFromTokensByteBuffer((ByteBuffer)amCredBuffer);
        Assertions.assertEquals((int)2, (int)amCreds.numberOfTokens());
        for (Token tk : amCreds.getAllTokens()) {
            Assertions.assertTrue((boolean)tk.getKind().equals((Object)DockerCredentialTokenIdentifier.KIND));
        }
        am.stop();
    }

    @Test
    public void testIPChange() throws TimeoutException, InterruptedException {
        ApplicationId applicationId = ApplicationId.newInstance((long)123456L, (int)1);
        String comp1Name = "comp1";
        String comp1InstName = "comp1-0";
        Service exampleApp = new Service();
        exampleApp.setId(applicationId.toString());
        exampleApp.setVersion("v1");
        exampleApp.setName("testIPChange");
        Component comp1 = TestServiceAM.createComponent(comp1Name, 1L, "sleep 60");
        comp1.setArtifact(new Artifact().type(Artifact.TypeEnum.DOCKER));
        exampleApp.addComponent(comp1);
        MockServiceAM am = new MockServiceAM(exampleApp);
        am.init((Configuration)this.conf);
        am.start();
        ComponentInstance comp1inst0 = am.getCompInstance(comp1Name, comp1InstName);
        am.feedContainerToComp(exampleApp, 1, comp1Name);
        GenericTestUtils.waitFor(() -> comp1inst0.getContainerStatus() != null, (long)2000L, (long)200000L);
        Assertions.assertEquals((Object)"localhost", (Object)comp1inst0.getContainerStatus().getHost());
        LOG.info("Change the IP and host");
        am.updateContainerStatus(exampleApp, 1, comp1Name, "new.host");
        GenericTestUtils.waitFor(() -> comp1inst0.getContainerStatus().getHost().equals("new.host"), (long)2000L, (long)200000L);
        LOG.info("Change the IP and host again");
        am.updateContainerStatus(exampleApp, 1, comp1Name, "newer.host");
        GenericTestUtils.waitFor(() -> comp1inst0.getContainerStatus().getHost().equals("newer.host"), (long)2000L, (long)200000L);
        am.stop();
    }

    @Test
    @Timeout(value=30L)
    public void testContainersReleasedWhenPreLaunchFails() throws Exception {
        ApplicationId applicationId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        Service exampleApp = new Service();
        exampleApp.setId(applicationId.toString());
        exampleApp.setVersion("v1");
        exampleApp.setName("testContainersReleasedWhenPreLaunchFails");
        Component compA = TestServiceAM.createComponent("compa", 1L, "pwd");
        Artifact artifact = new Artifact();
        artifact.setType(Artifact.TypeEnum.TARBALL);
        compA.artifact(artifact);
        exampleApp.addComponent(compA);
        MockServiceAM am = new MockServiceAM(exampleApp);
        am.init((Configuration)this.conf);
        am.start();
        ContainerId containerId = am.createContainerId(1);
        am.feedContainerToComp(exampleApp, containerId, "compa");
        am.waitForContainerToRelease(containerId);
        ComponentInstance compAinst0 = am.getCompInstance(compA.getName(), "compa-0");
        GenericTestUtils.waitFor(() -> am.getComponent(compA.getName()).getPendingInstances().contains(compAinst0), (long)2000L, (long)30000L);
        Assertions.assertEquals((int)1, (int)am.getComponent("compa").getPendingInstances().size());
        am.stop();
    }

    @Test
    @Timeout(value=30L)
    public void testSyncSysFS() {
        ApplicationId applicationId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        Service exampleApp = new Service();
        exampleApp.setId(applicationId.toString());
        exampleApp.setVersion("v1");
        exampleApp.setName("tensorflow");
        Component compA = TestServiceAM.createComponent("compa", 1L, "pwd");
        compA.getConfiguration().getEnv().put("YARN_CONTAINER_RUNTIME_YARN_SYSFS_ENABLE", "true");
        Artifact artifact = new Artifact();
        artifact.setType(Artifact.TypeEnum.TARBALL);
        compA.artifact(artifact);
        exampleApp.addComponent(compA);
        try {
            MockServiceAM am = new MockServiceAM(exampleApp);
            am.init((Configuration)this.conf);
            am.start();
            ServiceScheduler scheduler = am.context.scheduler;
            scheduler.syncSysFs(exampleApp);
            scheduler.close();
            am.stop();
            am.close();
        }
        catch (Exception e) {
            LOG.error("Fail to sync sysfs.", (Throwable)e);
            Assertions.fail((String)"Fail to sync sysfs.");
        }
    }

    @Test
    public void testScheduleWithResourceAttributes() throws Exception {
        ApplicationId applicationId = ApplicationId.newInstance((long)123456L, (int)1);
        Service exampleApp = new Service();
        exampleApp.setId(applicationId.toString());
        exampleApp.setName("testScheduleWithResourceAttributes");
        exampleApp.setVersion("v1");
        ArrayList<ResourceTypeInfo> resourceTypeInfos = new ArrayList<ResourceTypeInfo>(ResourceUtils.getResourcesTypeInfo());
        resourceTypeInfos.add(ResourceTypeInfo.newInstance((String)"test-resource", (String)"", (ResourceTypes)ResourceTypes.COUNTABLE));
        ResourceUtils.reinitializeResources(resourceTypeInfos);
        Component serviceCompoent = TestServiceAM.createComponent("compa", 1L, "pwd");
        serviceCompoent.getResource().setResourceInformations((Map)ImmutableMap.of((Object)"test-resource", (Object)new ResourceInformation().value(Long.valueOf(1234L)).unit("Gi").attributes((Map)ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2"))));
        exampleApp.addComponent(serviceCompoent);
        MockServiceAM am = new MockServiceAM(exampleApp);
        am.init((Configuration)this.conf);
        am.start();
        ServiceScheduler serviceScheduler = am.context.scheduler;
        AMRMClientAsync amrmClientAsync = serviceScheduler.getAmRMClient();
        Collection rr = amrmClientAsync.getMatchingRequests(0L);
        Assertions.assertEquals((int)1, (int)rr.size());
        Resource capability = ((AMRMClient.ContainerRequest)rr.iterator().next()).getCapability();
        Assertions.assertEquals((long)1234L, (long)capability.getResourceValue("test-resource"));
        Assertions.assertEquals((Object)"Gi", (Object)capability.getResourceInformation("test-resource").getUnits());
        Assertions.assertEquals((int)2, (int)capability.getResourceInformation("test-resource").getAttributes().size());
        am.stop();
    }

    class MockServiceScheduler
    extends ServiceScheduler {
        private AsyncDispatcher dispatcher;
        private ServiceScheduler.AMRMClientCallback callbackHandler;

        MockServiceScheduler(ServiceContext context) {
            super(context);
            this.callbackHandler = new ServiceScheduler.AMRMClientCallback((ServiceScheduler)this);
        }

        protected AsyncDispatcher createAsyncDispatcher() {
            this.dispatcher = (AsyncDispatcher)Mockito.mock(AsyncDispatcher.class);
            EventHandler handler = (EventHandler)Mockito.mock(EventHandler.class);
            ((AsyncDispatcher)Mockito.doReturn((Object)handler).when((Object)this.dispatcher)).getEventHandler();
            return this.dispatcher;
        }

        protected AMRMClientAsync<AMRMClient.ContainerRequest> createAMRMClient() {
            return AMRMClientAsync.createAMRMClientAsync((int)1000, (AMRMClientAsync.AbstractCallbackHandler)this.callbackHandler);
        }
    }
}

