/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FileUtils;
import org.apache.curator.test.TestingCluster;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.registry.client.impl.zk.CuratorService;
import org.apache.hadoop.service.ServiceOperations;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.base.Throwables;
import org.apache.hadoop.thirdparty.com.google.common.collect.HashMultimap;
import org.apache.hadoop.thirdparty.com.google.common.collect.Multimap;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.apache.hadoop.yarn.service.ServiceContext;
import org.apache.hadoop.yarn.service.ServiceManager;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.Container;
import org.apache.hadoop.yarn.service.api.records.ContainerState;
import org.apache.hadoop.yarn.service.api.records.Resource;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.api.records.ServiceState;
import org.apache.hadoop.yarn.service.client.ServiceClient;
import org.apache.hadoop.yarn.service.exceptions.SliderException;
import org.apache.hadoop.yarn.service.utils.JsonSerDeser;
import org.apache.hadoop.yarn.service.utils.ServiceApiUtil;
import org.apache.hadoop.yarn.service.utils.SliderFileSystem;
import org.apache.hadoop.yarn.util.LinuxResourceCalculatorPlugin;
import org.apache.hadoop.yarn.util.ProcfsBasedProcessTree;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceTestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceTestUtils.class);
    private MiniYARNCluster yarnCluster = null;
    private MiniDFSCluster hdfsCluster = null;
    private TestingCluster zkCluster;
    private CuratorService curatorService;
    private FileSystem fs = null;
    private Configuration conf = null;
    public static final int NUM_NMS = 1;
    private File basedir;
    public static final JsonSerDeser<Service> JSON_SER_DESER = new JsonSerDeser(Service.class, PropertyNamingStrategies.SNAKE_CASE);

    public static Service createExampleApplication() {
        Service exampleApp = new Service();
        exampleApp.setName("example-app");
        exampleApp.setVersion("v1");
        exampleApp.addComponent(ServiceTestUtils.createComponent("compa"));
        exampleApp.addComponent(ServiceTestUtils.createComponent("compb"));
        return exampleApp;
    }

    public static Service createTerminatingJobExample(String serviceName) {
        Service exampleApp = new Service();
        exampleApp.setName(serviceName);
        exampleApp.setVersion("v1");
        exampleApp.addComponent(ServiceTestUtils.createComponent("terminating-comp1", 2L, "sleep 1000", Component.RestartPolicyEnum.NEVER, null));
        exampleApp.addComponent(ServiceTestUtils.createComponent("terminating-comp2", 2L, "sleep 1000", Component.RestartPolicyEnum.ON_FAILURE, null));
        exampleApp.addComponent(ServiceTestUtils.createComponent("terminating-comp3", 2L, "sleep 1000", Component.RestartPolicyEnum.ON_FAILURE, null));
        return exampleApp;
    }

    public static Service createTerminatingDominantComponentJobExample(String serviceName) {
        Service exampleApp = new Service();
        exampleApp.setName(serviceName);
        exampleApp.setVersion("v1");
        Component serviceStateComponent = ServiceTestUtils.createComponent("terminating-comp1", 2L, "sleep 1000", Component.RestartPolicyEnum.NEVER, null);
        serviceStateComponent.getConfiguration().setProperty("yarn.service.container-state-report-as-service-state", "true");
        exampleApp.addComponent(serviceStateComponent);
        exampleApp.addComponent(ServiceTestUtils.createComponent("terminating-comp2", 2L, "sleep 60000", Component.RestartPolicyEnum.ON_FAILURE, null));
        return exampleApp;
    }

    public static Component createComponent(String name) {
        return ServiceTestUtils.createComponent(name, 2L, "sleep 1000", Component.RestartPolicyEnum.ALWAYS, null);
    }

    protected static Component createComponent(String name, long numContainers, String command) {
        Component comp1 = new Component();
        comp1.setNumberOfContainers(Long.valueOf(numContainers));
        comp1.setLaunchCommand(command);
        comp1.setName(name);
        Resource resource = new Resource();
        comp1.setResource(resource);
        resource.setMemory("128");
        resource.setCpus(Integer.valueOf(1));
        return comp1;
    }

    protected static Component createComponent(String name, long numContainers, String command, Component.RestartPolicyEnum restartPolicyEnum, List<String> dependencies) {
        Component comp = ServiceTestUtils.createComponent(name, numContainers, command);
        comp.setRestartPolicy(restartPolicyEnum);
        if (dependencies != null) {
            comp.dependencies(dependencies);
        }
        return comp;
    }

    public static SliderFileSystem initMockFs() throws IOException {
        return ServiceTestUtils.initMockFs(null);
    }

    public static SliderFileSystem initMockFs(Service ext) throws IOException {
        SliderFileSystem sfs = (SliderFileSystem)Mockito.mock(SliderFileSystem.class);
        FileSystem mockFs = (FileSystem)Mockito.mock(FileSystem.class);
        JsonSerDeser jsonSerDeser = (JsonSerDeser)Mockito.mock(JsonSerDeser.class);
        Mockito.when((Object)sfs.getFileSystem()).thenReturn((Object)mockFs);
        Mockito.when((Object)sfs.buildClusterDirPath((String)ArgumentMatchers.any())).thenReturn((Object)new Path("cluster_dir_path"));
        if (ext != null) {
            Mockito.when((Object)((Service)jsonSerDeser.load((FileSystem)ArgumentMatchers.any(), (Path)ArgumentMatchers.any()))).thenReturn((Object)ext);
        }
        ServiceApiUtil.setJsonSerDeser((JsonSerDeser)jsonSerDeser);
        return sfs;
    }

    protected void setConf(YarnConfiguration conf) {
        this.conf = conf;
    }

    protected Configuration getConf() {
        return this.conf;
    }

    protected FileSystem getFS() {
        return this.fs;
    }

    protected MiniYARNCluster getYarnCluster() {
        return this.yarnCluster;
    }

    protected void setupInternal(int numNodeManager) throws Exception {
        LOG.info("Starting up YARN cluster");
        if (this.conf == null) {
            this.setConf(new YarnConfiguration());
            this.conf.setBoolean("yarn.minicluster.fixed.ports", false);
            this.conf.setBoolean("yarn.minicluster.use-rpc", false);
            this.conf.setInt("yarn.resourcemanager.max-completed-applications", 1000);
        }
        this.conf.setInt("yarn.scheduler.minimum-allocation-mb", 128);
        this.conf.setLong("yarn.dispatcher.drain-events.timeout", 1000L);
        this.conf.set("yarn.log.dir", "target");
        this.conf.set("yarn.nodemanager.aux-services", "");
        this.conf.set("yarn.nodemanager.vmem-pmem-ratio", "8");
        this.conf.set("yarn.nodemanager.container-monitor.resource-calculator.class", LinuxResourceCalculatorPlugin.class.getName());
        this.conf.set("yarn.nodemanager.container-monitor.process-tree.class", ProcfsBasedProcessTree.class.getName());
        this.conf.setBoolean("yarn.minicluster.control-resource-monitoring", true);
        this.conf.setBoolean("yarn.timeline-service.enabled", false);
        this.conf.setInt("yarn.nodemanager.disk-health-checker.max-disk-utilization-per-disk-percentage", 100);
        this.conf.setLong("yarn.nodemanager.delete.debug-delay-sec", 60000L);
        this.conf.setLong("yarn.service.am-resource.memory", 526L);
        this.conf.setLong("yarn.service.readiness-check-interval.seconds", 5L);
        this.conf.setBoolean("yarn.nodemanager.vmem-check-enabled", false);
        this.conf.setBoolean("yarn.nodemanager.pmem-check-enabled", false);
        this.conf.set("hadoop.http.filter.initializers", "org.apache.hadoop.security.AuthenticationFilterInitializer,org.apache.hadoop.security.HttpCrossOriginFilterInitializer");
        this.zkCluster = new TestingCluster(1);
        this.zkCluster.start();
        this.conf.set("yarn.resourcemanager.zk-address", this.zkCluster.getConnectString());
        this.conf.set("hadoop.registry.zk.quorum", this.zkCluster.getConnectString());
        LOG.info("ZK cluster: {}.", (Object)this.zkCluster.getConnectString());
        this.curatorService = new CuratorService("testCuratorService");
        this.curatorService.init(this.conf);
        this.curatorService.start();
        this.fs = FileSystem.get((Configuration)this.conf);
        this.basedir = new File("target", "apps");
        if (this.basedir.exists()) {
            FileUtils.deleteDirectory((File)this.basedir);
        } else {
            this.basedir.mkdirs();
        }
        this.conf.set("yarn.service.base.path", this.basedir.getAbsolutePath());
        if (this.yarnCluster == null) {
            this.yarnCluster = new MiniYARNCluster(this.getClass().getSimpleName(), 1, numNodeManager, 1, 1);
            this.yarnCluster.init(this.conf);
            this.yarnCluster.start();
            this.waitForNMsToRegister();
            URL url = Thread.currentThread().getContextClassLoader().getResource("yarn-site.xml");
            if (url == null) {
                throw new RuntimeException("Could not find 'yarn-site.xml' dummy file in classpath");
            }
            Configuration yarnClusterConfig = this.yarnCluster.getConfig();
            yarnClusterConfig.set("yarn.application.classpath", new File(url.getPath()).getParent());
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            yarnClusterConfig.writeXml((OutputStream)bytesOut);
            bytesOut.close();
            OutputStream os = Files.newOutputStream(new File(url.getPath()).toPath(), new OpenOption[0]);
            os.write(bytesOut.toByteArray());
            os.close();
            LOG.info("Write yarn-site.xml configs to: {}.", (Object)url);
        }
        if (this.hdfsCluster == null) {
            HdfsConfiguration hdfsConfig = new HdfsConfiguration();
            this.hdfsCluster = new MiniDFSCluster.Builder((Configuration)hdfsConfig).numDataNodes(1).build();
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            LOG.error("setup thread sleep interrupted.", (Throwable)e);
        }
    }

    public void shutdown() throws IOException {
        if (this.yarnCluster != null) {
            try {
                this.yarnCluster.stop();
            }
            finally {
                this.yarnCluster = null;
            }
        }
        if (this.hdfsCluster != null) {
            try {
                this.hdfsCluster.shutdown();
            }
            finally {
                this.hdfsCluster = null;
            }
        }
        if (this.curatorService != null) {
            ServiceOperations.stop((org.apache.hadoop.service.Service)this.curatorService);
        }
        if (this.zkCluster != null) {
            this.zkCluster.stop();
        }
        if (this.basedir != null) {
            FileUtils.deleteDirectory((File)this.basedir);
        }
        SliderFileSystem sfs = new SliderFileSystem(this.conf);
        Path appDir = sfs.getBaseApplicationPath();
        sfs.getFileSystem().delete(appDir, true);
    }

    private void waitForNMsToRegister() throws Exception {
        for (int sec = 60; sec >= 0 && this.yarnCluster.getResourceManager().getRMContext().getRMNodes().size() < 1; --sec) {
            Thread.sleep(1000L);
        }
    }

    public static ServiceClient createClient(Configuration conf) throws Exception {
        ServiceClient client = new ServiceClient(){

            protected Path addJarResource(String appName, Map<String, LocalResource> localResources) throws IOException, SliderException {
                return null;
            }
        };
        client.init(conf);
        client.start();
        return client;
    }

    public static ServiceManager createServiceManager(ServiceContext context) {
        ServiceManager serviceManager = new ServiceManager(context);
        context.setServiceManager(serviceManager);
        return serviceManager;
    }

    public static YarnClient createYarnClient(Configuration conf) {
        YarnClient client = YarnClient.createYarnClient();
        client.init(conf);
        client.start();
        return client;
    }

    protected CuratorService getCuratorService() throws IOException {
        return this.curatorService;
    }

    protected Multimap<String, String> waitForAllCompToBeReady(ServiceClient client, Service exampleApp) throws TimeoutException, InterruptedException {
        int expectedTotalContainers = this.countTotalContainers(exampleApp);
        HashMultimap allContainers = HashMultimap.create();
        GenericTestUtils.waitFor(() -> ServiceTestUtils.lambda$waitForAllCompToBeReady$0(client, exampleApp, (Multimap)allContainers, expectedTotalContainers), (long)2000L, (long)200000L);
        return allContainers;
    }

    protected void waitForServiceToBeStable(ServiceClient client, Service exampleApp) throws TimeoutException, InterruptedException {
        this.waitForServiceToBeStable(client, exampleApp, 200000);
    }

    protected void waitForServiceToBeStable(ServiceClient client, Service exampleApp, int waitForMillis) throws TimeoutException, InterruptedException {
        this.waitForServiceToBeInState(client, exampleApp, ServiceState.STABLE, waitForMillis);
    }

    protected void waitForServiceToBeStarted(ServiceClient client, Service exampleApp) throws TimeoutException, InterruptedException {
        this.waitForServiceToBeInState(client, exampleApp, ServiceState.STARTED);
    }

    protected void waitForServiceToBeExpressUpgrading(ServiceClient client, Service exampleApp) throws TimeoutException, InterruptedException {
        this.waitForServiceToBeInState(client, exampleApp, ServiceState.EXPRESS_UPGRADING);
    }

    protected void waitForServiceToBeInState(ServiceClient client, Service exampleApp, ServiceState desiredState) throws TimeoutException, InterruptedException {
        this.waitForServiceToBeInState(client, exampleApp, desiredState, 200000);
    }

    protected void waitForServiceToBeInState(ServiceClient client, Service exampleApp, ServiceState desiredState, int waitForMillis) throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor(() -> {
            try {
                Service retrievedApp = client.getStatus(exampleApp.getName());
                return retrievedApp.getState() == desiredState;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }, (long)2000L, (long)waitForMillis);
    }

    private int countTotalContainers(Service service) {
        int totalContainers = 0;
        for (Component component : service.getComponents()) {
            totalContainers = (int)((long)totalContainers + component.getNumberOfContainers());
        }
        return totalContainers;
    }

    private static /* synthetic */ Boolean lambda$waitForAllCompToBeReady$0(ServiceClient client, Service exampleApp, Multimap allContainers, int expectedTotalContainers) {
        try {
            Service retrievedApp = client.getStatus(exampleApp.getName());
            int totalReadyContainers = 0;
            allContainers.clear();
            LOG.info("Num Components " + retrievedApp.getComponents().size());
            for (Component component : retrievedApp.getComponents()) {
                LOG.info("looking for  " + component.getName());
                LOG.info(component.toString());
                if (component.getContainers() == null) continue;
                if ((long)component.getContainers().size() == exampleApp.getComponent(component.getName()).getNumberOfContainers()) {
                    for (Container container : component.getContainers()) {
                        LOG.info("Container state {}, component {}.", (Object)container.getState(), (Object)component.getName());
                        if (container.getState() != ContainerState.READY) continue;
                        ++totalReadyContainers;
                        allContainers.put((Object)component.getName(), (Object)container.getId());
                        LOG.info("Found 1 ready container {}.", (Object)container.getId());
                    }
                    continue;
                }
                LOG.info(component.getName() + " Expected number of containers " + exampleApp.getComponent(component.getName()).getNumberOfContainers() + ", current = " + component.getContainers());
            }
            LOG.info("Exit loop, totalReadyContainers= " + totalReadyContainers + " expected = " + expectedTotalContainers);
            return totalReadyContainers == expectedTotalContainers;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static class ServiceFSWatcher
    implements BeforeEachCallback,
    AfterEachCallback {
        private YarnConfiguration conf;
        private SliderFileSystem fs;
        private java.nio.file.Path serviceBasePath;

        public void afterEach(ExtensionContext context) throws Exception {
            this.delete(context);
        }

        public void beforeEach(ExtensionContext context) throws Exception {
            this.conf = new YarnConfiguration();
            this.delete(context);
            this.serviceBasePath = Paths.get("target", this.getClassName(context), this.getMethodName(context));
            this.conf.set("yarn.service.base.path", this.serviceBasePath.toString());
            try {
                Files.createDirectories(this.serviceBasePath, new FileAttribute[0]);
                this.fs = new SliderFileSystem((Configuration)this.conf);
                this.fs.setAppDir(new Path(this.serviceBasePath.toString()));
            }
            catch (IOException e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }

        private void delete(ExtensionContext context) {
            FileUtils.deleteQuietly((File)Paths.get("target", this.getClassName(context)).toFile());
        }

        private String getClassName(ExtensionContext context) {
            Class requiredTestClass = context.getRequiredTestClass();
            return requiredTestClass.getName();
        }

        private String getMethodName(ExtensionContext context) {
            return ((Method)context.getTestMethod().get()).getName();
        }

        public YarnConfiguration getConf() {
            return this.conf;
        }

        public SliderFileSystem getFs() {
            return this.fs;
        }

        public java.nio.file.Path getServiceBasePath() {
            return this.serviceBasePath;
        }
    }
}

