/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.Futures;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.client.api.NMClient;
import org.apache.hadoop.yarn.client.api.async.NMClientAsync;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.service.ServiceContext;
import org.apache.hadoop.yarn.service.ServiceManager;
import org.apache.hadoop.yarn.service.ServiceScheduler;
import org.apache.hadoop.yarn.service.ServiceTestUtils;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.component.ComponentEvent;
import org.apache.hadoop.yarn.service.component.ComponentEventType;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceEvent;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceEventType;
import org.apache.hadoop.yarn.service.containerlaunch.AbstractLauncher;
import org.apache.hadoop.yarn.service.containerlaunch.ContainerLaunchService;
import org.apache.hadoop.yarn.service.exceptions.SliderException;
import org.apache.hadoop.yarn.service.provider.ProviderService;
import org.apache.hadoop.yarn.service.provider.ProviderUtils;
import org.apache.hadoop.yarn.service.registry.YarnRegistryViewForProviders;
import org.apache.hadoop.yarn.service.utils.ServiceUtils;
import org.apache.hadoop.yarn.service.utils.SliderFileSystem;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;

public class MockRunningServiceContext
extends ServiceContext {
    private static final NodeId NODE_ID = NodeId.fromString((String)"localhost:0");

    public MockRunningServiceContext(ServiceTestUtils.ServiceFSWatcher fsWatcher, Service serviceDef) throws Exception {
        this.service = serviceDef;
        this.fs = fsWatcher.getFs();
        final ContainerLaunchService mockLaunchService = (ContainerLaunchService)Mockito.mock(ContainerLaunchService.class);
        this.scheduler = new ServiceScheduler(this){

            protected YarnRegistryViewForProviders createYarnRegistryOperations(ServiceContext context, RegistryOperations registryClient) {
                return (YarnRegistryViewForProviders)Mockito.mock(YarnRegistryViewForProviders.class);
            }

            public NMClientAsync createNMClient() {
                NMClientAsync nmClientAsync = super.createNMClient();
                NMClient nmClient = (NMClient)Mockito.mock(NMClient.class);
                try {
                    Mockito.when((Object)nmClient.getContainerStatus((ContainerId)ArgumentMatchers.any(), (NodeId)ArgumentMatchers.any())).thenAnswer(invocation -> ContainerStatus.newInstance((ContainerId)((ContainerId)invocation.getArguments()[0]), (ContainerState)ContainerState.RUNNING, (String)"", (int)0));
                }
                catch (IOException | YarnException e) {
                    throw new RuntimeException(e);
                }
                nmClientAsync.setClient(nmClient);
                return nmClientAsync;
            }

            public ContainerLaunchService getContainerLaunchService() {
                return mockLaunchService;
            }

            public ServiceUtils.ProcessTerminationHandler getTerminationHandler() {
                return new ServiceUtils.ProcessTerminationHandler(){

                    public void terminate(int exitCode) {
                    }
                };
            }

            protected ServiceManager createServiceManager() {
                return ServiceTestUtils.createServiceManager(MockRunningServiceContext.this);
            }
        };
        this.scheduler.init((Configuration)fsWatcher.getConf());
        Mockito.when((Object)mockLaunchService.launchCompInstance((Service)ArgumentMatchers.any(), (ComponentInstance)ArgumentMatchers.any(), (Container)ArgumentMatchers.any(), (ContainerLaunchService.ComponentLaunchContext)ArgumentMatchers.any())).thenAnswer(this::launchAndReinitHelper);
        Mockito.when((Object)mockLaunchService.reInitCompInstance((Service)ArgumentMatchers.any(), (ComponentInstance)ArgumentMatchers.any(), (Container)ArgumentMatchers.any(), (ContainerLaunchService.ComponentLaunchContext)ArgumentMatchers.any())).thenAnswer(this::launchAndReinitHelper);
        this.stabilizeComponents(this);
    }

    private Future<ProviderService.ResolvedLaunchParams> launchAndReinitHelper(InvocationOnMock invocation) throws IOException, SliderException {
        AbstractLauncher launcher = new AbstractLauncher(this.scheduler.getContext());
        ComponentInstance instance = (ComponentInstance)invocation.getArguments()[1];
        Container container = (Container)invocation.getArguments()[2];
        ContainerLaunchService.ComponentLaunchContext clc = (ContainerLaunchService.ComponentLaunchContext)invocation.getArguments()[3];
        ProviderService.ResolvedLaunchParams resolvedParams = new ProviderService.ResolvedLaunchParams();
        ProviderUtils.createConfigFileAndAddLocalResource((AbstractLauncher)launcher, (SliderFileSystem)this.fs, (ContainerLaunchService.ComponentLaunchContext)clc, new HashMap(), (ComponentInstance)instance, (ServiceContext)this.scheduler.getContext(), (ProviderService.ResolvedLaunchParams)resolvedParams);
        ProviderUtils.handleStaticFilesForLocalization((AbstractLauncher)launcher, (SliderFileSystem)this.fs, (ContainerLaunchService.ComponentLaunchContext)clc, (ProviderService.ResolvedLaunchParams)resolvedParams);
        return Futures.immediateFuture((Object)resolvedParams);
    }

    private void stabilizeComponents(ServiceContext context) {
        ApplicationAttemptId attemptId;
        ApplicationId appId = ApplicationId.fromString((String)context.service.getId());
        context.attemptId = attemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        Map componentState = context.scheduler.getAllComponents();
        int counter = 0;
        for (Component componentSpec : context.service.getComponents()) {
            org.apache.hadoop.yarn.service.component.Component component = new org.apache.hadoop.yarn.service.component.Component(componentSpec, 1L, context);
            componentState.put(component.getName(), component);
            component.handle(new ComponentEvent(component.getName(), ComponentEventType.FLEX).setDesired(component.getComponentSpec().getNumberOfContainers().longValue()));
            int i = 0;
            while ((long)i < componentSpec.getNumberOfContainers()) {
                this.assignNewContainer(attemptId, ++counter, component);
                ++i;
            }
            component.handle(new ComponentEvent(component.getName(), ComponentEventType.CHECK_STABLE));
        }
    }

    public void assignNewContainer(ApplicationAttemptId attemptId, long containerNum, org.apache.hadoop.yarn.service.component.Component component) {
        Container container = Container.newInstance((ContainerId)ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)containerNum), (NodeId)NODE_ID, (String)"localhost", null, null, null);
        component.handle(new ComponentEvent(component.getName(), ComponentEventType.CONTAINER_ALLOCATED).setContainer(container).setContainerId(container.getId()));
        ComponentInstance instance = (ComponentInstance)this.scheduler.getLiveInstances().get(container.getId());
        ComponentInstanceEvent startEvent = new ComponentInstanceEvent(container.getId(), ComponentInstanceEventType.START);
        instance.handle(startEvent);
        ComponentInstanceEvent readyEvent = new ComponentInstanceEvent(container.getId(), ComponentInstanceEventType.BECOME_READY);
        instance.handle(readyEvent);
    }
}

