/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.client;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.hadoop.registry.client.api.RegistryOperationsFactory;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationTimeoutsRequest;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ApplicationTimeout;
import org.apache.hadoop.yarn.api.records.ApplicationTimeoutType;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.AppAdminClient;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.client.util.YarnClientUtils;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.proto.ClientAMProtocol;
import org.apache.hadoop.yarn.service.ClientAMProtocol;
import org.apache.hadoop.yarn.service.ServiceMaster;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.ComponentContainers;
import org.apache.hadoop.yarn.service.api.records.ConfigFile;
import org.apache.hadoop.yarn.service.api.records.Container;
import org.apache.hadoop.yarn.service.api.records.ContainerState;
import org.apache.hadoop.yarn.service.api.records.ServiceState;
import org.apache.hadoop.yarn.service.client.ClientAMProxy;
import org.apache.hadoop.yarn.service.conf.SliderExitCodes;
import org.apache.hadoop.yarn.service.conf.YarnServiceConf;
import org.apache.hadoop.yarn.service.conf.YarnServiceConstants;
import org.apache.hadoop.yarn.service.containerlaunch.ClasspathConstructor;
import org.apache.hadoop.yarn.service.containerlaunch.JavaCommandLineBuilder;
import org.apache.hadoop.yarn.service.exceptions.BadClusterStateException;
import org.apache.hadoop.yarn.service.exceptions.BadConfigException;
import org.apache.hadoop.yarn.service.exceptions.SliderException;
import org.apache.hadoop.yarn.service.provider.AbstractClientProvider;
import org.apache.hadoop.yarn.service.provider.ProviderUtils;
import org.apache.hadoop.yarn.service.utils.ServiceApiUtil;
import org.apache.hadoop.yarn.service.utils.ServiceRegistryUtils;
import org.apache.hadoop.yarn.service.utils.ServiceUtils;
import org.apache.hadoop.yarn.service.utils.SliderFileSystem;
import org.apache.hadoop.yarn.service.utils.ZookeeperUtils;
import org.apache.hadoop.yarn.util.DockerClientConfigHandler;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.Times;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class ServiceClient
extends AppAdminClient
implements SliderExitCodes,
YarnServiceConstants {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceClient.class);
    private SliderFileSystem fs;
    protected YarnClient yarnClient;
    private Map<String, AppInfo> cachedAppInfo = new ConcurrentHashMap<String, AppInfo>();
    private RegistryOperations registryClient;
    private CuratorFramework curatorClient;
    private YarnRPC rpc;
    private static EnumSet<YarnApplicationState> terminatedStates = EnumSet.of(YarnApplicationState.FINISHED, YarnApplicationState.FAILED, YarnApplicationState.KILLED);
    private static EnumSet<YarnApplicationState> liveStates = EnumSet.of(YarnApplicationState.NEW, YarnApplicationState.NEW_SAVING, YarnApplicationState.SUBMITTED, YarnApplicationState.ACCEPTED, YarnApplicationState.RUNNING);
    private static EnumSet<YarnApplicationState> preRunningStates = EnumSet.of(YarnApplicationState.NEW, YarnApplicationState.NEW_SAVING, YarnApplicationState.SUBMITTED, YarnApplicationState.ACCEPTED);

    protected void serviceInit(Configuration configuration) throws Exception {
        this.fs = new SliderFileSystem(configuration);
        this.yarnClient = YarnClient.createYarnClient();
        this.rpc = YarnRPC.create((Configuration)configuration);
        this.addService((Service)this.yarnClient);
        super.serviceInit(configuration);
    }

    protected void serviceStop() throws Exception {
        if (this.registryClient != null) {
            this.registryClient.stop();
        }
        this.fs.getFileSystem().close();
        super.serviceStop();
    }

    public org.apache.hadoop.yarn.service.api.records.Service loadAppJsonFromLocalFS(String fileName, String serviceName, Long lifetime, String queue) throws IOException, YarnException {
        File file = new File(fileName);
        if (!file.exists() && fileName.equals(file.getName())) {
            String dir;
            String[] examplesDirs;
            String examplesDirStr = System.getenv("YARN_SERVICE_EXAMPLES_DIR");
            if (examplesDirStr == null) {
                String yarnHome = System.getenv(ApplicationConstants.Environment.HADOOP_YARN_HOME.key());
                examplesDirs = new String[]{yarnHome + "/share/hadoop/yarn/yarn-service-examples", yarnHome + "/yarn-service-examples"};
            } else {
                examplesDirs = StringUtils.split((String)examplesDirStr, (String)":");
            }
            String[] stringArray = examplesDirs;
            int n = stringArray.length;
            for (int i = 0; i < n && !(file = new File(MessageFormat.format("{0}/{1}/{2}.json", dir = stringArray[i], fileName, fileName))).exists() && !(file = new File(MessageFormat.format("{0}/{1}.json", dir, fileName))).exists(); ++i) {
            }
        }
        if (!file.exists()) {
            throw new YarnException("File or example could not be found: " + fileName);
        }
        Path filePath = new Path(file.getAbsolutePath());
        LOG.info("Loading service definition from local FS: " + filePath);
        org.apache.hadoop.yarn.service.api.records.Service service = ServiceApiUtil.jsonSerDeser.load((FileSystem)FileSystem.getLocal((Configuration)this.getConfig()), filePath);
        if (!StringUtils.isEmpty((CharSequence)serviceName)) {
            service.setName(serviceName);
        }
        if (lifetime != null && lifetime > 0L) {
            service.setLifetime(lifetime);
        }
        if (!StringUtils.isEmpty((CharSequence)queue)) {
            service.setQueue(queue);
        }
        return service;
    }

    public int actionSave(String fileName, String serviceName, Long lifetime, String queue) throws IOException, YarnException {
        return this.actionBuild(this.loadAppJsonFromLocalFS(fileName, serviceName, lifetime, queue));
    }

    public int actionBuild(org.apache.hadoop.yarn.service.api.records.Service service) throws YarnException, IOException {
        ServiceApiUtil.validateAndResolveService(service, this.fs, this.getConfig());
        Path appDir = this.checkAppNotExistOnHdfs(service, false);
        ServiceApiUtil.createDirAndPersistApp(this.fs, appDir, service);
        return 0;
    }

    private ApplicationReport upgradePrecheck(org.apache.hadoop.yarn.service.api.records.Service service) throws YarnException, IOException {
        boolean upgradeEnabled = this.getConfig().getBoolean("yarn.service.upgrade.enabled", false);
        if (!upgradeEnabled) {
            throw new YarnException("Service upgrade is disabled.");
        }
        org.apache.hadoop.yarn.service.api.records.Service persistedService = ServiceApiUtil.loadService(this.fs, service.getName());
        if (!StringUtils.isEmpty((CharSequence)persistedService.getId())) {
            this.cachedAppInfo.put(persistedService.getName(), new AppInfo(ApplicationId.fromString((String)persistedService.getId()), persistedService.getKerberosPrincipal().getPrincipalName()));
        }
        if (persistedService.getVersion().equals(service.getVersion())) {
            String message = service.getName() + " is already at version " + service.getVersion() + ". There is nothing to upgrade.";
            LOG.error(message);
            throw new YarnException(message);
        }
        boolean foundNotNeverComp = false;
        for (Component comp : persistedService.getComponents()) {
            if (comp.getRestartPolicy().equals((Object)Component.RestartPolicyEnum.NEVER)) continue;
            foundNotNeverComp = true;
            break;
        }
        if (!foundNotNeverComp) {
            String message = "All the components of the service " + service.getName() + " have " + Component.RestartPolicyEnum.NEVER + " restart policy, so it cannot be upgraded.";
            LOG.error(message);
            throw new YarnException(message);
        }
        org.apache.hadoop.yarn.service.api.records.Service liveService = this.getStatus(service.getName());
        if (!liveService.getState().equals((Object)ServiceState.STABLE)) {
            String message = service.getName() + " is at " + liveService.getState() + " state and upgrade can only be initiated when service is STABLE.";
            LOG.error(message);
            throw new YarnException(message);
        }
        Path serviceUpgradeDir = this.checkAppNotExistOnHdfs(service, true);
        ServiceApiUtil.validateAndResolveService(service, this.fs, this.getConfig());
        ServiceApiUtil.createDirAndPersistApp(this.fs, serviceUpgradeDir, service);
        ApplicationReport appReport = this.yarnClient.getApplicationReport(this.getAppId(service.getName()));
        if (StringUtils.isEmpty((CharSequence)appReport.getHost())) {
            throw new YarnException(service.getName() + " AM hostname is empty");
        }
        return appReport;
    }

    public int actionUpgradeExpress(String appName, File path) throws IOException, YarnException {
        org.apache.hadoop.yarn.service.api.records.Service service = this.loadAppJsonFromLocalFS(path.getAbsolutePath(), appName, null, null);
        service.setState(ServiceState.UPGRADING_AUTO_FINALIZE);
        this.actionUpgradeExpress(service);
        return 0;
    }

    public int actionUpgradeExpress(org.apache.hadoop.yarn.service.api.records.Service service) throws YarnException, IOException {
        ClientAMProtocol.UpgradeServiceResponseProto responseProto;
        ApplicationReport appReport = this.upgradePrecheck(service);
        ClientAMProtocol proxy = this.createAMProxy(service.getName(), appReport);
        ClientAMProtocol.UpgradeServiceRequestProto.Builder requestBuilder = ClientAMProtocol.UpgradeServiceRequestProto.newBuilder();
        requestBuilder.setVersion(service.getVersion());
        if (service.getState().equals((Object)ServiceState.UPGRADING_AUTO_FINALIZE)) {
            requestBuilder.setAutoFinalize(true);
        }
        if (service.getState().equals((Object)ServiceState.EXPRESS_UPGRADING)) {
            requestBuilder.setExpressUpgrade(true);
            requestBuilder.setAutoFinalize(true);
        }
        if ((responseProto = proxy.upgrade(requestBuilder.build())).hasError()) {
            LOG.error("Service {} express upgrade to version {} failed because {}", new Object[]{service.getName(), service.getVersion(), responseProto.getError()});
            throw new YarnException("Failed to express upgrade service " + service.getName() + " to version " + service.getVersion() + " because " + responseProto.getError());
        }
        return 0;
    }

    public int initiateUpgrade(String appName, String fileName, boolean autoFinalize) throws IOException, YarnException {
        org.apache.hadoop.yarn.service.api.records.Service upgradeService = this.loadAppJsonFromLocalFS(fileName, appName, null, null);
        if (autoFinalize) {
            upgradeService.setState(ServiceState.UPGRADING_AUTO_FINALIZE);
        } else {
            upgradeService.setState(ServiceState.UPGRADING);
        }
        return this.initiateUpgrade(upgradeService);
    }

    public int initiateUpgrade(org.apache.hadoop.yarn.service.api.records.Service service) throws YarnException, IOException {
        ClientAMProtocol.UpgradeServiceResponseProto responseProto;
        ApplicationReport appReport = this.upgradePrecheck(service);
        ClientAMProtocol proxy = this.createAMProxy(service.getName(), appReport);
        ClientAMProtocol.UpgradeServiceRequestProto.Builder requestBuilder = ClientAMProtocol.UpgradeServiceRequestProto.newBuilder();
        requestBuilder.setVersion(service.getVersion());
        if (service.getState().equals((Object)ServiceState.UPGRADING_AUTO_FINALIZE)) {
            requestBuilder.setAutoFinalize(true);
        }
        if ((responseProto = proxy.upgrade(requestBuilder.build())).hasError()) {
            LOG.error("Service {} upgrade to version {} failed because {}", new Object[]{service.getName(), service.getVersion(), responseProto.getError()});
            throw new YarnException("Failed to upgrade service " + service.getName() + " to version " + service.getVersion() + " because " + responseProto.getError());
        }
        return 0;
    }

    public int actionUpgradeInstances(String appName, List<String> componentInstances) throws IOException, YarnException {
        this.checkAppExistOnHdfs(appName);
        org.apache.hadoop.yarn.service.api.records.Service persistedService = ServiceApiUtil.loadService(this.fs, appName);
        List<Container> containersToUpgrade = ServiceApiUtil.getLiveContainers(persistedService, componentInstances);
        ServiceApiUtil.validateInstancesUpgrade(containersToUpgrade);
        return this.actionUpgrade(persistedService, containersToUpgrade);
    }

    public int actionUpgradeComponents(String appName, List<String> components) throws IOException, YarnException {
        this.checkAppExistOnHdfs(appName);
        org.apache.hadoop.yarn.service.api.records.Service persistedService = ServiceApiUtil.loadService(this.fs, appName);
        List<Container> containersToUpgrade = ServiceApiUtil.validateAndResolveCompsUpgrade(persistedService, components);
        return this.actionUpgrade(persistedService, containersToUpgrade);
    }

    public int actionCancelUpgrade(String appName) throws IOException, YarnException {
        org.apache.hadoop.yarn.service.api.records.Service liveService = this.getStatus(appName);
        if (liveService == null || !ServiceState.isUpgrading(liveService.getState())) {
            throw new YarnException("Service " + appName + " is not upgrading, so nothing to cancel.");
        }
        ApplicationReport appReport = this.yarnClient.getApplicationReport(this.getAppId(appName));
        if (StringUtils.isEmpty((CharSequence)appReport.getHost())) {
            throw new YarnException(appName + " AM hostname is empty");
        }
        ClientAMProtocol proxy = this.createAMProxy(appName, appReport);
        proxy.cancelUpgrade(ClientAMProtocol.CancelUpgradeRequestProto.newBuilder().build());
        return 0;
    }

    public int actionDecommissionInstances(String appName, List<String> componentInstances) throws IOException, YarnException {
        this.checkAppExistOnHdfs(appName);
        org.apache.hadoop.yarn.service.api.records.Service persistedService = ServiceApiUtil.loadService(this.fs, appName);
        if (StringUtils.isEmpty((CharSequence)persistedService.getId())) {
            throw new YarnException(persistedService.getName() + " appId is null, may be not submitted to YARN yet");
        }
        this.cachedAppInfo.put(persistedService.getName(), new AppInfo(ApplicationId.fromString((String)persistedService.getId()), persistedService.getKerberosPrincipal().getPrincipalName()));
        for (String instance : componentInstances) {
            String componentName = ServiceApiUtil.parseComponentName(ServiceApiUtil.parseAndValidateComponentInstanceName(instance, appName, this.getConfig()));
            Component component = persistedService.getComponent(componentName);
            if (component == null) {
                throw new IllegalArgumentException(instance + " does not exist !");
            }
            if (component.getDecommissionedInstances().contains(instance)) continue;
            component.addDecommissionedInstance(instance);
            component.setNumberOfContainers(Math.max(0L, component.getNumberOfContainers() - 1L));
        }
        ServiceApiUtil.writeAppDefinition(this.fs, persistedService);
        ApplicationReport appReport = this.yarnClient.getApplicationReport(ApplicationId.fromString((String)persistedService.getId()));
        if (appReport.getYarnApplicationState() != YarnApplicationState.RUNNING) {
            String message = persistedService.getName() + " is at " + appReport.getYarnApplicationState() + " state, decommission can only be invoked when service is running";
            LOG.error(message);
            throw new YarnException(message);
        }
        if (StringUtils.isEmpty((CharSequence)appReport.getHost())) {
            throw new YarnException(persistedService.getName() + " AM hostname is empty");
        }
        ClientAMProtocol proxy = this.createAMProxy(persistedService.getName(), appReport);
        ClientAMProtocol.DecommissionCompInstancesRequestProto.Builder requestBuilder = ClientAMProtocol.DecommissionCompInstancesRequestProto.newBuilder();
        requestBuilder.addAllCompInstances(componentInstances);
        proxy.decommissionCompInstances(requestBuilder.build());
        return 0;
    }

    public int actionCleanUp(String appName, String userName) throws IOException, YarnException {
        if (this.cleanUpRegistry(appName, userName)) {
            return 0;
        }
        return -1;
    }

    public String getInstances(String appName, List<String> components, String version, List<String> containerStates) throws IOException, YarnException {
        ClientAMProtocol.GetCompInstancesResponseProto result = this.filterContainers(appName, components, version, containerStates);
        return result.getCompInstances();
    }

    public ComponentContainers[] getContainers(String appName, List<String> components, String version, List<ContainerState> containerStates) throws IOException, YarnException {
        ClientAMProtocol.GetCompInstancesResponseProto result = this.filterContainers(appName, components, version, containerStates != null ? containerStates.stream().map(Enum::toString).collect(Collectors.toList()) : null);
        return ServiceApiUtil.COMP_CONTAINERS_JSON_SERDE.fromJson(result.getCompInstances());
    }

    private ClientAMProtocol.GetCompInstancesResponseProto filterContainers(String appName, List<String> components, String version, List<String> containerStates) throws IOException, YarnException {
        ApplicationReport appReport = this.yarnClient.getApplicationReport(this.getAppId(appName));
        if (StringUtils.isEmpty((CharSequence)appReport.getHost())) {
            throw new YarnException(appName + " AM hostname is empty.");
        }
        ClientAMProtocol proxy = this.createAMProxy(appName, appReport);
        ClientAMProtocol.GetCompInstancesRequestProto.Builder req = ClientAMProtocol.GetCompInstancesRequestProto.newBuilder();
        if (components != null && !components.isEmpty()) {
            req.addAllComponentNames(components);
        }
        if (version != null) {
            req.setVersion(version);
        }
        if (containerStates != null && !containerStates.isEmpty()) {
            req.addAllContainerStates(containerStates);
        }
        return proxy.getCompInstances(req.build());
    }

    public int actionUpgrade(org.apache.hadoop.yarn.service.api.records.Service service, List<Container> compInstances) throws IOException, YarnException {
        ApplicationReport appReport = this.yarnClient.getApplicationReport(this.getAppId(service.getName()));
        if (appReport.getYarnApplicationState() != YarnApplicationState.RUNNING) {
            String message = service.getName() + " is at " + appReport.getYarnApplicationState() + " state, upgrade can only be invoked when service is running.";
            LOG.error(message);
            throw new YarnException(message);
        }
        if (StringUtils.isEmpty((CharSequence)appReport.getHost())) {
            throw new YarnException(service.getName() + " AM hostname is empty.");
        }
        ClientAMProtocol proxy = this.createAMProxy(service.getName(), appReport);
        ArrayList<String> containerIdsToUpgrade = new ArrayList<String>();
        compInstances.forEach(compInst -> containerIdsToUpgrade.add(compInst.getId()));
        LOG.info("instances to upgrade {}", containerIdsToUpgrade);
        ClientAMProtocol.CompInstancesUpgradeRequestProto.Builder upgradeRequestBuilder = ClientAMProtocol.CompInstancesUpgradeRequestProto.newBuilder();
        upgradeRequestBuilder.addAllContainerIds(containerIdsToUpgrade);
        proxy.upgrade(upgradeRequestBuilder.build());
        return 0;
    }

    public int actionLaunch(String fileName, String serviceName, Long lifetime, String queue) throws IOException, YarnException {
        this.actionCreate(this.loadAppJsonFromLocalFS(fileName, serviceName, lifetime, queue));
        return 0;
    }

    public ApplicationId actionCreate(org.apache.hadoop.yarn.service.api.records.Service service) throws IOException, YarnException {
        ApplicationId appId;
        String serviceName = service.getName();
        ServiceApiUtil.validateAndResolveService(service, this.fs, this.getConfig());
        this.verifyNoLiveAppInRM(serviceName, "create");
        Path appDir = this.checkAppNotExistOnHdfs(service, false);
        ServiceApiUtil.createDirAndPersistApp(this.fs, appDir, service);
        try {
            appId = this.submitApp(service);
        }
        catch (YarnException e) {
            this.actionDestroy(serviceName);
            throw e;
        }
        this.cachedAppInfo.put(serviceName, new AppInfo(appId, service.getKerberosPrincipal().getPrincipalName()));
        service.setId(appId.toString());
        ServiceApiUtil.writeAppDefinition(this.fs, appDir, service);
        return appId;
    }

    public int actionFlex(String serviceName, Map<String, String> componentCountStrings) throws YarnException, IOException {
        HashMap<String, Long> componentCounts = new HashMap<String, Long>(componentCountStrings.size());
        org.apache.hadoop.yarn.service.api.records.Service persistedService = ServiceApiUtil.loadService(this.fs, serviceName);
        if (StringUtils.isEmpty((CharSequence)persistedService.getId())) {
            throw new YarnException(persistedService.getName() + " appId is null, may be not submitted to YARN yet");
        }
        this.cachedAppInfo.put(persistedService.getName(), new AppInfo(ApplicationId.fromString((String)persistedService.getId()), persistedService.getKerberosPrincipal().getPrincipalName()));
        for (Map.Entry<String, String> entry : componentCountStrings.entrySet()) {
            String compName = entry.getKey();
            ServiceApiUtil.validateNameFormat(compName, this.getConfig());
            Component component = persistedService.getComponent(compName);
            if (component == null) {
                throw new IllegalArgumentException(entry.getKey() + " does not exist !");
            }
            long numberOfContainers = this.parseNumberOfContainers(component, entry.getValue());
            componentCounts.put(compName, numberOfContainers);
        }
        this.flexComponents(serviceName, componentCounts, persistedService);
        return 0;
    }

    private long parseNumberOfContainers(Component component, String newNumber) {
        long orig = component.getNumberOfContainers();
        if (newNumber.startsWith("+")) {
            return orig + Long.parseLong(newNumber.substring(1));
        }
        if (newNumber.startsWith("-")) {
            long ret = orig - Long.parseLong(newNumber.substring(1));
            if (ret < 0L) {
                LOG.warn(MessageFormat.format("[COMPONENT {0}]: component count goes to negative ({1}{2} = {3}), ignore and reset it to 0.", component.getName(), orig, newNumber, ret));
                ret = 0L;
            }
            return ret;
        }
        return Long.parseLong(newNumber);
    }

    public Map<String, Long> flexByRestService(String serviceName, Map<String, Long> componentCounts) throws YarnException, IOException {
        org.apache.hadoop.yarn.service.api.records.Service persistedService = ServiceApiUtil.loadService(this.fs, serviceName);
        if (StringUtils.isEmpty((CharSequence)persistedService.getId())) {
            throw new YarnException(serviceName + " appId is null, may be not submitted to YARN yet");
        }
        this.cachedAppInfo.put(persistedService.getName(), new AppInfo(ApplicationId.fromString((String)persistedService.getId()), persistedService.getKerberosPrincipal().getPrincipalName()));
        return this.flexComponents(serviceName, componentCounts, persistedService);
    }

    private Map<String, Long> flexComponents(String serviceName, Map<String, Long> componentCounts, org.apache.hadoop.yarn.service.api.records.Service persistedService) throws YarnException, IOException {
        ServiceApiUtil.validateNameFormat(serviceName, this.getConfig());
        HashMap<String, Long> original = new HashMap<String, Long>(componentCounts.size());
        ClientAMProtocol.ComponentCountProto.Builder countBuilder = ClientAMProtocol.ComponentCountProto.newBuilder();
        ClientAMProtocol.FlexComponentsRequestProto.Builder requestBuilder = ClientAMProtocol.FlexComponentsRequestProto.newBuilder();
        for (Component persistedComp : persistedService.getComponents()) {
            String name = persistedComp.getName();
            if (!componentCounts.containsKey(persistedComp.getName())) continue;
            original.put(name, persistedComp.getNumberOfContainers());
            persistedComp.setNumberOfContainers(componentCounts.get(name));
            countBuilder.setName(persistedComp.getName()).setNumberOfContainers(persistedComp.getNumberOfContainers());
            requestBuilder.addComponents(countBuilder.build());
        }
        if (original.size() < componentCounts.size()) {
            componentCounts.keySet().removeAll(original.keySet());
            throw new YarnException("Components " + componentCounts.keySet() + " do not exist in app definition.");
        }
        ServiceApiUtil.writeAppDefinition(this.fs, persistedService);
        ApplicationId appId = this.getAppId(serviceName);
        if (appId == null) {
            String message = "Application ID doesn't exist for " + serviceName;
            LOG.error(message);
            throw new YarnException(message);
        }
        ApplicationReport appReport = this.yarnClient.getApplicationReport(appId);
        if (appReport.getYarnApplicationState() != YarnApplicationState.RUNNING) {
            String message = serviceName + " is at " + appReport.getYarnApplicationState() + " state, flex can only be invoked when service is running";
            LOG.error(message);
            throw new YarnException(message);
        }
        org.apache.hadoop.yarn.service.api.records.Service liveService = this.getStatus(serviceName);
        if (liveService.getState().equals((Object)ServiceState.UPGRADING) || liveService.getState().equals((Object)ServiceState.UPGRADING_AUTO_FINALIZE)) {
            String message = serviceName + " is at " + liveService.getState() + " state, flex can not be invoked when service is upgrading. ";
            LOG.error(message);
            throw new YarnException(message);
        }
        if (StringUtils.isEmpty((CharSequence)appReport.getHost())) {
            throw new YarnException(serviceName + " AM hostname is empty");
        }
        ClientAMProtocol proxy = this.createAMProxy(serviceName, appReport);
        proxy.flexComponents(requestBuilder.build());
        for (Map.Entry entry : original.entrySet()) {
            LOG.info("[COMPONENT {}]: number of containers changed from {} to {}", new Object[]{entry.getKey(), entry.getValue(), componentCounts.get(entry.getKey())});
        }
        return original;
    }

    public int actionStop(String serviceName) throws YarnException, IOException {
        return this.actionStop(serviceName, true);
    }

    public int actionStop(String serviceName, boolean waitForAppStopped) throws YarnException, IOException {
        ServiceApiUtil.validateNameFormat(serviceName, this.getConfig());
        ApplicationId currentAppId = this.getAppId(serviceName);
        if (currentAppId == null) {
            LOG.info("Application ID doesn't exist for service {}", (Object)serviceName);
            this.cleanUpRegistry(serviceName);
            return 40;
        }
        ApplicationReport report = this.yarnClient.getApplicationReport(currentAppId);
        if (terminatedStates.contains(report.getYarnApplicationState())) {
            LOG.info("Service {} is already in a terminated state {}", (Object)serviceName, (Object)report.getYarnApplicationState());
            this.cleanUpRegistry(serviceName);
            return 40;
        }
        if (preRunningStates.contains(report.getYarnApplicationState())) {
            String msg = serviceName + " is at " + report.getYarnApplicationState() + ", forcefully killed by user!";
            this.yarnClient.killApplication(currentAppId, msg);
            LOG.info(msg);
            this.cleanUpRegistry(serviceName);
            return 0;
        }
        if (StringUtils.isEmpty((CharSequence)report.getHost())) {
            throw new YarnException(serviceName + " AM hostname is empty");
        }
        LOG.info("Stopping service {}, with appId = {}", (Object)serviceName, (Object)currentAppId);
        try {
            ClientAMProtocol proxy = this.createAMProxy(serviceName, report);
            this.cachedAppInfo.remove(serviceName);
            if (proxy == null) {
                this.yarnClient.killApplication(currentAppId, serviceName + " is forcefully killed by user!");
                LOG.info("Forcefully kill the service: " + serviceName);
                this.cleanUpRegistry(serviceName);
                return 0;
            }
            ClientAMProtocol.StopRequestProto request = ClientAMProtocol.StopRequestProto.newBuilder().build();
            proxy.stop(request);
            LOG.info("Service " + serviceName + " is being gracefully stopped...");
            if (!waitForAppStopped) {
                this.cleanUpRegistry(serviceName);
                return 0;
            }
            long startTime = System.currentTimeMillis();
            int pollCount = 0;
            while (true) {
                Thread.sleep(2000L);
                report = this.yarnClient.getApplicationReport(currentAppId);
                if (terminatedStates.contains(report.getYarnApplicationState())) {
                    LOG.info("Service " + serviceName + " is stopped.");
                    break;
                }
                if (System.currentTimeMillis() - startTime > 10000L) {
                    LOG.info("Stop operation timeout stopping, forcefully kill the app " + serviceName);
                    this.yarnClient.killApplication(currentAppId, "Forcefully kill the app by user");
                    break;
                }
                if (++pollCount % 10 != 0) continue;
                LOG.info("Waiting for service " + serviceName + " to be stopped.");
            }
        }
        catch (IOException | InterruptedException | YarnException e) {
            LOG.info("Failed to stop " + serviceName + " gracefully due to: " + e.getMessage() + ", forcefully kill the app.");
            this.yarnClient.killApplication(currentAppId, "Forcefully kill the app");
        }
        this.cleanUpRegistry(serviceName);
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int actionDestroy(String serviceName) throws YarnException, IOException {
        ServiceApiUtil.validateNameFormat(serviceName, this.getConfig());
        this.verifyNoLiveAppInRM(serviceName, "destroy");
        Path appDir = this.fs.buildClusterDirPath(serviceName);
        FileSystem fileSystem = this.fs.getFileSystem();
        this.cachedAppInfo.remove(serviceName);
        int ret = 0;
        if (fileSystem.exists(appDir)) {
            if (!fileSystem.delete(appDir, true)) {
                String message = "Failed to delete service + " + serviceName + " at:  " + appDir;
                LOG.info(message);
                throw new YarnException(message);
            }
            LOG.info("Successfully deleted service dir for " + serviceName + ": " + appDir);
        } else {
            LOG.info("Service '" + serviceName + "' doesn't exist at hdfs path: " + appDir);
            ret = 44;
        }
        Path publicResourceDir = new Path(this.fs.getBasePath(), serviceName);
        if (fileSystem.exists(publicResourceDir)) {
            if (!fileSystem.delete(publicResourceDir, true)) {
                String message = "Failed to delete public resource dir for service " + serviceName + " at:  " + publicResourceDir;
                LOG.info(message);
                throw new YarnException(message);
            }
            LOG.info("Successfully deleted public resource dir for " + serviceName + ": " + publicResourceDir);
        }
        try {
            this.deleteZKNode(serviceName);
        }
        catch (Exception e) {
            throw new IOException("Could not delete zk node for " + serviceName, e);
        }
        if (!this.cleanUpRegistry(serviceName) && ret == 0) {
            ret = 5;
        }
        if (ret == 0) {
            LOG.info("Successfully destroyed service {}", (Object)serviceName);
            return ret;
        }
        if (ret == 44) {
            LOG.error("Error on destroy '" + serviceName + "': not found.");
            return ret;
        }
        LOG.error("Error on destroy '" + serviceName + "': error cleaning up registry.");
        return ret;
    }

    private boolean cleanUpRegistry(String serviceName, String user) throws SliderException {
        String encodedName = RegistryUtils.registryUser((String)user);
        String registryPath = RegistryUtils.servicePath((String)encodedName, (String)"yarn-service", (String)serviceName);
        return this.cleanUpRegistryPath(registryPath, serviceName);
    }

    private boolean cleanUpRegistry(String serviceName) throws SliderException {
        String registryPath = ServiceRegistryUtils.registryPathForInstance(serviceName);
        return this.cleanUpRegistryPath(registryPath, serviceName);
    }

    private boolean cleanUpRegistryPath(String registryPath, String serviceName) throws SliderException {
        try {
            if (this.getRegistryClient().exists(registryPath)) {
                this.getRegistryClient().delete(registryPath, true);
            } else {
                LOG.info("Service '" + serviceName + "' doesn't exist at ZK registry path: " + registryPath);
            }
        }
        catch (IOException e) {
            LOG.warn("Error deleting registry entry {}", (Object)registryPath, (Object)e);
            return false;
        }
        return true;
    }

    private synchronized RegistryOperations getRegistryClient() throws SliderException, IOException {
        if (this.registryClient == null) {
            this.registryClient = RegistryOperationsFactory.createInstance((String)"ServiceClient", (Configuration)this.getConfig());
            this.registryClient.init(this.getConfig());
            this.registryClient.start();
        }
        return this.registryClient;
    }

    private boolean deleteZKNode(String serviceName) throws Exception {
        CuratorFramework curatorFramework = this.getCuratorClient();
        String user = RegistryUtils.currentUser();
        String zkPath = ServiceRegistryUtils.mkServiceHomePath(user, serviceName);
        if (curatorFramework.checkExists().forPath(zkPath) != null) {
            curatorFramework.delete().deletingChildrenIfNeeded().forPath(zkPath);
            LOG.info("Deleted zookeeper path: " + zkPath);
            return true;
        }
        LOG.info("Service '" + serviceName + "' doesn't exist at ZK path: " + zkPath);
        return false;
    }

    private synchronized CuratorFramework getCuratorClient() throws BadConfigException {
        String registryQuorum = this.getConfig().get("hadoop.registry.zk.quorum");
        if (ServiceUtils.isUnset(registryQuorum)) {
            throw new BadConfigException("No Zookeeper quorum provided in the configuration property hadoop.registry.zk.quorum");
        }
        ZookeeperUtils.splitToHostsAndPortsStrictly(registryQuorum);
        if (this.curatorClient == null) {
            this.curatorClient = CuratorFrameworkFactory.builder().connectString(registryQuorum).sessionTimeoutMs(10000).retryPolicy((RetryPolicy)new RetryNTimes(5, 2000)).build();
            this.curatorClient.start();
        }
        return this.curatorClient;
    }

    private void verifyNoLiveAppInRM(String serviceName, String action) throws IOException, YarnException {
        List reports;
        HashSet<String> types = new HashSet<String>(1);
        types.add("yarn-service");
        Set<String> tags = null;
        if (serviceName != null) {
            tags = Collections.singleton(ServiceUtils.createNameTag(serviceName));
        }
        GetApplicationsRequest request = GetApplicationsRequest.newInstance();
        request.setApplicationTypes(types);
        request.setApplicationTags(tags);
        request.setApplicationStates(liveStates);
        String user = UserGroupInformation.getCurrentUser().getUserName();
        if (user != null) {
            request.setUsers(Collections.singleton(user));
        }
        if (!(reports = this.yarnClient.getApplications(request)).isEmpty()) {
            Object message = "";
            message = action.equals("destroy") ? "Failed to destroy service " + serviceName + ", because it is still running." : "Failed to " + action + " service " + serviceName + ", because it already exists.";
            throw new YarnException((String)message);
        }
    }

    @VisibleForTesting
    ApplicationId submitApp(org.apache.hadoop.yarn.service.api.records.Service app) throws IOException, YarnException {
        String serviceName = app.getName();
        Configuration conf = this.getConfig();
        Path appRootDir = this.fs.buildClusterDirPath(app.getName());
        YarnClientApplication yarnApp = this.yarnClient.createApplication();
        ApplicationSubmissionContext submissionContext = yarnApp.getApplicationSubmissionContext();
        ServiceApiUtil.validateCompResourceSize(yarnApp.getNewApplicationResponse().getMaximumResourceCapability(), app);
        submissionContext.setKeepContainersAcrossApplicationAttempts(true);
        if (app.getLifetime() > 0L) {
            HashMap<ApplicationTimeoutType, Long> appTimeout = new HashMap<ApplicationTimeoutType, Long>();
            appTimeout.put(ApplicationTimeoutType.LIFETIME, app.getLifetime());
            submissionContext.setApplicationTimeouts(appTimeout);
        }
        submissionContext.setMaxAppAttempts(YarnServiceConf.getInt("yarn.service.am-restart.max-attempts", 20, app.getConfiguration(), conf));
        submissionContext.setAttemptFailuresValidityInterval(YarnServiceConf.getLong("yarn.service.am-failure.validity-interval-ms", -1L, app.getConfiguration(), conf));
        this.setLogAggregationContext(app, conf, submissionContext);
        HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
        boolean hasAMLog4j = this.addAMLog4jResource(serviceName, conf, localResources);
        this.addJarResource(serviceName, localResources);
        this.addKeytabResourceIfSecure(this.fs, localResources, app);
        this.addYarnSysFs(appRootDir, localResources, app);
        if (LOG.isDebugEnabled()) {
            this.printLocalResources(localResources);
        }
        Map<String, String> env = this.addAMEnv();
        String cmdStr = this.buildCommandLine(app, conf, appRootDir, hasAMLog4j);
        submissionContext.setResource(Resource.newInstance((long)YarnServiceConf.getLong("yarn.service.am-resource.memory", 1024L, app.getConfiguration(), conf), (int)1));
        String queue = app.getQueue();
        if (StringUtils.isEmpty((CharSequence)queue)) {
            queue = conf.get("yarn.service.queue", "default");
        }
        submissionContext.setQueue(queue);
        submissionContext.setApplicationName(serviceName);
        submissionContext.setApplicationType("yarn-service");
        Set<String> appTags = AbstractClientProvider.createApplicationTags(serviceName, null, null);
        if (!appTags.isEmpty()) {
            submissionContext.setApplicationTags(appTags);
        }
        ContainerLaunchContext amLaunchContext = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        amLaunchContext.setCommands(Collections.singletonList(cmdStr));
        amLaunchContext.setEnvironment(env);
        amLaunchContext.setLocalResources(localResources);
        this.addCredentials(amLaunchContext, app);
        submissionContext.setAMContainerSpec(amLaunchContext);
        this.yarnClient.submitApplication(submissionContext);
        return submissionContext.getApplicationId();
    }

    public static File compressFiles(Collection<File> files, File output, String bundleRoot) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(output);
             TarArchiveOutputStream taos = new TarArchiveOutputStream((OutputStream)new BufferedOutputStream(fos));){
            taos.setLongFileMode(2);
            for (File f : files) {
                ServiceClient.addFilesToCompression(taos, f, "sysfs", bundleRoot);
            }
        }
        return output;
    }

    private static void addFilesToCompression(TarArchiveOutputStream taos, File file, String dir, String bundleRoot) throws IOException {
        if (!file.isHidden()) {
            if (!dir.equals(".") && File.separator.equals("\\")) {
                dir = dir.replaceAll("\\\\", "/");
            }
            taos.putArchiveEntry(new TarArchiveEntry(file, dir + "/" + file.getName()));
            if (file.isFile()) {
                try (FileInputStream input = new FileInputStream(file);){
                    IOUtils.copy((InputStream)input, (OutputStream)taos);
                    taos.closeArchiveEntry();
                }
            } else if (file.isDirectory()) {
                File[] allFiles;
                if (!dir.equals(".")) {
                    taos.closeArchiveEntry();
                }
                if ((allFiles = file.listFiles()) != null) {
                    for (File childFile : allFiles) {
                        ServiceClient.addFilesToCompression(taos, childFile, file.getPath().substring(bundleRoot.length()), bundleRoot);
                    }
                }
            }
        }
    }

    private void addYarnSysFs(Path path, Map<String, LocalResource> localResources, org.apache.hadoop.yarn.service.api.records.Service app) throws IOException {
        ArrayList<Component> componentsWithYarnSysFS = new ArrayList<Component>();
        for (Component c : app.getComponents()) {
            boolean enabled = Boolean.parseBoolean(c.getConfiguration().getEnv(ApplicationConstants.Environment.YARN_CONTAINER_RUNTIME_YARN_SYSFS_ENABLE.name()));
            if (!enabled) continue;
            componentsWithYarnSysFS.add(c);
        }
        if (componentsWithYarnSysFS.size() == 0) {
            return;
        }
        String buffer = ServiceApiUtil.jsonSerDeser.toJson(app);
        File testDir = new File(System.getProperty("java.io.tmpdir"));
        File tmpDir = Files.createTempDirectory(testDir.toPath(), System.currentTimeMillis() + "-", new FileAttribute[0]).toFile();
        if (tmpDir.exists()) {
            String serviceJsonPath = tmpDir.getAbsolutePath() + "/app.json";
            File localFile = new File(serviceJsonPath);
            if (localFile.createNewFile()) {
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(localFile), StandardCharsets.UTF_8);){
                    writer.write(buffer);
                }
            } else {
                throw new IOException("Fail to write app.json to temp directory");
            }
            File destinationFile = new File(tmpDir.getAbsolutePath() + "/sysfs.tar");
            if (!destinationFile.createNewFile()) {
                throw new IOException("Fail to localize sysfs.tar.");
            }
            ArrayList<File> files = new ArrayList<File>();
            files.add(localFile);
            ServiceClient.compressFiles(files, destinationFile, "sysfs");
            LocalResource localResource = this.fs.submitFile(destinationFile, path, ".", "sysfs.tar");
            Path serviceJson = new Path(path, "sysfs.tar");
            for (Component c : componentsWithYarnSysFS) {
                ConfigFile e = new ConfigFile();
                e.type(ConfigFile.TypeEnum.ARCHIVE);
                e.srcFile(serviceJson.toString());
                e.destFile("/hadoop/yarn");
                if (c.getConfiguration().getFiles().contains(e)) continue;
                c.getConfiguration().getFiles().add(e);
            }
            localResources.put("sysfs", localResource);
            if (!tmpDir.delete()) {
                LOG.warn("Failed to delete temp file: " + tmpDir.getAbsolutePath());
            }
        } else {
            throw new IOException("Fail to localize sysfs resource.");
        }
    }

    private void setLogAggregationContext(org.apache.hadoop.yarn.service.api.records.Service app, Configuration conf, ApplicationSubmissionContext submissionContext) {
        String rollingLogExclude;
        String rollingLogInclude;
        String finalLogExclude;
        LogAggregationContext context = (LogAggregationContext)Records.newRecord(LogAggregationContext.class);
        String finalLogInclude = YarnServiceConf.get("yarn.service.log.include-pattern", null, app.getConfiguration(), conf);
        if (!StringUtils.isEmpty((CharSequence)finalLogInclude)) {
            context.setIncludePattern(finalLogInclude);
        }
        if (!StringUtils.isEmpty((CharSequence)(finalLogExclude = YarnServiceConf.get("yarn.service.log.exclude-pattern", null, app.getConfiguration(), conf)))) {
            context.setExcludePattern(finalLogExclude);
        }
        if (!StringUtils.isEmpty((CharSequence)(rollingLogInclude = YarnServiceConf.get("yarn.service.rolling-log.include-pattern", null, app.getConfiguration(), conf)))) {
            context.setRolledLogsIncludePattern(rollingLogInclude);
        }
        if (!StringUtils.isEmpty((CharSequence)(rollingLogExclude = YarnServiceConf.get("yarn.service.rolling-log.exclude-pattern", null, app.getConfiguration(), conf)))) {
            context.setRolledLogsExcludePattern(rollingLogExclude);
        }
        submissionContext.setLogAggregationContext(context);
    }

    private void printLocalResources(Map<String, LocalResource> map) {
        LOG.debug("Added LocalResource for localization: ");
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, LocalResource> entry : map.entrySet()) {
            builder.append(entry.getKey()).append(" -> ").append(entry.getValue().getResource().getFile()).append(System.lineSeparator());
        }
        LOG.debug("{}", (Object)builder);
    }

    private String buildCommandLine(org.apache.hadoop.yarn.service.api.records.Service app, Configuration conf, Path appRootDir, boolean hasSliderAMLog4j) throws BadConfigException {
        JavaCommandLineBuilder CLI = new JavaCommandLineBuilder();
        CLI.forceIPv4().headless();
        Object jvmOpts = YarnServiceConf.get("yarn.service.am.java.opts", "", app.getConfiguration(), conf);
        if (!((String)jvmOpts).contains("-Xmx")) {
            jvmOpts = (String)jvmOpts + " -Xmx768m ";
        }
        ServiceApiUtil.validateJvmOpts((String)jvmOpts);
        CLI.setJVMOpts((String)jvmOpts);
        if (hasSliderAMLog4j) {
            CLI.sysprop("log4j.configuration", "yarnservice-log4j.properties");
            CLI.sysprop("LOG_DIR", "<LOG_DIR>");
        }
        CLI.add(ServiceMaster.class.getCanonicalName());
        CLI.add("-yarnfile", new Path(appRootDir, app.getName() + ".json"));
        CLI.add("-service_name", app.getName());
        if (app.getKerberosPrincipal() != null) {
            if (!StringUtils.isEmpty((CharSequence)app.getKerberosPrincipal().getKeytab())) {
                CLI.add("-keytab", app.getKerberosPrincipal().getKeytab());
            }
            if (!StringUtils.isEmpty((CharSequence)app.getKerberosPrincipal().getPrincipalName())) {
                CLI.add("-principal_name", app.getKerberosPrincipal().getPrincipalName());
            }
        }
        CLI.addConfOptionToCLI(conf, "hadoop.registry.zk.root", "/registry");
        CLI.addMandatoryConfOption(conf, "hadoop.registry.zk.quorum");
        CLI.addOutAndErrFiles("serviceam-out.txt", "serviceam-err.txt");
        String cmdStr = CLI.build();
        LOG.debug("AM launch command: {}", (Object)cmdStr);
        return cmdStr;
    }

    @VisibleForTesting
    protected Map<String, String> addAMEnv() throws IOException {
        HashMap<String, String> env = new HashMap<String, String>();
        ClasspathConstructor classpath = ServiceUtils.buildClasspath("conf", "lib", this.fs, this.getConfig().get("yarn.service.classpath", ""), this.getConfig().getBoolean("yarn.is.minicluster", false));
        env.put("CLASSPATH", classpath.buildClasspath());
        env.put("LANG", "en_US.UTF-8");
        env.put("LC_ALL", "en_US.UTF-8");
        env.put("LANGUAGE", "en_US.UTF-8");
        String jaas = System.getenv("HADOOP_JAAS_DEBUG");
        if (jaas != null) {
            env.put("HADOOP_JAAS_DEBUG", jaas);
        }
        if (!UserGroupInformation.isSecurityEnabled()) {
            String userName = UserGroupInformation.getCurrentUser().getUserName();
            LOG.debug("Run as user {}", (Object)userName);
            env.put("HADOOP_USER_NAME", userName);
        }
        LOG.debug("AM env: \n{}", (Object)ServiceUtils.stringifyMap(env));
        return env;
    }

    protected Path addJarResource(String serviceName, Map<String, LocalResource> localResources) throws IOException, YarnException {
        Path libPath = this.fs.buildClusterDirPath(serviceName);
        ProviderUtils.addProviderJar(localResources, ServiceMaster.class, "yarn-service-core.jar", this.fs, libPath, "lib", false);
        Path dependencyLibTarGzip = this.fs.getDependencyTarGzip();
        if (this.actionDependency(null, false) == 0) {
            LOG.info("Loading lib tar from " + dependencyLibTarGzip);
            this.fs.submitTarGzipAndUpdate(localResources);
        } else {
            if (dependencyLibTarGzip != null) {
                LOG.warn("Property {} has a value {}, but is not a valid file", (Object)"yarn.service.framework.path", (Object)dependencyLibTarGzip);
            }
            String[] libs = ServiceUtils.getLibDirs();
            LOG.info("Uploading all dependency jars to HDFS. For faster submission of apps, set config property {} to the dependency tarball location. Dependency tarball can be uploaded to any HDFS path directly or by using command: yarn app -{} [<Destination Folder>]", (Object)"yarn.service.framework.path", (Object)"enableFastLaunch");
            for (String libDirProp : libs) {
                ProviderUtils.addAllDependencyJars(localResources, this.fs, libPath, "lib", libDirProp);
            }
        }
        return libPath;
    }

    private boolean addAMLog4jResource(String serviceName, Configuration conf, Map<String, LocalResource> localResources) throws IOException, BadClusterStateException {
        boolean hasAMLog4j = false;
        String hadoopConfDir = System.getenv(ApplicationConstants.Environment.HADOOP_CONF_DIR.name());
        if (hadoopConfDir != null) {
            File localFile = new File(hadoopConfDir, "yarnservice-log4j.properties");
            if (localFile.exists()) {
                Path localFilePath = ServiceUtils.createLocalPath(localFile);
                Path appDirPath = this.fs.buildClusterDirPath(serviceName);
                Path remoteConfPath = new Path(appDirPath, "conf");
                Path remoteFilePath = new Path(remoteConfPath, "yarnservice-log4j.properties");
                ServiceUtils.copy(conf, localFilePath, remoteFilePath);
                LocalResource localResource = this.fs.createAmResource(remoteConfPath, LocalResourceType.FILE, LocalResourceVisibility.APPLICATION);
                localResources.put(localFilePath.getName(), localResource);
                hasAMLog4j = true;
            } else {
                LOG.warn("AM log4j property file doesn't exist: " + localFile);
            }
        }
        return hasAMLog4j;
    }

    public int actionStart(String serviceName) throws YarnException, IOException {
        this.actionStartAndGetId(serviceName);
        return 0;
    }

    public ApplicationId actionStartAndGetId(String serviceName) throws YarnException, IOException {
        ServiceApiUtil.validateNameFormat(serviceName, this.getConfig());
        org.apache.hadoop.yarn.service.api.records.Service liveService = this.getStatus(serviceName);
        if (liveService == null || !liveService.getState().equals((Object)ServiceState.UPGRADING)) {
            ApplicationId appId;
            Path appDir = this.checkAppExistOnHdfs(serviceName);
            org.apache.hadoop.yarn.service.api.records.Service service = ServiceApiUtil.loadService(this.fs, serviceName);
            ServiceApiUtil.validateAndResolveService(service, this.fs, this.getConfig());
            this.verifyNoLiveAppInRM(serviceName, "start");
            try {
                appId = this.submitApp(service);
            }
            catch (YarnException e) {
                this.actionDestroy(serviceName);
                throw e;
            }
            this.cachedAppInfo.put(serviceName, new AppInfo(appId, service.getKerberosPrincipal().getPrincipalName()));
            service.setId(appId.toString());
            Path appJson = ServiceApiUtil.writeAppDefinition(this.fs, appDir, service);
            LOG.info("Persisted service " + service.getName() + " at " + appJson);
            return appId;
        }
        LOG.info("Finalize service {} upgrade", (Object)serviceName);
        ApplicationId appId = this.getAppId(serviceName);
        ApplicationReport appReport = this.yarnClient.getApplicationReport(appId);
        if (StringUtils.isEmpty((CharSequence)appReport.getHost())) {
            throw new YarnException(serviceName + " AM hostname is empty");
        }
        ClientAMProtocol proxy = this.createAMProxy(serviceName, appReport);
        ClientAMProtocol.RestartServiceRequestProto.Builder requestBuilder = ClientAMProtocol.RestartServiceRequestProto.newBuilder();
        proxy.restart(requestBuilder.build());
        return appId;
    }

    private Path checkAppNotExistOnHdfs(org.apache.hadoop.yarn.service.api.records.Service service, boolean isUpgrade) throws IOException, SliderException {
        Path appDir = !isUpgrade ? this.fs.buildClusterDirPath(service.getName()) : this.fs.buildClusterUpgradeDirPath(service.getName(), service.getVersion());
        this.fs.verifyDirectoryNonexistent(new Path(appDir, service.getName() + ".json"));
        return appDir;
    }

    private Path checkAppExistOnHdfs(String serviceName) throws IOException, SliderException {
        Path appDir = this.fs.buildClusterDirPath(serviceName);
        this.fs.verifyPathExists(new Path(appDir, serviceName + ".json"));
        return appDir;
    }

    private void addCredentials(ContainerLaunchContext amContext, org.apache.hadoop.yarn.service.api.records.Service app) throws IOException {
        Object tokens;
        Credentials allCreds = new Credentials();
        if (UserGroupInformation.isSecurityEnabled()) {
            String tokenRenewer = YarnClientUtils.getRmPrincipal((Configuration)this.getConfig());
            if (StringUtils.isEmpty((CharSequence)tokenRenewer)) {
                throw new IOException("Can't get Master Kerberos principal for the RM to use as renewer");
            }
            tokens = this.fs.getFileSystem().addDelegationTokens(tokenRenewer, allCreds);
            if (LOG.isDebugEnabled() && tokens != null && ((Token[])tokens).length != 0) {
                for (Token token : tokens) {
                    LOG.debug("Got DT: {}", (Object)token);
                }
            }
        }
        if (!StringUtils.isEmpty((CharSequence)app.getDockerClientConfig())) {
            allCreds.addAll(DockerClientConfigHandler.readCredentialsFromConfigFile((Path)new Path(app.getDockerClientConfig()), (Configuration)this.getConfig(), (String)app.getName()));
        }
        if (allCreds.numberOfTokens() > 0) {
            DataOutputBuffer dob = new DataOutputBuffer();
            allCreds.writeTokenStorageToStream((DataOutputStream)dob);
            tokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
            amContext.setTokens((ByteBuffer)tokens);
        }
    }

    private void addKeytabResourceIfSecure(SliderFileSystem fileSystem, Map<String, LocalResource> localResource, org.apache.hadoop.yarn.service.api.records.Service service) throws IOException, YarnException {
        URI keytabURI;
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        String principalName = service.getKerberosPrincipal().getPrincipalName();
        if (StringUtils.isEmpty((CharSequence)principalName)) {
            LOG.warn("No Kerberos principal name specified for " + service.getName());
            return;
        }
        if (StringUtils.isEmpty((CharSequence)service.getKerberosPrincipal().getKeytab())) {
            LOG.warn("No Kerberos keytab specified for " + service.getName());
            return;
        }
        try {
            keytabURI = new URI(service.getKerberosPrincipal().getKeytab());
        }
        catch (URISyntaxException e) {
            throw new YarnException((Throwable)e);
        }
        if ("file".equals(keytabURI.getScheme())) {
            LOG.info("Using a keytab from localhost: " + keytabURI);
        } else {
            Path keytabPath = new Path(keytabURI);
            if (!fileSystem.getFileSystem().exists(keytabPath)) {
                LOG.warn(service.getName() + "'s keytab (principalName = " + principalName + ") doesn't exist at: " + keytabPath);
                return;
            }
            LocalResource keytabRes = fileSystem.createAmResource(keytabPath, LocalResourceType.FILE, LocalResourceVisibility.PRIVATE);
            localResource.put(String.format("keytabs/%s.keytab", service.getName()), keytabRes);
            LOG.info("Adding " + service.getName() + "'s keytab for localization, uri = " + keytabPath);
        }
    }

    public String updateLifetime(String serviceName, long lifetime) throws YarnException, IOException {
        ApplicationId currentAppId = this.getAppId(serviceName);
        if (currentAppId == null) {
            throw new YarnException("Application ID not found for " + serviceName);
        }
        ApplicationReport report = this.yarnClient.getApplicationReport(currentAppId);
        if (report == null) {
            throw new YarnException("Service not found for " + serviceName);
        }
        ApplicationId appId = report.getApplicationId();
        LOG.info("Updating lifetime of an service: serviceName = " + serviceName + ", appId = " + appId + ", lifetime = " + lifetime);
        HashMap<ApplicationTimeoutType, String> map = new HashMap<ApplicationTimeoutType, String>();
        String newTimeout = Times.formatISO8601((long)(System.currentTimeMillis() + lifetime * 1000L));
        map.put(ApplicationTimeoutType.LIFETIME, newTimeout);
        UpdateApplicationTimeoutsRequest request = UpdateApplicationTimeoutsRequest.newInstance((ApplicationId)appId, map);
        this.yarnClient.updateApplicationTimeouts(request);
        LOG.info("Successfully updated lifetime for an service: serviceName = " + serviceName + ", appId = " + appId + ". New expiry time in ISO8601 format is " + newTimeout);
        return newTimeout;
    }

    public ServiceState convertState(YarnApplicationState state) {
        switch (state) {
            case NEW: 
            case NEW_SAVING: 
            case SUBMITTED: 
            case ACCEPTED: {
                return ServiceState.ACCEPTED;
            }
            case RUNNING: {
                return ServiceState.STARTED;
            }
            case FINISHED: 
            case KILLED: {
                return ServiceState.STOPPED;
            }
            case FAILED: {
                return ServiceState.FAILED;
            }
        }
        return ServiceState.ACCEPTED;
    }

    public String getStatusString(String appIdOrName) throws IOException, YarnException {
        try {
            ApplicationId appId = ApplicationId.fromString((String)appIdOrName);
            return this.getStatusByAppId(appId);
        }
        catch (IllegalArgumentException e) {
            org.apache.hadoop.yarn.service.api.records.Service status = this.getStatus(appIdOrName);
            return ServiceApiUtil.jsonSerDeser.toJson(status);
        }
    }

    private String getStatusByAppId(ApplicationId appId) throws IOException, YarnException {
        ApplicationReport appReport = this.yarnClient.getApplicationReport(appId);
        if (appReport.getYarnApplicationState() != YarnApplicationState.RUNNING) {
            return "";
        }
        if (StringUtils.isEmpty((CharSequence)appReport.getHost())) {
            return "";
        }
        ClientAMProtocol amProxy = this.createAMProxy(appReport.getName(), appReport);
        ClientAMProtocol.GetStatusResponseProto response = amProxy.getStatus(ClientAMProtocol.GetStatusRequestProto.newBuilder().build());
        return response.getStatus();
    }

    public org.apache.hadoop.yarn.service.api.records.Service getStatus(String serviceName) throws IOException, YarnException {
        ServiceApiUtil.validateNameFormat(serviceName, this.getConfig());
        org.apache.hadoop.yarn.service.api.records.Service appSpec = new org.apache.hadoop.yarn.service.api.records.Service();
        appSpec.setName(serviceName);
        appSpec.setState(ServiceState.STOPPED);
        ApplicationId currentAppId = this.getAppId(serviceName);
        if (currentAppId == null) {
            LOG.info("Service {} does not have an application ID", (Object)serviceName);
            return appSpec;
        }
        appSpec.setId(currentAppId.toString());
        ApplicationReport appReport = null;
        try {
            appReport = this.yarnClient.getApplicationReport(currentAppId);
        }
        catch (ApplicationNotFoundException e) {
            LOG.info("application ID {} doesn't exist", (Object)currentAppId);
            return appSpec;
        }
        if (appReport == null) {
            LOG.warn("application ID {} is reported as null", (Object)currentAppId);
            return appSpec;
        }
        appSpec.setState(this.convertState(appReport.getYarnApplicationState()));
        ApplicationTimeout lifetime = (ApplicationTimeout)appReport.getApplicationTimeouts().get(ApplicationTimeoutType.LIFETIME);
        if (lifetime != null) {
            appSpec.setLifetime(lifetime.getRemainingTime());
        }
        if (appReport.getYarnApplicationState() != YarnApplicationState.RUNNING) {
            LOG.info("Service {} is at {} state", (Object)serviceName, (Object)appReport.getYarnApplicationState());
            return appSpec;
        }
        if (StringUtils.isEmpty((CharSequence)appReport.getHost())) {
            LOG.warn(serviceName + " AM hostname is empty");
            return appSpec;
        }
        ClientAMProtocol amProxy = this.createAMProxy(serviceName, appReport);
        ClientAMProtocol.GetStatusResponseProto response = amProxy.getStatus(ClientAMProtocol.GetStatusRequestProto.newBuilder().build());
        appSpec = ServiceApiUtil.jsonSerDeser.fromJson(response.getStatus());
        if (lifetime != null) {
            appSpec.setLifetime(lifetime.getRemainingTime());
        }
        return appSpec;
    }

    public YarnClient getYarnClient() {
        return this.yarnClient;
    }

    public int enableFastLaunch(String destinationFolder) throws IOException, YarnException {
        return this.actionDependency(destinationFolder, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int actionDependency(String destinationFolder, boolean overwrite) {
        String currentUser = RegistryUtils.currentUser();
        LOG.info("Running command as user {}", (Object)currentUser);
        Path dependencyLibTarGzip = destinationFolder == null ? this.fs.getDependencyTarGzip() : new Path(destinationFolder, "service-dep.tar.gz");
        if (this.fs.isFile(dependencyLibTarGzip) && !overwrite) {
            System.out.println(String.format("Dependency libs are already uploaded to %s.", dependencyLibTarGzip.toUri()));
            return 0;
        }
        String[] libDirs = ServiceUtils.getLibDirs();
        if (libDirs.length > 0) {
            File tempLibTarGzipFile = null;
            try {
                if (!this.checkPermissions(dependencyLibTarGzip)) {
                    int n = 41;
                    return n;
                }
                tempLibTarGzipFile = File.createTempFile("service-dep_", ".tar.gz");
                ServiceUtils.tarGzipFolder(libDirs, tempLibTarGzipFile, ServiceUtils.createJarFilter());
                this.fs.copyLocalFileToHdfs(tempLibTarGzipFile, dependencyLibTarGzip, new FsPermission("755"));
                LOG.info("To let apps use this tarball, in yarn-site set config property {} to {}", (Object)"yarn.service.framework.path", (Object)dependencyLibTarGzip);
                int n = 0;
                return n;
            }
            catch (IOException e) {
                LOG.error("Got exception creating tarball and uploading to HDFS", (Throwable)e);
                int n = 56;
                return n;
            }
            finally {
                if (tempLibTarGzipFile != null && !tempLibTarGzipFile.delete()) {
                    LOG.warn("Failed to delete tmp file {}", (Object)tempLibTarGzipFile);
                }
            }
        }
        return -1;
    }

    private boolean checkPermissions(Path dependencyLibTarGzip) throws IOException {
        AccessControlList yarnAdminAcl = new AccessControlList(this.getConfig().get("yarn.admin.acl", "*"));
        AccessControlList dfsAdminAcl = new AccessControlList(this.getConfig().get("dfs.cluster.administrators", " "));
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        if (!yarnAdminAcl.isUserAllowed(ugi) && !dfsAdminAcl.isUserAllowed(ugi)) {
            LOG.error("User must be on the {} or {} list to have permission to upload AM dependency tarball", (Object)"yarn.admin.acl", (Object)"dfs.cluster.administrators");
            return false;
        }
        for (Path parent = dependencyLibTarGzip.getParent(); parent != null; parent = parent.getParent()) {
            FsPermission perm;
            if (!this.fs.getFileSystem().exists(parent) || (perm = this.fs.getFileSystem().getFileStatus(parent).getPermission()).getOtherAction().implies(FsAction.READ_EXECUTE)) continue;
            LOG.error("Parent directory {} of {} tarball location {} does not have world read/execute permission", new Object[]{parent, "yarn.service.framework.path", dependencyLibTarGzip});
            return false;
        }
        return true;
    }

    protected ClientAMProtocol createAMProxy(String serviceName, ApplicationReport appReport) throws IOException, YarnException {
        if (UserGroupInformation.isSecurityEnabled()) {
            String principalName;
            if (!this.cachedAppInfo.containsKey(serviceName)) {
                org.apache.hadoop.yarn.service.api.records.Service persistedService = ServiceApiUtil.loadService(this.fs, serviceName);
                this.cachedAppInfo.put(serviceName, new AppInfo(appReport.getApplicationId(), persistedService.getKerberosPrincipal().getPrincipalName()));
            }
            if (!StringUtils.isEmpty((CharSequence)(principalName = this.cachedAppInfo.get((Object)serviceName).principalName))) {
                this.getConfig().set("yarn.service.am.principal", principalName);
            } else {
                throw new YarnException("No principal specified in the persisted service definition, fail to connect to AM.");
            }
        }
        InetSocketAddress address = NetUtils.createSocketAddrForHost((String)appReport.getHost(), (int)appReport.getRpcPort());
        return ClientAMProxy.createProxy(this.getConfig(), ClientAMProtocol.class, UserGroupInformation.getCurrentUser(), this.rpc, address);
    }

    @VisibleForTesting
    void setFileSystem(SliderFileSystem fileSystem) throws IOException {
        this.fs = fileSystem;
    }

    @VisibleForTesting
    void setYarnClient(YarnClient yarnClient) {
        this.yarnClient = yarnClient;
    }

    public synchronized ApplicationId getAppId(String serviceName) throws IOException, YarnException {
        if (this.cachedAppInfo.containsKey(serviceName)) {
            return this.cachedAppInfo.get((Object)serviceName).appId;
        }
        org.apache.hadoop.yarn.service.api.records.Service persistedService = ServiceApiUtil.loadService(this.fs, serviceName);
        if (persistedService == null) {
            throw new YarnException("Service " + serviceName + " doesn't exist on hdfs. Please check if the app exists in RM");
        }
        if (persistedService.getId() == null) {
            return null;
        }
        ApplicationId currentAppId = ApplicationId.fromString((String)persistedService.getId());
        this.cachedAppInfo.put(serviceName, new AppInfo(currentAppId, persistedService.getKerberosPrincipal().getPrincipalName()));
        return currentAppId;
    }

    private static class AppInfo {
        ApplicationId appId;
        String principalName;

        AppInfo(ApplicationId appId, String principalName) {
            this.appId = appId;
            this.principalName = principalName;
        }
    }
}

