/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.metrics2.MetricsSink;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.hadoop.registry.client.api.RegistryOperationsFactory;
import org.apache.hadoop.registry.client.binding.RegistryPathUtils;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.security.HadoopKerberosName;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.hadoop.thirdparty.com.google.common.cache.CacheLoader;
import org.apache.hadoop.thirdparty.com.google.common.cache.LoadingCache;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.RejectedSchedulingRequest;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.UpdatedContainer;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.TimelineV2Client;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.hadoop.yarn.client.api.async.NMClientAsync;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.service.ServiceContext;
import org.apache.hadoop.yarn.service.ServiceEvent;
import org.apache.hadoop.yarn.service.ServiceEventType;
import org.apache.hadoop.yarn.service.ServiceManager;
import org.apache.hadoop.yarn.service.ServiceMetrics;
import org.apache.hadoop.yarn.service.api.ServiceApiConstants;
import org.apache.hadoop.yarn.service.api.records.ComponentState;
import org.apache.hadoop.yarn.service.api.records.ConfigFile;
import org.apache.hadoop.yarn.service.api.records.Container;
import org.apache.hadoop.yarn.service.api.records.ContainerState;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.api.records.ServiceState;
import org.apache.hadoop.yarn.service.component.Component;
import org.apache.hadoop.yarn.service.component.ComponentEvent;
import org.apache.hadoop.yarn.service.component.ComponentEventType;
import org.apache.hadoop.yarn.service.component.ComponentRestartPolicy;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceEvent;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceEventType;
import org.apache.hadoop.yarn.service.conf.YarnServiceConf;
import org.apache.hadoop.yarn.service.containerlaunch.ContainerLaunchService;
import org.apache.hadoop.yarn.service.provider.ProviderUtils;
import org.apache.hadoop.yarn.service.registry.YarnRegistryViewForProviders;
import org.apache.hadoop.yarn.service.timelineservice.ServiceMetricsSink;
import org.apache.hadoop.yarn.service.timelineservice.ServiceTimelinePublisher;
import org.apache.hadoop.yarn.service.utils.HttpUtil;
import org.apache.hadoop.yarn.service.utils.ServiceApiUtil;
import org.apache.hadoop.yarn.service.utils.ServiceRegistryUtils;
import org.apache.hadoop.yarn.service.utils.ServiceUtils;
import org.apache.hadoop.yarn.util.BoundedAppender;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceScheduler
extends CompositeService {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceScheduler.class);
    private Service app;
    private ServiceManager serviceManager;
    private final Map<String, Component> componentsByName = new ConcurrentHashMap<String, Component>();
    protected final Map<Long, Component> componentsById = new ConcurrentHashMap<Long, Component>();
    private final Map<ContainerId, ComponentInstance> liveInstances = new ConcurrentHashMap<ContainerId, ComponentInstance>();
    private ServiceMetrics serviceMetrics;
    private ServiceTimelinePublisher serviceTimelinePublisher;
    private boolean timelineServiceEnabled;
    private BoundedAppender diagnostics = new BoundedAppender(65536);
    public LoadingCache<ConfigFile, Object> configFileCache = null;
    public ScheduledExecutorService executorService;
    public Map<String, String> globalTokens = new HashMap<String, String>();
    private AMRMClientAsync<AMRMClient.ContainerRequest> amRMClient;
    private NMClientAsync nmClient;
    private AsyncDispatcher dispatcher;
    private YarnRegistryViewForProviders yarnRegistryOperations;
    private ServiceContext context;
    private ContainerLaunchService containerLaunchService;
    private final Map<ContainerId, ComponentInstance> unRecoveredInstances = new ConcurrentHashMap<ContainerId, ComponentInstance>();
    private long containerRecoveryTimeout;
    private boolean hasAtLeastOnePlacementConstraint;
    private boolean gracefulStop = false;
    private volatile FinalApplicationStatus finalApplicationStatus = FinalApplicationStatus.ENDED;
    private Clock systemClock;
    private ServiceUtils.ProcessTerminationHandler terminationHandler = new ServiceUtils.ProcessTerminationHandler();

    public ServiceScheduler(ServiceContext context) {
        super(context.getService().getName());
        this.context = context;
        this.app = context.getService();
        this.systemClock = SystemClock.getInstance();
    }

    public void buildInstance(ServiceContext context, Configuration configuration) throws YarnException, IOException {
        this.app = context.service;
        this.executorService = Executors.newScheduledThreadPool(10);
        RegistryOperations registryClient = null;
        if (UserGroupInformation.isSecurityEnabled() && !StringUtils.isEmpty((CharSequence)context.principal) && !StringUtils.isEmpty((CharSequence)context.keytab)) {
            Configuration conf = this.getConfig();
            String username = new HadoopKerberosName(context.principal.trim()).getServiceName();
            LOG.info("Set registry user accounts: sasl:" + username);
            conf.set("hadoop.registry.user.accounts", "sasl:" + username);
            registryClient = RegistryOperationsFactory.createKerberosInstance((Configuration)conf, (String)"Client", (String)context.principal, (String)context.keytab);
        } else {
            registryClient = RegistryOperationsFactory.createInstance((String)"ServiceScheduler", (Configuration)configuration);
        }
        this.addIfService(registryClient);
        this.yarnRegistryOperations = this.createYarnRegistryOperations(context, registryClient);
        this.serviceMetrics = ServiceMetrics.register(this.app.getName(), "Metrics for service");
        this.serviceMetrics.tag("type", "Metrics type [component or service]", "service");
        this.serviceMetrics.tag("appId", "Service id for service", this.app.getId());
        this.amRMClient = this.createAMRMClient();
        this.addIfService(this.amRMClient);
        this.nmClient = this.createNMClient();
        this.nmClient.getClient().cleanupRunningContainersOnStop(false);
        this.addIfService(this.nmClient);
        this.dispatcher = this.createAsyncDispatcher();
        this.dispatcher.register(ServiceEventType.class, (EventHandler)new ServiceEventHandler());
        this.dispatcher.register(ComponentEventType.class, (EventHandler)new ComponentEventHandler());
        this.dispatcher.register(ComponentInstanceEventType.class, (EventHandler)new ComponentInstanceEventHandler());
        this.dispatcher.setDrainEventsOnStop();
        this.addIfService(this.dispatcher);
        this.containerLaunchService = new ContainerLaunchService(context);
        this.addService((org.apache.hadoop.service.Service)this.containerLaunchService);
        if (YarnConfiguration.timelineServiceV2Enabled((Configuration)configuration)) {
            TimelineV2Client timelineClient = TimelineV2Client.createTimelineClient((ApplicationId)context.attemptId.getApplicationId());
            this.amRMClient.registerTimelineV2Client(timelineClient);
            this.serviceTimelinePublisher = new ServiceTimelinePublisher(timelineClient);
            this.addService((org.apache.hadoop.service.Service)this.serviceTimelinePublisher);
            DefaultMetricsSystem.instance().register("ServiceMetricsSink", "For processing metrics to ATS", (MetricsSink)new ServiceMetricsSink(this.serviceTimelinePublisher));
            LOG.info("Timeline v2 is enabled.");
        }
        this.initGlobalTokensForSubstitute(context);
        ProviderUtils.substituteMapWithTokens(this.app.getQuicklinks(), this.globalTokens);
        this.createConfigFileCache(context.fs.getFileSystem());
        this.createAllComponents();
        this.containerRecoveryTimeout = YarnServiceConf.getInt("yarn.service.container-recovery.timeout.ms", 120000, this.app.getConfiguration(), this.getConfig());
        if (YarnConfiguration.timelineServiceV2Enabled((Configuration)this.getConfig())) {
            this.timelineServiceEnabled = true;
        }
        this.serviceManager = this.createServiceManager();
        context.setServiceManager(this.serviceManager);
    }

    protected YarnRegistryViewForProviders createYarnRegistryOperations(ServiceContext context, RegistryOperations registryClient) {
        return new YarnRegistryViewForProviders(registryClient, RegistryUtils.currentUser(), "yarn-service", this.app.getName(), context.attemptId);
    }

    protected ServiceManager createServiceManager() {
        return new ServiceManager(this.context);
    }

    protected AsyncDispatcher createAsyncDispatcher() {
        return new AsyncDispatcher("Component  dispatcher");
    }

    protected NMClientAsync createNMClient() {
        return NMClientAsync.createNMClientAsync((NMClientAsync.AbstractCallbackHandler)new NMClientCallback());
    }

    protected AMRMClientAsync<AMRMClient.ContainerRequest> createAMRMClient() {
        return AMRMClientAsync.createAMRMClientAsync((int)1000, (AMRMClientAsync.AbstractCallbackHandler)new AMRMClientCallback());
    }

    public void setGracefulStop(FinalApplicationStatus applicationStatus) {
        this.gracefulStop = true;
        this.finalApplicationStatus = applicationStatus;
        this.nmClient.getClient().cleanupRunningContainersOnStop(true);
    }

    public void serviceInit(Configuration conf) throws Exception {
        try {
            this.buildInstance(this.context, conf);
        }
        catch (YarnException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
        super.serviceInit(conf);
    }

    public void serviceStop() throws Exception {
        LOG.info("Stopping service scheduler");
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
        DefaultMetricsSystem.shutdown();
        if (this.gracefulStop) {
            if (YarnConfiguration.timelineServiceV2Enabled((Configuration)this.getConfig())) {
                Map<ContainerId, ComponentInstance> liveInst = this.getLiveInstances();
                for (Map.Entry<ContainerId, ComponentInstance> instance : liveInst.entrySet()) {
                    if (ComponentInstance.isFinalState(instance.getValue().getContainerSpec().getState())) continue;
                    LOG.info("{} Component instance state changed from {} to {}", new Object[]{instance.getValue().getCompInstanceName(), instance.getValue().getContainerSpec().getState(), ContainerState.STOPPED});
                    this.serviceTimelinePublisher.componentInstanceFinished(instance.getKey(), -107, ContainerState.STOPPED, this.getDiagnostics().toString());
                }
                LOG.info("Service state changed to {}", (Object)this.finalApplicationStatus);
                this.serviceTimelinePublisher.serviceAttemptUnregistered(this.context, this.finalApplicationStatus, this.diagnostics.toString());
            }
            this.amRMClient.unregisterApplicationMaster(this.finalApplicationStatus, this.diagnostics.toString(), "");
            LOG.info("Service {} unregistered with RM, with attemptId = {} , diagnostics = {} ", new Object[]{this.app.getName(), this.context.attemptId, this.diagnostics});
        }
        super.serviceStop();
    }

    public void serviceStart() throws Exception {
        super.serviceStart();
        InetSocketAddress bindAddress = this.context.clientAMService.getBindAddress();
        RegisterApplicationMasterResponse response = this.amRMClient.registerApplicationMaster(bindAddress.getHostName(), bindAddress.getPort(), "N/A");
        if (response.getResourceTypes() != null) {
            ResourceUtils.reinitializeResources((List)response.getResourceTypes());
        }
        if (response.getClientToAMTokenMasterKey() != null && response.getClientToAMTokenMasterKey().remaining() != 0) {
            this.context.secretManager.setMasterKey(response.getClientToAMTokenMasterKey().array());
        }
        this.registerServiceInstance(this.context.attemptId, this.app);
        this.app.setState(ServiceState.STARTED);
        ServiceApiUtil.checkServiceDependencySatisified(this.context.service);
        this.recoverComponents(response);
        for (Component component : this.componentsById.values()) {
            if (!component.areDependenciesReady()) continue;
            LOG.info("Triggering initial evaluation of component {}", (Object)component.getName());
            ComponentEvent event = new ComponentEvent(component.getName(), ComponentEventType.FLEX).setDesired(component.getComponentSpec().getNumberOfContainers());
            component.handle(event);
        }
    }

    private void recoverComponents(RegisterApplicationMasterResponse response) {
        ServiceRecord record2;
        List containersFromPrevAttempt = response.getContainersFromPreviousAttempts();
        LOG.info("Received {} containers from previous attempt.", (Object)containersFromPrevAttempt.size());
        HashMap<String, ServiceRecord> existingRecords = new HashMap<String, ServiceRecord>();
        List<String> existingComps = null;
        try {
            existingComps = this.yarnRegistryOperations.listComponents();
            LOG.info("Found {} containers from ZK registry: {}", (Object)existingComps.size(), existingComps);
        }
        catch (Exception e) {
            LOG.info("Could not read component paths: {}", (Object)e.getMessage());
        }
        if (existingComps != null) {
            for (String existingComp : existingComps) {
                try {
                    record2 = this.yarnRegistryOperations.getComponent(existingComp);
                    existingRecords.put(existingComp, record2);
                }
                catch (Exception e) {
                    LOG.warn("Could not resolve record for component {}: {}", (Object)existingComp, (Object)e);
                }
            }
        }
        for (org.apache.hadoop.yarn.api.records.Container container : containersFromPrevAttempt) {
            LOG.info("Handling {} from previous attempt", (Object)container.getId());
            record2 = (ServiceRecord)existingRecords.remove(RegistryPathUtils.encodeYarnID((String)container.getId().toString()));
            if (record2 != null) {
                Component comp = this.componentsById.get(container.getAllocationRequestId());
                ComponentEvent event = new ComponentEvent(comp.getName(), ComponentEventType.CONTAINER_RECOVERED).setContainer(container).setInstance(comp.getComponentInstance(record2.description));
                comp.handle(event);
                continue;
            }
            LOG.info("Record not found in registry for container {} from previous attempt, releasing", (Object)container.getId());
            this.amRMClient.releaseAssignedContainer(container.getId());
        }
        ApplicationId appId = ApplicationId.fromString((String)this.app.getId());
        existingRecords.forEach((encodedContainerId, record) -> {
            Component component;
            String componentName = record.get("yarn:component");
            if (componentName != null && (component = this.componentsByName.get(componentName)) != null) {
                ComponentInstance compInstance = component.getComponentInstance(record.description);
                ContainerId containerId = ContainerId.fromString((String)record.get("yarn:id"));
                if (containerId.getApplicationAttemptId().getApplicationId().equals((Object)appId)) {
                    this.unRecoveredInstances.put(containerId, compInstance);
                    component.removePendingInstance(compInstance);
                }
            }
        });
        if (this.unRecoveredInstances.size() > 0) {
            this.executorService.schedule(() -> {
                Map<ContainerId, ComponentInstance> map = this.unRecoveredInstances;
                synchronized (map) {
                    this.unRecoveredInstances.forEach((containerId, instance) -> {
                        LOG.info("{}, wait on container {} expired", (Object)instance.getCompInstanceId(), containerId);
                        instance.cleanupRegistryAndCompHdfsDir((ContainerId)containerId);
                        Component component = this.componentsByName.get(instance.getCompName());
                        component.requestContainers(1L);
                        component.reInsertPendingInstance((ComponentInstance)instance);
                        this.amRMClient.releaseAssignedContainer(containerId);
                    });
                    this.unRecoveredInstances.clear();
                }
            }, this.containerRecoveryTimeout, TimeUnit.MILLISECONDS);
        }
    }

    private void initGlobalTokensForSubstitute(ServiceContext context) {
        String clusterFs;
        this.globalTokens.put(ServiceApiConstants.CLUSTER_ZK_QUORUM, this.getConfig().getTrimmed("hadoop.registry.zk.quorum", "localhost:2181"));
        String user = RegistryUtils.currentUser();
        this.globalTokens.put(ServiceApiConstants.SERVICE_ZK_PATH, ServiceRegistryUtils.mkServiceHomePath(user, this.app.getName()));
        this.globalTokens.put(ServiceApiConstants.USER, user);
        String dnsDomain = this.getConfig().getTrimmed("hadoop.registry.dns.domain-name");
        if (dnsDomain != null && !dnsDomain.isEmpty()) {
            this.globalTokens.put(ServiceApiConstants.DOMAIN, dnsDomain);
        }
        if ((clusterFs = this.getConfig().getTrimmed("fs.defaultFS")) != null && !clusterFs.isEmpty()) {
            this.globalTokens.put(ServiceApiConstants.CLUSTER_FS_URI, clusterFs);
            this.globalTokens.put(ServiceApiConstants.CLUSTER_FS_HOST, URI.create(clusterFs).getHost());
        }
        this.globalTokens.put(ServiceApiConstants.SERVICE_HDFS_DIR, context.serviceHdfsDir);
        this.globalTokens.put(ServiceApiConstants.SERVICE_NAME_LC, this.app.getName().toLowerCase());
        this.globalTokens.put(ServiceApiConstants.SERVICE_NAME, this.app.getName());
    }

    private void createConfigFileCache(final FileSystem fileSystem) {
        this.configFileCache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<ConfigFile, Object>(){

            public Object load(ConfigFile key) throws Exception {
                switch (key.getType()) {
                    case HADOOP_XML: {
                        try (FSDataInputStream input = fileSystem.open(new Path(key.getSrcFile()));){
                            Configuration confRead = new Configuration(false);
                            confRead.addResource((InputStream)input);
                            HashMap<String, String> map = new HashMap<String, String>(confRead.size());
                            for (Map.Entry entry : confRead) {
                                map.put((String)entry.getKey(), (String)entry.getValue());
                            }
                            HashMap<String, String> hashMap = map;
                            return hashMap;
                        }
                    }
                    case TEMPLATE: {
                        try (FSDataInputStream fileInput = fileSystem.open(new Path(key.getSrcFile()));){
                            String string = IOUtils.toString((InputStream)fileInput, (Charset)StandardCharsets.UTF_8);
                            return string;
                        }
                    }
                }
                return null;
            }
        });
        this.context.configCache = this.configFileCache;
    }

    private void registerServiceInstance(final ApplicationAttemptId attemptId, Service service) throws IOException {
        LOG.info("Registering " + attemptId + ", " + service.getName() + " into registry");
        final ServiceRecord serviceRecord = new ServiceRecord();
        serviceRecord.set("yarn:id", (Object)attemptId.getApplicationId().toString());
        serviceRecord.set("yarn:persistence", (Object)"application");
        serviceRecord.description = "YarnServiceMaster";
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    boolean isFirstAttempt;
                    ServiceScheduler.this.yarnRegistryOperations.registerSelf(serviceRecord, false);
                    LOG.info("Registered service under {}; absolute path {}", (Object)ServiceScheduler.this.yarnRegistryOperations.getSelfRegistrationPath(), (Object)ServiceScheduler.this.yarnRegistryOperations.getAbsoluteSelfRegistrationPath());
                    boolean bl = isFirstAttempt = 1 == attemptId.getAttemptId();
                    if (isFirstAttempt) {
                        ServiceScheduler.this.yarnRegistryOperations.deleteChildren(ServiceScheduler.this.yarnRegistryOperations.getSelfRegistrationPath(), true);
                    }
                }
                catch (IOException e) {
                    LOG.error("Failed to register app " + ServiceScheduler.this.app.getName() + " in registry", (Throwable)e);
                }
            }
        });
        if (YarnConfiguration.timelineServiceV2Enabled((Configuration)this.getConfig())) {
            this.serviceTimelinePublisher.serviceAttemptRegistered(this.app, this.getConfig());
        }
    }

    private void createAllComponents() {
        long allocateId = 0L;
        Collection<org.apache.hadoop.yarn.service.api.records.Component> sortedComponents = ServiceApiUtil.sortByDependencies(this.app.getComponents());
        for (org.apache.hadoop.yarn.service.api.records.Component compSpec : sortedComponents) {
            Component component = new Component(compSpec, allocateId, this.context);
            this.componentsById.put(allocateId, component);
            this.componentsByName.put(component.getName(), component);
            ++allocateId;
            if (this.hasAtLeastOnePlacementConstraint || compSpec.getPlacementPolicy() == null || compSpec.getPlacementPolicy().getConstraints() == null || compSpec.getPlacementPolicy().getConstraints().isEmpty()) continue;
            this.hasAtLeastOnePlacementConstraint = true;
        }
    }

    public ServiceMetrics getServiceMetrics() {
        return this.serviceMetrics;
    }

    public AMRMClientAsync<AMRMClient.ContainerRequest> getAmRMClient() {
        return this.amRMClient;
    }

    public NMClientAsync getNmClient() {
        return this.nmClient;
    }

    public void addLiveCompInstance(ContainerId containerId, ComponentInstance instance) {
        this.liveInstances.put(containerId, instance);
    }

    public void removeLiveCompInstance(ContainerId containerId) {
        this.liveInstances.remove(containerId);
    }

    public YarnRegistryViewForProviders getYarnRegistryOperations() {
        return this.yarnRegistryOperations;
    }

    public ServiceTimelinePublisher getServiceTimelinePublisher() {
        return this.serviceTimelinePublisher;
    }

    public Map<ContainerId, ComponentInstance> getLiveInstances() {
        return this.liveInstances;
    }

    public ContainerLaunchService getContainerLaunchService() {
        return this.containerLaunchService;
    }

    public ServiceContext getContext() {
        return this.context;
    }

    public Map<String, Component> getAllComponents() {
        return this.componentsByName;
    }

    public Service getApp() {
        return this.app;
    }

    public AsyncDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public BoundedAppender getDiagnostics() {
        return this.diagnostics;
    }

    public boolean hasAtLeastOnePlacementConstraint() {
        return this.hasAtLeastOnePlacementConstraint;
    }

    public boolean terminateServiceIfNeeded(Component component) {
        boolean serviceIsTerminated = this.terminateServiceIfDominantComponentFinished(component) || this.terminateServiceIfAllComponentsFinished();
        return serviceIsTerminated;
    }

    private boolean terminateServiceIfDominantComponentFinished(Component component) {
        ComponentRestartPolicy restartPolicy;
        boolean shouldTerminate = false;
        boolean componentIsDominant = component.getComponentSpec().getConfiguration().getPropertyBool("yarn.service.container-state-report-as-service-state", false);
        if (componentIsDominant && (restartPolicy = component.getRestartPolicyHandler()).shouldTerminate(component)) {
            shouldTerminate = true;
            boolean isSucceeded = restartPolicy.hasCompletedSuccessfully(component);
            ComponentState state = isSucceeded ? ComponentState.SUCCEEDED : ComponentState.FAILED;
            LOG.info("{} Component state changed from {} to {}", new Object[]{component.getName(), component.getComponentSpec().getState(), state});
            component.getComponentSpec().setState(state);
            LOG.info("Dominate component {} finished, exiting Service Master... , final status=" + (isSucceeded ? "Succeeded" : "Failed"), (Object)component.getName());
            this.terminateService(isSucceeded);
        }
        return shouldTerminate;
    }

    private boolean terminateServiceIfAllComponentsFinished() {
        boolean shouldTerminate = true;
        HashSet<String> succeededComponents = new HashSet<String>();
        HashSet<String> failedComponents = new HashSet<String>();
        for (Component comp : this.getAllComponents().values()) {
            ComponentRestartPolicy restartPolicy = comp.getRestartPolicyHandler();
            if (restartPolicy.shouldTerminate(comp)) {
                if (restartPolicy.hasCompletedSuccessfully(comp)) {
                    LOG.info("{} Component state changed from {} to {}", new Object[]{comp.getName(), comp.getComponentSpec().getState(), ComponentState.SUCCEEDED});
                    comp.getComponentSpec().setState(ComponentState.SUCCEEDED);
                } else {
                    LOG.info("{} Component state changed from {} to {}", new Object[]{comp.getName(), comp.getComponentSpec().getState(), ComponentState.FAILED});
                    comp.getComponentSpec().setState(ComponentState.FAILED);
                }
                if (this.isTimelineServiceEnabled()) {
                    this.serviceTimelinePublisher.componentFinished(comp.getComponentSpec(), comp.getComponentSpec().getState(), this.systemClock.getTime());
                }
            } else {
                shouldTerminate = false;
                break;
            }
            long nFailed = comp.getNumFailedInstances();
            if (nFailed > 0L) {
                failedComponents.add(comp.getName());
                continue;
            }
            succeededComponents.add(comp.getName());
        }
        if (shouldTerminate) {
            LOG.info("All component finished, exiting Service Master... , final status=" + (failedComponents.isEmpty() ? "Succeeded" : "Failed"));
            LOG.info("Succeeded components: [" + StringUtils.join(succeededComponents, (String)",") + "]");
            LOG.info("Failed components: [" + StringUtils.join(failedComponents, (String)",") + "]");
            this.terminateService(failedComponents.isEmpty());
        }
        return shouldTerminate;
    }

    private void terminateService(boolean isSucceeded) {
        int exitStatus = 0;
        if (isSucceeded) {
            this.setGracefulStop(FinalApplicationStatus.SUCCEEDED);
            this.app.setState(ServiceState.SUCCEEDED);
        } else {
            this.setGracefulStop(FinalApplicationStatus.FAILED);
            this.app.setState(ServiceState.FAILED);
            exitStatus = -1;
        }
        this.getTerminationHandler().terminate(exitStatus);
    }

    public Clock getSystemClock() {
        return this.systemClock;
    }

    public boolean isTimelineServiceEnabled() {
        return this.timelineServiceEnabled;
    }

    public ServiceUtils.ProcessTerminationHandler getTerminationHandler() {
        return this.terminationHandler;
    }

    public void syncSysFs(Service yarnApp) {
        boolean success = true;
        Configuration conf = this.getConfig();
        boolean useKerberos = UserGroupInformation.isSecurityEnabled();
        boolean printSyncResult = false;
        try {
            String port = conf.get("yarn.nodemanager.webapp.address").split(":")[1];
            String spec = ServiceApiUtil.jsonSerDeser.toJson(yarnApp);
            for (org.apache.hadoop.yarn.service.api.records.Component c : yarnApp.getComponents()) {
                HashSet<String> nodes = new HashSet<String>();
                boolean update = Boolean.parseBoolean(c.getConfiguration().getEnv(ApplicationConstants.Environment.YARN_CONTAINER_RUNTIME_YARN_SYSFS_ENABLE.name()));
                if (!update) continue;
                printSyncResult = true;
                for (Container container : c.getContainers()) {
                    String bareHost = container.getBareHost();
                    nodes.add(bareHost);
                }
                for (String bareHost : nodes) {
                    WebResource.Builder builder;
                    ClientResponse response;
                    StringBuilder requestPath = new StringBuilder();
                    if (YarnConfiguration.useHttps((Configuration)conf)) {
                        requestPath.append("https://");
                    } else {
                        requestPath.append("http://");
                    }
                    requestPath.append(bareHost).append(":").append(port).append("/ws/v1/node/yarn/sysfs/").append(UserGroupInformation.getCurrentUser().getShortUserName()).append("/").append(yarnApp.getId());
                    if (!useKerberos) {
                        requestPath.append("?user.name=").append(UserGroupInformation.getCurrentUser().getShortUserName());
                    }
                    if ((response = (ClientResponse)(builder = HttpUtil.connect(requestPath.toString())).put(ClientResponse.class, (Object)spec)).getStatus() == ClientResponse.Status.OK.getStatusCode()) continue;
                    LOG.warn("Error synchronize YARN sysfs: " + (String)response.getEntity(String.class));
                    success = false;
                }
            }
            if (printSyncResult && success) {
                LOG.info("YARN sysfs synchronized.");
            }
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            LOG.error("Fail to sync service spec.", (Throwable)e);
        }
    }

    private final class ServiceEventHandler
    implements EventHandler<ServiceEvent> {
        private ServiceEventHandler() {
        }

        public void handle(ServiceEvent event) {
            try {
                ServiceScheduler.this.serviceManager.handle(event);
            }
            catch (Throwable t) {
                LOG.error(MessageFormat.format("[SERVICE]: Error in handling event type {0}", new Object[]{event.getType()}), t);
            }
        }
    }

    private final class ComponentEventHandler
    implements EventHandler<ComponentEvent> {
        private ComponentEventHandler() {
        }

        public void handle(ComponentEvent event) {
            Component component = ServiceScheduler.this.componentsByName.get(event.getName());
            if (component == null) {
                LOG.error("No component exists for " + event.getName());
                return;
            }
            try {
                component.handle(event);
            }
            catch (Throwable t) {
                LOG.error(MessageFormat.format("[COMPONENT {0}]: Error in handling event type {1}", new Object[]{component.getName(), event.getType()}), t);
            }
        }
    }

    private final class ComponentInstanceEventHandler
    implements EventHandler<ComponentInstanceEvent> {
        private ComponentInstanceEventHandler() {
        }

        public void handle(ComponentInstanceEvent event) {
            ComponentInstance instance = ServiceScheduler.this.liveInstances.get(event.getContainerId());
            if (instance == null) {
                LOG.error("No component instance exists for " + event.getContainerId());
                return;
            }
            try {
                instance.handle(event);
            }
            catch (Throwable t) {
                LOG.error(instance.getCompInstanceId() + ": Error in handling event type " + event.getType(), t);
            }
        }
    }

    private class NMClientCallback
    extends NMClientAsync.AbstractCallbackHandler {
        private NMClientCallback() {
        }

        public void onContainerStarted(ContainerId containerId, Map<String, ByteBuffer> allServiceResponse) {
            ComponentInstance instance = ServiceScheduler.this.liveInstances.get(containerId);
            if (instance == null) {
                LOG.error("No component instance exists for " + containerId);
                return;
            }
            ComponentEvent event = new ComponentEvent(instance.getCompName(), ComponentEventType.CONTAINER_STARTED).setInstance(instance).setContainerId(containerId);
            ServiceScheduler.this.dispatcher.getEventHandler().handle((Event)event);
        }

        public void onContainerStatusReceived(ContainerId containerId, ContainerStatus containerStatus) {
        }

        public void onContainerStopped(ContainerId containerId) {
        }

        public void onStartContainerError(ContainerId containerId, Throwable t) {
            ComponentInstance instance = ServiceScheduler.this.liveInstances.get(containerId);
            if (instance == null) {
                LOG.error("No component instance exists for " + containerId);
                return;
            }
            LOG.error("Failed to start " + containerId, t);
            ServiceScheduler.this.amRMClient.releaseAssignedContainer(containerId);
        }

        public void onContainerReInitialize(ContainerId containerId) {
            ComponentInstance instance = ServiceScheduler.this.liveInstances.get(containerId);
            if (instance == null) {
                LOG.error("No component instance exists for {}", (Object)containerId);
                return;
            }
            ServiceScheduler.this.dispatcher.getEventHandler().handle((Event)new ComponentInstanceEvent(containerId, ComponentInstanceEventType.START));
        }

        public void onContainerReInitializeError(ContainerId containerId, Throwable t) {
            ComponentInstance instance = ServiceScheduler.this.liveInstances.get(containerId);
            if (instance == null) {
                LOG.error("No component instance exists for {}", (Object)containerId);
                return;
            }
            ComponentEvent event = new ComponentEvent(instance.getCompName(), ComponentEventType.CONTAINER_COMPLETED).setInstance(instance).setContainerId(containerId);
            ServiceScheduler.this.dispatcher.getEventHandler().handle((Event)event);
        }

        public void onContainerResourceIncreased(ContainerId containerId, Resource resource) {
        }

        public void onContainerResourceUpdated(ContainerId containerId, Resource resource) {
        }

        public void onGetContainerStatusError(ContainerId containerId, Throwable t) {
        }

        public void onIncreaseContainerResourceError(ContainerId containerId, Throwable t) {
        }

        public void onUpdateContainerResourceError(ContainerId containerId, Throwable t) {
        }

        public void onStopContainerError(ContainerId containerId, Throwable t) {
        }
    }

    class AMRMClientCallback
    extends AMRMClientAsync.AbstractCallbackHandler {
        AMRMClientCallback() {
        }

        public void onContainersAllocated(List<org.apache.hadoop.yarn.api.records.Container> containers) {
            LOG.info(containers.size() + " containers allocated. ");
            for (org.apache.hadoop.yarn.api.records.Container container : containers) {
                Component comp = ServiceScheduler.this.componentsById.get(container.getAllocationRequestId());
                ComponentEvent event = new ComponentEvent(comp.getName(), ComponentEventType.CONTAINER_ALLOCATED).setContainer(container);
                ServiceScheduler.this.dispatcher.getEventHandler().handle((Event)event);
                try {
                    Collection requests = ServiceScheduler.this.amRMClient.getMatchingRequests(container.getAllocationRequestId());
                    LOG.info("[COMPONENT {}]: remove {} outstanding container requests for allocateId " + container.getAllocationRequestId(), (Object)comp.getName(), (Object)requests.size());
                    if (!requests.iterator().hasNext()) continue;
                    AMRMClient.ContainerRequest request = (AMRMClient.ContainerRequest)requests.iterator().next();
                    ServiceScheduler.this.amRMClient.removeContainerRequest(request);
                }
                catch (Exception e) {
                    LOG.error("Exception when removing the matching requests. ", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onContainersReceivedFromPreviousAttempts(List<org.apache.hadoop.yarn.api.records.Container> containers) {
            LOG.info("Containers recovered after AM registered: {}", containers);
            if (containers == null || containers.isEmpty()) {
                return;
            }
            for (org.apache.hadoop.yarn.api.records.Container container : containers) {
                ComponentInstance compInstance;
                Map<ContainerId, ComponentInstance> map = ServiceScheduler.this.unRecoveredInstances;
                synchronized (map) {
                    compInstance = ServiceScheduler.this.unRecoveredInstances.remove(container.getId());
                }
                if (compInstance != null) {
                    Component component = ServiceScheduler.this.componentsById.get(container.getAllocationRequestId());
                    ComponentEvent event = new ComponentEvent(component.getName(), ComponentEventType.CONTAINER_RECOVERED).setInstance(compInstance).setContainerId(container.getId()).setContainer(container);
                    component.handle(event);
                    continue;
                }
                LOG.info("Not waiting to recover container {}, releasing", (Object)container.getId());
                ServiceScheduler.this.amRMClient.releaseAssignedContainer(container.getId());
            }
        }

        public void onContainersCompleted(List<ContainerStatus> statuses) {
            for (ContainerStatus status : statuses) {
                ContainerId containerId = status.getContainerId();
                ComponentInstance instance = ServiceScheduler.this.liveInstances.get(status.getContainerId());
                if (instance == null) {
                    LOG.warn("Container {} Completed. No component instance exists. exitStatus={}. diagnostics={} ", new Object[]{containerId, status.getExitStatus(), status.getDiagnostics()});
                    continue;
                }
                ComponentEvent event = new ComponentEvent(instance.getCompName(), ComponentEventType.CONTAINER_COMPLETED).setStatus(status).setInstance(instance).setContainerId(containerId);
                ServiceScheduler.this.dispatcher.getEventHandler().handle((Event)event);
            }
        }

        public void onContainersUpdated(List<UpdatedContainer> containers) {
        }

        public void onShutdownRequest() {
        }

        public void onNodesUpdated(List<NodeReport> updatedNodes) {
            StringBuilder str = new StringBuilder();
            str.append("Nodes updated info: ").append(System.lineSeparator());
            for (NodeReport report : updatedNodes) {
                str.append(report.getNodeId()).append(", state = ").append(report.getNodeState()).append(", healthDiagnostics = ").append(report.getHealthReport()).append(System.lineSeparator());
            }
            LOG.warn(str.toString());
        }

        public float getProgress() {
            long total = 0L;
            for (org.apache.hadoop.yarn.service.api.records.Component component : ServiceScheduler.this.app.getComponents()) {
                total += component.getNumberOfContainers().longValue();
            }
            if (total == 0L) {
                return 100.0f;
            }
            return Math.max((float)ServiceScheduler.this.liveInstances.size() / (float)total * 100.0f, 100.0f);
        }

        public void onError(Throwable e) {
            LOG.error("Error in AMRMClient callback handler ", e);
        }

        public void onRequestsRejected(List<RejectedSchedulingRequest> rejectedSchedulingRequests) {
            LOG.error("Error in AMRMClient callback handler. Following scheduling requests were rejected: {}", rejectedSchedulingRequests);
        }
    }
}

