/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.utils;

import java.util.List;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.yarn.proto.ClientAMProtocol;
import org.apache.hadoop.yarn.service.MockRunningServiceContext;
import org.apache.hadoop.yarn.service.ServiceContext;
import org.apache.hadoop.yarn.service.ServiceTestUtils;
import org.apache.hadoop.yarn.service.TestServiceManager;
import org.apache.hadoop.yarn.service.api.records.ComponentContainers;
import org.apache.hadoop.yarn.service.api.records.ContainerState;
import org.apache.hadoop.yarn.service.utils.FilterUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestFilterUtils {
    @Rule
    public ServiceTestUtils.ServiceFSWatcher rule = new ServiceTestUtils.ServiceFSWatcher();

    @Test
    public void testNoFilter() throws Exception {
        ClientAMProtocol.GetCompInstancesRequestProto req = ClientAMProtocol.GetCompInstancesRequestProto.newBuilder().build();
        List compContainers = FilterUtils.filterInstances((ServiceContext)new MockRunningServiceContext(this.rule, TestServiceManager.createBaseDef("service")), (ClientAMProtocol.GetCompInstancesRequestProto)req);
        Assert.assertEquals((String)"num comps", (long)2L, (long)compContainers.size());
        compContainers.forEach(item -> Assert.assertEquals((String)"num containers", (long)2L, (long)item.getContainers().size()));
    }

    @Test
    public void testFilterWithComp() throws Exception {
        ClientAMProtocol.GetCompInstancesRequestProto req = ClientAMProtocol.GetCompInstancesRequestProto.newBuilder().addAllComponentNames((Iterable)Lists.newArrayList((Object[])new String[]{"compa"})).build();
        List compContainers = FilterUtils.filterInstances((ServiceContext)new MockRunningServiceContext(this.rule, TestServiceManager.createBaseDef("service")), (ClientAMProtocol.GetCompInstancesRequestProto)req);
        Assert.assertEquals((String)"num comps", (long)1L, (long)compContainers.size());
        Assert.assertEquals((String)"comp name", (Object)"compa", (Object)((ComponentContainers)compContainers.get(0)).getComponentName());
        Assert.assertEquals((String)"num containers", (long)2L, (long)((ComponentContainers)compContainers.get(0)).getContainers().size());
    }

    @Test
    public void testFilterWithVersion() throws Exception {
        MockRunningServiceContext sc = new MockRunningServiceContext(this.rule, TestServiceManager.createBaseDef("service"));
        ClientAMProtocol.GetCompInstancesRequestProto.Builder reqBuilder = ClientAMProtocol.GetCompInstancesRequestProto.newBuilder();
        reqBuilder.setVersion("v2");
        Assert.assertEquals((String)"num comps", (long)0L, (long)FilterUtils.filterInstances((ServiceContext)sc, (ClientAMProtocol.GetCompInstancesRequestProto)reqBuilder.build()).size());
        reqBuilder.addAllComponentNames((Iterable)Lists.newArrayList((Object[])new String[]{"compa"})).setVersion("v1").build();
        Assert.assertEquals((String)"num containers", (long)2L, (long)((ComponentContainers)FilterUtils.filterInstances((ServiceContext)sc, (ClientAMProtocol.GetCompInstancesRequestProto)reqBuilder.build()).get(0)).getContainers().size());
    }

    @Test
    public void testFilterWithState() throws Exception {
        MockRunningServiceContext sc = new MockRunningServiceContext(this.rule, TestServiceManager.createBaseDef("service"));
        ClientAMProtocol.GetCompInstancesRequestProto.Builder reqBuilder = ClientAMProtocol.GetCompInstancesRequestProto.newBuilder();
        reqBuilder.addAllContainerStates((Iterable)Lists.newArrayList((Object[])new String[]{ContainerState.READY.toString()}));
        List compContainers = FilterUtils.filterInstances((ServiceContext)sc, (ClientAMProtocol.GetCompInstancesRequestProto)reqBuilder.build());
        Assert.assertEquals((String)"num comps", (long)2L, (long)compContainers.size());
        compContainers.forEach(item -> Assert.assertEquals((String)"num containers", (long)2L, (long)item.getContainers().size()));
        reqBuilder.clearContainerStates();
        reqBuilder.addAllContainerStates((Iterable)Lists.newArrayList((Object[])new String[]{ContainerState.STOPPED.toString()}));
        Assert.assertEquals((String)"num comps", (long)0L, (long)FilterUtils.filterInstances((ServiceContext)sc, (ClientAMProtocol.GetCompInstancesRequestProto)reqBuilder.build()).size());
    }
}

