/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.timelineservice;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.client.api.TimelineV2Client;
import org.apache.hadoop.yarn.client.api.impl.TimelineV2ClientImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.service.ServiceContext;
import org.apache.hadoop.yarn.service.api.records.Artifact;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.Configuration;
import org.apache.hadoop.yarn.service.api.records.Container;
import org.apache.hadoop.yarn.service.api.records.ContainerState;
import org.apache.hadoop.yarn.service.api.records.PlacementConstraint;
import org.apache.hadoop.yarn.service.api.records.PlacementPolicy;
import org.apache.hadoop.yarn.service.api.records.PlacementType;
import org.apache.hadoop.yarn.service.api.records.Resource;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.api.records.ServiceState;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceId;
import org.apache.hadoop.yarn.service.timelineservice.ServiceTimelineEntityType;
import org.apache.hadoop.yarn.service.timelineservice.ServiceTimelineEvent;
import org.apache.hadoop.yarn.service.timelineservice.ServiceTimelinePublisher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestServiceTimelinePublisher {
    private TimelineV2Client timelineClient;
    private org.apache.hadoop.conf.Configuration config;
    private ServiceTimelinePublisher serviceTimelinePublisher;
    private static String SERVICE_NAME = "HBASE";
    private static String SERVICEID = "application_1490093646524_0005";
    private static String ARTIFACTID = "ARTIFACTID";
    private static String COMPONENT_NAME = "DEFAULT";
    private static String CONTAINER_ID = "container_e02_1490093646524_0005_01_000001";
    private static String CONTAINER_IP = "localhost";
    private static String CONTAINER_HOSTNAME = "cnl124-localhost.site";
    private static String CONTAINER_BAREHOST = "localhost.com";

    @Before
    public void setUp() throws Exception {
        this.config = new org.apache.hadoop.conf.Configuration();
        this.config.setBoolean("yarn.timeline-service.enabled", true);
        this.config.setFloat("yarn.timeline-service.version", 2.0f);
        this.timelineClient = new DummyTimelineClient(ApplicationId.fromString((String)SERVICEID));
        this.serviceTimelinePublisher = new ServiceTimelinePublisher(this.timelineClient);
        this.serviceTimelinePublisher.init(this.config);
        this.serviceTimelinePublisher.start();
    }

    @After
    public void tearDown() throws Exception {
        if (this.serviceTimelinePublisher != null) {
            this.serviceTimelinePublisher.stop();
        }
        if (this.timelineClient != null) {
            this.timelineClient.stop();
        }
    }

    @Test
    public void testServiceAttemptEntity() {
        Service service = TestServiceTimelinePublisher.createMockApplication();
        this.serviceTimelinePublisher.serviceAttemptRegistered(service, (org.apache.hadoop.conf.Configuration)new YarnConfiguration());
        Collection<TimelineEntity> lastPublishedEntities = ((DummyTimelineClient)this.timelineClient).getLastPublishedEntities();
        Assert.assertEquals((long)2L, (long)lastPublishedEntities.size());
        for (TimelineEntity timelineEntity : lastPublishedEntities) {
            if (timelineEntity.getType() == ServiceTimelineEntityType.COMPONENT.toString()) {
                this.verifyComponentTimelineEntity(timelineEntity);
                continue;
            }
            this.verifyServiceAttemptTimelineEntity(timelineEntity, null, true);
        }
        ServiceContext context = new ServiceContext();
        context.attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.fromString((String)service.getId()), (int)1);
        String exitDiags = "service killed";
        this.serviceTimelinePublisher.serviceAttemptUnregistered(context, FinalApplicationStatus.ENDED, exitDiags);
        lastPublishedEntities = ((DummyTimelineClient)this.timelineClient).getLastPublishedEntities();
        for (TimelineEntity timelineEntity : lastPublishedEntities) {
            if (timelineEntity.getType() != ServiceTimelineEntityType.SERVICE_ATTEMPT.toString()) continue;
            this.verifyServiceAttemptTimelineEntity(timelineEntity, exitDiags, false);
        }
    }

    @Test
    public void testComponentInstanceEntity() {
        Container container = new Container();
        container.id(CONTAINER_ID).ip(CONTAINER_IP).bareHost(CONTAINER_BAREHOST).hostname(CONTAINER_HOSTNAME).state(ContainerState.RUNNING_BUT_UNREADY).launchTime(new Date());
        ComponentInstanceId id = new ComponentInstanceId(0L, COMPONENT_NAME);
        ComponentInstance instance = (ComponentInstance)Mockito.mock(ComponentInstance.class);
        Mockito.when((Object)instance.getCompName()).thenReturn((Object)COMPONENT_NAME);
        Mockito.when((Object)instance.getCompInstanceName()).thenReturn((Object)"comp_instance_name");
        this.serviceTimelinePublisher.componentInstanceStarted(container, instance);
        Collection<TimelineEntity> lastPublishedEntities = ((DummyTimelineClient)this.timelineClient).getLastPublishedEntities();
        Assert.assertEquals((long)1L, (long)lastPublishedEntities.size());
        TimelineEntity entity = lastPublishedEntities.iterator().next();
        Assert.assertEquals((long)1L, (long)entity.getEvents().size());
        Assert.assertEquals((Object)CONTAINER_ID, (Object)entity.getId());
        Assert.assertEquals((Object)CONTAINER_BAREHOST, entity.getInfo().get("BARE_HOST"));
        Assert.assertEquals((Object)COMPONENT_NAME, entity.getInfo().get("COMPONENT_NAME"));
        Assert.assertEquals((Object)ContainerState.RUNNING_BUT_UNREADY.toString(), entity.getInfo().get("STATE"));
        container.setState(ContainerState.READY);
        this.serviceTimelinePublisher.componentInstanceIPHostUpdated(container);
        lastPublishedEntities = ((DummyTimelineClient)this.timelineClient).getLastPublishedEntities();
        Assert.assertEquals((long)1L, (long)lastPublishedEntities.size());
        entity = lastPublishedEntities.iterator().next();
        Assert.assertEquals((long)2L, (long)entity.getEvents().size());
        Assert.assertEquals((Object)ContainerState.READY.toString(), entity.getInfo().get("STATE"));
    }

    private void verifyServiceAttemptTimelineEntity(TimelineEntity timelineEntity, String message, boolean isRegistedEntity) {
        Assert.assertEquals((Object)SERVICEID, (Object)timelineEntity.getId());
        Assert.assertEquals((Object)SERVICE_NAME, timelineEntity.getInfo().get("NAME"));
        if (isRegistedEntity) {
            Assert.assertEquals((Object)ServiceState.STARTED.toString(), timelineEntity.getInfo().get("STATE"));
            Assert.assertEquals((Object)ServiceTimelineEvent.SERVICE_ATTEMPT_REGISTERED.toString(), (Object)((TimelineEvent)timelineEntity.getEvents().iterator().next()).getId());
        } else {
            Assert.assertEquals((Object)"ENDED", (Object)timelineEntity.getInfo().get("STATE").toString());
            Assert.assertEquals((Object)message, timelineEntity.getInfo().get("DIAGNOSTICS_INFO"));
            Assert.assertEquals((long)2L, (long)timelineEntity.getEvents().size());
            Assert.assertEquals((Object)ServiceTimelineEvent.SERVICE_ATTEMPT_UNREGISTERED.toString(), (Object)((TimelineEvent)timelineEntity.getEvents().iterator().next()).getId());
        }
    }

    private void verifyComponentTimelineEntity(TimelineEntity entity) {
        Map info = entity.getInfo();
        Assert.assertEquals((Object)"DEFAULT", (Object)entity.getId());
        Assert.assertEquals((Object)ARTIFACTID, info.get("ARTIFACT_ID"));
        Assert.assertEquals((Object)"DOCKER", info.get("ARTIFACT_TYPE"));
        Assert.assertEquals((Object)"medium", info.get("RESOURCE_PROFILE"));
        Assert.assertEquals((Object)1, info.get("RESOURCE_CPU"));
        Assert.assertEquals((Object)"1024", info.get("RESOURCE_MEMORY"));
        Assert.assertEquals((Object)"sleep 1", info.get("LAUNCH_COMMAND"));
        Assert.assertEquals((Object)"false", info.get("RUN_PRIVILEGED_CONTAINER"));
    }

    private static Service createMockApplication() {
        Service service = (Service)Mockito.mock(Service.class);
        Mockito.when((Object)service.getId()).thenReturn((Object)SERVICEID);
        Mockito.when((Object)service.getLaunchTime()).thenReturn((Object)new Date());
        Mockito.when((Object)service.getState()).thenReturn((Object)ServiceState.STARTED);
        Mockito.when((Object)service.getName()).thenReturn((Object)SERVICE_NAME);
        Mockito.when((Object)service.getConfiguration()).thenReturn((Object)new Configuration());
        Component component = (Component)Mockito.mock(Component.class);
        Artifact artifact = new Artifact();
        artifact.setId(ARTIFACTID);
        Resource resource = new Resource();
        resource.setCpus(Integer.valueOf(1));
        resource.setMemory("1024");
        resource.setProfile("medium");
        Mockito.when((Object)component.getArtifact()).thenReturn((Object)artifact);
        Mockito.when((Object)component.getName()).thenReturn((Object)COMPONENT_NAME);
        Mockito.when((Object)component.getResource()).thenReturn((Object)resource);
        Mockito.when((Object)component.getLaunchCommand()).thenReturn((Object)"sleep 1");
        PlacementPolicy placementPolicy = new PlacementPolicy();
        PlacementConstraint placementConstraint = new PlacementConstraint();
        placementConstraint.setType(PlacementType.ANTI_AFFINITY);
        placementPolicy.setConstraints(Collections.singletonList(placementConstraint));
        Mockito.when((Object)component.getPlacementPolicy()).thenReturn((Object)placementPolicy);
        Mockito.when((Object)component.getConfiguration()).thenReturn((Object)new Configuration());
        ArrayList<Component> components = new ArrayList<Component>();
        components.add(component);
        Mockito.when((Object)service.getComponents()).thenReturn(components);
        return service;
    }

    protected static class DummyTimelineClient
    extends TimelineV2ClientImpl {
        private Map<TimelineEntity.Identifier, TimelineEntity> lastPublishedEntities = new HashMap<TimelineEntity.Identifier, TimelineEntity>();

        public DummyTimelineClient(ApplicationId appId) {
            super(appId);
        }

        public void putEntitiesAsync(TimelineEntity ... entities) throws IOException, YarnException {
            this.putEntities(entities);
        }

        public void putEntities(TimelineEntity ... entities) throws IOException, YarnException {
            for (TimelineEntity timelineEntity : entities) {
                TimelineEntity entity = this.lastPublishedEntities.get(timelineEntity.getIdentifier());
                if (entity == null) {
                    this.lastPublishedEntities.put(timelineEntity.getIdentifier(), timelineEntity);
                    continue;
                }
                entity.addMetrics(timelineEntity.getMetrics());
                entity.addEvents((Set)timelineEntity.getEvents());
                entity.addInfo(timelineEntity.getInfo());
                entity.addConfigs(timelineEntity.getConfigs());
                entity.addRelatesToEntities(timelineEntity.getRelatesToEntities());
                entity.addIsRelatedToEntities(timelineEntity.getIsRelatedToEntities());
            }
        }

        public Collection<TimelineEntity> getLastPublishedEntities() {
            return this.lastPublishedEntities.values();
        }

        public void reset() {
            this.lastPublishedEntities = null;
        }
    }
}

