/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.providers;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.service.api.records.Artifact;
import org.apache.hadoop.yarn.service.api.records.ConfigFile;
import org.apache.hadoop.yarn.service.provider.AbstractClientProvider;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestAbstractClientProvider {
    private static final String EXCEPTION_PREFIX = "Should have thrown exception: ";
    private static final String NO_EXCEPTION_PREFIX = "Should not have thrown exception: ";

    @Test
    public void testConfigFiles() throws IOException {
        ClientProvider clientProvider = new ClientProvider();
        FileSystem mockFs = (FileSystem)Mockito.mock(FileSystem.class);
        FileStatus mockFileStatus = (FileStatus)Mockito.mock(FileStatus.class);
        Mockito.when((Object)mockFs.exists((Path)ArgumentMatchers.any())).thenReturn((Object)true);
        String compName = "sleeper";
        ConfigFile configFile = new ConfigFile();
        ArrayList<ConfigFile> configFiles = new ArrayList<ConfigFile>();
        configFiles.add(configFile);
        try {
            clientProvider.validateConfigFiles(configFiles, compName, mockFs);
            Assert.fail((String)"Should have thrown exception: null file type");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        configFile.setType(ConfigFile.TypeEnum.TEMPLATE);
        try {
            clientProvider.validateConfigFiles(configFiles, compName, mockFs);
            Assert.fail((String)"Should have thrown exception: empty src_file for type template");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        configFile.setSrcFile("srcfile");
        try {
            clientProvider.validateConfigFiles(configFiles, compName, mockFs);
            Assert.fail((String)"Should have thrown exception: empty dest file");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        configFile.setDestFile("destfile");
        try {
            clientProvider.validateConfigFiles(configFiles, compName, mockFs);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)(NO_EXCEPTION_PREFIX + e.getMessage()));
        }
        configFile = new ConfigFile();
        configFile.setType(ConfigFile.TypeEnum.JSON);
        configFile.setSrcFile(null);
        configFile.setDestFile("path/destfile2");
        configFiles.add(configFile);
        try {
            clientProvider.validateConfigFiles(configFiles, compName, mockFs);
            Assert.fail((String)"Should have thrown exception: dest file with multiple path elements");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        configFile.setDestFile("/path/destfile2");
        try {
            clientProvider.validateConfigFiles(configFiles, compName, mockFs);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)(NO_EXCEPTION_PREFIX + e.getMessage()));
        }
        configFile.setDestFile("destfile");
        try {
            clientProvider.validateConfigFiles(configFiles, compName, mockFs);
            Assert.fail((String)"Should have thrown exception: duplicate dest file");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        configFiles.clear();
        configFile = new ConfigFile();
        configFile.setType(ConfigFile.TypeEnum.STATIC);
        configFile.setSrcFile(null);
        configFile.setDestFile("path/destfile3");
        configFiles.add(configFile);
        try {
            clientProvider.validateConfigFiles(configFiles, compName, mockFs);
            Assert.fail((String)"Should have thrown exception: dest file with multiple path elements");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        configFile.setDestFile("/path/destfile3");
        try {
            clientProvider.validateConfigFiles(configFiles, compName, mockFs);
            Assert.fail((String)"Should have thrown exception: src file should be specified");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        configFile.setSrcFile("srcFile");
        configFile.setDestFile("destfile3");
        clientProvider.validateConfigFiles(configFiles, compName, mockFs);
        Mockito.when((Object)mockFileStatus.isDirectory()).thenReturn((Object)true);
        Mockito.when((Object)mockFs.getFileStatus(new Path("srcFile"))).thenReturn((Object)mockFileStatus).thenReturn((Object)mockFileStatus);
        configFiles.clear();
        configFile = new ConfigFile();
        configFile.setType(ConfigFile.TypeEnum.STATIC);
        configFile.setSrcFile("srcFile");
        configFile.setDestFile("destfile3");
        configFiles.add(configFile);
        try {
            clientProvider.validateConfigFiles(configFiles, compName, mockFs);
            Assert.fail((String)"Should have thrown exception: src file is a directory");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static class ClientProvider
    extends AbstractClientProvider {
        private ClientProvider() {
        }

        public void validateArtifact(Artifact artifact, String compName, FileSystem fileSystem) throws IOException {
        }

        protected void validateConfigFile(ConfigFile configFile, String compName, FileSystem fileSystem) throws IOException {
        }
    }
}

