/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.component;

import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.service.component.AlwaysRestartPolicy;
import org.apache.hadoop.yarn.service.component.Component;
import org.apache.hadoop.yarn.service.component.NeverRestartPolicy;
import org.apache.hadoop.yarn.service.component.OnFailureRestartPolicy;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestComponentRestartPolicy {
    @Test
    public void testAlwaysRestartPolicy() throws Exception {
        AlwaysRestartPolicy alwaysRestartPolicy = AlwaysRestartPolicy.getInstance();
        Component component = (Component)Mockito.mock(Component.class);
        Mockito.when((Object)component.getNumReadyInstances()).thenReturn((Object)1);
        Mockito.when((Object)component.getNumDesiredInstances()).thenReturn((Object)2);
        ComponentInstance instance = (ComponentInstance)Mockito.mock(ComponentInstance.class);
        Mockito.when((Object)instance.getComponent()).thenReturn((Object)component);
        ContainerStatus containerStatus = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        Assert.assertEquals((Object)true, (Object)alwaysRestartPolicy.isLongLived());
        Assert.assertEquals((Object)true, (Object)alwaysRestartPolicy.allowUpgrades());
        Assert.assertEquals((Object)false, (Object)alwaysRestartPolicy.hasCompleted(component));
        Assert.assertEquals((Object)false, (Object)alwaysRestartPolicy.hasCompletedSuccessfully(component));
        Assert.assertEquals((Object)true, (Object)alwaysRestartPolicy.shouldRelaunchInstance(instance, containerStatus));
        Assert.assertEquals((Object)false, (Object)alwaysRestartPolicy.isReadyForDownStream(component));
    }

    @Test
    public void testNeverRestartPolicy() throws Exception {
        NeverRestartPolicy restartPolicy = NeverRestartPolicy.getInstance();
        Component component = (Component)Mockito.mock(Component.class);
        Mockito.when((Object)component.getNumSucceededInstances()).thenReturn((Object)new Long(1L));
        Mockito.when((Object)component.getNumFailedInstances()).thenReturn((Object)new Long(2L));
        Mockito.when((Object)component.getNumDesiredInstances()).thenReturn((Object)3);
        Mockito.when((Object)component.getNumReadyInstances()).thenReturn((Object)3);
        ComponentInstance instance = (ComponentInstance)Mockito.mock(ComponentInstance.class);
        Mockito.when((Object)instance.getComponent()).thenReturn((Object)component);
        ContainerStatus containerStatus = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        Assert.assertEquals((Object)false, (Object)restartPolicy.isLongLived());
        Assert.assertEquals((Object)false, (Object)restartPolicy.allowUpgrades());
        Assert.assertEquals((Object)true, (Object)restartPolicy.hasCompleted(component));
        Assert.assertEquals((Object)false, (Object)restartPolicy.hasCompletedSuccessfully(component));
        Assert.assertEquals((Object)false, (Object)restartPolicy.shouldRelaunchInstance(instance, containerStatus));
        Assert.assertEquals((Object)true, (Object)restartPolicy.isReadyForDownStream(component));
    }

    @Test
    public void testOnFailureRestartPolicy() throws Exception {
        OnFailureRestartPolicy restartPolicy = OnFailureRestartPolicy.getInstance();
        Component component = (Component)Mockito.mock(Component.class);
        Mockito.when((Object)component.getNumSucceededInstances()).thenReturn((Object)new Long(3L));
        Mockito.when((Object)component.getNumFailedInstances()).thenReturn((Object)new Long(0L));
        Mockito.when((Object)component.getNumDesiredInstances()).thenReturn((Object)3);
        Mockito.when((Object)component.getNumReadyInstances()).thenReturn((Object)3);
        ComponentInstance instance = (ComponentInstance)Mockito.mock(ComponentInstance.class);
        Mockito.when((Object)instance.getComponent()).thenReturn((Object)component);
        ContainerStatus containerStatus = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        Mockito.when((Object)containerStatus.getExitStatus()).thenReturn((Object)0);
        Assert.assertEquals((Object)false, (Object)restartPolicy.isLongLived());
        Assert.assertEquals((Object)false, (Object)restartPolicy.allowUpgrades());
        Assert.assertEquals((Object)true, (Object)restartPolicy.hasCompleted(component));
        Assert.assertEquals((Object)true, (Object)restartPolicy.hasCompletedSuccessfully(component));
        Assert.assertEquals((Object)false, (Object)restartPolicy.shouldRelaunchInstance(instance, containerStatus));
        Assert.assertEquals((Object)true, (Object)restartPolicy.isReadyForDownStream(component));
        Mockito.when((Object)component.getNumSucceededInstances()).thenReturn((Object)new Long(2L));
        Mockito.when((Object)component.getNumFailedInstances()).thenReturn((Object)new Long(1L));
        Mockito.when((Object)component.getNumDesiredInstances()).thenReturn((Object)3);
        Assert.assertEquals((Object)false, (Object)restartPolicy.hasCompleted(component));
        Assert.assertEquals((Object)false, (Object)restartPolicy.hasCompletedSuccessfully(component));
        Mockito.when((Object)containerStatus.getExitStatus()).thenReturn((Object)-1000);
        Assert.assertEquals((Object)true, (Object)restartPolicy.shouldRelaunchInstance(instance, containerStatus));
        Assert.assertEquals((Object)true, (Object)restartPolicy.isReadyForDownStream(component));
    }
}

