/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.proto.ClientAMProtocol;
import org.apache.hadoop.yarn.service.ClientAMProtocol;
import org.apache.hadoop.yarn.service.MockRunningServiceContext;
import org.apache.hadoop.yarn.service.ServiceContext;
import org.apache.hadoop.yarn.service.ServiceTestUtils;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.ComponentContainers;
import org.apache.hadoop.yarn.service.api.records.Container;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.api.records.ServiceState;
import org.apache.hadoop.yarn.service.client.ServiceClient;
import org.apache.hadoop.yarn.service.utils.FilterUtils;
import org.apache.hadoop.yarn.service.utils.ServiceApiUtil;
import org.apache.hadoop.yarn.service.utils.SliderFileSystem;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestServiceClient {
    private static final Logger LOG = LoggerFactory.getLogger(TestServiceClient.class);
    @Rule
    public ServiceTestUtils.ServiceFSWatcher rule = new ServiceTestUtils.ServiceFSWatcher();

    @Test
    public void testAMEnvCustomClasspath() throws Exception {
        Service service = this.createService();
        service.getComponents().forEach(comp -> comp.setRestartPolicy(Component.RestartPolicyEnum.NEVER));
        MockServiceClient client = MockServiceClient.create(this.rule, service, true);
        String oldParam = client.getConfig().get("yarn.service.classpath", "");
        String originalPath = (String)client.addAMEnv().get("CLASSPATH");
        client.getConfig().set("yarn.service.classpath", "{{VAR_1}},{{VAR_2}}");
        String newPath = (String)client.addAMEnv().get("CLASSPATH");
        Assert.assertEquals((Object)(originalPath + "<CPS>{{VAR_1}}<CPS>{{VAR_2}}"), (Object)newPath);
        client.getConfig().set("yarn.service.classpath", oldParam);
        newPath = (String)client.addAMEnv().get("CLASSPATH");
        Assert.assertEquals((Object)originalPath, (Object)newPath);
        client.stop();
    }

    @Test
    public void testUpgradeDisabledByDefault() throws Exception {
        Service service = this.createService();
        MockServiceClient client = MockServiceClient.create(this.rule, service, false);
        service.setVersion("v2");
        try {
            client.initiateUpgrade(service);
        }
        catch (YarnException ex) {
            Assert.assertEquals((Object)"Service upgrade is disabled.", (Object)ex.getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testActionServiceUpgrade() throws Exception {
        Service service = this.createService();
        MockServiceClient client = MockServiceClient.create(this.rule, service, true);
        service.setVersion("v2");
        client.initiateUpgrade(service);
        Service fromFs = ServiceApiUtil.loadServiceUpgrade((SliderFileSystem)this.rule.getFs(), (String)service.getName(), (String)service.getVersion());
        Assert.assertEquals((Object)service.getName(), (Object)fromFs.getName());
        Assert.assertEquals((Object)service.getVersion(), (Object)fromFs.getVersion());
        client.stop();
    }

    @Test
    public void testActionCompInstanceUpgrade() throws Exception {
        Service service = this.createService();
        MockServiceClient client = MockServiceClient.create(this.rule, service, true);
        service.setVersion("v2");
        client.initiateUpgrade(service);
        Component comp = (Component)service.getComponents().iterator().next();
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)client.attemptId, (long)1L);
        comp.addContainer(new Container().id(containerId.toString()));
        client.actionUpgrade(service, comp.getContainers());
        ClientAMProtocol.CompInstancesUpgradeResponseProto response = client.getLastProxyResponse(ClientAMProtocol.CompInstancesUpgradeResponseProto.class);
        Assert.assertNotNull((String)"upgrade did not complete", (Object)response);
        client.stop();
    }

    @Test
    public void testGetCompInstances() throws Exception {
        Service service = this.createService();
        MockServiceClient client = MockServiceClient.create(this.rule, service, true);
        service.setVersion("v2");
        client.initiateUpgrade(service);
        Component comp = (Component)service.getComponents().iterator().next();
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)client.attemptId, (long)1L);
        comp.addContainer(new Container().id(containerId.toString()));
        ComponentContainers[] compContainers = client.getContainers(service.getName(), Lists.newArrayList((Object[])new String[]{"compa"}), "v1", null);
        Assert.assertEquals((String)"num comp", (long)1L, (long)compContainers.length);
        Assert.assertEquals((String)"comp name", (Object)"compa", (Object)compContainers[0].getComponentName());
        Assert.assertEquals((String)"num containers", (long)2L, (long)compContainers[0].getContainers().size());
        client.stop();
    }

    @Test
    public void testUpgradeDisabledWhenAllCompsHaveNeverRestartPolicy() throws Exception {
        Service service = this.createService();
        service.getComponents().forEach(comp -> comp.setRestartPolicy(Component.RestartPolicyEnum.NEVER));
        MockServiceClient client = MockServiceClient.create(this.rule, service, true);
        service.setVersion("v2");
        try {
            client.initiateUpgrade(service);
        }
        catch (YarnException ex) {
            Assert.assertEquals((Object)("All the components of the service " + service.getName() + " have " + Component.RestartPolicyEnum.NEVER + " restart policy, so it cannot be upgraded."), (Object)ex.getMessage());
            return;
        }
        Assert.fail();
    }

    private Service createService() throws IOException, YarnException {
        Service service = ServiceTestUtils.createExampleApplication();
        service.setVersion("v1");
        service.setState(ServiceState.UPGRADING);
        return service;
    }

    private static YarnClient createMockYarnClient() throws IOException, YarnException {
        YarnClient yarnClient = (YarnClient)Mockito.mock(YarnClient.class);
        Mockito.when((Object)yarnClient.getApplications((GetApplicationsRequest)ArgumentMatchers.any(GetApplicationsRequest.class))).thenReturn(new ArrayList());
        return yarnClient;
    }

    private static final class MockServiceClient
    extends ServiceClient {
        private final ApplicationId appId;
        private final ApplicationAttemptId attemptId;
        private final ClientAMProtocol amProxy = (ClientAMProtocol)Mockito.mock(ClientAMProtocol.class);
        private Object proxyResponse;
        private Service service;
        private ServiceContext context;

        private MockServiceClient() {
            this.appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
            LOG.debug("mocking service client for {}", (Object)this.appId);
            this.attemptId = ApplicationAttemptId.newInstance((ApplicationId)this.appId, (int)1);
        }

        static MockServiceClient create(ServiceTestUtils.ServiceFSWatcher rule, Service service, boolean enableUpgrade) throws Exception {
            MockServiceClient client = new MockServiceClient();
            ApplicationId applicationId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
            service.setId(applicationId.toString());
            client.context = new MockRunningServiceContext(rule, service);
            YarnClient yarnClient = TestServiceClient.createMockYarnClient();
            ApplicationReport appReport = (ApplicationReport)Mockito.mock(ApplicationReport.class);
            Mockito.when((Object)appReport.getHost()).thenReturn((Object)"localhost");
            Mockito.when((Object)appReport.getYarnApplicationState()).thenReturn((Object)YarnApplicationState.RUNNING);
            ApplicationAttemptReport attemptReport = ApplicationAttemptReport.newInstance((ApplicationAttemptId)client.attemptId, (String)"localhost", (int)0, null, null, null, (YarnApplicationAttemptState)YarnApplicationAttemptState.RUNNING, null);
            Mockito.when((Object)yarnClient.getApplicationAttemptReport((ApplicationAttemptId)ArgumentMatchers.any())).thenReturn((Object)attemptReport);
            Mockito.when((Object)yarnClient.getApplicationReport(client.appId)).thenReturn((Object)appReport);
            Mockito.when((Object)client.amProxy.upgrade((ClientAMProtocol.UpgradeServiceRequestProto)ArgumentMatchers.any(ClientAMProtocol.UpgradeServiceRequestProto.class))).thenAnswer(invocation -> {
                ClientAMProtocol.UpgradeServiceResponseProto response = ClientAMProtocol.UpgradeServiceResponseProto.newBuilder().build();
                client.proxyResponse = response;
                return response;
            });
            Mockito.when((Object)client.amProxy.upgrade((ClientAMProtocol.CompInstancesUpgradeRequestProto)ArgumentMatchers.any(ClientAMProtocol.CompInstancesUpgradeRequestProto.class))).thenAnswer(invocation -> {
                ClientAMProtocol.CompInstancesUpgradeResponseProto response = ClientAMProtocol.CompInstancesUpgradeResponseProto.newBuilder().build();
                client.proxyResponse = response;
                return response;
            });
            Mockito.when((Object)client.amProxy.getCompInstances((ClientAMProtocol.GetCompInstancesRequestProto)ArgumentMatchers.any(ClientAMProtocol.GetCompInstancesRequestProto.class))).thenAnswer(invocation -> {
                ClientAMProtocol.GetCompInstancesRequestProto req = (ClientAMProtocol.GetCompInstancesRequestProto)invocation.getArguments()[0];
                List compContainers = FilterUtils.filterInstances((ServiceContext)client.context, (ClientAMProtocol.GetCompInstancesRequestProto)req);
                ClientAMProtocol.GetCompInstancesResponseProto response = ClientAMProtocol.GetCompInstancesResponseProto.newBuilder().setCompInstances(ServiceApiUtil.COMP_CONTAINERS_JSON_SERDE.toJson((Object)compContainers.toArray(new ComponentContainers[compContainers.size()]))).build();
                client.proxyResponse = response;
                return response;
            });
            client.setFileSystem(rule.getFs());
            client.setYarnClient(yarnClient);
            client.service = service;
            rule.getConf().setBoolean("yarn.service.upgrade.enabled", enableUpgrade);
            client.init((Configuration)rule.getConf());
            client.start();
            client.actionCreate(service);
            return client;
        }

        protected void serviceInit(Configuration configuration) throws Exception {
        }

        protected ClientAMProtocol createAMProxy(String serviceName, ApplicationReport appReport) throws IOException, YarnException {
            return this.amProxy;
        }

        ApplicationId submitApp(Service app) throws IOException, YarnException {
            return this.appId;
        }

        public Service getStatus(String serviceName) throws IOException, YarnException {
            this.service.setState(ServiceState.STABLE);
            return this.service;
        }

        private <T> T getLastProxyResponse(Class<T> clazz) {
            if (clazz.isInstance(this.proxyResponse)) {
                return clazz.cast(this.proxyResponse);
            }
            return null;
        }
    }
}

