/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.client;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.client.api.AppAdminClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.conf.ExampleAppJson;
import org.apache.hadoop.yarn.service.utils.ServiceApiUtil;
import org.apache.hadoop.yarn.service.utils.SliderFileSystem;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBuildExternalComponents {
    protected Configuration conf = new YarnConfiguration();
    private File basedir;

    private static void checkComponentNames(List<Component> components, Set<String> expectedComponents) {
        Assert.assertEquals((long)expectedComponents.size(), (long)components.size());
        for (Component comp : components) {
            Assert.assertTrue((boolean)expectedComponents.contains(comp.getName()));
        }
    }

    private void buildAndCheckComponents(String appName, String appDef, SliderFileSystem sfs, Set<String> names) throws Throwable {
        AppAdminClient client = AppAdminClient.createAppAdminClient((String)"unit-test", (Configuration)this.conf);
        client.actionSave(ExampleAppJson.resourceName(appDef), null, null, null);
        List components = ServiceApiUtil.getComponents((SliderFileSystem)sfs, (String)appName);
        TestBuildExternalComponents.checkComponentNames(components, names);
    }

    @Before
    public void setup() throws IOException {
        this.basedir = new File("target", "apps");
        if (this.basedir.exists()) {
            FileUtils.deleteDirectory((File)this.basedir);
        } else {
            this.basedir.mkdirs();
        }
        this.conf.set("yarn.service.base.path", this.basedir.getAbsolutePath());
    }

    @After
    public void tearDown() throws IOException {
        if (this.basedir != null) {
            FileUtils.deleteDirectory((File)this.basedir);
        }
    }

    @Test
    public void testExternalComponentBuild() throws Throwable {
        SliderFileSystem sfs = new SliderFileSystem(this.conf);
        HashSet<String> nameSet = new HashSet<String>();
        nameSet.add("simple");
        nameSet.add("master");
        nameSet.add("worker");
        this.buildAndCheckComponents("app-1", "app.json", sfs, nameSet);
        this.buildAndCheckComponents("external-0", "external0.json", sfs, nameSet);
        nameSet.add("other");
        this.buildAndCheckComponents("external-1", "external1.json", sfs, nameSet);
        nameSet.add("another");
        this.buildAndCheckComponents("external-2", "external2.json", sfs, nameSet);
    }
}

