/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.providers;

import org.apache.hadoop.yarn.service.api.records.Artifact;
import org.apache.hadoop.yarn.service.provider.ProviderFactory;
import org.apache.hadoop.yarn.service.provider.defaultImpl.DefaultClientProvider;
import org.apache.hadoop.yarn.service.provider.defaultImpl.DefaultProviderFactory;
import org.apache.hadoop.yarn.service.provider.defaultImpl.DefaultProviderService;
import org.apache.hadoop.yarn.service.provider.docker.DockerClientProvider;
import org.apache.hadoop.yarn.service.provider.docker.DockerProviderFactory;
import org.apache.hadoop.yarn.service.provider.docker.DockerProviderService;
import org.apache.hadoop.yarn.service.provider.tarball.TarballClientProvider;
import org.apache.hadoop.yarn.service.provider.tarball.TarballProviderFactory;
import org.apache.hadoop.yarn.service.provider.tarball.TarballProviderService;
import org.junit.Assert;
import org.junit.Test;

public class TestProviderFactory {
    @Test
    public void testDockerFactory() throws Throwable {
        ProviderFactory factory = ProviderFactory.createServiceProviderFactory((Artifact)new Artifact().type(Artifact.TypeEnum.DOCKER));
        Assert.assertTrue((boolean)(factory instanceof DockerProviderFactory));
        Assert.assertTrue((boolean)(factory.createClientProvider() instanceof DockerClientProvider));
        Assert.assertTrue((boolean)(factory.createServerProvider() instanceof DockerProviderService));
        Assert.assertTrue((boolean)(ProviderFactory.getProviderService((Artifact)new Artifact().type(Artifact.TypeEnum.DOCKER)) instanceof DockerProviderService));
    }

    @Test
    public void testTarballFactory() throws Throwable {
        ProviderFactory factory = ProviderFactory.createServiceProviderFactory((Artifact)new Artifact().type(Artifact.TypeEnum.TARBALL));
        Assert.assertTrue((boolean)(factory instanceof TarballProviderFactory));
        Assert.assertTrue((boolean)(factory.createClientProvider() instanceof TarballClientProvider));
        Assert.assertTrue((boolean)(factory.createServerProvider() instanceof TarballProviderService));
        Assert.assertTrue((boolean)(ProviderFactory.getProviderService((Artifact)new Artifact().type(Artifact.TypeEnum.TARBALL)) instanceof TarballProviderService));
    }

    @Test
    public void testDefaultFactory() throws Throwable {
        ProviderFactory factory = ProviderFactory.createServiceProviderFactory(null);
        Assert.assertTrue((boolean)(factory instanceof DefaultProviderFactory));
        Assert.assertTrue((boolean)(factory.createClientProvider() instanceof DefaultClientProvider));
        Assert.assertTrue((boolean)(factory.createServerProvider() instanceof DefaultProviderService));
        Assert.assertTrue((boolean)(ProviderFactory.getProviderService(null) instanceof DefaultProviderService));
    }
}

