/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.provider;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.service.api.records.ConfigFile;
import org.apache.hadoop.yarn.service.api.records.Configuration;
import org.apache.hadoop.yarn.service.containerlaunch.AbstractLauncher;
import org.apache.hadoop.yarn.service.containerlaunch.ContainerLaunchService;
import org.apache.hadoop.yarn.service.provider.ProviderService;
import org.apache.hadoop.yarn.service.provider.ProviderUtils;
import org.apache.hadoop.yarn.service.utils.SliderFileSystem;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestProviderUtils {
    @Test
    public void testStaticFileLocalization() throws IOException {
        ContainerLaunchService.ComponentLaunchContext compLaunchCtx = (ContainerLaunchService.ComponentLaunchContext)Mockito.mock(ContainerLaunchService.ComponentLaunchContext.class);
        AbstractLauncher launcher = (AbstractLauncher)Mockito.mock(AbstractLauncher.class);
        SliderFileSystem sfs = (SliderFileSystem)Mockito.mock(SliderFileSystem.class);
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)fs.getFileStatus((Path)ArgumentMatchers.any(Path.class))).thenAnswer(invocationOnMock -> new FileStatus(1L, false, 1, 1L, 1L, (Path)invocationOnMock.getArguments()[0]));
        Mockito.when((Object)fs.exists((Path)ArgumentMatchers.any(Path.class))).thenReturn((Object)true);
        Mockito.when((Object)sfs.getFileSystem()).thenReturn((Object)fs);
        Configuration conf = (Configuration)Mockito.mock(Configuration.class);
        ArrayList<ConfigFile> configFileList = new ArrayList<ConfigFile>();
        Mockito.when((Object)conf.getFiles()).thenReturn(configFileList);
        Mockito.when((Object)compLaunchCtx.getConfiguration()).thenReturn((Object)conf);
        Mockito.when((Object)sfs.createAmResource((Path)ArgumentMatchers.any(Path.class), (LocalResourceType)ArgumentMatchers.any(LocalResourceType.class), (LocalResourceVisibility)ArgumentMatchers.any(LocalResourceVisibility.class))).thenAnswer(invocationOnMock -> new LocalResource(){

            public URL getResource() {
                return URL.fromPath((Path)((Path)invocationOnMock.getArguments()[0]));
            }

            public void setResource(URL resource) {
            }

            public long getSize() {
                return 0L;
            }

            public void setSize(long size) {
            }

            public long getTimestamp() {
                return 0L;
            }

            public void setTimestamp(long timestamp) {
            }

            public LocalResourceType getType() {
                return (LocalResourceType)invocationOnMock.getArguments()[1];
            }

            public void setType(LocalResourceType type) {
            }

            public LocalResourceVisibility getVisibility() {
                return LocalResourceVisibility.APPLICATION;
            }

            public void setVisibility(LocalResourceVisibility visibility) {
            }

            public String getPattern() {
                return null;
            }

            public void setPattern(String pattern) {
            }

            public boolean getShouldBeUploadedToSharedCache() {
                return false;
            }

            public void setShouldBeUploadedToSharedCache(boolean shouldBeUploadedToSharedCache) {
            }
        });
        configFileList.add(new ConfigFile().srcFile("hdfs://default/sourceFile1").destFile("destFile1").type(ConfigFile.TypeEnum.ARCHIVE).visibility(LocalResourceVisibility.APPLICATION));
        configFileList.add(new ConfigFile().srcFile("hdfs://default/sourceFile2").destFile("folder/destFile_2").type(ConfigFile.TypeEnum.STATIC).visibility(LocalResourceVisibility.APPLICATION));
        configFileList.add(new ConfigFile().srcFile("hdfs://default/sourceFile3").destFile("destFile3").type(ConfigFile.TypeEnum.JSON).visibility(LocalResourceVisibility.APPLICATION));
        configFileList.add(new ConfigFile().srcFile("hdfs://default/sourceFile4").type(ConfigFile.TypeEnum.STATIC).visibility(LocalResourceVisibility.APPLICATION));
        ProviderService.ResolvedLaunchParams resolved = new ProviderService.ResolvedLaunchParams();
        ProviderUtils.handleStaticFilesForLocalization((AbstractLauncher)launcher, (SliderFileSystem)sfs, (ContainerLaunchService.ComponentLaunchContext)compLaunchCtx, (ProviderService.ResolvedLaunchParams)resolved);
        ((AbstractLauncher)Mockito.verify((Object)launcher)).addLocalResource((String)Mockito.eq((Object)"destFile1"), (LocalResource)ArgumentMatchers.any(LocalResource.class));
        ((AbstractLauncher)Mockito.verify((Object)launcher)).addLocalResource((String)Mockito.eq((Object)"destFile_2"), (LocalResource)ArgumentMatchers.any(LocalResource.class));
        ((AbstractLauncher)Mockito.verify((Object)launcher)).addLocalResource((String)Mockito.eq((Object)"sourceFile4"), (LocalResource)ArgumentMatchers.any(LocalResource.class));
        Assert.assertEquals((long)3L, (long)resolved.getResolvedRsrcPaths().size());
        Assert.assertEquals(resolved.getResolvedRsrcPaths().get("destFile1"), (Object)"destFile1");
    }

    @Test
    public void testReplaceSpacesWithDelimiter() {
        String command = "ls  -l \" space\"";
        String expected = "ls,-l, space";
        String actual = ProviderUtils.replaceSpacesWithDelimiter((String)command, (String)",");
        Assert.assertEquals((String)"replaceSpaceWithDelimiter produces unexpected result.", (Object)expected, (Object)actual);
    }
}

