/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.monitor.probe;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.service.api.records.ReadinessCheck;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;
import org.apache.hadoop.yarn.service.monitor.probe.DefaultProbe;
import org.apache.hadoop.yarn.service.monitor.probe.MonitorUtils;
import org.apache.hadoop.yarn.service.monitor.probe.Probe;
import org.apache.hadoop.yarn.service.monitor.probe.ProbeStatus;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@RunWith(value=Parameterized.class)
public class TestDefaultProbe {
    private final DefaultProbe probe;

    public TestDefaultProbe(Probe probe) {
        this.probe = (DefaultProbe)probe;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Probe p1 = MonitorUtils.getProbe(null);
        ReadinessCheck rc2 = new ReadinessCheck().type(ReadinessCheck.TypeEnum.DEFAULT).properties(Collections.singletonMap("dns.check.enabled", "true"));
        Probe p2 = MonitorUtils.getProbe((ReadinessCheck)rc2);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("dns.check.enabled", "true");
        props.put("dns.address", "8.8.8.8");
        ReadinessCheck rc3 = new ReadinessCheck().type(ReadinessCheck.TypeEnum.DEFAULT).properties(props);
        Probe p3 = MonitorUtils.getProbe((ReadinessCheck)rc3);
        return Arrays.asList({p1}, {p2}, {p3});
    }

    @Test
    public void testDefaultProbe() {
        ComponentInstance componentInstance = TestDefaultProbe.createMockComponentInstance("example.com");
        TestDefaultProbe.checkPingResults((Probe)this.probe, componentInstance, false);
        componentInstance = TestDefaultProbe.createMockComponentInstance("bad.dns.test");
        TestDefaultProbe.checkPingResults((Probe)this.probe, componentInstance, this.probe.isDnsCheckEnabled());
    }

    private static void checkPingResults(Probe probe, ComponentInstance componentInstance, boolean expectDNSCheckFailure) {
        ProbeStatus probeStatus = probe.ping(componentInstance);
        Assert.assertFalse((String)("Expected failure for " + probeStatus.toString()), (boolean)probeStatus.isSuccess());
        Assert.assertTrue((String)("Expected IP failure for " + probeStatus.toString()), (boolean)probeStatus.toString().contains(componentInstance.getCompInstanceName() + ": IP is not available yet"));
        probeStatus = probe.ping(componentInstance);
        Assert.assertFalse((String)("Expected failure for " + probeStatus.toString()), (boolean)probeStatus.isSuccess());
        Assert.assertTrue((String)("Expected IP failure for " + probeStatus.toString()), (boolean)probeStatus.toString().contains(componentInstance.getCompInstanceName() + ": IP is not available yet"));
        probeStatus = probe.ping(componentInstance);
        if (expectDNSCheckFailure) {
            Assert.assertFalse((String)("Expected failure for " + probeStatus.toString()), (boolean)probeStatus.isSuccess());
            Assert.assertTrue((String)("Expected DNS failure for " + probeStatus.toString()), (boolean)probeStatus.toString().contains(componentInstance.getCompInstanceName() + ": DNS checking is enabled, but lookup for " + componentInstance.getHostname() + " is not available yet"));
        } else {
            Assert.assertTrue((String)("Expected success for " + probeStatus.toString()), (boolean)probeStatus.isSuccess());
        }
    }

    private static ComponentInstance createMockComponentInstance(String hostname) {
        ComponentInstance componentInstance = (ComponentInstance)Mockito.mock(ComponentInstance.class);
        Mockito.when((Object)componentInstance.getHostname()).thenReturn((Object)hostname);
        Mockito.when((Object)componentInstance.getCompInstanceName()).thenReturn((Object)"comp-0");
        Mockito.when((Object)componentInstance.getContainerStatus()).thenAnswer((Answer)new Answer<ContainerStatus>(){
            private int count = 0;

            public ContainerStatus answer(InvocationOnMock invocationOnMock) {
                ++this.count;
                if (this.count == 1) {
                    return null;
                }
                if (this.count == 2) {
                    ContainerStatus containerStatus = (ContainerStatus)Mockito.mock(ContainerStatus.class);
                    Mockito.when((Object)containerStatus.getIPs()).thenReturn(null);
                    return containerStatus;
                }
                ContainerStatus containerStatus = (ContainerStatus)Mockito.mock(ContainerStatus.class);
                Mockito.when((Object)containerStatus.getIPs()).thenReturn(Collections.singletonList("1.2.3.4"));
                return containerStatus;
            }
        });
        return componentInstance;
    }
}

