/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.conf;

import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.service.ServiceTestUtils;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.conf.ExampleAppJson;
import org.apache.hadoop.yarn.service.utils.ServiceApiUtil;
import org.apache.hadoop.yarn.service.utils.SliderFileSystem;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestLoadExampleAppJson
extends Assert {
    private String resource;

    public TestLoadExampleAppJson(String resource) {
        this.resource = resource;
    }

    @Parameterized.Parameters
    public static Collection<String[]> filenames() {
        String[][] stringArray = new String[ExampleAppJson.ALL_EXAMPLE_RESOURCES.size()][1];
        int i = 0;
        for (String s : ExampleAppJson.ALL_EXAMPLE_RESOURCES) {
            stringArray[i++][0] = s;
        }
        return Arrays.asList(stringArray);
    }

    @Test
    public void testLoadResource() throws Throwable {
        try {
            Service service = (Service)ServiceTestUtils.JSON_SER_DESER.fromResource(this.resource);
            SliderFileSystem sfs = ServiceTestUtils.initMockFs();
            ServiceApiUtil.validateAndResolveService((Service)service, (SliderFileSystem)sfs, (Configuration)new YarnConfiguration());
        }
        catch (Exception e) {
            throw new Exception("exception loading " + this.resource + ":" + e.toString());
        }
    }
}

