/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.conf;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.service.ServiceTestUtils;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.ConfigFile;
import org.apache.hadoop.yarn.service.api.records.Configuration;
import org.apache.hadoop.yarn.service.api.records.Resource;
import org.apache.hadoop.yarn.service.api.records.ResourceInformation;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.conf.ExampleAppJson;
import org.apache.hadoop.yarn.service.utils.ServiceApiUtil;
import org.apache.hadoop.yarn.service.utils.SliderFileSystem;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAppJsonResolve
extends Assert {
    protected static final Logger LOG = LoggerFactory.getLogger(TestAppJsonResolve.class);

    @Test
    public void testOverride() throws Throwable {
        Service orig = ExampleAppJson.loadResource("app-override.json");
        Configuration global = orig.getConfiguration();
        TestAppJsonResolve.assertEquals((Object)"a", (Object)global.getProperty("g1"));
        TestAppJsonResolve.assertEquals((Object)"b", (Object)global.getProperty("g2"));
        TestAppJsonResolve.assertEquals((long)2L, (long)global.getFiles().size());
        Configuration simple = orig.getComponent("simple").getConfiguration();
        TestAppJsonResolve.assertEquals((long)0L, (long)simple.getProperties().size());
        TestAppJsonResolve.assertEquals((long)1L, (long)simple.getFiles().size());
        Configuration master = orig.getComponent("master").getConfiguration();
        TestAppJsonResolve.assertEquals((Object)"m", (Object)master.getProperty("name"));
        TestAppJsonResolve.assertEquals((Object)"overridden", (Object)master.getProperty("g1"));
        TestAppJsonResolve.assertEquals((long)0L, (long)master.getFiles().size());
        Configuration worker = orig.getComponent("worker").getConfiguration();
        LOG.info("worker = {}", (Object)worker);
        TestAppJsonResolve.assertEquals((long)3L, (long)worker.getProperties().size());
        TestAppJsonResolve.assertEquals((long)0L, (long)worker.getFiles().size());
        TestAppJsonResolve.assertEquals((Object)"worker", (Object)worker.getProperty("name"));
        TestAppJsonResolve.assertEquals((Object)"overridden-by-worker", (Object)worker.getProperty("g1"));
        TestAppJsonResolve.assertNull((Object)worker.getProperty("g2"));
        TestAppJsonResolve.assertEquals((Object)"1000", (Object)worker.getProperty("timeout"));
        SliderFileSystem sfs = ServiceTestUtils.initMockFs();
        ServiceApiUtil.validateAndResolveService((Service)orig, (SliderFileSystem)sfs, (org.apache.hadoop.conf.Configuration)new YarnConfiguration());
        global = orig.getConfiguration();
        LOG.info("global = {}", (Object)global);
        TestAppJsonResolve.assertEquals((Object)"a", (Object)global.getProperty("g1"));
        TestAppJsonResolve.assertEquals((Object)"b", (Object)global.getProperty("g2"));
        TestAppJsonResolve.assertEquals((long)2L, (long)global.getFiles().size());
        simple = orig.getComponent("simple").getConfiguration();
        TestAppJsonResolve.assertEquals((long)2L, (long)simple.getProperties().size());
        TestAppJsonResolve.assertEquals((Object)"a", (Object)simple.getProperty("g1"));
        TestAppJsonResolve.assertEquals((Object)"b", (Object)simple.getProperty("g2"));
        TestAppJsonResolve.assertEquals((long)2L, (long)simple.getFiles().size());
        HashSet<ConfigFile> files = new HashSet<ConfigFile>();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("k1", "overridden");
        props.put("k2", "v2");
        files.add(new ConfigFile().destFile("file1").type(ConfigFile.TypeEnum.PROPERTIES).properties(props));
        files.add(new ConfigFile().destFile("file2").type(ConfigFile.TypeEnum.XML).properties(Collections.singletonMap("k3", "v3")));
        TestAppJsonResolve.assertTrue((boolean)files.contains(simple.getFiles().get(0)));
        TestAppJsonResolve.assertTrue((boolean)files.contains(simple.getFiles().get(1)));
        master = orig.getComponent("master").getConfiguration();
        LOG.info("master = {}", (Object)master);
        TestAppJsonResolve.assertEquals((long)3L, (long)master.getProperties().size());
        TestAppJsonResolve.assertEquals((Object)"m", (Object)master.getProperty("name"));
        TestAppJsonResolve.assertEquals((Object)"overridden", (Object)master.getProperty("g1"));
        TestAppJsonResolve.assertEquals((Object)"b", (Object)master.getProperty("g2"));
        TestAppJsonResolve.assertEquals((long)2L, (long)master.getFiles().size());
        props.put("k1", "v1");
        files.clear();
        files.add(new ConfigFile().destFile("file1").type(ConfigFile.TypeEnum.PROPERTIES).properties(props));
        files.add(new ConfigFile().destFile("file2").type(ConfigFile.TypeEnum.XML).properties(Collections.singletonMap("k3", "v3")));
        TestAppJsonResolve.assertTrue((boolean)files.contains(master.getFiles().get(0)));
        TestAppJsonResolve.assertTrue((boolean)files.contains(master.getFiles().get(1)));
        worker = orig.getComponent("worker").getConfiguration();
        LOG.info("worker = {}", (Object)worker);
        TestAppJsonResolve.assertEquals((long)4L, (long)worker.getProperties().size());
        TestAppJsonResolve.assertEquals((Object)"worker", (Object)worker.getProperty("name"));
        TestAppJsonResolve.assertEquals((Object)"overridden-by-worker", (Object)worker.getProperty("g1"));
        TestAppJsonResolve.assertEquals((Object)"b", (Object)worker.getProperty("g2"));
        TestAppJsonResolve.assertEquals((Object)"1000", (Object)worker.getProperty("timeout"));
        TestAppJsonResolve.assertEquals((long)2L, (long)worker.getFiles().size());
        TestAppJsonResolve.assertTrue((boolean)files.contains(worker.getFiles().get(0)));
        TestAppJsonResolve.assertTrue((boolean)files.contains(worker.getFiles().get(1)));
    }

    @Test
    public void testOverrideExternalConfiguration() throws IOException {
        Service orig = ExampleAppJson.loadResource("external1.json");
        Configuration global = orig.getConfiguration();
        TestAppJsonResolve.assertEquals((long)0L, (long)global.getProperties().size());
        TestAppJsonResolve.assertEquals((long)3L, (long)orig.getComponents().size());
        Configuration simple = orig.getComponent("simple").getConfiguration();
        TestAppJsonResolve.assertEquals((long)0L, (long)simple.getProperties().size());
        Configuration master = orig.getComponent("master").getConfiguration();
        TestAppJsonResolve.assertEquals((long)1L, (long)master.getProperties().size());
        TestAppJsonResolve.assertEquals((Object)"is-overridden", (Object)master.getProperty("g3"));
        Configuration other = orig.getComponent("other").getConfiguration();
        TestAppJsonResolve.assertEquals((long)0L, (long)other.getProperties().size());
        SliderFileSystem sfs = ServiceTestUtils.initMockFs();
        Service ext = ExampleAppJson.loadResource("app.json");
        ServiceApiUtil.validateAndResolveService((Service)ext, (SliderFileSystem)sfs, (org.apache.hadoop.conf.Configuration)new YarnConfiguration());
        sfs = ServiceTestUtils.initMockFs(ext);
        ServiceApiUtil.validateAndResolveService((Service)orig, (SliderFileSystem)sfs, (org.apache.hadoop.conf.Configuration)new YarnConfiguration());
        global = orig.getConfiguration();
        TestAppJsonResolve.assertEquals((long)0L, (long)global.getProperties().size());
        TestAppJsonResolve.assertEquals((long)4L, (long)orig.getComponents().size());
        simple = orig.getComponent("simple").getConfiguration();
        TestAppJsonResolve.assertEquals((long)3L, (long)simple.getProperties().size());
        TestAppJsonResolve.assertEquals((Object)"a", (Object)simple.getProperty("g1"));
        TestAppJsonResolve.assertEquals((Object)"b", (Object)simple.getProperty("g2"));
        TestAppJsonResolve.assertEquals((Object)"60", (Object)simple.getProperty("yarn.service.failure-count-reset.window"));
        master = orig.getComponent("master").getConfiguration();
        TestAppJsonResolve.assertEquals((long)5L, (long)master.getProperties().size());
        TestAppJsonResolve.assertEquals((Object)"512M", (Object)master.getProperty("jvm.heapsize"));
        TestAppJsonResolve.assertEquals((Object)"overridden", (Object)master.getProperty("g1"));
        TestAppJsonResolve.assertEquals((Object)"b", (Object)master.getProperty("g2"));
        TestAppJsonResolve.assertEquals((Object)"is-overridden", (Object)master.getProperty("g3"));
        TestAppJsonResolve.assertEquals((Object)"60", (Object)simple.getProperty("yarn.service.failure-count-reset.window"));
        Configuration worker = orig.getComponent("worker").getConfiguration();
        LOG.info("worker = {}", (Object)worker);
        TestAppJsonResolve.assertEquals((long)4L, (long)worker.getProperties().size());
        TestAppJsonResolve.assertEquals((Object)"512M", (Object)worker.getProperty("jvm.heapsize"));
        TestAppJsonResolve.assertEquals((Object)"overridden-by-worker", (Object)worker.getProperty("g1"));
        TestAppJsonResolve.assertEquals((Object)"b", (Object)worker.getProperty("g2"));
        TestAppJsonResolve.assertEquals((Object)"60", (Object)worker.getProperty("yarn.service.failure-count-reset.window"));
        Resource workerResource = orig.getComponent("worker").getResource();
        Assert.assertEquals((long)1L, (long)workerResource.getCpus().intValue());
        Assert.assertEquals((long)1024L, (long)workerResource.calcMemoryMB());
        Assert.assertNotNull((Object)workerResource.getAdditional());
        Assert.assertEquals((long)2L, (long)workerResource.getAdditional().size());
        Assert.assertEquals((long)3333L, (long)((ResourceInformation)workerResource.getAdditional().get("resource-1")).getValue());
        Assert.assertEquals((Object)"Gi", (Object)((ResourceInformation)workerResource.getAdditional().get("resource-1")).getUnit());
        Assert.assertEquals((long)5L, (long)((ResourceInformation)workerResource.getAdditional().get("yarn.io/gpu")).getValue());
        Assert.assertEquals((Object)"", (Object)((ResourceInformation)workerResource.getAdditional().get("yarn.io/gpu")).getUnit());
        other = orig.getComponent("other").getConfiguration();
        TestAppJsonResolve.assertEquals((long)0L, (long)other.getProperties().size());
    }

    @Test
    public void testSetResourceAttributes() throws IOException {
        Service orig = ExampleAppJson.loadResource("external3.json");
        Component component = orig.getComponent("volume-service");
        Assert.assertNotNull((Object)component);
        Map adResource = component.getResource().getAdditional();
        Assert.assertNotNull((Object)adResource);
        Assert.assertEquals((long)1L, (long)adResource.size());
        Map.Entry volume = adResource.entrySet().iterator().next();
        Assert.assertEquals((Object)"yarn.io/csi-volume", volume.getKey());
        Assert.assertEquals((long)100L, (long)((ResourceInformation)volume.getValue()).getValue());
        Assert.assertEquals((long)2L, (long)((ResourceInformation)volume.getValue()).getAttributes().size());
        Assert.assertEquals((long)1L, (long)((ResourceInformation)volume.getValue()).getTags().size());
    }
}

