/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.component;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.service.ServiceTestUtils;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.Container;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.api.records.ServiceState;
import org.apache.hadoop.yarn.service.client.ServiceClient;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestComponentDecommissionInstances
extends ServiceTestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TestComponentDecommissionInstances.class);
    private static final String APP_NAME = "test-decommission";
    private static final String COMPA = "compa";
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();

    @Before
    public void setup() throws Exception {
        File tmpYarnDir = new File("target", "tmp");
        FileUtils.deleteQuietly((File)tmpYarnDir);
    }

    @After
    public void tearDown() throws IOException {
        this.shutdown();
    }

    @Test
    public void testDecommissionInstances() throws Exception {
        this.setupInternal(3);
        ServiceClient client = TestComponentDecommissionInstances.createClient(this.getConf());
        Service exampleApp = new Service();
        exampleApp.setName(APP_NAME);
        exampleApp.setVersion("v1");
        Component comp = TestComponentDecommissionInstances.createComponent(COMPA, 6L, "sleep 1000");
        exampleApp.addComponent(comp);
        client.actionCreate(exampleApp);
        this.waitForServiceToBeStable(client, exampleApp);
        TestComponentDecommissionInstances.checkInstances(client, "compa-0", "compa-1", "compa-2", "compa-3", "compa-4", "compa-5");
        client.actionDecommissionInstances(APP_NAME, Arrays.asList("compa-1", "compa-5"));
        TestComponentDecommissionInstances.waitForNumInstances(client, 4);
        TestComponentDecommissionInstances.checkInstances(client, "compa-0", "compa-2", "compa-3", "compa-4");
        client.actionStop(APP_NAME);
        this.waitForServiceToBeInState(client, exampleApp, ServiceState.STOPPED);
        client.actionStart(APP_NAME);
        this.waitForServiceToBeStable(client, exampleApp);
        TestComponentDecommissionInstances.checkInstances(client, "compa-0", "compa-2", "compa-3", "compa-4");
        HashMap<String, String> compCounts = new HashMap<String, String>();
        compCounts.put(COMPA, "5");
        client.actionFlex(APP_NAME, compCounts);
        TestComponentDecommissionInstances.waitForNumInstances(client, 5);
        TestComponentDecommissionInstances.checkInstances(client, "compa-0", "compa-2", "compa-3", "compa-4", "compa-6");
        client.actionDecommissionInstances(APP_NAME, Arrays.asList("compa-0.test-decommission." + RegistryUtils.currentUser()));
        TestComponentDecommissionInstances.waitForNumInstances(client, 4);
        TestComponentDecommissionInstances.checkInstances(client, "compa-2", "compa-3", "compa-4", "compa-6");
    }

    private static void waitForNumInstances(ServiceClient client, int expectedInstances) throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor(() -> {
            try {
                Service retrievedApp = client.getStatus(APP_NAME);
                return retrievedApp.getComponent(COMPA).getContainers().size() == expectedInstances && retrievedApp.getState() == ServiceState.STABLE;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }, (long)2000L, (long)200000L);
    }

    private static void checkInstances(ServiceClient client, String ... instances) throws IOException, YarnException {
        Service service = client.getStatus(APP_NAME);
        Component component = service.getComponent(COMPA);
        Assert.assertEquals((String)"Service state should be STABLE", (Object)ServiceState.STABLE, (Object)service.getState());
        Assert.assertEquals((String)(instances.length + " containers are expected to be running"), (long)instances.length, (long)component.getContainers().size());
        HashSet<String> existingInstances = new HashSet<String>();
        for (Container cont : component.getContainers()) {
            existingInstances.add(cont.getComponentInstanceName());
        }
        Assert.assertEquals((String)(instances.length + " instances are expected to be running"), (long)instances.length, (long)existingInstances.size());
        for (String instance : instances) {
            Assert.assertTrue((String)("Expected instance did not exist " + instance), (boolean)existingInstances.contains(instance));
        }
    }
}

