/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.service.MockRunningServiceContext;
import org.apache.hadoop.yarn.service.ServiceContext;
import org.apache.hadoop.yarn.service.ServiceEvent;
import org.apache.hadoop.yarn.service.ServiceEventType;
import org.apache.hadoop.yarn.service.ServiceManager;
import org.apache.hadoop.yarn.service.ServiceTestUtils;
import org.apache.hadoop.yarn.service.api.records.Artifact;
import org.apache.hadoop.yarn.service.api.records.ComponentState;
import org.apache.hadoop.yarn.service.api.records.ContainerState;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.api.records.ServiceState;
import org.apache.hadoop.yarn.service.component.Component;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceEvent;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceEventType;
import org.apache.hadoop.yarn.service.exceptions.SliderException;
import org.apache.hadoop.yarn.service.utils.ServiceApiUtil;
import org.apache.hadoop.yarn.service.utils.SliderFileSystem;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestServiceManager {
    @Rule
    public ServiceTestUtils.ServiceFSWatcher rule = new ServiceTestUtils.ServiceFSWatcher();
    private static final int TIMEOUT = 10000;
    private static final int CHECK_EVERY_MILLIS = 100;

    @Test(timeout=10000L)
    public void testUpgrade() throws Exception {
        ServiceContext context = this.createServiceContext("testUpgrade");
        this.initUpgrade(context, "v2", false, false, false);
        Assert.assertEquals((String)"service not upgraded", (Object)ServiceState.UPGRADING, (Object)context.getServiceManager().getServiceSpec().getState());
    }

    @Test(timeout=10000L)
    public void testRestartNothingToUpgrade() throws Exception {
        ServiceContext context = this.createServiceContext("testRestartNothingToUpgrade");
        this.initUpgrade(context, "v2", false, false, false);
        ServiceManager manager = context.getServiceManager();
        this.upgradeAndReadyAllInstances(context);
        context.scheduler.getDispatcher().getEventHandler().handle((Event)new ServiceEvent(ServiceEventType.START));
        GenericTestUtils.waitFor(() -> context.service.getState().equals((Object)ServiceState.STABLE), (long)100L, (long)10000L);
        Assert.assertEquals((String)"service not re-started", (Object)ServiceState.STABLE, (Object)manager.getServiceSpec().getState());
    }

    @Test(timeout=10000L)
    public void testAutoFinalizeNothingToUpgrade() throws Exception {
        ServiceContext context = this.createServiceContext("testAutoFinalizeNothingToUpgrade");
        this.initUpgrade(context, "v2", false, true, false);
        ServiceManager manager = context.getServiceManager();
        this.upgradeAndReadyAllInstances(context);
        GenericTestUtils.waitFor(() -> context.service.getState().equals((Object)ServiceState.STABLE), (long)100L, (long)10000L);
        Assert.assertEquals((String)"service stable", (Object)ServiceState.STABLE, (Object)manager.getServiceSpec().getState());
    }

    @Test(timeout=10000L)
    public void testRestartWithPendingUpgrade() throws Exception {
        ServiceContext context = this.createServiceContext("testRestart");
        this.initUpgrade(context, "v2", true, false, false);
        ServiceManager manager = context.getServiceManager();
        context.scheduler.getDispatcher().getEventHandler().handle((Event)new ServiceEvent(ServiceEventType.START));
        context.scheduler.getDispatcher().stop();
        Assert.assertEquals((String)"service should still be upgrading", (Object)ServiceState.UPGRADING, (Object)manager.getServiceSpec().getState());
    }

    @Test(timeout=10000L)
    public void testFinalize() throws Exception {
        ServiceContext context = this.createServiceContext("testCheckState");
        this.initUpgrade(context, "v2", true, false, false);
        ServiceManager manager = context.getServiceManager();
        Assert.assertEquals((String)"service not upgrading", (Object)ServiceState.UPGRADING, (Object)manager.getServiceSpec().getState());
        this.upgradeAndReadyAllInstances(context);
        context.scheduler.getDispatcher().getEventHandler().handle((Event)new ServiceEvent(ServiceEventType.START));
        GenericTestUtils.waitFor(() -> context.service.getState().equals((Object)ServiceState.STABLE), (long)100L, (long)10000L);
        Assert.assertEquals((String)"service not re-started", (Object)ServiceState.STABLE, (Object)manager.getServiceSpec().getState());
        this.validateUpgradeFinalization(manager.getName(), "v2");
    }

    @Test(timeout=10000L)
    public void testAutoFinalize() throws Exception {
        ServiceContext context = this.createServiceContext("testCheckStateAutoFinalize");
        ServiceManager manager = context.getServiceManager();
        manager.getServiceSpec().setState(ServiceState.UPGRADING_AUTO_FINALIZE);
        this.initUpgrade(context, "v2", true, true, false);
        this.upgradeAndReadyAllInstances(context);
        GenericTestUtils.waitFor(() -> context.service.getState().equals((Object)ServiceState.STABLE), (long)100L, (long)10000L);
        Assert.assertEquals((String)"service not stable", (Object)ServiceState.STABLE, (Object)manager.getServiceSpec().getState());
        this.validateUpgradeFinalization(manager.getName(), "v2");
    }

    @Test
    public void testInvalidUpgrade() throws Exception {
        ServiceContext serviceContext = this.createServiceContext("testInvalidUpgrade");
        ServiceManager manager = serviceContext.getServiceManager();
        manager.getServiceSpec().setState(ServiceState.UPGRADING_AUTO_FINALIZE);
        Service upgradedDef = ServiceTestUtils.createExampleApplication();
        upgradedDef.setName(manager.getName());
        upgradedDef.setVersion("v2");
        upgradedDef.setLifetime(Long.valueOf(2L));
        this.writeUpgradedDef(upgradedDef);
        try {
            manager.processUpgradeRequest("v2", true, false);
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof UnsupportedOperationException));
            return;
        }
        Assert.fail();
    }

    @Test(timeout=10000L)
    public void testExpressUpgrade() throws Exception {
        ServiceContext context = this.createServiceContext("testExpressUpgrade");
        ServiceManager manager = context.getServiceManager();
        manager.getServiceSpec().setState(ServiceState.EXPRESS_UPGRADING);
        this.initUpgrade(context, "v2", true, true, true);
        List comps = ServiceApiUtil.resolveCompsDependency((Service)context.service);
        String compA = (String)comps.get(0);
        this.makeInstancesReadyAfterUpgrade(context, compA);
        String compB = (String)comps.get(1);
        this.makeInstancesReadyAfterUpgrade(context, compB);
        GenericTestUtils.waitFor(() -> context.service.getState().equals((Object)ServiceState.STABLE), (long)100L, (long)10000L);
        Assert.assertEquals((String)"service not stable", (Object)ServiceState.STABLE, (Object)manager.getServiceSpec().getState());
        this.validateUpgradeFinalization(manager.getName(), "v2");
    }

    @Test(timeout=10000L)
    public void testCancelUpgrade() throws Exception {
        ServiceContext context = this.createServiceContext("testCancelUpgrade");
        this.writeInitialDef(context.service);
        this.initUpgrade(context, "v2", true, false, false);
        ServiceManager manager = context.getServiceManager();
        Assert.assertEquals((String)"service not upgrading", (Object)ServiceState.UPGRADING, (Object)manager.getServiceSpec().getState());
        List comps = ServiceApiUtil.resolveCompsDependency((Service)context.service);
        String compA = (String)comps.get(0);
        this.upgradeInstances(context, compA);
        this.makeInstancesReadyAfterUpgrade(context, compA);
        context.scheduler.getDispatcher().getEventHandler().handle((Event)new ServiceEvent(ServiceEventType.CANCEL_UPGRADE));
        this.makeInstancesReadyAfterUpgrade(context, compA);
        GenericTestUtils.waitFor(() -> context.service.getState().equals((Object)ServiceState.STABLE), (long)100L, (long)10000L);
        Assert.assertEquals((String)"service upgrade not cancelled", (Object)ServiceState.STABLE, (Object)manager.getServiceSpec().getState());
        this.validateUpgradeFinalization(manager.getName(), "v1");
    }

    @Test(timeout=10000L)
    public void testCancelUpgradeAfterInitiate() throws Exception {
        ServiceContext context = this.createServiceContext("testCancelUpgrade");
        this.writeInitialDef(context.service);
        this.initUpgrade(context, "v2", true, false, false);
        ServiceManager manager = context.getServiceManager();
        Assert.assertEquals((String)"service not upgrading", (Object)ServiceState.UPGRADING, (Object)manager.getServiceSpec().getState());
        context.scheduler.getDispatcher().getEventHandler().handle((Event)new ServiceEvent(ServiceEventType.CANCEL_UPGRADE));
        GenericTestUtils.waitFor(() -> context.service.getState().equals((Object)ServiceState.STABLE), (long)100L, (long)10000L);
        Assert.assertEquals((String)"service upgrade not cancelled", (Object)ServiceState.STABLE, (Object)manager.getServiceSpec().getState());
        this.validateUpgradeFinalization(manager.getName(), "v1");
    }

    private void validateUpgradeFinalization(String serviceName, String expectedVersion) throws IOException {
        Service savedSpec = ServiceApiUtil.loadService((SliderFileSystem)this.rule.getFs(), (String)serviceName);
        Assert.assertEquals((String)"service def not re-written", (Object)expectedVersion, (Object)savedSpec.getVersion());
        Assert.assertNotNull((String)"app id not present", (Object)savedSpec.getId());
        Assert.assertEquals((String)"state not stable", (Object)ServiceState.STABLE, (Object)savedSpec.getState());
        savedSpec.getComponents().forEach(compSpec -> Assert.assertEquals((String)"comp not stable", (Object)ComponentState.STABLE, (Object)compSpec.getState()));
    }

    private void initUpgrade(ServiceContext context, String version, boolean upgradeArtifact, boolean autoFinalize, boolean expressUpgrade) throws IOException, SliderException, TimeoutException, InterruptedException {
        ServiceManager serviceManager = context.getServiceManager();
        Service upgradedDef = ServiceTestUtils.createExampleApplication();
        upgradedDef.setName(serviceManager.getName());
        upgradedDef.setVersion(version);
        if (upgradeArtifact) {
            Artifact upgradedArtifact = TestServiceManager.createTestArtifact("2");
            upgradedDef.getComponents().forEach(component -> component.setArtifact(upgradedArtifact));
        }
        this.writeUpgradedDef(upgradedDef);
        serviceManager.processUpgradeRequest(version, autoFinalize, expressUpgrade);
        GenericTestUtils.waitFor(() -> {
            for (Component comp : context.scheduler.getAllComponents().values()) {
                if (comp.getComponentSpec().getState().equals((Object)ComponentState.NEEDS_UPGRADE)) continue;
                return false;
            }
            return true;
        }, (long)100L, (long)10000L);
    }

    private void upgradeAndReadyAllInstances(ServiceContext context) throws TimeoutException, InterruptedException {
        this.upgradeAllInstances(context);
        this.makeAllInstancesReady(context);
    }

    private void upgradeAllInstances(ServiceContext context) throws TimeoutException, InterruptedException {
        context.scheduler.getLiveInstances().forEach((containerId, instance) -> {
            ComponentInstanceEvent event = new ComponentInstanceEvent(containerId, ComponentInstanceEventType.UPGRADE);
            context.scheduler.getDispatcher().getEventHandler().handle((Event)event);
        });
    }

    private void makeAllInstancesReady(ServiceContext context) throws TimeoutException, InterruptedException {
        context.scheduler.getLiveInstances().forEach((containerId, instance) -> {
            ComponentInstanceEvent startEvent = new ComponentInstanceEvent(containerId, ComponentInstanceEventType.START);
            context.scheduler.getDispatcher().getEventHandler().handle((Event)startEvent);
            ComponentInstanceEvent becomeReadyEvent = new ComponentInstanceEvent(containerId, ComponentInstanceEventType.BECOME_READY);
            context.scheduler.getDispatcher().getEventHandler().handle((Event)becomeReadyEvent);
        });
        GenericTestUtils.waitFor(() -> {
            for (ComponentInstance instance : context.scheduler.getLiveInstances().values()) {
                if (instance.getContainerState().equals((Object)ContainerState.READY)) continue;
                return false;
            }
            return true;
        }, (long)100L, (long)10000L);
    }

    private void upgradeInstances(ServiceContext context, String compName) {
        Collection compInstances = ((Component)context.scheduler.getAllComponents().get(compName)).getAllComponentInstances();
        compInstances.forEach(instance -> {
            ComponentInstanceEvent event = new ComponentInstanceEvent(instance.getContainer().getId(), ComponentInstanceEventType.UPGRADE);
            context.scheduler.getDispatcher().getEventHandler().handle((Event)event);
        });
    }

    private void makeInstancesReadyAfterUpgrade(ServiceContext context, String compName) throws TimeoutException, InterruptedException {
        Collection compInstances = ((Component)context.scheduler.getAllComponents().get(compName)).getAllComponentInstances();
        GenericTestUtils.waitFor(() -> {
            for (ComponentInstance instance : compInstances) {
                if (instance.getContainerState().equals((Object)ContainerState.UPGRADING)) continue;
                return false;
            }
            return true;
        }, (long)100L, (long)10000L);
        compInstances.forEach(instance -> {
            ComponentInstanceEvent startEvent = new ComponentInstanceEvent(instance.getContainer().getId(), ComponentInstanceEventType.START);
            context.scheduler.getDispatcher().getEventHandler().handle((Event)startEvent);
            ComponentInstanceEvent becomeReadyEvent = new ComponentInstanceEvent(instance.getContainer().getId(), ComponentInstanceEventType.BECOME_READY);
            context.scheduler.getDispatcher().getEventHandler().handle((Event)becomeReadyEvent);
        });
        GenericTestUtils.waitFor(() -> {
            for (ComponentInstance instance : compInstances) {
                if (instance.getContainerState().equals((Object)ContainerState.READY)) continue;
                return false;
            }
            return true;
        }, (long)100L, (long)10000L);
    }

    private ServiceContext createServiceContext(String name) throws Exception {
        Service service = TestServiceManager.createBaseDef(name);
        MockRunningServiceContext context = new MockRunningServiceContext(this.rule, service);
        context.scheduler.getDispatcher().setDrainEventsOnStop();
        context.scheduler.getDispatcher().start();
        return context;
    }

    public static Service createBaseDef(String name) {
        return TestServiceManager.createDef(name, ServiceTestUtils.createExampleApplication());
    }

    public static Service createDef(String name, Service serviceDef) {
        ApplicationId applicationId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        serviceDef.setId(applicationId.toString());
        serviceDef.setName(name);
        serviceDef.setState(ServiceState.STARTED);
        Artifact artifact = TestServiceManager.createTestArtifact("1");
        serviceDef.getComponents().forEach(component -> component.setArtifact(artifact));
        return serviceDef;
    }

    static Artifact createTestArtifact(String artifactId) {
        Artifact artifact = new Artifact();
        artifact.setId(artifactId);
        artifact.setType(Artifact.TypeEnum.TARBALL);
        return artifact;
    }

    private void writeInitialDef(Service service) throws IOException, SliderException {
        Path servicePath = this.rule.getFs().buildClusterDirPath(service.getName());
        ServiceApiUtil.createDirAndPersistApp((SliderFileSystem)this.rule.getFs(), (Path)servicePath, (Service)service);
    }

    private void writeUpgradedDef(Service upgradedDef) throws IOException, SliderException {
        Path upgradePath = this.rule.getFs().buildClusterUpgradeDirPath(upgradedDef.getName(), upgradedDef.getVersion());
        ServiceApiUtil.createDirAndPersistApp((SliderFileSystem)this.rule.getFs(), (Path)upgradePath, (Service)upgradedDef);
    }
}

