/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.yarn.service.ServiceTestUtils;
import org.apache.hadoop.yarn.service.TestServiceManager;
import org.apache.hadoop.yarn.service.UpgradeComponentsFinder;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.ConfigFile;
import org.apache.hadoop.yarn.service.api.records.Configuration;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.junit.Assert;
import org.junit.Test;

public class TestDefaultUpgradeComponentsFinder {
    private UpgradeComponentsFinder.DefaultUpgradeComponentsFinder finder = new UpgradeComponentsFinder.DefaultUpgradeComponentsFinder();

    @Test
    public void testServiceArtifactChange() {
        Service currentDef = ServiceTestUtils.createExampleApplication();
        Service targetDef = ServiceTestUtils.createExampleApplication();
        targetDef.getComponents().forEach(x -> x.setArtifact(TestServiceManager.createTestArtifact("v1")));
        Assert.assertEquals((String)"all components need upgrade", (Object)targetDef.getComponents(), (Object)this.finder.findTargetComponentSpecs(currentDef, targetDef));
    }

    @Test
    public void testServiceUpgradeWithNewComponentAddition() {
        Service currentDef = ServiceTestUtils.createExampleApplication();
        Service targetDef = ServiceTestUtils.createExampleApplication();
        Iterator targetComponentsIter = targetDef.getComponents().iterator();
        Component firstComponent = (Component)targetComponentsIter.next();
        firstComponent.setName("newComponentA");
        try {
            this.finder.findTargetComponentSpecs(currentDef, targetDef);
            Assert.fail((String)"Expected error since component does not exist in service definition");
        }
        catch (UnsupportedOperationException usoe) {
            Assert.assertEquals((Object)"addition/deletion of components not supported by upgrade. Could not find component newComponentA in current service definition.", (Object)usoe.getMessage());
        }
    }

    @Test
    public void testComponentArtifactChange() {
        Service currentDef = TestServiceManager.createBaseDef("test");
        Service targetDef = TestServiceManager.createBaseDef("test");
        ((Component)targetDef.getComponents().get(0)).setArtifact(TestServiceManager.createTestArtifact("v2"));
        ArrayList expected = new ArrayList();
        expected.add(targetDef.getComponents().get(0));
        Assert.assertEquals((String)"single components needs upgrade", expected, (Object)this.finder.findTargetComponentSpecs(currentDef, targetDef));
    }

    @Test
    public void testChangeInConfigFileProperty() {
        ConfigFile file = new ConfigFile().srcFile("src").destFile("dest").type(ConfigFile.TypeEnum.HADOOP_XML);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("k1", "v1");
        file.setProperties(props);
        Configuration conf = new Configuration().files((List)Lists.newArrayList((Object[])new ConfigFile[]{file}));
        Service currentDef = TestServiceManager.createBaseDef("test");
        currentDef.setConfiguration(conf);
        file = new ConfigFile().srcFile("src").destFile("dest").type(ConfigFile.TypeEnum.HADOOP_XML);
        HashMap<String, String> changedProps = new HashMap<String, String>();
        changedProps.put("k1", "v2");
        file.setProperties(changedProps);
        conf = new Configuration().files((List)Lists.newArrayList((Object[])new ConfigFile[]{file}));
        Service targetDef = TestServiceManager.createBaseDef("test");
        targetDef.setConfiguration(conf);
        ArrayList expected = new ArrayList();
        expected.addAll(targetDef.getComponents());
        Assert.assertEquals((String)"all components needs upgrade", expected, (Object)this.finder.findTargetComponentSpecs(currentDef, targetDef));
    }
}

