/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.hadoop.registry.client.binding.RegistryPathUtils;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.NMClient;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.hadoop.yarn.client.api.async.NMClientAsync;
import org.apache.hadoop.yarn.client.api.impl.AMRMClientImpl;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.proto.ClientAMProtocol;
import org.apache.hadoop.yarn.service.ClientAMService;
import org.apache.hadoop.yarn.service.ServiceContext;
import org.apache.hadoop.yarn.service.ServiceMaster;
import org.apache.hadoop.yarn.service.ServiceScheduler;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.component.Component;
import org.apache.hadoop.yarn.service.component.ComponentState;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceState;
import org.apache.hadoop.yarn.service.exceptions.BadClusterStateException;
import org.apache.hadoop.yarn.service.registry.YarnRegistryViewForProviders;
import org.apache.hadoop.yarn.service.utils.SliderFileSystem;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServiceAM
extends ServiceMaster {
    private static final Logger LOG = LoggerFactory.getLogger(MockServiceAM.class);
    Service service;
    final List<Container> feedContainers = Collections.synchronizedList(new LinkedList());
    final List<ContainerStatus> failedContainers = Collections.synchronizedList(new LinkedList());
    private final List<Container> recoveredContainers = Collections.synchronizedList(new LinkedList());
    private final Map<String, ServiceRecord> registryComponents = new ConcurrentHashMap<String, ServiceRecord>();
    private Map<ContainerId, ContainerStatus> containerStatuses = new ConcurrentHashMap<ContainerId, ContainerStatus>();
    private Set<ContainerId> releasedContainers = ConcurrentHashMap.newKeySet();
    private Credentials amCreds;

    public MockServiceAM(Service service) {
        super(service.getName());
        this.service = service;
    }

    public MockServiceAM(Service service, Credentials amCreds) {
        super(service.getName());
        this.service = service;
        this.amCreds = amCreds;
    }

    protected ContainerId getAMContainerId() throws BadClusterStateException {
        return ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.fromString((String)this.service.getId()), (int)1), (long)1L);
    }

    protected Path getAppDir() {
        Path path = new Path(new Path("target", "apps"), this.service.getName());
        LOG.info("Service path: {}", (Object)path);
        return path;
    }

    protected ClientAMService createClientAMService() {
        return new ClientAMService(this.context){

            String getNMHostName() {
                return "0.0.0.0";
            }
        };
    }

    protected ServiceScheduler createServiceScheduler(ServiceContext context) throws IOException, YarnException {
        return new ServiceScheduler(context){

            protected YarnRegistryViewForProviders createYarnRegistryOperations(ServiceContext context, RegistryOperations registryClient) {
                YarnRegistryViewForProviders yarnRegistryView = (YarnRegistryViewForProviders)Mockito.mock(YarnRegistryViewForProviders.class);
                if (!MockServiceAM.this.registryComponents.isEmpty()) {
                    try {
                        Mockito.when((Object)yarnRegistryView.listComponents()).thenReturn(new LinkedList(MockServiceAM.this.registryComponents.keySet()));
                        Mockito.when((Object)yarnRegistryView.getComponent(ArgumentMatchers.anyString())).thenAnswer(invocation -> (ServiceRecord)MockServiceAM.this.registryComponents.get(invocation.getArguments()[0]));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return yarnRegistryView;
            }

            protected AMRMClientAsync<AMRMClient.ContainerRequest> createAMRMClient() {
                AMRMClientImpl client1 = new AMRMClientImpl(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public AllocateResponse allocate(float progressIndicator) throws YarnException, IOException {
                        AllocateResponse.AllocateResponseBuilder builder = AllocateResponse.newBuilder();
                        List<ContainerStatus> list = MockServiceAM.this.feedContainers;
                        synchronized (list) {
                            if (MockServiceAM.this.feedContainers.isEmpty()) {
                                LOG.info("Allocating........ no containers");
                            } else {
                                LinkedList<Container> allocatedContainers = new LinkedList<Container>();
                                Iterator<Container> itor = MockServiceAM.this.feedContainers.iterator();
                                while (itor.hasNext()) {
                                    Container c = itor.next();
                                    Component component = (Component)componentsById.get(c.getAllocationRequestId());
                                    if (component.getState() != ComponentState.FLEXING) continue;
                                    LOG.info("Allocated container {} ", (Object)c.getId());
                                    allocatedContainers.add(c);
                                    itor.remove();
                                }
                                builder.allocatedContainers(allocatedContainers);
                            }
                        }
                        list = MockServiceAM.this.recoveredContainers;
                        synchronized (list) {
                            if (!MockServiceAM.this.recoveredContainers.isEmpty()) {
                                LinkedList containersFromPrevAttempt = new LinkedList();
                                containersFromPrevAttempt.addAll(MockServiceAM.this.recoveredContainers);
                                MockServiceAM.this.recoveredContainers.clear();
                                builder.containersFromPreviousAttempt(containersFromPrevAttempt);
                            }
                        }
                        list = MockServiceAM.this.failedContainers;
                        synchronized (list) {
                            if (!MockServiceAM.this.failedContainers.isEmpty()) {
                                LinkedList<ContainerStatus> failed = new LinkedList<ContainerStatus>(MockServiceAM.this.failedContainers);
                                MockServiceAM.this.failedContainers.clear();
                                builder.completedContainersStatuses(failed);
                            }
                        }
                        return builder.build();
                    }

                    public RegisterApplicationMasterResponse registerApplicationMaster(String appHostName, int appHostPort, String appTrackingUrl, Map placementConstraintsMap) throws YarnException, IOException {
                        return this.registerApplicationMaster(appHostName, appHostPort, appTrackingUrl);
                    }

                    public RegisterApplicationMasterResponse registerApplicationMaster(String appHostName, int appHostPort, String appTrackingUrl) {
                        RegisterApplicationMasterResponse response = (RegisterApplicationMasterResponse)Mockito.mock(RegisterApplicationMasterResponse.class);
                        Mockito.when((Object)response.getResourceTypes()).thenReturn((Object)ResourceUtils.getResourcesTypeInfo());
                        return response;
                    }

                    public synchronized void releaseAssignedContainer(ContainerId containerId) {
                        MockServiceAM.this.releasedContainers.add(containerId);
                        super.releaseAssignedContainer(containerId);
                    }

                    public void unregisterApplicationMaster(FinalApplicationStatus appStatus, String appMessage, String appTrackingUrl) {
                    }
                };
                AMRMClientAsync amrmClientAsync = AMRMClientAsync.createAMRMClientAsync((AMRMClient)client1, (int)1000, (AMRMClientAsync.AbstractCallbackHandler)new ServiceScheduler.AMRMClientCallback((ServiceScheduler)this));
                return amrmClientAsync;
            }

            public NMClientAsync createNMClient() {
                NMClientAsync nmClientAsync = super.createNMClient();
                NMClient nmClient = (NMClient)Mockito.mock(NMClient.class);
                try {
                    Mockito.when((Object)nmClient.getContainerStatus((ContainerId)ArgumentMatchers.any(), (NodeId)ArgumentMatchers.any())).thenAnswer(invocation -> (ContainerStatus)MockServiceAM.this.containerStatuses.get(invocation.getArguments()[0]));
                }
                catch (IOException | YarnException e) {
                    throw new RuntimeException(e);
                }
                nmClientAsync.setClient(nmClient);
                return nmClientAsync;
            }
        };
    }

    protected void loadApplicationJson(ServiceContext context, SliderFileSystem fs) throws IOException {
        context.service = this.service;
    }

    public void feedRegistryComponent(ContainerId containerId, String compName, String compInstName) {
        ServiceRecord record = new ServiceRecord();
        record.set("yarn:id", (Object)containerId.toString());
        record.description = compInstName;
        record.set("yarn:persistence", (Object)"container");
        record.set("yarn:ip", (Object)"localhost");
        record.set("yarn:hostname", (Object)"localhost");
        record.set("yarn:component", (Object)compName);
        this.registryComponents.put(RegistryPathUtils.encodeYarnID((String)containerId.toString()), record);
    }

    public void feedRecoveredContainer(ContainerId containerId, String compName) {
        Container container = this.createContainer(containerId, compName);
        this.recoveredContainers.add(container);
        this.addContainerStatus(container, ContainerState.RUNNING);
    }

    public Container feedContainerToComp(Service service, int id, String compName) {
        ContainerId containerId = this.createContainerId(id);
        return this.feedContainerToComp(service, containerId, compName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Container feedContainerToComp(Service service, ContainerId containerId, String compName) {
        Container container = this.createContainer(containerId, compName);
        List<Container> list = this.feedContainers;
        synchronized (list) {
            this.feedContainers.add(container);
        }
        this.addContainerStatus(container, ContainerState.RUNNING);
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void feedFailedContainerToComp(Service service, int id, String compName) {
        ApplicationId applicationId = ApplicationId.fromString((String)service.getId());
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)1), (long)id);
        ContainerStatus status = (ContainerStatus)Records.newRecord(ContainerStatus.class);
        status.setContainerId(containerId);
        List<ContainerStatus> list = this.failedContainers;
        synchronized (list) {
            this.failedContainers.add(status);
        }
    }

    public Container updateContainerStatus(Service service, int id, String compName, String host) {
        ContainerId containerId = this.createContainerId(id);
        Container container = this.createContainer(containerId, compName);
        this.addContainerStatus(container, ContainerState.RUNNING, host);
        return container;
    }

    public ContainerId createContainerId(int id) {
        ApplicationId applicationId = ApplicationId.fromString((String)this.service.getId());
        return ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)1), (long)id);
    }

    private Container createContainer(ContainerId containerId, String compName) {
        NodeId nodeId = NodeId.newInstance((String)"localhost", (int)1234);
        Container container = Container.newInstance((ContainerId)containerId, (NodeId)nodeId, (String)"localhost", (Resource)Resource.newInstance((int)100, (int)1), (Priority)Priority.newInstance((int)0), null);
        long allocateId = ((Component)this.context.scheduler.getAllComponents().get(compName)).getAllocateId();
        container.setAllocationRequestId(allocateId);
        return container;
    }

    public void flexComponent(String compName, long numberOfContainers) throws IOException {
        ClientAMProtocol.ComponentCountProto componentCountProto = ClientAMProtocol.ComponentCountProto.newBuilder().setName(compName).setNumberOfContainers(numberOfContainers).build();
        ClientAMProtocol.FlexComponentsRequestProto requestProto = ClientAMProtocol.FlexComponentsRequestProto.newBuilder().addComponents(componentCountProto).build();
        this.context.clientAMService.flexComponents(requestProto);
    }

    public Component getComponent(String compName) {
        return (Component)this.context.scheduler.getAllComponents().get(compName);
    }

    public void waitForDependenciesSatisfied(final String compName) throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return ((Component)MockServiceAM.this.context.scheduler.getAllComponents().get(compName)).areDependenciesReady();
            }
        }, (long)1000L, (long)20000L);
    }

    public void waitForNumDesiredContainers(final String compName, final int numDesiredContainers) throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return ((Component)MockServiceAM.this.context.scheduler.getAllComponents().get(compName)).getNumDesiredInstances() == numDesiredContainers;
            }
        }, (long)1000L, (long)20000L);
    }

    public ComponentInstance getCompInstance(String compName, String instanceName) {
        return ((Component)this.context.scheduler.getAllComponents().get(compName)).getComponentInstance(instanceName);
    }

    public void waitForCompInstanceState(final ComponentInstance instance, final ComponentInstanceState state) throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return instance.getState().equals((Object)state);
            }
        }, (long)1000L, (long)20000L);
    }

    private void addContainerStatus(Container container, ContainerState state) {
        this.addContainerStatus(container, state, container.getNodeId().getHost());
    }

    private void addContainerStatus(Container container, ContainerState state, String host) {
        ContainerStatus status = ContainerStatus.newInstance((ContainerId)container.getId(), (ContainerState)state, (String)"", (int)0);
        status.setHost(host);
        status.setIPs((List)Lists.newArrayList((Object[])new String[]{host}));
        this.containerStatuses.put(container.getId(), status);
    }

    protected ByteBuffer recordTokensForContainers() throws IOException {
        DataOutputBuffer dob = new DataOutputBuffer();
        if (this.amCreds == null) {
            return ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        }
        try {
            this.amCreds.writeTokenStorageToStream((DataOutputStream)dob);
        }
        finally {
            dob.close();
        }
        return ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
    }

    public void waitForContainerToRelease(ContainerId containerId) throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor(() -> this.releasedContainers.contains(containerId), (long)1000L, (long)30000L);
    }
}

