/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.client;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.client.ApiServiceClient;
import org.apache.hadoop.yarn.service.client.ServiceClient;
import org.apache.hadoop.yarn.service.client.SystemServiceManagerImpl;
import org.apache.hadoop.yarn.service.exceptions.SliderException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSystemServiceManagerImpl {
    private static final Logger LOG = LoggerFactory.getLogger(TestSystemServiceManagerImpl.class);
    private SystemServiceManagerImpl systemService;
    private Configuration conf;
    private String resourcePath = "system-services";
    private String[] users = new String[]{"user1", "user2"};
    private static Map<String, Set<String>> loadedServices = new HashMap<String, Set<String>>();
    private static Map<String, Set<String>> savedServices = new HashMap<String, Set<String>>();
    private static Map<String, Set<String>> submittedServices = new HashMap<String, Set<String>>();

    @BeforeEach
    public void setup() {
        File file = new File(this.getClass().getClassLoader().getResource(this.resourcePath).getFile());
        this.conf = new Configuration();
        this.conf.set("yarn.service.system-service.dir", file.getAbsolutePath());
        this.systemService = new SystemServiceManagerImpl(){

            ServiceClient getServiceClient() {
                return new TestServiceClient();
            }
        };
        this.systemService.init(this.conf);
        this.constructUserService(this.users[0], "example-app1");
        this.constructUserService(this.users[1], "example-app1", "example-app2");
    }

    @AfterEach
    public void tearDown() {
        this.systemService.stop();
    }

    @Test
    void testSystemServiceSubmission() throws Exception {
        this.systemService.start();
        Map ignoredUserServices = this.systemService.getIgnoredUserServices();
        Assertions.assertEquals((int)1, (int)ignoredUserServices.size());
        Assertions.assertTrue((boolean)ignoredUserServices.containsKey(this.users[0]), (String)"User user1 doesn't exist.");
        int count = (Integer)ignoredUserServices.get(this.users[0]);
        Assertions.assertEquals((int)1, (int)count);
        Assertions.assertEquals((int)1, (int)this.systemService.getBadFileNameExtensionSkipCounter());
        Assertions.assertEquals((int)1, (int)this.systemService.getBadDirSkipCounter());
        Map userServices = this.systemService.getSyncUserServices();
        Assertions.assertEquals((int)loadedServices.size(), (int)userServices.size());
        this.verifyForScannedUserServices(userServices);
        this.verifyForLaunchedUserServices();
        this.systemService.launchUserService(userServices);
        this.verifyForLaunchedUserServices();
        submittedServices.clear();
        this.systemService.launchUserService(userServices);
        this.verifyForLaunchedUserServices();
    }

    private void verifyForScannedUserServices(Map<String, Set<Service>> userServices) {
        for (String user : this.users) {
            Set<Service> services = userServices.get(user);
            Set<String> serviceNames = loadedServices.get(user);
            Assertions.assertEquals((int)serviceNames.size(), (int)services.size());
            for (Service next : services) {
                Assertions.assertTrue((boolean)serviceNames.contains(next.getName()), (String)("Service name doesn't exist in expected userService " + serviceNames));
            }
        }
    }

    public void constructUserService(String user, String ... serviceNames) {
        Set<String> service = loadedServices.get(user);
        if (service == null) {
            service = new HashSet<String>();
            for (String serviceName : serviceNames) {
                service.add(serviceName);
            }
            loadedServices.put(user, service);
        }
    }

    private void verifyForLaunchedUserServices() {
        Assertions.assertEquals((int)loadedServices.size(), (int)submittedServices.size());
        for (Map.Entry<String, Set<String>> entry : submittedServices.entrySet()) {
            String user = entry.getKey();
            Set<String> serviceSet = entry.getValue();
            Assertions.assertTrue((boolean)loadedServices.containsKey(user));
            Set<String> services = loadedServices.get(user);
            Assertions.assertEquals((int)services.size(), (int)serviceSet.size());
            Assertions.assertTrue((boolean)services.containsAll(serviceSet));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testFileSystemCloseWhenCleanUpService() throws Exception {
        DistributedFileSystem fs = null;
        Path path = new Path("/tmp/servicedir");
        HdfsConfiguration hdfsConfig = new HdfsConfiguration();
        MiniDFSCluster hdfsCluster = new MiniDFSCluster.Builder((Configuration)hdfsConfig).numDataNodes(1).build();
        fs = hdfsCluster.getFileSystem();
        if (!fs.exists(path)) {
            fs.mkdirs(path);
        }
        SystemServiceManagerImpl serviceManager = new SystemServiceManagerImpl();
        hdfsConfig.set("yarn.service.system-service.dir", path.toString());
        serviceManager.init((Configuration)hdfsConfig);
        hdfsConfig.set("hadoop.registry.zk.connection.timeout.ms", "100");
        hdfsConfig.set("hadoop.registry.zk.retry.times", "1");
        ApiServiceClient asc = new ApiServiceClient();
        asc.serviceInit((Configuration)hdfsConfig);
        asc.actionCleanUp("testapp", "testuser");
        try {
            serviceManager.start();
        }
        catch (Exception e) {
            if (e.getMessage().contains("Filesystem closed")) {
                Assertions.fail((String)"SystemServiceManagerImpl failed to handle FileSystem close");
            } else {
                Assertions.fail((String)"Should not get any exceptions");
            }
        }
        finally {
            serviceManager.stop();
            fs = hdfsCluster.getFileSystem();
            if (fs.exists(path)) {
                fs.delete(path, true);
            }
            if (hdfsCluster != null) {
                hdfsCluster.shutdown();
            }
        }
    }

    class TestServiceClient
    extends ServiceClient {
        TestServiceClient() {
        }

        protected void serviceStart() throws Exception {
        }

        protected void serviceStop() throws Exception {
        }

        protected void serviceInit(Configuration configuration) throws Exception {
        }

        public int actionBuild(Service service) throws YarnException, IOException {
            String userName = UserGroupInformation.getCurrentUser().getShortUserName();
            Set<String> services = savedServices.get(userName);
            if (services == null) {
                services = new HashSet<String>();
                savedServices.put(userName, services);
            }
            if (services.contains(service.getName())) {
                String message = "Failed to save service " + service.getName() + ", because it already exists.";
                throw new SliderException(75, message);
            }
            services.add(service.getName());
            return 0;
        }

        public ApplicationId actionStartAndGetId(String serviceName) throws YarnException, IOException {
            String userName = UserGroupInformation.getCurrentUser().getShortUserName();
            Set<String> services = submittedServices.get(userName);
            if (services == null) {
                services = new HashSet<String>();
                submittedServices.put(userName, services);
            }
            if (services.contains(serviceName)) {
                String message = "Failed to create service " + serviceName + ", because it is already running.";
                throw new YarnException(message);
            }
            services.add(serviceName);
            return ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        }
    }
}

