/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy.amfilter;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.http.TestHttpServer;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.server.webproxy.amfilter.AmIpFilter;
import org.apache.hadoop.yarn.server.webproxy.amfilter.AmIpServletRequestWrapper;
import org.assertj.core.api.Assertions;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;

public class TestAmFilter {
    private String proxyHost = "localhost";
    private String proxyUri = "http://bogus";
    private String doFilterRequest;
    private AmIpServletRequestWrapper servletWrapper;

    @Test
    @Timeout(value=5000L)
    void filterNullCookies() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getCookies()).thenReturn(null);
        Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)this.proxyHost);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        final AtomicBoolean invoked = new AtomicBoolean();
        FilterChain chain = new FilterChain(){

            public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
                invoked.set(true);
            }
        };
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("PROXY_HOST", this.proxyHost);
        params.put("PROXY_URI_BASE", this.proxyUri);
        DummyFilterConfig conf = new DummyFilterConfig(params);
        TestAmIpFilter filter = new TestAmIpFilter();
        filter.init(conf);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)invoked.get());
        filter.destroy();
    }

    @Test
    void testFindRedirectUrl() throws Exception {
        String rm1 = "rm1";
        String rm2 = "rm2";
        String rm1Url = this.startHttpServer();
        String rm2Url = "host2:8088";
        TestAmIpFilter filter = new TestAmIpFilter();
        TestAmIpFilter spy = (TestAmIpFilter)((Object)Mockito.spy((Object)((Object)filter)));
        spy.proxyUriBases = new HashMap();
        spy.proxyUriBases.put("rm1", rm1Url);
        spy.proxyUriBases.put("rm2", "host2:8088");
        spy.rmUrls = new String[]{"rm1", "rm2"};
        Assertions.assertThat((String)spy.findRedirectUrl()).isEqualTo((Object)rm1Url);
    }

    private String startHttpServer() throws Exception {
        Server server = new Server(0);
        ((QueuedThreadPool)server.getThreadPool()).setMaxThreads(20);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/foo");
        server.setHandler((Handler)context);
        String servletPath = "/bar";
        context.addServlet(new ServletHolder(TestHttpServer.EchoServlet.class), servletPath);
        ((ServerConnector)server.getConnectors()[0]).setHost("localhost");
        server.start();
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        return server.getURI().toString() + servletPath;
    }

    @Test
    @Timeout(value=2000L)
    void testProxyUpdate() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("PROXY_HOSTS", this.proxyHost);
        params.put("PROXY_URI_BASES", this.proxyUri);
        DummyFilterConfig conf = new DummyFilterConfig(params);
        final AmIpFilter filter = new AmIpFilter();
        int updateInterval = 1000;
        AmIpFilter.setUpdateInterval((long)updateInterval);
        filter.init((FilterConfig)conf);
        filter.getProxyAddresses();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)filter.getProxyAddresses().contains("127.0.0.1"));
        params = new HashMap();
        params.put("PROXY_HOSTS", "unknownhost");
        params.put("PROXY_URI_BASES", this.proxyUri);
        conf = new DummyFilterConfig(params);
        filter.init((FilterConfig)conf);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)filter.getProxyAddresses().isEmpty());
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                try {
                    return filter.getProxyAddresses().isEmpty();
                }
                catch (ServletException e) {
                    return true;
                }
            }
        }, (long)500L, (long)updateInterval);
    }

    @Test
    @Timeout(value=10000L)
    void testFilter() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("PROXY_HOST", this.proxyHost);
        params.put("PROXY_URI_BASE", this.proxyUri);
        DummyFilterConfig config = new DummyFilterConfig(params);
        FilterChain chain = new FilterChain(){

            public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
                TestAmFilter.this.doFilterRequest = servletRequest.getClass().getName();
                if (servletRequest instanceof AmIpServletRequestWrapper) {
                    TestAmFilter.this.servletWrapper = (AmIpServletRequestWrapper)servletRequest;
                }
            }
        };
        AmIpFilter testFilter = new AmIpFilter();
        testFilter.init((FilterConfig)config);
        HttpServletResponseForTest response = new HttpServletResponseForTest();
        ServletRequest failRequest = (ServletRequest)Mockito.mock(ServletRequest.class);
        try {
            testFilter.doFilter(failRequest, (ServletResponse)response, chain);
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (ServletException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"This filter only works for HTTP/HTTPS", (Object)e.getMessage());
        }
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)"nowhere");
        Mockito.when((Object)request.getRequestURI()).thenReturn((Object)"/app/application_00_0");
        testFilter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        org.junit.jupiter.api.Assertions.assertEquals((int)302, (int)response.status);
        String redirect = response.getHeader("Location");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"http://bogus/app/application_00_0", (Object)redirect);
        Mockito.when((Object)request.getRequestURI()).thenReturn((Object)"/proxy/application_00_0");
        testFilter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        org.junit.jupiter.api.Assertions.assertEquals((int)302, (int)response.status);
        redirect = response.getHeader("Location");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"http://bogus/proxy/redirect/application_00_0", (Object)redirect);
        Mockito.when((Object)request.getRequestURI()).thenReturn((Object)"/proxy/application_00_0");
        Mockito.when((Object)request.getQueryString()).thenReturn((Object)"id=0");
        testFilter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        org.junit.jupiter.api.Assertions.assertEquals((int)302, (int)response.status);
        redirect = response.getHeader("Location");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"http://bogus/proxy/redirect/application_00_0?id=0", (Object)redirect);
        Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)"127.0.0.1");
        testFilter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.doFilterRequest.contains("HttpServletRequest"));
        Cookie[] cookies = new Cookie[]{new Cookie("proxy-user", "user")};
        Mockito.when((Object)request.getCookies()).thenReturn((Object)cookies);
        testFilter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"org.apache.hadoop.yarn.server.webproxy.amfilter.AmIpServletRequestWrapper", (Object)this.doFilterRequest);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"user", (Object)this.servletWrapper.getUserPrincipal().getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"user", (Object)this.servletWrapper.getRemoteUser());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.servletWrapper.isUserInRole(""));
    }

    private static class DummyFilterConfig
    implements FilterConfig {
        final Map<String, String> map;

        DummyFilterConfig(Map<String, String> map) {
            this.map = map;
        }

        public String getFilterName() {
            return "dummy";
        }

        public String getInitParameter(String arg0) {
            return this.map.get(arg0);
        }

        public Enumeration<String> getInitParameterNames() {
            return Collections.enumeration(this.map.keySet());
        }

        public ServletContext getServletContext() {
            return null;
        }
    }

    private class TestAmIpFilter
    extends AmIpFilter {
        private Set<String> proxyAddresses = null;

        private TestAmIpFilter() {
        }

        protected Set<String> getProxyAddresses() {
            if (this.proxyAddresses == null) {
                this.proxyAddresses = new HashSet<String>();
            }
            this.proxyAddresses.add(TestAmFilter.this.proxyHost);
            return this.proxyAddresses;
        }
    }

    private class HttpServletResponseForTest
    implements HttpServletResponse {
        String redirectLocation = "";
        int status;
        private String contentType;
        private final Map<String, String> headers = new HashMap<String, String>(1);
        private StringWriter body;

        private HttpServletResponseForTest() {
        }

        public String getRedirect() {
            return this.redirectLocation;
        }

        public void sendRedirect(String location) throws IOException {
            this.redirectLocation = location;
        }

        public void setDateHeader(String name, long date) {
        }

        public void addDateHeader(String name, long date) {
        }

        public void addCookie(Cookie cookie) {
        }

        public boolean containsHeader(String name) {
            return false;
        }

        public String encodeURL(String url) {
            return null;
        }

        public String encodeRedirectURL(String url) {
            return url;
        }

        public String encodeUrl(String url) {
            return null;
        }

        public String encodeRedirectUrl(String url) {
            return null;
        }

        public void sendError(int sc, String msg) throws IOException {
        }

        public void sendError(int sc) throws IOException {
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public void setStatus(int sc, String sm) {
        }

        public int getStatus() {
            return 0;
        }

        public void setContentType(String type) {
            this.contentType = type;
        }

        public void setBufferSize(int size) {
        }

        public int getBufferSize() {
            return 0;
        }

        public void flushBuffer() throws IOException {
        }

        public void resetBuffer() {
        }

        public boolean isCommitted() {
            return false;
        }

        public void reset() {
        }

        public void setLocale(Locale loc) {
        }

        public Locale getLocale() {
            return null;
        }

        public void setHeader(String name, String value) {
            this.headers.put(name, value);
        }

        public void addHeader(String name, String value) {
        }

        public void setIntHeader(String name, int value) {
        }

        public void addIntHeader(String name, int value) {
        }

        public String getHeader(String name) {
            return this.headers.get(name);
        }

        public Collection<String> getHeaders(String name) {
            return null;
        }

        public Collection<String> getHeaderNames() {
            return null;
        }

        public String getCharacterEncoding() {
            return null;
        }

        public String getContentType() {
            return null;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return null;
        }

        public PrintWriter getWriter() throws IOException {
            this.body = new StringWriter();
            return new PrintWriter(this.body);
        }

        public void setCharacterEncoding(String charset) {
        }

        public void setContentLength(int len) {
        }

        public void setContentLengthLong(long len) {
        }
    }
}

