/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxy;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxyServer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestWebAppProxyServer {
    private WebAppProxyServer webAppProxy = null;
    private final String port = "8888";
    private final String proxyAddress = "localhost:8888";
    private YarnConfiguration conf = null;

    @BeforeEach
    public void setUp() throws Exception {
        this.conf = new YarnConfiguration();
        this.conf.set("yarn.web-proxy.address", "localhost:8888");
        this.webAppProxy = new WebAppProxyServer();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.webAppProxy.stop();
    }

    @Test
    void testStart() {
        this.webAppProxy.init((Configuration)this.conf);
        Assertions.assertEquals((Object)Service.STATE.INITED, (Object)this.webAppProxy.getServiceState());
        this.webAppProxy.start();
        for (Service service : this.webAppProxy.getServices()) {
            if (!(service instanceof WebAppProxy)) continue;
            Assertions.assertEquals((Object)"localhost:8888", (Object)((WebAppProxy)service).getBindAddress());
        }
        Assertions.assertEquals((Object)Service.STATE.STARTED, (Object)this.webAppProxy.getServiceState());
    }

    @Test
    void testStartWithBindHost() {
        String bindHost = "0.0.0.0";
        this.conf.set("yarn.web-proxy.bind-host", bindHost);
        this.webAppProxy.init((Configuration)this.conf);
        Assertions.assertEquals((Object)Service.STATE.INITED, (Object)this.webAppProxy.getServiceState());
        this.webAppProxy.start();
        for (Service service : this.webAppProxy.getServices()) {
            if (!(service instanceof WebAppProxy)) continue;
            Assertions.assertEquals((Object)(bindHost + ":8888"), (Object)((WebAppProxy)service).getBindAddress());
        }
        Assertions.assertEquals((Object)Service.STATE.STARTED, (Object)this.webAppProxy.getServiceState());
    }

    @Test
    void testBindAddress() {
        this.conf = new YarnConfiguration();
        InetSocketAddress defaultBindAddress = WebAppProxyServer.getBindAddress((Configuration)this.conf);
        Assertions.assertEquals((int)9099, (int)defaultBindAddress.getPort(), (String)"Web Proxy default bind address port is incorrect");
    }
}

