/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.ApplicationHistoryProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.impl.MemoryFederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.records.AddApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.ApplicationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterRegisterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.apache.hadoop.yarn.server.webproxy.FedAppReportFetcher;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestFedAppReportFetcher {
    private Configuration conf;
    private static ApplicationHistoryProtocol history;
    private SubClusterId subClusterId1 = SubClusterId.newInstance((String)"subCluster1");
    private SubClusterId subClusterId2 = SubClusterId.newInstance((String)"subCluster2");
    private SubClusterInfo clusterInfo1 = SubClusterInfo.newInstance((SubClusterId)this.subClusterId1, (String)"10.0.0.1:1000", (String)"10.0.0.1:1000", (String)"10.0.0.1:1000", (String)"10.0.0.1:1000", (SubClusterState)SubClusterState.SC_RUNNING, (long)0L, (String)"");
    private SubClusterInfo clusterInfo2 = SubClusterInfo.newInstance((SubClusterId)this.subClusterId2, (String)"10.0.0.2:1000", (String)"10.0.0.2:1000", (String)"10.0.0.2:1000", (String)"10.0.0.2:1000", (SubClusterState)SubClusterState.SC_RUNNING, (long)0L, (String)"");
    private ApplicationClientProtocol appManager1;
    private ApplicationClientProtocol appManager2;
    private ApplicationId appId1 = ApplicationId.newInstance((long)0L, (int)1);
    private ApplicationId appId2 = ApplicationId.newInstance((long)0L, (int)2);
    private static FedAppReportFetcher fetcher;
    private final String appNotFoundExceptionMsg = "APP NOT FOUND";

    @AfterEach
    public void cleanUp() {
        history = null;
        fetcher = null;
    }

    private void testHelper(boolean isAHSEnabled) throws YarnException, IOException {
        this.conf = new YarnConfiguration();
        this.conf.setBoolean("yarn.timeline-service.generic-application-history.enabled", isAHSEnabled);
        FederationStateStoreFacade fedFacade = FederationStateStoreFacade.getInstance((Configuration)this.conf);
        MemoryFederationStateStore fss = new MemoryFederationStateStore();
        fss.init(this.conf);
        fedFacade.reinitialize((FederationStateStore)fss, this.conf);
        fss.registerSubCluster(SubClusterRegisterRequest.newInstance((SubClusterInfo)this.clusterInfo1));
        fss.registerSubCluster(SubClusterRegisterRequest.newInstance((SubClusterInfo)this.clusterInfo2));
        fss.addApplicationHomeSubCluster(AddApplicationHomeSubClusterRequest.newInstance((ApplicationHomeSubCluster)ApplicationHomeSubCluster.newInstance((ApplicationId)this.appId1, (SubClusterId)this.subClusterId1)));
        fss.addApplicationHomeSubCluster(AddApplicationHomeSubClusterRequest.newInstance((ApplicationHomeSubCluster)ApplicationHomeSubCluster.newInstance((ApplicationId)this.appId2, (SubClusterId)this.subClusterId2)));
        this.appManager1 = (ApplicationClientProtocol)Mockito.mock(ApplicationClientProtocol.class);
        Mockito.when((Object)this.appManager1.getApplicationReport((GetApplicationReportRequest)Mockito.any(GetApplicationReportRequest.class))).thenThrow(new Throwable[]{new ApplicationNotFoundException("APP NOT FOUND")});
        this.appManager2 = (ApplicationClientProtocol)Mockito.mock(ApplicationClientProtocol.class);
        Mockito.when((Object)this.appManager2.getApplicationReport((GetApplicationReportRequest)Mockito.any(GetApplicationReportRequest.class))).thenThrow(new Throwable[]{new ApplicationNotFoundException("APP NOT FOUND")});
        fetcher = new FedAppReportFetcherForTest(this.conf);
        fetcher.registerSubCluster(this.clusterInfo1, this.appManager1);
        fetcher.registerSubCluster(this.clusterInfo2, this.appManager2);
    }

    @Test
    public void testFetchReportAHSEnabled() throws YarnException, IOException {
        this.testHelper(true);
        fetcher.getApplicationReport(this.appId1);
        fetcher.getApplicationReport(this.appId2);
        ((ApplicationHistoryProtocol)Mockito.verify((Object)history, (VerificationMode)Mockito.times((int)2))).getApplicationReport((GetApplicationReportRequest)Mockito.any(GetApplicationReportRequest.class));
        ((ApplicationClientProtocol)Mockito.verify((Object)this.appManager1, (VerificationMode)Mockito.times((int)1))).getApplicationReport((GetApplicationReportRequest)Mockito.any(GetApplicationReportRequest.class));
        ((ApplicationClientProtocol)Mockito.verify((Object)this.appManager2, (VerificationMode)Mockito.times((int)1))).getApplicationReport((GetApplicationReportRequest)Mockito.any(GetApplicationReportRequest.class));
    }

    @Test
    public void testFetchReportAHSDisabled() throws Exception {
        this.testHelper(false);
        LambdaTestUtils.intercept(ApplicationNotFoundException.class, (String)"APP NOT FOUND", () -> fetcher.getApplicationReport(this.appId1));
        LambdaTestUtils.intercept(ApplicationNotFoundException.class, (String)"APP NOT FOUND", () -> fetcher.getApplicationReport(this.appId2));
        ((ApplicationClientProtocol)Mockito.verify((Object)this.appManager1, (VerificationMode)Mockito.times((int)1))).getApplicationReport((GetApplicationReportRequest)Mockito.any(GetApplicationReportRequest.class));
        ((ApplicationClientProtocol)Mockito.verify((Object)this.appManager2, (VerificationMode)Mockito.times((int)1))).getApplicationReport((GetApplicationReportRequest)Mockito.any(GetApplicationReportRequest.class));
        Assertions.assertNull((Object)history, (String)"HistoryManager should be null as AHS is disabled");
    }

    @Test
    public void testGetRmAppPageUrlBase() throws IOException, YarnException {
        this.testHelper(true);
        String scheme = WebAppUtils.getHttpSchemePrefix((Configuration)this.conf);
        Assertions.assertEquals((Object)fetcher.getRmAppPageUrlBase(this.appId1), (Object)StringHelper.pjoin((Object[])new Object[]{scheme + this.clusterInfo1.getRMWebServiceAddress(), "cluster", "app"}));
        Assertions.assertEquals((Object)fetcher.getRmAppPageUrlBase(this.appId2), (Object)StringHelper.pjoin((Object[])new Object[]{scheme + this.clusterInfo2.getRMWebServiceAddress(), "cluster", "app"}));
    }

    static class FedAppReportFetcherForTest
    extends FedAppReportFetcher {
        FedAppReportFetcherForTest(Configuration conf) {
            super(conf);
        }

        protected ApplicationHistoryProtocol getAHSProxy(Configuration conf) throws IOException {
            GetApplicationReportResponse resp = (GetApplicationReportResponse)Mockito.mock(GetApplicationReportResponse.class);
            history = (ApplicationHistoryProtocol)Mockito.mock(ApplicationHistoryProtocol.class);
            try {
                Mockito.when((Object)history.getApplicationReport((GetApplicationReportRequest)Mockito.any(GetApplicationReportRequest.class))).thenReturn((Object)resp);
            }
            catch (YarnException e) {
                Assertions.fail((String)"Found exception when getApplicationReport!");
            }
            return history;
        }
    }
}

