/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy.amfilter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.yarn.server.webproxy.amfilter.AmFilterInitializer;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestAmFilterInitializer {
    @BeforeEach
    public void setUp() throws Exception {
        NetUtils.addStaticResolution((String)"host1", (String)"172.0.0.1");
        NetUtils.addStaticResolution((String)"host2", (String)"172.0.0.1");
        NetUtils.addStaticResolution((String)"host3", (String)"172.0.0.1");
        NetUtils.addStaticResolution((String)"host4", (String)"172.0.0.1");
        NetUtils.addStaticResolution((String)"host5", (String)"172.0.0.1");
        NetUtils.addStaticResolution((String)"host6", (String)"172.0.0.1");
    }

    @Test
    void testInitFilter() {
        MockFilterContainer con = new MockFilterContainer();
        Configuration conf = new Configuration(false);
        conf.set("yarn.web-proxy.address", "host1:1000");
        MockAmFilterInitializer afi = new MockAmFilterInitializer();
        Assertions.assertNull(con.givenParameters);
        afi.initFilter(con, conf);
        Assertions.assertEquals((int)2, (int)con.givenParameters.size());
        Assertions.assertEquals((Object)"host1", (Object)con.givenParameters.get("PROXY_HOSTS"));
        Assertions.assertEquals((Object)"http://host1:1000/foo", (Object)con.givenParameters.get("PROXY_URI_BASES"));
        Assertions.assertNull((Object)con.givenParameters.get("RM_HA_URLS"));
        con = new MockFilterContainer();
        conf = new Configuration(false);
        conf.set("yarn.resourcemanager.webapp.address", "host2:2000");
        afi = new MockAmFilterInitializer();
        Assertions.assertNull(con.givenParameters);
        afi.initFilter(con, conf);
        Assertions.assertEquals((int)2, (int)con.givenParameters.size());
        Assertions.assertEquals((Object)"host2", (Object)con.givenParameters.get("PROXY_HOSTS"));
        Assertions.assertEquals((Object)"http://host2:2000/foo", (Object)con.givenParameters.get("PROXY_URI_BASES"));
        Assertions.assertNull((Object)con.givenParameters.get("RM_HA_URLS"));
        con = new MockFilterContainer();
        conf = new Configuration(false);
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm2,rm3");
        conf.set("yarn.resourcemanager.webapp.address.rm1", "host2:2000");
        conf.set("yarn.resourcemanager.webapp.address.rm2", "host3:3000");
        conf.set("yarn.resourcemanager.webapp.address.rm3", "host4:4000");
        afi = new MockAmFilterInitializer();
        Assertions.assertNull(con.givenParameters);
        afi.initFilter(con, conf);
        Assertions.assertEquals((int)3, (int)con.givenParameters.size());
        Object[] proxyHosts = con.givenParameters.get("PROXY_HOSTS").split(",");
        Assertions.assertEquals((int)3, (int)proxyHosts.length);
        Arrays.sort(proxyHosts);
        Assertions.assertEquals((Object)"host2", (Object)proxyHosts[0]);
        Assertions.assertEquals((Object)"host3", (Object)proxyHosts[1]);
        Assertions.assertEquals((Object)"host4", (Object)proxyHosts[2]);
        Object[] proxyBases = con.givenParameters.get("PROXY_URI_BASES").split(",");
        Assertions.assertEquals((int)3, (int)proxyBases.length);
        Arrays.sort(proxyBases);
        Assertions.assertEquals((Object)"http://host2:2000/foo", (Object)proxyBases[0]);
        Assertions.assertEquals((Object)"http://host3:3000/foo", (Object)proxyBases[1]);
        Assertions.assertEquals((Object)"http://host4:4000/foo", (Object)proxyBases[2]);
        Assertions.assertEquals((Object)"host2:2000,host3:3000,host4:4000", (Object)con.givenParameters.get("RM_HA_URLS"));
        con = new MockFilterContainer();
        conf = new Configuration(false);
        conf.set("yarn.http.policy", HttpConfig.Policy.HTTPS_ONLY.toString());
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm2");
        conf.set("yarn.resourcemanager.webapp.https.address.rm1", "host5:5000");
        conf.set("yarn.resourcemanager.webapp.https.address.rm2", "host6:6000");
        afi = new MockAmFilterInitializer();
        Assertions.assertNull(con.givenParameters);
        afi.initFilter(con, conf);
        Assertions.assertEquals((int)3, (int)con.givenParameters.size());
        proxyHosts = con.givenParameters.get("PROXY_HOSTS").split(",");
        Assertions.assertEquals((int)2, (int)proxyHosts.length);
        Arrays.sort(proxyHosts);
        Assertions.assertEquals((Object)"host5", (Object)proxyHosts[0]);
        Assertions.assertEquals((Object)"host6", (Object)proxyHosts[1]);
        proxyBases = con.givenParameters.get("PROXY_URI_BASES").split(",");
        Assertions.assertEquals((int)2, (int)proxyBases.length);
        Arrays.sort(proxyBases);
        Assertions.assertEquals((Object)"https://host5:5000/foo", (Object)proxyBases[0]);
        Assertions.assertEquals((Object)"https://host6:6000/foo", (Object)proxyBases[1]);
        Assertions.assertEquals((Object)"host5:5000,host6:6000", (Object)con.givenParameters.get("RM_HA_URLS"));
    }

    @Test
    void testGetProxyHostsAndPortsForAmFilter() {
        Configuration conf = new Configuration(false);
        List proxyHosts = WebAppUtils.getProxyHostsAndPortsForAmFilter((Configuration)conf);
        Assertions.assertEquals((int)1, (int)proxyHosts.size());
        Assertions.assertEquals((Object)WebAppUtils.getResolvedRMWebAppURLWithoutScheme((Configuration)conf), proxyHosts.get(0));
        conf = new Configuration(false);
        conf.set("yarn.resourcemanager.webapp.address", "${yarn.resourcemanager.hostname}:8088");
        conf.set("yarn.resourcemanager.hostname", "host1");
        proxyHosts = WebAppUtils.getProxyHostsAndPortsForAmFilter((Configuration)conf);
        Assertions.assertEquals((int)1, (int)proxyHosts.size());
        Assertions.assertEquals((Object)"host1:8088", proxyHosts.get(0));
        conf = new Configuration(false);
        conf.set("yarn.web-proxy.address", "host1:1000");
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm2,rm3");
        conf.set("yarn.resourcemanager.webapp.address.rm1", "host2:2000");
        conf.set("yarn.resourcemanager.webapp.address.rm2", "host3:3000");
        conf.set("yarn.resourcemanager.webapp.address.rm3", "host4:4000");
        proxyHosts = WebAppUtils.getProxyHostsAndPortsForAmFilter((Configuration)conf);
        Assertions.assertEquals((int)1, (int)proxyHosts.size());
        Assertions.assertEquals((Object)"host1:1000", proxyHosts.get(0));
        conf = new Configuration(false);
        conf.set("yarn.resourcemanager.webapp.address", "host2:2000");
        proxyHosts = WebAppUtils.getProxyHostsAndPortsForAmFilter((Configuration)conf);
        Assertions.assertEquals((int)1, (int)proxyHosts.size());
        Collections.sort(proxyHosts);
        Assertions.assertEquals((Object)"host2:2000", proxyHosts.get(0));
        conf = new Configuration(false);
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm2,rm3");
        conf.set("yarn.resourcemanager.webapp.address.rm1", "host2:2000");
        conf.set("yarn.resourcemanager.webapp.address.rm2", "host3:3000");
        conf.set("yarn.resourcemanager.webapp.address.rm3", "host4:4000");
        conf.set("yarn.resourcemanager.webapp.address.rm4", "dummy");
        conf.set("yarn.resourcemanager.webapp.https.address.rm1", "host5:5000");
        conf.set("yarn.resourcemanager.webapp.https.address.rm2", "host6:6000");
        proxyHosts = WebAppUtils.getProxyHostsAndPortsForAmFilter((Configuration)conf);
        Assertions.assertEquals((int)3, (int)proxyHosts.size());
        Collections.sort(proxyHosts);
        Assertions.assertEquals((Object)"host2:2000", proxyHosts.get(0));
        Assertions.assertEquals((Object)"host3:3000", proxyHosts.get(1));
        Assertions.assertEquals((Object)"host4:4000", proxyHosts.get(2));
        conf = new Configuration(false);
        conf.set("yarn.http.policy", HttpConfig.Policy.HTTPS_ONLY.toString());
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm2,rm3,dummy");
        conf.set("yarn.resourcemanager.webapp.address.rm1", "host2:2000");
        conf.set("yarn.resourcemanager.webapp.address.rm2", "host3:3000");
        conf.set("yarn.resourcemanager.webapp.address.rm3", "host4:4000");
        conf.set("yarn.resourcemanager.webapp.https.address.rm1", "host5:5000");
        conf.set("yarn.resourcemanager.webapp.https.address.rm2", "host6:6000");
        proxyHosts = WebAppUtils.getProxyHostsAndPortsForAmFilter((Configuration)conf);
        Assertions.assertEquals((int)2, (int)proxyHosts.size());
        Collections.sort(proxyHosts);
        Assertions.assertEquals((Object)"host5:5000", proxyHosts.get(0));
        Assertions.assertEquals((Object)"host6:6000", proxyHosts.get(1));
        conf = new Configuration(false);
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm2,rm3");
        conf.set("yarn.resourcemanager.hostname.rm1", "host2");
        conf.set("yarn.resourcemanager.hostname.rm2", "host3");
        conf.set("yarn.resourcemanager.hostname.rm3", "host4");
        conf.set("yarn.resourcemanager.hostname.rm4", "dummy");
        proxyHosts = WebAppUtils.getProxyHostsAndPortsForAmFilter((Configuration)conf);
        Assertions.assertEquals((int)3, (int)proxyHosts.size());
        Collections.sort(proxyHosts);
        Assertions.assertEquals((Object)"host2:8088", proxyHosts.get(0));
        Assertions.assertEquals((Object)"host3:8088", proxyHosts.get(1));
        Assertions.assertEquals((Object)"host4:8088", proxyHosts.get(2));
        conf = new Configuration(false);
        conf.set("yarn.http.policy", HttpConfig.Policy.HTTPS_ONLY.toString());
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm2,rm3");
        conf.set("yarn.resourcemanager.hostname.rm1", "host2");
        conf.set("yarn.resourcemanager.hostname.rm2", "host3");
        conf.set("yarn.resourcemanager.hostname.rm3", "host4");
        conf.set("yarn.resourcemanager.hostname.rm4", "dummy");
        proxyHosts = WebAppUtils.getProxyHostsAndPortsForAmFilter((Configuration)conf);
        Assertions.assertEquals((int)3, (int)proxyHosts.size());
        Collections.sort(proxyHosts);
        Assertions.assertEquals((Object)"host2:8090", proxyHosts.get(0));
        Assertions.assertEquals((Object)"host3:8090", proxyHosts.get(1));
        Assertions.assertEquals((Object)"host4:8090", proxyHosts.get(2));
    }

    class MockFilterContainer
    implements FilterContainer {
        Map<String, String> givenParameters;

        MockFilterContainer() {
        }

        public void addFilter(String name, String classname, Map<String, String> parameters) {
            this.givenParameters = parameters;
        }

        public void addGlobalFilter(String name, String classname, Map<String, String> parameters) {
        }
    }

    class MockAmFilterInitializer
    extends AmFilterInitializer {
        MockAmFilterInitializer() {
        }

        protected String getApplicationWebProxyBase() {
            return "/foo";
        }
    }
}

