/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;

@Provider
@Consumes(value={"application/json"})
public class TimelineEntitySetReader
implements MessageBodyReader<Set<TimelineEntity>> {
    private ObjectMapper objectMapper = new ObjectMapper();
    private String timelineEntityType = "java.util.Set<org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity>";

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.timelineEntityType.equals(genericType.getTypeName());
    }

    public Set<TimelineEntity> readFrom(Class<Set<TimelineEntity>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        HashSet<TimelineEntity> timelineEntitySet = new HashSet<TimelineEntity>();
        JsonNode jsonNode = this.objectMapper.readTree(entityStream);
        if (jsonNode.isArray()) {
            for (JsonNode jNode : jsonNode) {
                TimelineEntity entity = new TimelineEntity();
                JsonNode jnIdentifier = jNode.get("identifier");
                JsonNode jnType = jnIdentifier.get("type");
                JsonNode jnId = jnIdentifier.get("id");
                TimelineEntity.Identifier identifier = new TimelineEntity.Identifier(jnType.asText(), jnId.asText());
                entity.setIdentifier(identifier);
                JsonNode jnAppType = jNode.get("type");
                entity.setType(jnAppType.asText());
                JsonNode jnCreatedTime = jNode.get("createdtime");
                entity.setCreatedTime(Long.valueOf(jnCreatedTime.asLong()));
                JsonNode jnIdprefix = jNode.get("idprefix");
                entity.setIdPrefix(jnIdprefix.asLong());
                timelineEntitySet.add(entity);
            }
        }
        return timelineEntitySet;
    }
}

