/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.hadoop.yarn.api.records.timeline.TimelineAbout;

@Provider
@Consumes(value={"application/json"})
public class TimelineAboutReader
implements MessageBodyReader<TimelineAbout> {
    private ObjectMapper objectMapper = new ObjectMapper();

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == TimelineAbout.class;
    }

    public TimelineAbout readFrom(Class<TimelineAbout> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        JsonNode rootNode = this.objectMapper.readTree(entityStream);
        assert (rootNode != null);
        JsonNode jsonNode = rootNode.get("about");
        assert (jsonNode != null);
        JsonNode about = jsonNode.get("About");
        JsonNode hadoopBuildVersion = jsonNode.get("hadoop-build-version");
        JsonNode hadoopVersion = jsonNode.get("hadoop-version");
        JsonNode hadoopVersionBuildOn = jsonNode.get("hadoop-version-built-on");
        JsonNode timelineServiceBuildVersion = jsonNode.get("timeline-service-build-version");
        JsonNode timelineLineServiceVersion = jsonNode.get("timeline-service-version");
        JsonNode timelineServiceVersionBuiltOn = jsonNode.get("timeline-service-version-built-on");
        TimelineAbout timelineAbout = new TimelineAbout();
        timelineAbout.setAbout(about.asText());
        timelineAbout.setHadoopBuildVersion(hadoopBuildVersion.asText());
        timelineAbout.setHadoopVersion(hadoopVersion.asText());
        timelineAbout.setHadoopVersionBuiltOn(hadoopVersionBuildOn.asText());
        timelineAbout.setTimelineServiceBuildVersion(timelineServiceBuildVersion.asText());
        timelineAbout.setTimelineServiceVersion(timelineLineServiceVersion.asText());
        timelineAbout.setTimelineServiceVersionBuiltOn(timelineServiceVersionBuiltOn.asText());
        return timelineAbout;
    }
}

