/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderServer;
import org.apache.hadoop.yarn.server.timelineservice.storage.FileSystemTimelineReaderImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.TestFileSystemTimelineReaderImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineReader;
import org.apache.hadoop.yarn.webapp.YarnJacksonJaxbJsonProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.HttpUrlConnectorProvider;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestTimelineReaderWebServicesACL {
    private static final String ROOT_DIR = new File("target", TestTimelineReaderWebServicesACL.class.getSimpleName()).getAbsolutePath();
    private int serverPort;
    private TimelineReaderServer server;
    private static final String ADMIN = "yarn";

    @BeforeAll
    public static void setup() throws Exception {
        TestFileSystemTimelineReaderImpl.initializeDataDirectory(ROOT_DIR);
    }

    @AfterAll
    public static void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)new File(ROOT_DIR));
    }

    @BeforeEach
    public void init() throws Exception {
        try {
            YarnConfiguration config = new YarnConfiguration();
            config.setBoolean("yarn.timeline-service.enabled", true);
            config.setFloat("yarn.timeline-service.version", 2.0f);
            config.set("yarn.timeline-service.reader.webapp.address", "localhost:0");
            config.set("yarn.resourcemanager.cluster-id", "cluster1");
            config.setClass("yarn.timeline-service.reader.class", FileSystemTimelineReaderImpl.class, TimelineReader.class);
            config.set("yarn.timeline-service.fs-writer.root-dir", ROOT_DIR);
            config.setBoolean("yarn.webapp.filter-entity-list-by-user", true);
            config.setBoolean("yarn.acl.enable", true);
            config.set("yarn.admin.acl", ADMIN);
            this.server = new TimelineReaderServer();
            this.server.init((org.apache.hadoop.conf.Configuration)config);
            this.server.start();
            this.serverPort = this.server.getWebServerPort();
        }
        catch (Exception e) {
            Assertions.fail((String)"Web server failed to start");
        }
    }

    @AfterEach
    public void stop() throws Exception {
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
    }

    private static Response verifyHttpResponse(Client client, URI uri, Response.Status expectedStatus) {
        Response resp = (Response)client.target(uri).request(new String[]{"application/json"}).get(Response.class);
        Assertions.assertNotNull((Object)resp);
        Assertions.assertEquals((int)resp.getStatusInfo().getStatusCode(), (int)expectedStatus.getStatusCode());
        return resp;
    }

    private static Client createClient() {
        ClientConfig cfg = new ClientConfig();
        cfg.register(YarnJacksonJaxbJsonProvider.class);
        cfg.connectorProvider((ConnectorProvider)new HttpUrlConnectorProvider().connectionFactory((HttpUrlConnectorProvider.ConnectionFactory)new DummyURLConnectionFactory()));
        return ClientBuilder.newClient((Configuration)cfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testGetEntityTypes() throws Exception {
        try (Client client = TestTimelineReaderWebServicesACL.createClient();){
            String unAuthorizedUser = "user2";
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/apps/app1/entity-types?user.name=" + unAuthorizedUser);
            String msg = "User " + unAuthorizedUser + " is not allowed to read TimelineService V2 data.";
            Response resp = TestTimelineReaderWebServicesACL.verifyHttpResponse(client, uri, Response.Status.FORBIDDEN);
            Assertions.assertTrue((boolean)((String)resp.readEntity(String.class)).contains(msg));
            String authorizedUser = "user1";
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/apps/app1/entity-types?user.name=" + authorizedUser);
            TestTimelineReaderWebServicesACL.verifyHttpResponse(client, uri, Response.Status.OK);
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/apps/app1/entity-types?user.name=yarn");
            TestTimelineReaderWebServicesACL.verifyHttpResponse(client, uri, Response.Status.OK);
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/apps/app1/entity-types?user.name=" + authorizedUser + "&userid=" + authorizedUser);
            TestTimelineReaderWebServicesACL.verifyHttpResponse(client, uri, Response.Status.OK);
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/apps/app1/entity-types?user.name=" + authorizedUser + "&userid=" + unAuthorizedUser);
            TestTimelineReaderWebServicesACL.verifyHttpResponse(client, uri, Response.Status.FORBIDDEN);
        }
    }

    private static class DummyURLConnectionFactory
    implements HttpUrlConnectorProvider.ConnectionFactory {
        private DummyURLConnectionFactory() {
        }

        public HttpURLConnection getConnection(URL url) throws IOException {
            try {
                return (HttpURLConnection)url.openConnection();
            }
            catch (UndeclaredThrowableException e) {
                throw new IOException(e.getCause());
            }
        }
    }
}

