/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Set;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.yarn.api.records.timeline.TimelineAbout;
import org.apache.hadoop.yarn.api.records.timeline.TimelineHealth;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineAboutReader;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineEntityReader;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineEntitySetReader;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineHealthReader;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderServer;
import org.apache.hadoop.yarn.server.timelineservice.storage.FileSystemTimelineReaderImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.TestFileSystemTimelineReaderImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineReader;
import org.apache.hadoop.yarn.webapp.YarnJacksonJaxbJsonProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.HttpUrlConnectorProvider;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestTimelineReaderWebServices {
    private static final String ROOT_DIR = new File("target", TestTimelineReaderWebServices.class.getSimpleName()).getAbsolutePath();
    private int serverPort;
    private TimelineReaderServer server;

    @BeforeAll
    public static void setup() throws Exception {
        TestFileSystemTimelineReaderImpl.initializeDataDirectory(ROOT_DIR);
    }

    @AfterAll
    public static void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)new File(ROOT_DIR));
    }

    @BeforeEach
    public void init() throws Exception {
        try {
            YarnConfiguration config = new YarnConfiguration();
            config.setBoolean("yarn.timeline-service.enabled", true);
            config.setFloat("yarn.timeline-service.version", 2.0f);
            config.set("yarn.timeline-service.reader.webapp.address", "localhost:0");
            config.set("yarn.resourcemanager.cluster-id", "cluster1");
            config.setClass("yarn.timeline-service.reader.class", FileSystemTimelineReaderImpl.class, TimelineReader.class);
            config.set("yarn.timeline-service.fs-writer.root-dir", ROOT_DIR);
            this.server = new TimelineReaderServer();
            this.server.init((org.apache.hadoop.conf.Configuration)config);
            this.server.start();
            this.serverPort = this.server.getWebServerPort();
        }
        catch (Exception e) {
            Assertions.fail((String)"Web server failed to start");
        }
    }

    @AfterEach
    public void stop() throws Exception {
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
    }

    private static TimelineEntity newEntity(String type, String id) {
        TimelineEntity entity = new TimelineEntity();
        entity.setIdentifier(new TimelineEntity.Identifier(type, id));
        return entity;
    }

    private static void verifyHttpResponse(Client client, URI uri, Response.Status expectedStatus) {
        Response resp = (Response)client.target(uri).request(new String[]{"application/json"}).get(Response.class);
        Assertions.assertNotNull((Object)resp);
        Assertions.assertEquals((int)resp.getStatusInfo().getStatusCode(), (int)expectedStatus.getStatusCode());
    }

    private static Client createClient() {
        ClientConfig cfg = new ClientConfig();
        cfg.register(YarnJacksonJaxbJsonProvider.class);
        cfg.connectorProvider((ConnectorProvider)new HttpUrlConnectorProvider().connectionFactory((HttpUrlConnectorProvider.ConnectionFactory)new DummyURLConnectionFactory()));
        return ClientBuilder.newClient((Configuration)cfg);
    }

    private static Response getResponse(Client client, URI uri) throws Exception {
        Response resp = (Response)client.target(uri).request(new String[]{"application/json"}).get(Response.class);
        if (resp == null || resp.getStatusInfo().getStatusCode() != Response.Status.OK.getStatusCode()) {
            String msg = new String();
            if (resp != null) {
                msg = String.valueOf(resp.getStatusInfo().getStatusCode());
            }
            throw new IOException("Incorrect response from timeline reader. Status=" + msg);
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAbout() throws Exception {
        URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/");
        try (Client client = (Client)TestTimelineReaderWebServices.createClient().register(TimelineAboutReader.class);){
            Response resp = TestTimelineReaderWebServices.getResponse(client, uri);
            TimelineAbout about = (TimelineAbout)resp.readEntity(TimelineAbout.class);
            Assertions.assertNotNull((Object)about);
            Assertions.assertEquals((Object)"Timeline Reader API", (Object)about.getAbout());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntityDefaultView() throws Exception {
        try (Client client = (Client)TestTimelineReaderWebServices.createClient().register(TimelineEntityReader.class);){
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app/id_1");
            Response resp = TestTimelineReaderWebServices.getResponse(client, uri);
            TimelineEntity entity = (TimelineEntity)resp.readEntity(TimelineEntity.class);
            Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)resp.getMediaType().toString());
            Assertions.assertNotNull((Object)entity);
            Assertions.assertEquals((Object)"id_1", (Object)entity.getId());
            Assertions.assertEquals((Object)"app", (Object)entity.getType());
            Assertions.assertEquals((Long)1425016502000L, (Long)entity.getCreatedTime());
            Assertions.assertEquals((int)0, (int)entity.getConfigs().size());
            Assertions.assertEquals((int)0, (int)entity.getMetrics().size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testGetEntityWithUserAndFlowInfo() throws Exception {
        try (Client client = (Client)TestTimelineReaderWebServices.createClient().register(TimelineEntityReader.class);){
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app/id_1?userid=user1&flowname=flow1&flowrunid=1");
            Response resp = TestTimelineReaderWebServices.getResponse(client, uri);
            TimelineEntity entity = (TimelineEntity)resp.readEntity(TimelineEntity.class);
            Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)resp.getMediaType().toString());
            Assertions.assertNotNull((Object)entity);
            Assertions.assertEquals((Object)"id_1", (Object)entity.getId());
            Assertions.assertEquals((Object)"app", (Object)entity.getType());
            Assertions.assertEquals((Long)1425016502000L, (Long)entity.getCreatedTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testGetEntityCustomFields() throws Exception {
        try (Client client = (Client)TestTimelineReaderWebServices.createClient().register(TimelineEntityReader.class);){
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app/id_1?fields=CONFIGS,Metrics,info");
            Response resp = TestTimelineReaderWebServices.getResponse(client, uri);
            TimelineEntity entity = (TimelineEntity)resp.readEntity(TimelineEntity.class);
            Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)resp.getMediaType().toString());
            Assertions.assertNotNull((Object)entity);
            Assertions.assertEquals((Object)"id_1", (Object)entity.getId());
            Assertions.assertEquals((Object)"app", (Object)entity.getType());
            Assertions.assertEquals((int)3, (int)entity.getConfigs().size());
            Assertions.assertEquals((int)3, (int)entity.getMetrics().size());
            Assertions.assertTrue((boolean)entity.getInfo().containsKey("UID"), (String)"UID should be present");
            Assertions.assertEquals((int)3, (int)entity.getInfo().size());
            Assertions.assertEquals((int)0, (int)entity.getEvents().size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testGetEntityAllFields() throws Exception {
        try (Client client = (Client)TestTimelineReaderWebServices.createClient().register(TimelineEntityReader.class);){
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app/id_1?fields=ALL");
            Response resp = TestTimelineReaderWebServices.getResponse(client, uri);
            TimelineEntity entity = (TimelineEntity)resp.readEntity(TimelineEntity.class);
            Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)resp.getMediaType().toString());
            Assertions.assertNotNull((Object)entity);
            Assertions.assertEquals((Object)"id_1", (Object)entity.getId());
            Assertions.assertEquals((Object)"app", (Object)entity.getType());
            Assertions.assertEquals((int)3, (int)entity.getConfigs().size());
            Assertions.assertEquals((int)3, (int)entity.getMetrics().size());
            Assertions.assertTrue((boolean)entity.getInfo().containsKey("UID"), (String)"UID should be present");
            Assertions.assertEquals((int)3, (int)entity.getInfo().size());
            Assertions.assertEquals((int)2, (int)entity.getEvents().size());
        }
    }

    @Test
    void testGetEntityNotPresent() throws Exception {
        try (Client client = TestTimelineReaderWebServices.createClient();){
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app/id_10");
            TestTimelineReaderWebServices.verifyHttpResponse(client, uri, Response.Status.NOT_FOUND);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testQueryWithoutCluster() throws Exception {
        try (Client client = (Client)((Client)TestTimelineReaderWebServices.createClient().register(TimelineEntityReader.class)).register(TimelineEntitySetReader.class);){
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/apps/app1/entities/app/id_1");
            Response resp = TestTimelineReaderWebServices.getResponse(client, uri);
            TimelineEntity entity = (TimelineEntity)resp.readEntity(TimelineEntity.class);
            Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)resp.getMediaType().toString());
            Assertions.assertNotNull((Object)entity);
            Assertions.assertEquals((Object)"id_1", (Object)entity.getId());
            Assertions.assertEquals((Object)"app", (Object)entity.getType());
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/apps/app1/entities/app");
            resp = TestTimelineReaderWebServices.getResponse(client, uri);
            Set entities = (Set)resp.readEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)resp.getMediaType().toString());
            Assertions.assertNotNull((Object)entities);
            Assertions.assertEquals((int)4, (int)entities.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testGetEntities() throws Exception {
        try (Client client = (Client)TestTimelineReaderWebServices.createClient().register(TimelineEntitySetReader.class);){
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app");
            Response resp = TestTimelineReaderWebServices.getResponse(client, uri);
            Set entities = (Set)resp.readEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)resp.getMediaType().toString());
            Assertions.assertNotNull((Object)entities);
            Assertions.assertEquals((int)4, (int)entities.size());
            Assertions.assertTrue((entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_1")) && entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_2")) && entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_3")) && entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_4")) ? 1 : 0) != 0, (String)"Entities id_1, id_2, id_3 and id_4 should have been present in response");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testGetEntitiesWithLimit() throws Exception {
        try (Client client = (Client)TestTimelineReaderWebServices.createClient().register(TimelineEntitySetReader.class);){
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app?limit=2");
            Response resp = TestTimelineReaderWebServices.getResponse(client, uri);
            Set entities = (Set)resp.readEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)resp.getMediaType().toString());
            Assertions.assertNotNull((Object)entities);
            Assertions.assertEquals((int)2, (int)entities.size());
            Assertions.assertTrue((entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_1")) && entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_4")) ? 1 : 0) != 0, (String)"Entities with id_1 and id_4 should have been present in response based on entity created time.");
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app?limit=3");
            resp = TestTimelineReaderWebServices.getResponse(client, uri);
            entities = (Set)resp.readEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)resp.getMediaType().toString());
            Assertions.assertNotNull((Object)entities);
            Assertions.assertEquals((int)3, (int)entities.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testGetEntitiesBasedOnCreatedTime() throws Exception {
        try (Client client = (Client)TestTimelineReaderWebServices.createClient().register(TimelineEntitySetReader.class);){
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app?createdtimestart=1425016502030&createdtimeend=1425016502060");
            Response resp = TestTimelineReaderWebServices.getResponse(client, uri);
            Set entities = (Set)resp.readEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)resp.getMediaType().toString());
            Assertions.assertNotNull((Object)entities);
            Assertions.assertEquals((int)1, (int)entities.size());
            Assertions.assertTrue((boolean)entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_4")), (String)"Entity with id_4 should have been present in response.");
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app?createdtimeend=1425016502010");
            resp = TestTimelineReaderWebServices.getResponse(client, uri);
            entities = (Set)resp.readEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)resp.getMediaType().toString());
            Assertions.assertNotNull((Object)entities);
            Assertions.assertEquals((int)3, (int)entities.size());
            Assertions.assertFalse((boolean)entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_4")), (String)"Entity with id_4 should not have been present in response.");
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app?createdtimestart=1425016502010");
            resp = TestTimelineReaderWebServices.getResponse(client, uri);
            entities = (Set)resp.readEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)resp.getMediaType().toString());
            Assertions.assertNotNull((Object)entities);
            Assertions.assertEquals((int)1, (int)entities.size());
            Assertions.assertTrue((boolean)entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_4")), (String)"Entity with id_4 should have been present in response.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testGetEntitiesByRelations() throws Exception {
        try (Client client = (Client)TestTimelineReaderWebServices.createClient().register(TimelineEntitySetReader.class);){
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app?relatesto=flow:flow1");
            Response resp = TestTimelineReaderWebServices.getResponse(client, uri);
            Set entities = (Set)resp.readEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)resp.getMediaType().toString());
            Assertions.assertNotNull((Object)entities);
            Assertions.assertEquals((int)1, (int)entities.size());
            Assertions.assertTrue((boolean)entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_1")), (String)"Entity with id_1 should have been present in response.");
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app?isrelatedto=type1:tid1_2,type2:tid2_1%60");
            resp = TestTimelineReaderWebServices.getResponse(client, uri);
            entities = (Set)resp.readEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)resp.getMediaType().toString());
            Assertions.assertNotNull((Object)entities);
            Assertions.assertEquals((int)1, (int)entities.size());
            Assertions.assertTrue((boolean)entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_1")), (String)"Entity with id_1 should have been present in response.");
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app?isrelatedto=type1:tid1_1:tid1_2,type2:tid2_1%60");
            resp = TestTimelineReaderWebServices.getResponse(client, uri);
            entities = (Set)resp.readEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)resp.getMediaType().toString());
            Assertions.assertNotNull((Object)entities);
            Assertions.assertEquals((int)1, (int)entities.size());
            Assertions.assertTrue((boolean)entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_1")), (String)"Entity with id_1 should have been present in response.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testGetEntitiesByConfigFilters() throws Exception {
        try (Client client = (Client)TestTimelineReaderWebServices.createClient().register(TimelineEntitySetReader.class);){
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app?conffilters=config_1%20eq%20123%20AND%20config_3%20eq%20abc");
            Response resp = TestTimelineReaderWebServices.getResponse(client, uri);
            Set entities = (Set)resp.readEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)resp.getMediaType().toString());
            Assertions.assertNotNull((Object)entities);
            Assertions.assertEquals((int)1, (int)entities.size());
            Assertions.assertTrue((boolean)entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_3")), (String)"Entity with id_3 should have been present in response.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testGetEntitiesByInfoFilters() throws Exception {
        try (Client client = (Client)TestTimelineReaderWebServices.createClient().register(TimelineEntitySetReader.class);){
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app?infofilters=info2%20eq%203.5");
            Response resp = TestTimelineReaderWebServices.getResponse(client, uri);
            Set entities = (Set)resp.readEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)resp.getMediaType().toString());
            Assertions.assertNotNull((Object)entities);
            Assertions.assertEquals((int)1, (int)entities.size());
            Assertions.assertTrue((boolean)entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_3")), (String)"Entity with id_3 should have been present in response.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testGetEntitiesByMetricFilters() throws Exception {
        try (Client client = (Client)TestTimelineReaderWebServices.createClient().register(TimelineEntitySetReader.class);){
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app?metricfilters=metric3%20ge%200");
            Response resp = TestTimelineReaderWebServices.getResponse(client, uri);
            Set entities = (Set)resp.readEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)resp.getMediaType().toString());
            Assertions.assertNotNull((Object)entities);
            Assertions.assertEquals((int)2, (int)entities.size());
            Assertions.assertTrue((entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_1")) && entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_2")) ? 1 : 0) != 0, (String)"Entities with id_1 and id_2 should have been present in response.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testGetEntitiesByEventFilters() throws Exception {
        try (Client client = (Client)TestTimelineReaderWebServices.createClient().register(TimelineEntitySetReader.class);){
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app?eventfilters=event_2,event_4");
            Response resp = TestTimelineReaderWebServices.getResponse(client, uri);
            Set entities = (Set)resp.readEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)resp.getMediaType().toString());
            Assertions.assertNotNull((Object)entities);
            Assertions.assertEquals((int)1, (int)entities.size());
            Assertions.assertTrue((boolean)entities.contains(TestTimelineReaderWebServices.newEntity("app", "id_3")), (String)"Entity with id_3 should have been present in response.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testGetEntitiesNoMatch() throws Exception {
        try (Client client = (Client)TestTimelineReaderWebServices.createClient().register(TimelineEntitySetReader.class);){
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app?metricfilters=metric7%20ge%200&isrelatedto=type1:tid1_1:tid1_2,type2:tid2_1%60&relatesto=flow:flow1&eventfilters=event_2,event_4&infofilters=info2%20eq%203.5&createdtimestart=1425016502030&createdtimeend=1425016502060");
            Response resp = TestTimelineReaderWebServices.getResponse(client, uri);
            Set entities = (Set)resp.readEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)resp.getMediaType().toString());
            Assertions.assertNotNull((Object)entities);
            Assertions.assertEquals((int)0, (int)entities.size());
        }
    }

    @Test
    void testInvalidValuesHandling() throws Exception {
        try (Client client = TestTimelineReaderWebServices.createClient();){
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app?flowrunid=a23b");
            TestTimelineReaderWebServices.verifyHttpResponse(client, uri, Response.Status.BAD_REQUEST);
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app/id_1?flowrunid=2ab15");
            TestTimelineReaderWebServices.verifyHttpResponse(client, uri, Response.Status.BAD_REQUEST);
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/app?limit=#$561av");
            TestTimelineReaderWebServices.verifyHttpResponse(client, uri, Response.Status.BAD_REQUEST);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testGetAppAttempts() throws Exception {
        try (Client client = (Client)TestTimelineReaderWebServices.createClient().register(TimelineEntitySetReader.class);){
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/YARN_APPLICATION_ATTEMPT");
            Response resp = TestTimelineReaderWebServices.getResponse(client, uri);
            Set entities = (Set)resp.readEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)resp.getMediaType().toString());
            Assertions.assertNotNull((Object)entities);
            int totalEntities = entities.size();
            Assertions.assertEquals((int)2, (int)totalEntities);
            Assertions.assertTrue((boolean)entities.contains(TestTimelineReaderWebServices.newEntity(TimelineEntityType.YARN_APPLICATION_ATTEMPT.toString(), "app-attempt-1")), (String)"Entity with app-attempt-2 should have been present in response.");
            Assertions.assertTrue((boolean)entities.contains(TestTimelineReaderWebServices.newEntity(TimelineEntityType.YARN_APPLICATION_ATTEMPT.toString(), "app-attempt-2")), (String)"Entity with app-attempt-2 should have been present in response.");
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/appattempts");
            resp = TestTimelineReaderWebServices.getResponse(client, uri);
            entities = (Set)resp.readEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assertions.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)resp.getMediaType());
            Assertions.assertNotNull((Object)entities);
            int retrievedEntity = entities.size();
            Assertions.assertEquals((int)2, (int)retrievedEntity);
            Assertions.assertTrue((boolean)entities.contains(TestTimelineReaderWebServices.newEntity(TimelineEntityType.YARN_APPLICATION_ATTEMPT.toString(), "app-attempt-1")), (String)"Entity with app-attempt-2 should have been present in response.");
            Assertions.assertTrue((boolean)entities.contains(TestTimelineReaderWebServices.newEntity(TimelineEntityType.YARN_APPLICATION_ATTEMPT.toString(), "app-attempt-2")), (String)"Entity with app-attempt-2 should have been present in response.");
            Assertions.assertEquals((int)totalEntities, (int)retrievedEntity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testGetAppAttempt() throws Exception {
        try (Client client = (Client)TestTimelineReaderWebServices.createClient().register(TimelineEntityReader.class);){
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/YARN_APPLICATION_ATTEMPT/app-attempt-1");
            Response resp = TestTimelineReaderWebServices.getResponse(client, uri);
            TimelineEntity entities1 = (TimelineEntity)resp.readEntity((GenericType)new GenericType<TimelineEntity>(){});
            Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)resp.getMediaType().toString());
            Assertions.assertNotNull((Object)entities1);
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/appattempts/app-attempt-1");
            resp = TestTimelineReaderWebServices.getResponse(client, uri);
            TimelineEntity entities2 = (TimelineEntity)resp.readEntity((GenericType)new GenericType<TimelineEntity>(){});
            Assertions.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)resp.getMediaType());
            Assertions.assertNotNull((Object)entities2);
            Assertions.assertEquals((Object)entities1, (Object)entities2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testGetContainers() throws Exception {
        try (Client client = (Client)TestTimelineReaderWebServices.createClient().register(TimelineEntitySetReader.class);){
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/YARN_CONTAINER");
            Response resp = TestTimelineReaderWebServices.getResponse(client, uri);
            Set entities = (Set)resp.readEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)resp.getMediaType().toString());
            Assertions.assertNotNull((Object)entities);
            int totalEntities = entities.size();
            Assertions.assertEquals((int)3, (int)totalEntities);
            Assertions.assertTrue((boolean)entities.contains(TestTimelineReaderWebServices.newEntity(TimelineEntityType.YARN_CONTAINER.toString(), "container_1_1")), (String)"Entity with container_1_1 should have been present in response.");
            Assertions.assertTrue((boolean)entities.contains(TestTimelineReaderWebServices.newEntity(TimelineEntityType.YARN_CONTAINER.toString(), "container_2_1")), (String)"Entity with container_2_1 should have been present in response.");
            Assertions.assertTrue((boolean)entities.contains(TestTimelineReaderWebServices.newEntity(TimelineEntityType.YARN_CONTAINER.toString(), "container_2_2")), (String)"Entity with container_2_2 should have been present in response.");
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/appattempts/app-attempt-1/containers");
            resp = TestTimelineReaderWebServices.getResponse(client, uri);
            entities = (Set)resp.readEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assertions.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)resp.getMediaType());
            Assertions.assertNotNull((Object)entities);
            int retrievedEntity = entities.size();
            Assertions.assertEquals((int)1, (int)retrievedEntity);
            Assertions.assertTrue((boolean)entities.contains(TestTimelineReaderWebServices.newEntity(TimelineEntityType.YARN_CONTAINER.toString(), "container_1_1")), (String)"Entity with container_1_1 should have been present in response.");
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/appattempts/app-attempt-2/containers");
            resp = TestTimelineReaderWebServices.getResponse(client, uri);
            entities = (Set)resp.readEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assertions.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)resp.getMediaType());
            Assertions.assertNotNull((Object)entities);
            Assertions.assertEquals((int)2, (int)entities.size());
            Assertions.assertTrue((boolean)entities.contains(TestTimelineReaderWebServices.newEntity(TimelineEntityType.YARN_CONTAINER.toString(), "container_2_1")), (String)"Entity with container_2_1 should have been present in response.");
            Assertions.assertTrue((boolean)entities.contains(TestTimelineReaderWebServices.newEntity(TimelineEntityType.YARN_CONTAINER.toString(), "container_2_2")), (String)"Entity with container_2_2 should have been present in response.");
            Assertions.assertEquals((int)totalEntities, (int)(retrievedEntity += entities.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testGetContainer() throws Exception {
        try (Client client = (Client)TestTimelineReaderWebServices.createClient().register(TimelineEntityReader.class);){
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/entities/YARN_CONTAINER/container_2_2");
            Response resp = TestTimelineReaderWebServices.getResponse(client, uri);
            TimelineEntity entities1 = (TimelineEntity)resp.readEntity((GenericType)new GenericType<TimelineEntity>(){});
            Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)resp.getMediaType().toString());
            Assertions.assertNotNull((Object)entities1);
            uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/clusters/cluster1/apps/app1/containers/container_2_2");
            resp = TestTimelineReaderWebServices.getResponse(client, uri);
            TimelineEntity entities2 = (TimelineEntity)resp.readEntity((GenericType)new GenericType<TimelineEntity>(){});
            Assertions.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)resp.getMediaType());
            Assertions.assertNotNull((Object)entities2);
            Assertions.assertEquals((Object)entities1, (Object)entities2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testHealthCheck() throws Exception {
        try (Client client = (Client)TestTimelineReaderWebServices.createClient().register(TimelineHealthReader.class);){
            URI uri = URI.create("http://localhost:" + this.serverPort + "/ws/v2/timeline/health");
            Response resp = TestTimelineReaderWebServices.getResponse(client, uri);
            TimelineHealth timelineHealth = (TimelineHealth)resp.readEntity((GenericType)new GenericType<TimelineHealth>(){});
            Assertions.assertEquals((int)200, (int)resp.getStatus());
            Assertions.assertEquals((Object)TimelineHealth.TimelineHealthStatus.RUNNING, (Object)timelineHealth.getHealthStatus());
        }
    }

    private static class DummyURLConnectionFactory
    implements HttpUrlConnectorProvider.ConnectionFactory {
        private DummyURLConnectionFactory() {
        }

        public HttpURLConnection getConnection(URL url) throws IOException {
            try {
                return (HttpURLConnection)url.openConnection();
            }
            catch (UndeclaredThrowableException e) {
                throw new IOException(e.getCause());
            }
        }
    }
}

