/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.flow;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.timelineservice.FlowRunEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollectorContext;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineDataToRetrieve;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineEntityFilters;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineCompareFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineCompareOp;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilterList;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelinePrefixFilter;
import org.apache.hadoop.yarn.server.timelineservice.storage.DataGeneratorForTest;
import org.apache.hadoop.yarn.server.timelineservice.storage.HBaseTimelineReaderImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.HBaseTimelineWriterImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineReader;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.BaseTableRW;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnHelper;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.HBaseTimelineServerUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunColumn;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.TestFlowDataGenerator;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestHBaseStorageFlowRun {
    private static HBaseTestingUtility util;
    private static final String METRIC1 = "MAP_SLOT_MILLIS";
    private static final String METRIC2 = "HDFS_BYTES_READ";

    @BeforeAll
    public static void setupBeforeClass() throws Exception {
        util = new HBaseTestingUtility();
        Configuration conf = util.getConfiguration();
        conf.setInt("hfile.format.version", 3);
        try {
            util.startMiniCluster();
        }
        catch (Exception e) {
            if (e.getClass().getSimpleName().equals("InaccessibleObjectException")) {
                Assumptions.assumeTrue((boolean)false, (String)"Could not start HBase because of HBASE-29234");
            }
            throw e;
        }
        DataGeneratorForTest.createSchema(util.getConfiguration());
    }

    @Test
    public void checkCoProcessorOff() throws Exception, InterruptedException {
        Configuration hbaseConf = util.getConfiguration();
        TableName table = BaseTableRW.getTableName((Configuration)hbaseConf, (String)"yarn.timeline-service.flowrun.table.name", (String)"timelineservice.flowrun");
        Connection conn = null;
        conn = ConnectionFactory.createConnection((Configuration)hbaseConf);
        Admin admin = conn.getAdmin();
        if (admin == null) {
            throw new IOException("Can't check tables since admin is null");
        }
        if (admin.tableExists(table)) {
            util.waitUntilAllRegionsAssigned(table);
            this.checkCoprocessorExists(table, true);
        }
        if (admin.tableExists(table = BaseTableRW.getTableName((Configuration)hbaseConf, (String)"yarn.timeline-service.flowactivity.table.name", (String)"timelineservice.flowactivity"))) {
            util.waitUntilAllRegionsAssigned(table);
            this.checkCoprocessorExists(table, false);
        }
        if (admin.tableExists(table = BaseTableRW.getTableName((Configuration)hbaseConf, (String)"yarn.timeline-service.entity.table.name", (String)"timelineservice.entity"))) {
            util.waitUntilAllRegionsAssigned(table);
            this.checkCoprocessorExists(table, false);
        }
    }

    private void checkCoprocessorExists(TableName table, boolean exists) throws Exception {
        HRegionServer server = util.getRSForFirstRegionInTable(table);
        HBaseTimelineServerUtils.validateFlowRunCoprocessor((HRegionServer)server, (TableName)table, (boolean)exists);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteFlowRunMinMax() throws Exception {
        TimelineEntities te = new TimelineEntities();
        te.addEntity(TestFlowDataGenerator.getEntity1());
        HBaseTimelineWriterImpl hbi = null;
        Configuration c1 = util.getConfiguration();
        String cluster = "testWriteFlowRunMinMaxToHBase_cluster1";
        String user = "testWriteFlowRunMinMaxToHBase_user1";
        String flow = "testing_flowRun_flow_name";
        String flowVersion = "CF7022C10F1354";
        long runid = 1002345678919L;
        String appName = "application_100000000000_1111";
        long minStartTs = 1425026900000L;
        long greaterStartTs = 30000000000000L;
        long endTs = 1439750690000L;
        TimelineEntity entityMinStartTime = TestFlowDataGenerator.getEntityMinStartTime(minStartTs);
        try {
            hbi = new HBaseTimelineWriterImpl();
            hbi.init(c1);
            UserGroupInformation remoteUser = UserGroupInformation.createRemoteUser((String)user);
            hbi.write(new TimelineCollectorContext(cluster, user, flow, flowVersion, Long.valueOf(runid), appName), te, remoteUser);
            te = new TimelineEntities();
            te.addEntity(entityMinStartTime);
            appName = "application_100000000000_3333";
            hbi.write(new TimelineCollectorContext(cluster, user, flow, flowVersion, Long.valueOf(runid), appName), te, remoteUser);
            TimelineEntity entityMaxEndTime = TestFlowDataGenerator.getEntityMaxEndTime(endTs);
            te = new TimelineEntities();
            te.addEntity(entityMaxEndTime);
            appName = "application_100000000000_4444";
            hbi.write(new TimelineCollectorContext(cluster, user, flow, flowVersion, Long.valueOf(runid), appName), te, remoteUser);
            TimelineEntity entityGreaterStartTime = TestFlowDataGenerator.getEntityGreaterStartTime(greaterStartTs);
            te = new TimelineEntities();
            te.addEntity(entityGreaterStartTime);
            appName = "application_1000000000000000_2222";
            hbi.write(new TimelineCollectorContext(cluster, user, flow, flowVersion, Long.valueOf(runid), appName), te, remoteUser);
            hbi.flush();
        }
        finally {
            if (hbi != null) {
                hbi.close();
            }
        }
        Connection conn = ConnectionFactory.createConnection((Configuration)c1);
        Table table1 = conn.getTable(BaseTableRW.getTableName((Configuration)c1, (String)"yarn.timeline-service.flowrun.table.name", (String)"timelineservice.flowrun"));
        byte[] startRow = new FlowRunRowKey(cluster, user, flow, Long.valueOf(runid)).getRowKey();
        Get g = new Get(startRow);
        g.addColumn(FlowRunColumnFamily.INFO.getBytes(), FlowRunColumn.MIN_START_TIME.getColumnQualifierBytes());
        g.addColumn(FlowRunColumnFamily.INFO.getBytes(), FlowRunColumn.MAX_END_TIME.getColumnQualifierBytes());
        Result r1 = table1.get(g);
        Assertions.assertNotNull((Object)r1);
        Assertions.assertTrue((!r1.isEmpty() ? 1 : 0) != 0);
        NavigableMap values = r1.getFamilyMap(FlowRunColumnFamily.INFO.getBytes());
        Assertions.assertEquals((int)2, (int)r1.size());
        long starttime = Bytes.toLong((byte[])((byte[])values.get(FlowRunColumn.MIN_START_TIME.getColumnQualifierBytes())));
        Assertions.assertEquals((long)minStartTs, (long)starttime);
        Assertions.assertEquals((long)endTs, (long)Bytes.toLong((byte[])((byte[])values.get(FlowRunColumn.MAX_END_TIME.getColumnQualifierBytes()))));
        try (HBaseTimelineReaderImpl hbr = null;){
            hbr = new HBaseTimelineReaderImpl();
            hbr.init(c1);
            hbr.start();
            TimelineEntity entity = hbr.getEntity(new TimelineReaderContext(cluster, user, flow, Long.valueOf(runid), null, TimelineEntityType.YARN_FLOW_RUN.toString(), null), new TimelineDataToRetrieve());
            Assertions.assertTrue((boolean)TimelineEntityType.YARN_FLOW_RUN.matches(entity.getType()));
            FlowRunEntity flowRun = (FlowRunEntity)entity;
            Assertions.assertEquals((long)minStartTs, (long)flowRun.getStartTime());
            Assertions.assertEquals((long)endTs, (long)flowRun.getMaxEndTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteFlowRunMetricsOneFlow() throws Exception {
        String cluster = "testWriteFlowRunMetricsOneFlow_cluster1";
        String user = "testWriteFlowRunMetricsOneFlow_user1";
        String flow = "testing_flowRun_metrics_flow_name";
        String flowVersion = "CF7022C10F1354";
        long runid = 1002345678919L;
        TimelineEntities te = new TimelineEntities();
        TimelineEntity entityApp1 = TestFlowDataGenerator.getEntityMetricsApp1(System.currentTimeMillis());
        te.addEntity(entityApp1);
        Configuration c1 = util.getConfiguration();
        try (HBaseTimelineWriterImpl hbi = null;){
            hbi = new HBaseTimelineWriterImpl();
            hbi.init(c1);
            UserGroupInformation remoteUser = UserGroupInformation.createRemoteUser((String)user);
            String appName = "application_11111111111111_1111";
            hbi.write(new TimelineCollectorContext(cluster, user, flow, flowVersion, Long.valueOf(runid), appName), te, remoteUser);
            te = new TimelineEntities();
            TimelineEntity entityApp2 = TestFlowDataGenerator.getEntityMetricsApp2(System.currentTimeMillis());
            te.addEntity(entityApp2);
            appName = "application_11111111111111_2222";
            hbi.write(new TimelineCollectorContext(cluster, user, flow, flowVersion, Long.valueOf(runid), appName), te, remoteUser);
            hbi.flush();
        }
        this.checkFlowRunTable(cluster, user, flow, runid, c1);
        this.checkFlowRunTableBatchLimit(cluster, user, flow, runid, c1);
        try (HBaseTimelineReaderImpl hbr = null;){
            hbr = new HBaseTimelineReaderImpl();
            hbr.init(c1);
            hbr.start();
            TimelineEntity entity = hbr.getEntity(new TimelineReaderContext(cluster, user, flow, Long.valueOf(runid), null, TimelineEntityType.YARN_FLOW_RUN.toString(), null), new TimelineDataToRetrieve());
            Assertions.assertTrue((boolean)TimelineEntityType.YARN_FLOW_RUN.matches(entity.getType()));
            Set metrics = entity.getMetrics();
            Assertions.assertEquals((int)2, (int)metrics.size());
            block14: for (TimelineMetric metric : metrics) {
                String id = metric.getId();
                Map values = metric.getValues();
                Assertions.assertEquals((int)1, (int)values.size());
                Number value = null;
                Object object = values.values().iterator();
                while (object.hasNext()) {
                    Number n;
                    value = n = (Number)object.next();
                }
                switch (id) {
                    case "MAP_SLOT_MILLIS": {
                        Assertions.assertEquals((Object)141L, (Object)value);
                        continue block14;
                    }
                    case "HDFS_BYTES_READ": {
                        Assertions.assertEquals((Object)57L, (Object)value);
                        continue block14;
                    }
                }
                Assertions.fail((String)("unrecognized metric: " + id));
            }
        }
    }

    void checkFlowRunTableBatchLimit(String cluster, String user, String flow, long runid, Configuration c1) throws IOException {
        NavigableMap values;
        Scan s = new Scan();
        s.addFamily(FlowRunColumnFamily.INFO.getBytes());
        byte[] startRow = new FlowRunRowKey(cluster, user, flow, Long.valueOf(runid)).getRowKey();
        s.setStartRow(startRow);
        int batchLimit = 2;
        s.setBatch(batchLimit);
        String clusterStop = cluster + "1";
        byte[] stopRow = new FlowRunRowKey(clusterStop, user, flow, Long.valueOf(runid)).getRowKey();
        s.setStopRow(stopRow);
        Connection conn = ConnectionFactory.createConnection((Configuration)c1);
        Table table1 = conn.getTable(BaseTableRW.getTableName((Configuration)c1, (String)"yarn.timeline-service.flowrun.table.name", (String)"timelineservice.flowrun"));
        ResultScanner scanner = table1.getScanner(s);
        int loopCount = 0;
        for (Result result : scanner) {
            Assertions.assertNotNull((Object)result);
            Assertions.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
            Assertions.assertTrue((result.rawCells().length <= batchLimit ? 1 : 0) != 0);
            values = result.getFamilyMap(FlowRunColumnFamily.INFO.getBytes());
            Assertions.assertNotNull((Object)values);
            Assertions.assertTrue((values.size() <= batchLimit ? 1 : 0) != 0);
            ++loopCount;
        }
        Assertions.assertTrue((loopCount > 0 ? 1 : 0) != 0);
        s = new Scan();
        s.addFamily(FlowRunColumnFamily.INFO.getBytes());
        s.setStartRow(startRow);
        batchLimit = 1;
        s.setBatch(batchLimit);
        s.setMaxResultsPerColumnFamily(2);
        s.setStopRow(stopRow);
        scanner = table1.getScanner(s);
        loopCount = 0;
        for (Result result : scanner) {
            Assertions.assertNotNull((Object)result);
            Assertions.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
            Assertions.assertEquals((int)batchLimit, (int)result.rawCells().length);
            values = result.getFamilyMap(FlowRunColumnFamily.INFO.getBytes());
            Assertions.assertNotNull((Object)values);
            Assertions.assertEquals((int)batchLimit, (int)values.size());
            ++loopCount;
        }
        Assertions.assertTrue((loopCount > 0 ? 1 : 0) != 0);
        s = new Scan();
        s.addFamily(FlowRunColumnFamily.INFO.getBytes());
        s.setStartRow(startRow);
        batchLimit = 100;
        s.setBatch(batchLimit);
        s.setStopRow(stopRow);
        scanner = table1.getScanner(s);
        loopCount = 0;
        for (Result result : scanner) {
            Assertions.assertNotNull((Object)result);
            Assertions.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
            Assertions.assertTrue((result.rawCells().length <= batchLimit ? 1 : 0) != 0);
            values = result.getFamilyMap(FlowRunColumnFamily.INFO.getBytes());
            Assertions.assertNotNull((Object)values);
            Assertions.assertTrue((values.size() <= batchLimit ? 1 : 0) != 0);
            Assertions.assertTrue((values.size() == 3 ? 1 : 0) != 0);
            ++loopCount;
        }
        Assertions.assertTrue((loopCount == 1 ? 1 : 0) != 0);
        s = new Scan();
        s.addFamily(FlowRunColumnFamily.INFO.getBytes());
        s.setStartRow(startRow);
        batchLimit = -671;
        s.setBatch(batchLimit);
        s.setStopRow(stopRow);
        scanner = table1.getScanner(s);
        loopCount = 0;
        for (Result result : scanner) {
            Assertions.assertNotNull((Object)result);
            Assertions.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
            Assertions.assertEquals((int)3, (int)result.rawCells().length);
            values = result.getFamilyMap(FlowRunColumnFamily.INFO.getBytes());
            Assertions.assertNotNull((Object)values);
            Assertions.assertEquals((int)3, (int)values.size());
            ++loopCount;
        }
        Assertions.assertEquals((int)1, (int)loopCount);
        s = new Scan();
        s.addFamily(FlowRunColumnFamily.INFO.getBytes());
        s.setStartRow(startRow);
        batchLimit = 0;
        s.setBatch(batchLimit);
        s.setStopRow(stopRow);
        scanner = table1.getScanner(s);
        loopCount = 0;
        for (Result result : scanner) {
            Assertions.assertNotNull((Object)result);
            Assertions.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
            Assertions.assertEquals((int)3, (int)result.rawCells().length);
            values = result.getFamilyMap(FlowRunColumnFamily.INFO.getBytes());
            Assertions.assertNotNull((Object)values);
            Assertions.assertEquals((int)3, (int)values.size());
            ++loopCount;
        }
        Assertions.assertEquals((int)1, (int)loopCount);
    }

    private void checkFlowRunTable(String cluster, String user, String flow, long runid, Configuration c1) throws IOException {
        Scan s = new Scan();
        s.addFamily(FlowRunColumnFamily.INFO.getBytes());
        byte[] startRow = new FlowRunRowKey(cluster, user, flow, Long.valueOf(runid)).getRowKey();
        s.setStartRow(startRow);
        String clusterStop = cluster + "1";
        byte[] stopRow = new FlowRunRowKey(clusterStop, user, flow, Long.valueOf(runid)).getRowKey();
        s.setStopRow(stopRow);
        Connection conn = ConnectionFactory.createConnection((Configuration)c1);
        Table table1 = conn.getTable(BaseTableRW.getTableName((Configuration)c1, (String)"yarn.timeline-service.flowrun.table.name", (String)"timelineservice.flowrun"));
        ResultScanner scanner = table1.getScanner(s);
        int rowCount = 0;
        for (Result result : scanner) {
            Assertions.assertNotNull((Object)result);
            Assertions.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
            NavigableMap values = result.getFamilyMap(FlowRunColumnFamily.INFO.getBytes());
            ++rowCount;
            byte[] q = ColumnHelper.getColumnQualifier((byte[])FlowRunColumnPrefix.METRIC.getColumnPrefixBytes(), (String)METRIC1);
            Assertions.assertTrue((boolean)values.containsKey(q));
            Assertions.assertEquals((long)141L, (long)Bytes.toLong((byte[])((byte[])values.get(q))));
            Assertions.assertEquals((int)3, (int)values.size());
            q = ColumnHelper.getColumnQualifier((byte[])FlowRunColumnPrefix.METRIC.getColumnPrefixBytes(), (String)METRIC2);
            Assertions.assertTrue((boolean)values.containsKey(q));
            Assertions.assertEquals((long)57L, (long)Bytes.toLong((byte[])((byte[])values.get(q))));
        }
        Assertions.assertEquals((int)1, (int)rowCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteFlowRunMetricsPrefix() throws Exception {
        String cluster = "testWriteFlowRunMetricsPrefix_cluster1";
        String user = "testWriteFlowRunMetricsPrefix_user1";
        String flow = "testWriteFlowRunMetricsPrefix_flow_name";
        String flowVersion = "CF7022C10F1354";
        TimelineEntities te = new TimelineEntities();
        TimelineEntity entityApp1 = TestFlowDataGenerator.getEntityMetricsApp1(System.currentTimeMillis());
        te.addEntity(entityApp1);
        Configuration c1 = util.getConfiguration();
        try (HBaseTimelineWriterImpl hbi = null;){
            hbi = new HBaseTimelineWriterImpl();
            hbi.init(c1);
            UserGroupInformation remoteUser = UserGroupInformation.createRemoteUser((String)user);
            String appName = "application_11111111111111_1111";
            hbi.write(new TimelineCollectorContext(cluster, user, flow, flowVersion, Long.valueOf(1002345678919L), appName), te, remoteUser);
            te = new TimelineEntities();
            TimelineEntity entityApp2 = TestFlowDataGenerator.getEntityMetricsApp2(System.currentTimeMillis());
            te.addEntity(entityApp2);
            appName = "application_11111111111111_2222";
            hbi.write(new TimelineCollectorContext(cluster, user, flow, flowVersion, Long.valueOf(1002345678918L), appName), te, remoteUser);
            hbi.flush();
        }
        try (HBaseTimelineReaderImpl hbr = null;){
            hbr = new HBaseTimelineReaderImpl();
            hbr.init(c1);
            hbr.start();
            TimelineFilterList metricsToRetrieve = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelinePrefixFilter(TimelineCompareOp.EQUAL, METRIC1.substring(0, METRIC1.indexOf("_") + 1))});
            TimelineEntity entity = hbr.getEntity(new TimelineReaderContext(cluster, user, flow, Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_FLOW_RUN.toString(), null), new TimelineDataToRetrieve(null, metricsToRetrieve, null, null, null, null));
            Assertions.assertTrue((boolean)TimelineEntityType.YARN_FLOW_RUN.matches(entity.getType()));
            Set metrics = entity.getMetrics();
            Assertions.assertEquals((int)1, (int)metrics.size());
            block12: for (TimelineMetric metric : metrics) {
                String id = metric.getId();
                Map values = metric.getValues();
                Assertions.assertEquals((int)1, (int)values.size());
                Number value = null;
                Object object = values.values().iterator();
                while (object.hasNext()) {
                    Number n;
                    value = n = (Number)object.next();
                }
                switch (id) {
                    case "MAP_SLOT_MILLIS": {
                        Assertions.assertEquals((Object)40L, (Object)value);
                        continue block12;
                    }
                }
                Assertions.fail((String)("unrecognized metric: " + id));
            }
            Set entities = hbr.getEntities(new TimelineReaderContext(cluster, user, flow, null, null, TimelineEntityType.YARN_FLOW_RUN.toString(), null), new TimelineEntityFilters.Builder().build(), new TimelineDataToRetrieve(null, metricsToRetrieve, null, null, null, null));
            Assertions.assertEquals((int)2, (int)entities.size());
            int metricCnt = 0;
            for (TimelineEntity timelineEntity : entities) {
                metricCnt += timelineEntity.getMetrics().size();
            }
            Assertions.assertEquals((int)2, (int)metricCnt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteFlowRunsMetricFields() throws Exception {
        String cluster = "testWriteFlowRunsMetricFields_cluster1";
        String user = "testWriteFlowRunsMetricFields_user1";
        String flow = "testWriteFlowRunsMetricFields_flow_name";
        String flowVersion = "CF7022C10F1354";
        long runid = 1002345678919L;
        TimelineEntities te = new TimelineEntities();
        TimelineEntity entityApp1 = TestFlowDataGenerator.getEntityMetricsApp1(System.currentTimeMillis());
        te.addEntity(entityApp1);
        Configuration c1 = util.getConfiguration();
        try (HBaseTimelineWriterImpl hbi = null;){
            hbi = new HBaseTimelineWriterImpl();
            hbi.init(c1);
            UserGroupInformation remoteUser = UserGroupInformation.createRemoteUser((String)user);
            String appName = "application_11111111111111_1111";
            hbi.write(new TimelineCollectorContext(cluster, user, flow, flowVersion, Long.valueOf(runid), appName), te, remoteUser);
            te = new TimelineEntities();
            TimelineEntity entityApp2 = TestFlowDataGenerator.getEntityMetricsApp2(System.currentTimeMillis());
            te.addEntity(entityApp2);
            appName = "application_11111111111111_2222";
            hbi.write(new TimelineCollectorContext(cluster, user, flow, flowVersion, Long.valueOf(runid), appName), te, remoteUser);
            hbi.flush();
        }
        this.checkFlowRunTable(cluster, user, flow, runid, c1);
        try (HBaseTimelineReaderImpl hbr = null;){
            hbr = new HBaseTimelineReaderImpl();
            hbr.init(c1);
            hbr.start();
            Set entities = hbr.getEntities(new TimelineReaderContext(cluster, user, flow, Long.valueOf(runid), null, TimelineEntityType.YARN_FLOW_RUN.toString(), null), new TimelineEntityFilters.Builder().build(), new TimelineDataToRetrieve());
            Assertions.assertEquals((int)1, (int)entities.size());
            for (TimelineEntity timelineEntity : entities) {
                Assertions.assertEquals((int)0, (int)timelineEntity.getMetrics().size());
            }
            entities = hbr.getEntities(new TimelineReaderContext(cluster, user, flow, Long.valueOf(runid), null, TimelineEntityType.YARN_FLOW_RUN.toString(), null), new TimelineEntityFilters.Builder().build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.METRICS), null, null, null));
            Assertions.assertEquals((int)1, (int)entities.size());
            for (TimelineEntity timelineEntity : entities) {
                Set timelineMetrics = timelineEntity.getMetrics();
                Assertions.assertEquals((int)2, (int)timelineMetrics.size());
                block16: for (TimelineMetric metric : timelineMetrics) {
                    String id = metric.getId();
                    Map values = metric.getValues();
                    Assertions.assertEquals((int)1, (int)values.size());
                    Number value = null;
                    Object object = values.values().iterator();
                    while (object.hasNext()) {
                        Number n;
                        value = n = (Number)object.next();
                    }
                    switch (id) {
                        case "MAP_SLOT_MILLIS": {
                            Assertions.assertEquals((Object)141L, (Object)value);
                            continue block16;
                        }
                        case "HDFS_BYTES_READ": {
                            Assertions.assertEquals((Object)57L, (Object)value);
                            continue block16;
                        }
                    }
                    Assertions.fail((String)("unrecognized metric: " + id));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteFlowRunFlush() throws Exception {
        String cluster = "atestFlushFlowRun_cluster1";
        String user = "atestFlushFlowRun__user1";
        String flow = "atestFlushFlowRun_flow_name";
        String flowVersion = "AF1021C19F1351";
        long runid = 1449526652000L;
        int start = 10;
        int count = 20000;
        int appIdSuffix = 1;
        HBaseTimelineWriterImpl hbi = null;
        long insertTs = 1449796654827L - (long)count;
        long minTS = insertTs + 1L;
        long startTs = insertTs;
        Configuration c1 = util.getConfiguration();
        TimelineEntities te1 = null;
        TimelineEntity entityApp1 = null;
        TimelineEntity entityApp2 = null;
        try {
            hbi = new HBaseTimelineWriterImpl();
            hbi.init(c1);
            UserGroupInformation remoteUser = UserGroupInformation.createRemoteUser((String)user);
            for (int i = start; i < count; ++i) {
                String appName = "application_1060350000000_" + appIdSuffix;
                te1 = new TimelineEntities();
                entityApp1 = TestFlowDataGenerator.getMinFlushEntity(++insertTs);
                te1.addEntity(entityApp1);
                entityApp2 = TestFlowDataGenerator.getMaxFlushEntity(insertTs);
                te1.addEntity(entityApp2);
                hbi.write(new TimelineCollectorContext(cluster, user, flow, flowVersion, Long.valueOf(runid), appName), te1, remoteUser);
                Thread.sleep(1L);
                appName = "application_1001199480000_7" + appIdSuffix;
                ++appIdSuffix;
                te1 = new TimelineEntities();
                entityApp1 = TestFlowDataGenerator.getMinFlushEntity(++insertTs);
                te1.addEntity(entityApp1);
                entityApp2 = TestFlowDataGenerator.getMaxFlushEntity(insertTs);
                te1.addEntity(entityApp2);
                hbi.write(new TimelineCollectorContext(cluster, user, flow, flowVersion, Long.valueOf(runid), appName), te1, remoteUser);
                if (i % 1000 != 0) continue;
                hbi.flush();
                this.checkMinMaxFlush(c1, minTS, startTs, count, cluster, user, flow, runid, false);
            }
        }
        finally {
            if (hbi != null) {
                hbi.flush();
                hbi.close();
            }
            this.checkMinMaxFlush(c1, minTS, startTs, count, cluster, user, flow, runid, true);
        }
    }

    private void checkMinMaxFlush(Configuration c1, long minTS, long startTs, int count, String cluster, String user, String flow, long runid, boolean checkMax) throws IOException {
        Connection conn = ConnectionFactory.createConnection((Configuration)c1);
        Table table1 = conn.getTable(BaseTableRW.getTableName((Configuration)c1, (String)"yarn.timeline-service.flowrun.table.name", (String)"timelineservice.flowrun"));
        byte[] startRow = new FlowRunRowKey(cluster, user, flow, Long.valueOf(runid)).getRowKey();
        Get g = new Get(startRow);
        g.addColumn(FlowRunColumnFamily.INFO.getBytes(), FlowRunColumn.MIN_START_TIME.getColumnQualifierBytes());
        g.addColumn(FlowRunColumnFamily.INFO.getBytes(), FlowRunColumn.MAX_END_TIME.getColumnQualifierBytes());
        Result r1 = table1.get(g);
        Assertions.assertNotNull((Object)r1);
        Assertions.assertTrue((!r1.isEmpty() ? 1 : 0) != 0);
        NavigableMap values = r1.getFamilyMap(FlowRunColumnFamily.INFO.getBytes());
        int start = 10;
        Assertions.assertEquals((int)2, (int)r1.size());
        long starttime = Bytes.toLong((byte[])((byte[])values.get(FlowRunColumn.MIN_START_TIME.getColumnQualifierBytes())));
        Assertions.assertEquals((long)minTS, (long)starttime);
        if (checkMax) {
            Assertions.assertEquals((long)(startTs + (long)(2 * (count - start)) + 10000L), (long)Bytes.toLong((byte[])((byte[])values.get(FlowRunColumn.MAX_END_TIME.getColumnQualifierBytes()))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFilterFlowRunsByCreatedTime() throws Exception {
        String cluster = "cluster2";
        String user = "user2";
        String flow = "flow_name2";
        TimelineEntities te = new TimelineEntities();
        TimelineEntity entityApp1 = TestFlowDataGenerator.getEntityMetricsApp1(System.currentTimeMillis());
        entityApp1.setCreatedTime(Long.valueOf(1425016501000L));
        te.addEntity(entityApp1);
        Configuration c1 = util.getConfiguration();
        try (HBaseTimelineWriterImpl hbi = null;){
            hbi = new HBaseTimelineWriterImpl();
            hbi.init(c1);
            UserGroupInformation remoteUser = UserGroupInformation.createRemoteUser((String)user);
            hbi.write(new TimelineCollectorContext(cluster, user, flow, "CF7022C10F1354", Long.valueOf(1002345678919L), "application_11111111111111_1111"), te, remoteUser);
            te = new TimelineEntities();
            TimelineEntity entityApp2 = TestFlowDataGenerator.getEntityMetricsApp2(System.currentTimeMillis());
            entityApp2.setCreatedTime(Long.valueOf(1425016502000L));
            te.addEntity(entityApp2);
            hbi.write(new TimelineCollectorContext(cluster, user, flow, "CF7022C10F1354", Long.valueOf(1002345678918L), "application_11111111111111_2222"), te, remoteUser);
            hbi.flush();
        }
        try (HBaseTimelineReaderImpl hbr = null;){
            hbr = new HBaseTimelineReaderImpl();
            hbr.init(c1);
            hbr.start();
            Set entities = hbr.getEntities(new TimelineReaderContext(cluster, user, flow, null, null, TimelineEntityType.YARN_FLOW_RUN.toString(), null), new TimelineEntityFilters.Builder().createdTimeBegin(Long.valueOf(1425016501000L)).createTimeEnd(Long.valueOf(1425016502001L)).build(), new TimelineDataToRetrieve());
            Assertions.assertEquals((int)2, (int)entities.size());
            for (TimelineEntity entity : entities) {
                if (entity.getId().equals("user2@flow_name2/1002345678918") || entity.getId().equals("user2@flow_name2/1002345678919")) continue;
                Assertions.fail((String)"Entities with flow runs 1002345678918 and 1002345678919should be present.");
            }
            entities = hbr.getEntities(new TimelineReaderContext(cluster, user, flow, null, null, TimelineEntityType.YARN_FLOW_RUN.toString(), null), new TimelineEntityFilters.Builder().createdTimeBegin(Long.valueOf(1425016501050L)).build(), new TimelineDataToRetrieve());
            Assertions.assertEquals((int)1, (int)entities.size());
            for (TimelineEntity entity : entities) {
                if (entity.getId().equals("user2@flow_name2/1002345678918")) continue;
                Assertions.fail((String)"Entity with flow run 1002345678918 should be present.");
            }
            entities = hbr.getEntities(new TimelineReaderContext(cluster, user, flow, null, null, TimelineEntityType.YARN_FLOW_RUN.toString(), null), new TimelineEntityFilters.Builder().createTimeEnd(Long.valueOf(1425016501050L)).build(), new TimelineDataToRetrieve());
            Assertions.assertEquals((int)1, (int)entities.size());
            for (TimelineEntity entity : entities) {
                if (entity.getId().equals("user2@flow_name2/1002345678919")) continue;
                Assertions.fail((String)"Entity with flow run 1002345678919 should be present.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetricFilters() throws Exception {
        String cluster = "cluster1";
        String user = "user1";
        String flow = "flow_name1";
        TimelineEntities te = new TimelineEntities();
        TimelineEntity entityApp1 = TestFlowDataGenerator.getEntityMetricsApp1(System.currentTimeMillis());
        te.addEntity(entityApp1);
        Configuration c1 = util.getConfiguration();
        try (HBaseTimelineWriterImpl hbi = null;){
            hbi = new HBaseTimelineWriterImpl();
            hbi.init(c1);
            UserGroupInformation remoteUser = UserGroupInformation.createRemoteUser((String)user);
            hbi.write(new TimelineCollectorContext(cluster, user, flow, "CF7022C10F1354", Long.valueOf(1002345678919L), "application_11111111111111_1111"), te, remoteUser);
            te = new TimelineEntities();
            TimelineEntity entityApp2 = TestFlowDataGenerator.getEntityMetricsApp2(System.currentTimeMillis());
            te.addEntity(entityApp2);
            hbi.write(new TimelineCollectorContext(cluster, user, flow, "CF7022C10F1354", Long.valueOf(1002345678918L), "application_11111111111111_2222"), te, remoteUser);
            hbi.flush();
        }
        try (HBaseTimelineReaderImpl hbr = null;){
            hbr = new HBaseTimelineReaderImpl();
            hbr.init(c1);
            hbr.start();
            TimelineFilterList list1 = new TimelineFilterList();
            list1.addFilter((TimelineFilter)new TimelineCompareFilter(TimelineCompareOp.GREATER_OR_EQUAL, METRIC1, (Object)101));
            TimelineFilterList list2 = new TimelineFilterList();
            list2.addFilter((TimelineFilter)new TimelineCompareFilter(TimelineCompareOp.LESS_THAN, METRIC1, (Object)43));
            list2.addFilter((TimelineFilter)new TimelineCompareFilter(TimelineCompareOp.EQUAL, METRIC2, (Object)57));
            TimelineFilterList metricFilterList = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{list1, list2});
            Set entities = hbr.getEntities(new TimelineReaderContext(cluster, user, flow, null, null, TimelineEntityType.YARN_FLOW_RUN.toString(), null), new TimelineEntityFilters.Builder().metricFilters(metricFilterList).build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.METRICS), null, null, null));
            Assertions.assertEquals((int)2, (int)entities.size());
            int metricCnt = 0;
            for (Object entity : entities) {
                metricCnt += entity.getMetrics().size();
            }
            Assertions.assertEquals((int)3, (int)metricCnt);
            TimelineFilterList metricFilterList1 = new TimelineFilterList(new TimelineFilter[]{new TimelineCompareFilter(TimelineCompareOp.LESS_OR_EQUAL, METRIC1, (Object)127), new TimelineCompareFilter(TimelineCompareOp.NOT_EQUAL, METRIC2, (Object)30)});
            entities = hbr.getEntities(new TimelineReaderContext(cluster, user, flow, null, null, TimelineEntityType.YARN_FLOW_RUN.toString(), null), new TimelineEntityFilters.Builder().metricFilters(metricFilterList1).build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.METRICS), null, null, null));
            Assertions.assertEquals((int)1, (int)entities.size());
            metricCnt = 0;
            for (TimelineEntity entity : entities) {
                metricCnt += entity.getMetrics().size();
            }
            Assertions.assertEquals((int)2, (int)metricCnt);
            TimelineFilterList metricFilterList2 = new TimelineFilterList(new TimelineFilter[]{new TimelineCompareFilter(TimelineCompareOp.LESS_THAN, METRIC1, (Object)32), new TimelineCompareFilter(TimelineCompareOp.NOT_EQUAL, METRIC2, (Object)57)});
            entities = hbr.getEntities(new TimelineReaderContext(cluster, user, flow, null, null, TimelineEntityType.YARN_FLOW_RUN.toString(), null), new TimelineEntityFilters.Builder().metricFilters(metricFilterList2).build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.METRICS), null, null, null));
            Assertions.assertEquals((int)0, (int)entities.size());
            TimelineFilterList metricFilterList3 = new TimelineFilterList(new TimelineFilter[]{new TimelineCompareFilter(TimelineCompareOp.EQUAL, "s_metric", (Object)32)});
            entities = hbr.getEntities(new TimelineReaderContext(cluster, user, flow, null, null, TimelineEntityType.YARN_FLOW_RUN.toString(), null), new TimelineEntityFilters.Builder().metricFilters(metricFilterList3).build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.METRICS), null, null, null));
            Assertions.assertEquals((int)0, (int)entities.size());
            TimelineFilterList list3 = new TimelineFilterList();
            list3.addFilter((TimelineFilter)new TimelineCompareFilter(TimelineCompareOp.GREATER_OR_EQUAL, METRIC1, (Object)101));
            TimelineFilterList list4 = new TimelineFilterList();
            list4.addFilter((TimelineFilter)new TimelineCompareFilter(TimelineCompareOp.LESS_THAN, METRIC1, (Object)43));
            list4.addFilter((TimelineFilter)new TimelineCompareFilter(TimelineCompareOp.EQUAL, METRIC2, (Object)57));
            TimelineFilterList metricFilterList4 = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{list3, list4});
            TimelineFilterList metricsToRetrieve = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelinePrefixFilter(TimelineCompareOp.EQUAL, METRIC2.substring(0, METRIC2.indexOf("_") + 1))});
            entities = hbr.getEntities(new TimelineReaderContext(cluster, user, flow, null, null, TimelineEntityType.YARN_FLOW_RUN.toString(), null), new TimelineEntityFilters.Builder().metricFilters(metricFilterList4).build(), new TimelineDataToRetrieve(null, metricsToRetrieve, EnumSet.of(TimelineReader.Field.ALL), null, null, null));
            Assertions.assertEquals((int)2, (int)entities.size());
            metricCnt = 0;
            for (TimelineEntity entity : entities) {
                metricCnt += entity.getMetrics().size();
            }
            Assertions.assertEquals((int)1, (int)metricCnt);
        }
    }

    @AfterAll
    public static void tearDownAfterClass() throws Exception {
        if (util != null) {
            util.shutdownMiniCluster();
        }
    }
}

