/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.api.records.timelineservice.ApplicationEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollectorContext;
import org.apache.hadoop.yarn.server.timelineservice.storage.DataGeneratorForTest;
import org.apache.hadoop.yarn.server.timelineservice.storage.HBaseTimelineWriterImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineStorageMonitor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestTimelineWriterHBaseDown {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=300L)
    public void testTimelineWriterHBaseDown() throws Exception {
        block11: {
            HBaseTestingUtility util = new HBaseTestingUtility();
            HBaseTimelineWriterImpl writer = new HBaseTimelineWriterImpl();
            try {
                boolean exceptionCaught;
                block10: {
                    util.startMiniCluster();
                    Configuration c1 = util.getConfiguration();
                    c1.setLong("yarn.timeline-service.reader.storage-monitor.interval-ms", 5000L);
                    writer.init(c1);
                    writer.start();
                    DataGeneratorForTest.createSchema(util.getConfiguration());
                    TimelineStorageMonitor storageMonitor = writer.getTimelineStorageMonitor();
                    this.waitForHBaseToUp(storageMonitor);
                    try {
                        storageMonitor.checkStorageIsUp();
                    }
                    catch (IOException e) {
                        Assertions.fail((String)"HBaseStorageMonitor failed to detect HBase Up");
                    }
                    util.shutdownMiniHBaseCluster();
                    this.waitForHBaseToDown(storageMonitor);
                    TimelineEntities te = new TimelineEntities();
                    ApplicationEntity entity = new ApplicationEntity();
                    String appId = "application_1000178881110_2002";
                    entity.setId(appId);
                    Long cTime = 1425016501000L;
                    entity.setCreatedTime(cTime);
                    te.addEntity((TimelineEntity)entity);
                    exceptionCaught = false;
                    try {
                        writer.write(new TimelineCollectorContext("ATS1", "user1", "flow2", "AB7822C10F1111", Long.valueOf(1002345678919L), appId), te, UserGroupInformation.createRemoteUser((String)"user1"));
                    }
                    catch (IOException e) {
                        if (!e.getMessage().equals("HBase is down")) break block10;
                        exceptionCaught = true;
                    }
                }
                Assertions.assertTrue((boolean)exceptionCaught, (String)"HBaseStorageMonitor failed to detect HBase Down");
            }
            catch (Exception e) {
                if (e.getClass().getSimpleName().equals("InaccessibleObjectException")) {
                    Assumptions.assumeTrue((boolean)false, (String)"Could not start HBase because of HBASE-29234");
                    break block11;
                }
                throw e;
            }
            finally {
                writer.stop();
                util.shutdownMiniCluster();
            }
        }
    }

    public void waitForHBaseToUp(TimelineStorageMonitor storageMonitor) throws Exception {
        GenericTestUtils.waitFor(() -> {
            try {
                storageMonitor.checkStorageIsUp();
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }, (long)1000L, (long)150000L);
    }

    public void waitForHBaseToDown(TimelineStorageMonitor storageMonitor) throws Exception {
        GenericTestUtils.waitFor(() -> {
            try {
                storageMonitor.checkStorageIsUp();
                return false;
            }
            catch (IOException e) {
                return true;
            }
        }, (long)1000L, (long)150000L);
    }
}

