/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderServer;
import org.apache.hadoop.yarn.server.timelineservice.storage.DataGeneratorForTest;
import org.apache.hadoop.yarn.server.timelineservice.storage.HBaseStorageMonitor;
import org.apache.hadoop.yarn.server.timelineservice.storage.HBaseTimelineReaderImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestTimelineReaderHBaseDown {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=300L)
    public void testTimelineReaderHBaseUp() throws Exception {
        block6: {
            HBaseTestingUtility util = new HBaseTestingUtility();
            TestTimelineReaderHBaseDown.configure(util);
            try {
                util.startMiniCluster();
                DataGeneratorForTest.createSchema(util.getConfiguration());
                DataGeneratorForTest.loadApps(util, System.currentTimeMillis());
                TimelineReaderServer server = TestTimelineReaderHBaseDown.getTimelineReaderServer();
                server.init(util.getConfiguration());
                HBaseTimelineReaderImpl htr = TestTimelineReaderHBaseDown.getHBaseTimelineReaderImpl(server);
                server.start();
                TestTimelineReaderHBaseDown.checkQuery(htr);
            }
            catch (Exception e) {
                if (e.getClass().getSimpleName().equals("InaccessibleObjectException")) {
                    Assumptions.assumeTrue((boolean)false, (String)"Could not start HBase because of HBASE-29234");
                    break block6;
                }
                throw e;
            }
            finally {
                util.shutdownMiniCluster();
            }
        }
    }

    @Test
    @Timeout(value=300L)
    public void testTimelineReaderInitWhenHBaseIsDown() throws TimeoutException, InterruptedException {
        HBaseTestingUtility util = new HBaseTestingUtility();
        TestTimelineReaderHBaseDown.configure(util);
        TimelineReaderServer server = TestTimelineReaderHBaseDown.getTimelineReaderServer();
        server.init(util.getConfiguration());
        HBaseTimelineReaderImpl htr = TestTimelineReaderHBaseDown.getHBaseTimelineReaderImpl(server);
        server.start();
        TestTimelineReaderHBaseDown.waitForHBaseDown(htr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=300L)
    public void testTimelineReaderDetectsHBaseDown() throws Exception {
        block6: {
            HBaseTestingUtility util = new HBaseTestingUtility();
            TestTimelineReaderHBaseDown.configure(util);
            try {
                util.startMiniCluster();
                DataGeneratorForTest.createSchema(util.getConfiguration());
                DataGeneratorForTest.loadApps(util, System.currentTimeMillis());
                TimelineReaderServer server = TestTimelineReaderHBaseDown.getTimelineReaderServer();
                server.init(util.getConfiguration());
                HBaseTimelineReaderImpl htr = TestTimelineReaderHBaseDown.getHBaseTimelineReaderImpl(server);
                util.shutdownMiniHBaseCluster();
                server.start();
                TestTimelineReaderHBaseDown.waitForHBaseDown(htr);
            }
            catch (Exception e) {
                if (e.getClass().getSimpleName().equals("InaccessibleObjectException")) {
                    Assumptions.assumeTrue((boolean)false, (String)"Could not start HBase because of HBASE-29234");
                    break block6;
                }
                throw e;
            }
            finally {
                util.shutdownMiniCluster();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=300L)
    public void testTimelineReaderDetectsZooKeeperDown() throws Exception {
        block6: {
            HBaseTestingUtility util = new HBaseTestingUtility();
            TestTimelineReaderHBaseDown.configure(util);
            try {
                util.startMiniCluster();
                DataGeneratorForTest.createSchema(util.getConfiguration());
                DataGeneratorForTest.loadApps(util, System.currentTimeMillis());
                TimelineReaderServer server = TestTimelineReaderHBaseDown.getTimelineReaderServer();
                server.init(util.getConfiguration());
                HBaseTimelineReaderImpl htr = TestTimelineReaderHBaseDown.getHBaseTimelineReaderImpl(server);
                util.shutdownMiniCluster();
                server.start();
                TestTimelineReaderHBaseDown.waitForHBaseDown(htr);
            }
            catch (Exception e) {
                if (e.getClass().getSimpleName().equals("InaccessibleObjectException")) {
                    Assumptions.assumeTrue((boolean)false, (String)"Could not start HBase because of HBASE-29234");
                    break block6;
                }
                throw e;
            }
            finally {
                util.shutdownMiniCluster();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=300L)
    public void testTimelineReaderRecoversAfterHBaseReturns() throws Exception {
        block6: {
            HBaseTestingUtility util = new HBaseTestingUtility();
            TestTimelineReaderHBaseDown.configure(util);
            try {
                util.startMiniCluster();
                DataGeneratorForTest.createSchema(util.getConfiguration());
                DataGeneratorForTest.loadApps(util, System.currentTimeMillis());
                TimelineReaderServer server = TestTimelineReaderHBaseDown.getTimelineReaderServer();
                server.init(util.getConfiguration());
                HBaseTimelineReaderImpl htr = TestTimelineReaderHBaseDown.getHBaseTimelineReaderImpl(server);
                util.shutdownMiniHBaseCluster();
                server.start();
                TestTimelineReaderHBaseDown.waitForHBaseDown(htr);
                util.startMiniHBaseCluster(1, 1);
                GenericTestUtils.waitFor(() -> {
                    try {
                        htr.getTimelineStorageMonitor().checkStorageIsUp();
                        return true;
                    }
                    catch (IOException e) {
                        return false;
                    }
                }, (long)1000L, (long)150000L);
            }
            catch (Exception e) {
                if (e.getClass().getSimpleName().equals("InaccessibleObjectException")) {
                    Assumptions.assumeTrue((boolean)false, (String)"Could not start HBase because of HBASE-29234");
                    break block6;
                }
                throw e;
            }
            finally {
                util.shutdownMiniCluster();
            }
        }
    }

    private static void waitForHBaseDown(HBaseTimelineReaderImpl htr) throws TimeoutException, InterruptedException {
        try {
            GenericTestUtils.waitFor(() -> {
                try {
                    htr.getTimelineStorageMonitor().checkStorageIsUp();
                    return false;
                }
                catch (IOException e) {
                    return true;
                }
            }, (long)1000L, (long)150000L);
            TestTimelineReaderHBaseDown.checkQuery(htr);
            Assertions.fail((String)"Query should fail when HBase is down");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)"HBase is down", (Object)e.getMessage());
        }
    }

    private static Set<TimelineEntity> checkQuery(HBaseTimelineReaderImpl htr) throws IOException {
        TimelineReaderContext context = new TimelineReaderContext("yarn_cluster", null, null, null, null, TimelineEntityType.YARN_FLOW_ACTIVITY.toString(), null, null);
        return htr.getEntities(context, HBaseStorageMonitor.MONITOR_FILTERS, HBaseStorageMonitor.DATA_TO_RETRIEVE);
    }

    private static void configure(HBaseTestingUtility util) {
        Configuration config = util.getConfiguration();
        config.setBoolean("yarn.timeline-service.enabled", true);
        config.setFloat("yarn.timeline-service.version", 2.0f);
        config.set("yarn.timeline-service.reader.webapp.address", "localhost:0");
        config.set("yarn.resourcemanager.cluster-id", "cluster1");
        config.set("yarn.timeline-service.reader.class", "org.apache.hadoop.yarn.server.timelineservice.storage.HBaseTimelineReaderImpl");
        config.setInt("hfile.format.version", 3);
        config.setLong("yarn.timeline-service.reader.storage-monitor.interval-ms", 5000L);
        Path tmpDir = new Path(config.get("hadoop.tmp.dir", "target/build/test"), "httpfs");
        config.set("hadoop.http.temp.dir", tmpDir.toString());
    }

    private static TimelineReaderServer getTimelineReaderServer() {
        return new TimelineReaderServer(){

            protected void addFilters(Configuration conf) {
            }
        };
    }

    private static HBaseTimelineReaderImpl getHBaseTimelineReaderImpl(TimelineReaderServer server) {
        for (Service s : server.getServices()) {
            if (!(s instanceof HBaseTimelineReaderImpl)) continue;
            return (HBaseTimelineReaderImpl)s;
        }
        throw new IllegalStateException("Couldn't find HBaseTimelineReaderImpl");
    }
}

