/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.yarn.server.timelineservice.storage.DataGeneratorForTest;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.BaseTableRW;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestHBaseTimelineStorageSchema {
    private static HBaseTestingUtility util;

    @BeforeAll
    public static void setupBeforeClass() throws Exception {
        util = new HBaseTestingUtility();
        Configuration conf = util.getConfiguration();
        conf.setInt("hfile.format.version", 3);
        try {
            util.startMiniCluster();
        }
        catch (Exception e) {
            if (e.getClass().getSimpleName().equals("InaccessibleObjectException")) {
                Assumptions.assumeTrue((boolean)false, (String)"Could not start HBase because of HBASE-29234");
            }
            throw e;
        }
    }

    @Test
    public void createWithDefaultPrefix() throws IOException {
        Configuration hbaseConf = util.getConfiguration();
        DataGeneratorForTest.createSchema(hbaseConf);
        Connection conn = null;
        conn = ConnectionFactory.createConnection((Configuration)hbaseConf);
        Admin admin = conn.getAdmin();
        TableName entityTableName = BaseTableRW.getTableName((Configuration)hbaseConf, (String)"yarn.timeline-service.entity.table.name", (String)"timelineservice.entity");
        Assertions.assertTrue((boolean)admin.tableExists(entityTableName));
        Assertions.assertTrue((boolean)entityTableName.getNameAsString().startsWith("prod."));
        Table entityTable = conn.getTable(BaseTableRW.getTableName((Configuration)hbaseConf, (String)"yarn.timeline-service.entity.table.name", (String)"timelineservice.entity"));
        Assertions.assertNotNull((Object)entityTable);
        TableName flowRunTableName = BaseTableRW.getTableName((Configuration)hbaseConf, (String)"yarn.timeline-service.flowrun.table.name", (String)"timelineservice.flowrun");
        Assertions.assertTrue((boolean)admin.tableExists(flowRunTableName));
        Assertions.assertTrue((boolean)flowRunTableName.getNameAsString().startsWith("prod."));
        Table flowRunTable = conn.getTable(BaseTableRW.getTableName((Configuration)hbaseConf, (String)"yarn.timeline-service.flowrun.table.name", (String)"timelineservice.flowrun"));
        Assertions.assertNotNull((Object)flowRunTable);
    }

    @Test
    public void createWithSetPrefix() throws IOException {
        Configuration hbaseConf = util.getConfiguration();
        String prefix = "unit-test.";
        hbaseConf.set("yarn.timeline-service.hbase-schema.prefix", prefix);
        DataGeneratorForTest.createSchema(hbaseConf);
        Connection conn = null;
        conn = ConnectionFactory.createConnection((Configuration)hbaseConf);
        Admin admin = conn.getAdmin();
        TableName entityTableName = BaseTableRW.getTableName((Configuration)hbaseConf, (String)"yarn.timeline-service.entity.table.name", (String)"timelineservice.entity");
        Assertions.assertTrue((boolean)admin.tableExists(entityTableName));
        Assertions.assertTrue((boolean)entityTableName.getNameAsString().startsWith(prefix));
        Table entityTable = conn.getTable(BaseTableRW.getTableName((Configuration)hbaseConf, (String)"yarn.timeline-service.entity.table.name", (String)"timelineservice.entity"));
        Assertions.assertNotNull((Object)entityTable);
        TableName flowRunTableName = BaseTableRW.getTableName((Configuration)hbaseConf, (String)"yarn.timeline-service.flowrun.table.name", (String)"timelineservice.flowrun");
        Assertions.assertTrue((boolean)admin.tableExists(flowRunTableName));
        Assertions.assertTrue((boolean)flowRunTableName.getNameAsString().startsWith(prefix));
        Table flowRunTable = conn.getTable(BaseTableRW.getTableName((Configuration)hbaseConf, (String)"yarn.timeline-service.flowrun.table.name", (String)"timelineservice.flowrun"));
        Assertions.assertNotNull((Object)flowRunTable);
        hbaseConf.unset("yarn.timeline-service.hbase-schema.prefix");
        prefix = "yet-another-unit-test.";
        hbaseConf.set("yarn.timeline-service.hbase-schema.prefix", prefix);
        DataGeneratorForTest.createSchema(hbaseConf);
        entityTableName = BaseTableRW.getTableName((Configuration)hbaseConf, (String)"yarn.timeline-service.entity.table.name", (String)"timelineservice.entity");
        Assertions.assertTrue((boolean)admin.tableExists(entityTableName));
        Assertions.assertTrue((boolean)entityTableName.getNameAsString().startsWith(prefix));
        entityTable = conn.getTable(BaseTableRW.getTableName((Configuration)hbaseConf, (String)"yarn.timeline-service.entity.table.name", (String)"timelineservice.entity"));
        Assertions.assertNotNull((Object)entityTable);
        flowRunTableName = BaseTableRW.getTableName((Configuration)hbaseConf, (String)"yarn.timeline-service.flowrun.table.name", (String)"timelineservice.flowrun");
        Assertions.assertTrue((boolean)admin.tableExists(flowRunTableName));
        Assertions.assertTrue((boolean)flowRunTableName.getNameAsString().startsWith(prefix));
        flowRunTable = conn.getTable(BaseTableRW.getTableName((Configuration)hbaseConf, (String)"yarn.timeline-service.flowrun.table.name", (String)"timelineservice.flowrun"));
        Assertions.assertNotNull((Object)flowRunTable);
        hbaseConf.unset("yarn.timeline-service.hbase-schema.prefix");
    }

    @AfterAll
    public static void tearDownAfterClass() throws Exception {
        if (util != null) {
            try {
                util.shutdownMiniCluster();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

