/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage;

import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.timelineservice.ApplicationEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetricOperation;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollectorContext;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineDataToRetrieve;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineEntityFilters;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineCompareFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineCompareOp;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineExistsFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilterList;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineKeyValueFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineKeyValuesFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelinePrefixFilter;
import org.apache.hadoop.yarn.server.timelineservice.storage.DataGeneratorForTest;
import org.apache.hadoop.yarn.server.timelineservice.storage.HBaseTimelineReaderImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.HBaseTimelineWriterImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineReader;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationColumn;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationTableRW;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Column;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnRWHelper;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.EventColumnName;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.EventColumnNameConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.HBaseTimelineSchemaUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.KeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.StringKeyConverter;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHBaseTimelineStorageApps {
    private static HBaseTestingUtility util;
    private HBaseTimelineReaderImpl reader;
    private static final long CURRENT_TIME;

    @BeforeAll
    public static void setupBeforeClass() throws Exception {
        util = new HBaseTestingUtility();
        try {
            util.startMiniCluster();
        }
        catch (Exception e) {
            if (e.getClass().getSimpleName().equals("InaccessibleObjectException")) {
                Assumptions.assumeTrue((boolean)false, (String)"Could not start HBase because of HBASE-29234");
            }
            throw e;
        }
        DataGeneratorForTest.createSchema(util.getConfiguration());
        DataGeneratorForTest.loadApps(util, CURRENT_TIME);
    }

    @BeforeEach
    public void init() throws Exception {
        this.reader = new HBaseTimelineReaderImpl();
        this.reader.init(util.getConfiguration());
        this.reader.start();
    }

    @AfterEach
    public void stop() throws Exception {
        if (this.reader != null) {
            this.reader.stop();
            this.reader.close();
        }
    }

    private static void matchMetrics(Map<Long, Number> m1, Map<Long, Number> m2) {
        Assertions.assertEquals((int)m1.size(), (int)m2.size());
        for (Map.Entry<Long, Number> entry : m2.entrySet()) {
            Number val = m1.get(entry.getKey());
            Assertions.assertNotNull((Object)val);
            Assertions.assertEquals((long)val.longValue(), (long)entry.getValue().longValue());
        }
    }

    private boolean isApplicationRowKeyCorrect(byte[] rowKey, String cluster, String user, String flow, Long runid, String appName) {
        ApplicationRowKey key = ApplicationRowKey.parseRowKey((byte[])rowKey);
        Assertions.assertEquals((Object)cluster, (Object)key.getClusterId());
        Assertions.assertEquals((Object)user, (Object)key.getUserId());
        Assertions.assertEquals((Object)flow, (Object)key.getFlowName());
        Assertions.assertEquals((Long)runid, (Long)key.getFlowRunId());
        Assertions.assertEquals((Object)appName, (Object)key.getAppId());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteNullApplicationToHBase() throws Exception {
        TimelineEntities te = new TimelineEntities();
        ApplicationEntity entity = new ApplicationEntity();
        String appId = "application_1000178881110_2002";
        entity.setId(appId);
        long cTime = 1425016501000L;
        entity.setCreatedTime(Long.valueOf(cTime));
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        infoMap.put("in fo M apK  ey1", "infoMapValue1");
        infoMap.put("infoMapKey2", 10);
        entity.addInfo(infoMap);
        te.addEntity((TimelineEntity)entity);
        HBaseTimelineWriterImpl hbi = null;
        try {
            Configuration c1 = util.getConfiguration();
            hbi = new HBaseTimelineWriterImpl();
            hbi.init(c1);
            hbi.start();
            String cluster = "cluster_check_null_application";
            String user = "user1check_null_application";
            String flow = null;
            String flowVersion = "AB7822C10F1111";
            long runid = 1002345678919L;
            hbi.write(new TimelineCollectorContext(cluster, user, flow, flowVersion, Long.valueOf(runid), appId), te, UserGroupInformation.createRemoteUser((String)user));
            hbi.stop();
            Scan scan = new Scan();
            scan.setStartRow(Bytes.toBytes((String)cluster));
            scan.setStopRow(Bytes.toBytes((String)(cluster + "1")));
            Connection conn = ConnectionFactory.createConnection((Configuration)c1);
            ResultScanner resultScanner = new ApplicationTableRW().getResultScanner(c1, conn, scan);
            Assertions.assertTrue((resultScanner != null ? 1 : 0) != 0);
            int count = 0;
            Result rr = resultScanner.next();
            while (rr != null) {
                ++count;
                rr = resultScanner.next();
            }
            Assertions.assertEquals((int)0, (int)count);
        }
        finally {
            if (hbi != null) {
                hbi.stop();
                hbi.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteApplicationToHBase() throws Exception {
        TimelineEntities te = new TimelineEntities();
        ApplicationEntity entity = new ApplicationEntity();
        String appId = "application_1000178881110_2002";
        entity.setId(appId);
        Long cTime = 1425016501000L;
        entity.setCreatedTime(cTime);
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        infoMap.put("infoMapKey1", "infoMapValue1");
        infoMap.put("infoMapKey2", 10);
        entity.addInfo(infoMap);
        String key = "task";
        String value = "is_related_to_entity_id_here";
        HashSet<String> isRelatedToSet = new HashSet<String>();
        isRelatedToSet.add(value);
        HashMap<String, HashSet<String>> isRelatedTo = new HashMap<String, HashSet<String>>();
        isRelatedTo.put(key, isRelatedToSet);
        entity.setIsRelatedToEntities(isRelatedTo);
        key = "container";
        value = "relates_to_entity_id_here";
        HashSet<String> relatesToSet = new HashSet<String>();
        relatesToSet.add(value);
        value = "relates_to_entity_id_here_Second";
        relatesToSet.add(value);
        HashMap<String, HashSet<String>> relatesTo = new HashMap<String, HashSet<String>>();
        relatesTo.put(key, relatesToSet);
        entity.setRelatesToEntities(relatesTo);
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("config_param1", "value1");
        conf.put("config_param2", "value2");
        entity.addConfigs(conf);
        HashSet<TimelineMetric> metrics = new HashSet<TimelineMetric>();
        TimelineMetric m1 = new TimelineMetric();
        m1.setId("MAP_SLOT_MILLIS");
        HashMap<Long, Number> metricValues = new HashMap<Long, Number>();
        metricValues.put(CURRENT_TIME - 120000L, 100000000);
        metricValues.put(CURRENT_TIME - 100000L, 200000000);
        metricValues.put(CURRENT_TIME - 80000L, 300000000);
        metricValues.put(CURRENT_TIME - 60000L, 400000000);
        metricValues.put(CURRENT_TIME - 40000L, 50000000000L);
        metricValues.put(CURRENT_TIME - 20000L, 60000000000L);
        m1.setType(TimelineMetric.Type.TIME_SERIES);
        m1.setValues(metricValues);
        metrics.add(m1);
        entity.addMetrics(metrics);
        TimelineEntity aggEntity = new TimelineEntity();
        String type = TimelineEntityType.YARN_APPLICATION.toString();
        aggEntity.setId(appId);
        aggEntity.setType(type);
        long cTime2 = 1425016502000L;
        aggEntity.setCreatedTime(Long.valueOf(cTime2));
        TimelineMetric aggMetric = new TimelineMetric();
        aggMetric.setId("MEM_USAGE");
        HashMap<Long, Number> aggMetricValues = new HashMap<Long, Number>();
        long aggTs = CURRENT_TIME;
        aggMetricValues.put(aggTs - 120000L, 102400000L);
        aggMetric.setType(TimelineMetric.Type.SINGLE_VALUE);
        aggMetric.setRealtimeAggregationOp(TimelineMetricOperation.SUM);
        aggMetric.setValues(aggMetricValues);
        HashSet<TimelineMetric> aggMetrics = new HashSet<TimelineMetric>();
        aggMetrics.add(aggMetric);
        entity.addMetrics(aggMetrics);
        te.addEntity((TimelineEntity)entity);
        HBaseTimelineWriterImpl hbi = null;
        try {
            Map metricValues2;
            Configuration c1 = util.getConfiguration();
            hbi = new HBaseTimelineWriterImpl();
            hbi.init(c1);
            hbi.start();
            String cluster = "cluster_test_write_app";
            String user = "user1";
            String flow = "s!ome_f\tlow  _n am!e";
            String flowVersion = "AB7822C10F1111";
            long runid = 1002345678919L;
            hbi.write(new TimelineCollectorContext(cluster, user, flow, flowVersion, Long.valueOf(runid), appId), te, UserGroupInformation.createRemoteUser((String)user));
            entity = new ApplicationEntity();
            appId = "application_1000178881110_2002";
            entity.setId(appId);
            HashMap<String, String> infoMap1 = new HashMap<String, String>();
            infoMap1.put("infoMapKey3", "infoMapValue1");
            entity.addInfo(infoMap1);
            te = new TimelineEntities();
            te.addEntity((TimelineEntity)entity);
            hbi.write(new TimelineCollectorContext(cluster, user, flow, flowVersion, Long.valueOf(runid), appId), te, UserGroupInformation.createRemoteUser((String)user));
            hbi.stop();
            infoMap.putAll(infoMap1);
            ApplicationRowKey applicationRowKey = new ApplicationRowKey(cluster, user, flow, Long.valueOf(runid), appId);
            byte[] rowKey = applicationRowKey.getRowKey();
            Get get = new Get(rowKey);
            get.setMaxVersions(Integer.MAX_VALUE);
            Connection conn = ConnectionFactory.createConnection((Configuration)c1);
            Result result = new ApplicationTableRW().getResult(c1, conn, get);
            Assertions.assertTrue((result != null ? 1 : 0) != 0);
            Assertions.assertEquals((int)17, (int)result.size());
            byte[] row1 = result.getRow();
            Assertions.assertTrue((boolean)this.isApplicationRowKeyCorrect(row1, cluster, user, flow, runid, appId));
            String id1 = ColumnRWHelper.readResult((Result)result, (Column)ApplicationColumn.ID).toString();
            Assertions.assertEquals((Object)appId, (Object)id1);
            Long cTime1 = (Long)ColumnRWHelper.readResult((Result)result, (Column)ApplicationColumn.CREATED_TIME);
            Assertions.assertEquals((Long)cTime, (Long)cTime1);
            Map infoColumns = ColumnRWHelper.readResults((Result)result, (ColumnPrefix)ApplicationColumnPrefix.INFO, (KeyConverter)new StringKeyConverter());
            Assertions.assertEquals(infoMap, (Object)infoColumns);
            for (Map.Entry isRelatedToEntry : isRelatedTo.entrySet()) {
                Object isRelatedToValue = ColumnRWHelper.readResult((Result)result, (ColumnPrefix)ApplicationColumnPrefix.IS_RELATED_TO, (String)((String)isRelatedToEntry.getKey()));
                String compoundValue = isRelatedToValue.toString();
                HashSet isRelatedToValues = new HashSet(Separator.VALUES.splitEncoded(compoundValue));
                Assertions.assertEquals((int)((Set)isRelatedTo.get(isRelatedToEntry.getKey())).size(), (int)isRelatedToValues.size());
                for (String v : (Set)isRelatedToEntry.getValue()) {
                    Assertions.assertTrue((boolean)isRelatedToValues.contains(v));
                }
            }
            for (Map.Entry relatesToEntry : relatesTo.entrySet()) {
                String compoundValue = ColumnRWHelper.readResult((Result)result, (ColumnPrefix)ApplicationColumnPrefix.RELATES_TO, (String)((String)relatesToEntry.getKey())).toString();
                HashSet relatesToValues = new HashSet(Separator.VALUES.splitEncoded(compoundValue));
                Assertions.assertEquals((int)((Set)relatesTo.get(relatesToEntry.getKey())).size(), (int)relatesToValues.size());
                for (String v : (Set)relatesToEntry.getValue()) {
                    Assertions.assertTrue((boolean)relatesToValues.contains(v));
                }
            }
            StringKeyConverter stringKeyConverter = new StringKeyConverter();
            Map configColumns = ColumnRWHelper.readResults((Result)result, (ColumnPrefix)ApplicationColumnPrefix.CONFIG, (KeyConverter)stringKeyConverter);
            Assertions.assertEquals(conf, (Object)configColumns);
            NavigableMap metricsResult = ColumnRWHelper.readResultsWithTimestamps((Result)result, (ColumnPrefix)ApplicationColumnPrefix.METRIC, (KeyConverter)stringKeyConverter);
            NavigableMap metricMap = (NavigableMap)metricsResult.get(m1.getId());
            TestHBaseTimelineStorageApps.matchMetrics(metricValues, metricMap);
            TimelineEntity e1 = this.reader.getEntity(new TimelineReaderContext(cluster, user, flow, Long.valueOf(runid), appId, entity.getType(), entity.getId()), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.ALL), Integer.valueOf(Integer.MAX_VALUE), null, null));
            Assertions.assertNotNull((Object)e1);
            Assertions.assertEquals((Object)appId, (Object)e1.getId());
            Assertions.assertEquals((Object)TimelineEntityType.YARN_APPLICATION.toString(), (Object)e1.getType());
            Assertions.assertEquals((Long)cTime, (Long)e1.getCreatedTime());
            Map infoMap2 = e1.getInfo();
            infoMap2.remove("FROM_ID");
            Assertions.assertEquals(infoMap, (Object)infoMap2);
            Map isRelatedTo2 = e1.getIsRelatedToEntities();
            Assertions.assertEquals(isRelatedTo, (Object)isRelatedTo2);
            Map relatesTo2 = e1.getRelatesToEntities();
            Assertions.assertEquals(relatesTo, (Object)relatesTo2);
            Map conf2 = e1.getConfigs();
            Assertions.assertEquals(conf, (Object)conf2);
            Set metrics2 = e1.getMetrics();
            Assertions.assertEquals((int)2, (int)metrics2.size());
            for (TimelineMetric metric2 : metrics2) {
                metricValues2 = metric2.getValues();
                Assertions.assertTrue((metric2.getId().equals("MAP_SLOT_MILLIS") || metric2.getId().equals("MEM_USAGE") ? 1 : 0) != 0);
                if (metric2.getId().equals("MAP_SLOT_MILLIS")) {
                    Assertions.assertEquals((int)6, (int)metricValues2.size());
                    TestHBaseTimelineStorageApps.matchMetrics(metricValues, metricValues2);
                }
                if (!metric2.getId().equals("MEM_USAGE")) continue;
                Assertions.assertEquals((int)1, (int)metricValues2.size());
                TestHBaseTimelineStorageApps.matchMetrics(aggMetricValues, metricValues2);
            }
            e1 = this.reader.getEntity(new TimelineReaderContext(cluster, user, flow, Long.valueOf(runid), appId, entity.getType(), entity.getId()), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.ALL), Integer.valueOf(3), null, null));
            Assertions.assertNotNull((Object)e1);
            Assertions.assertEquals((Object)appId, (Object)e1.getId());
            Assertions.assertEquals((Object)TimelineEntityType.YARN_APPLICATION.toString(), (Object)e1.getType());
            Assertions.assertEquals(conf, (Object)e1.getConfigs());
            metrics2 = e1.getMetrics();
            Assertions.assertEquals((int)2, (int)metrics2.size());
            for (TimelineMetric metric2 : metrics2) {
                metricValues2 = metric2.getValues();
                Assertions.assertTrue((metricValues2.size() <= 3 ? 1 : 0) != 0);
                Assertions.assertTrue((metric2.getId().equals("MAP_SLOT_MILLIS") || metric2.getId().equals("MEM_USAGE") ? 1 : 0) != 0);
            }
            e1 = this.reader.getEntity(new TimelineReaderContext(cluster, user, flow, Long.valueOf(runid), appId, entity.getType(), entity.getId()), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.ALL), null, null, null));
            Assertions.assertNotNull((Object)e1);
            Assertions.assertEquals((Object)appId, (Object)e1.getId());
            Assertions.assertEquals((Object)TimelineEntityType.YARN_APPLICATION.toString(), (Object)e1.getType());
            Assertions.assertEquals((Long)cTime, (Long)e1.getCreatedTime());
            infoMap2 = e1.getInfo();
            infoMap2.remove("FROM_ID");
            Assertions.assertEquals(infoMap, (Object)e1.getInfo());
            Assertions.assertEquals(isRelatedTo, (Object)e1.getIsRelatedToEntities());
            Assertions.assertEquals(relatesTo, (Object)e1.getRelatesToEntities());
            Assertions.assertEquals(conf, (Object)e1.getConfigs());
            Assertions.assertEquals((int)2, (int)e1.getMetrics().size());
            for (TimelineMetric metric : e1.getMetrics()) {
                Assertions.assertEquals((int)1, (int)metric.getValues().size());
                Assertions.assertEquals((Object)TimelineMetric.Type.SINGLE_VALUE, (Object)metric.getType());
                Assertions.assertTrue((metric.getId().equals("MAP_SLOT_MILLIS") || metric.getId().equals("MEM_USAGE") ? 1 : 0) != 0);
                Assertions.assertEquals((int)1, (int)metric.getValues().size());
                if (metric.getId().equals("MAP_SLOT_MILLIS")) {
                    Assertions.assertTrue((boolean)metric.getValues().containsKey(CURRENT_TIME - 20000L));
                    Assertions.assertEquals(metricValues.get(CURRENT_TIME - 20000L), metric.getValues().get(CURRENT_TIME - 20000L));
                }
                if (!metric.getId().equals("MEM_USAGE")) continue;
                Assertions.assertTrue((boolean)metric.getValues().containsKey(aggTs - 120000L));
                Assertions.assertEquals(aggMetricValues.get(aggTs - 120000L), metric.getValues().get(aggTs - 120000L));
            }
        }
        finally {
            if (hbi != null) {
                hbi.stop();
                hbi.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEvents() throws IOException {
        TimelineEvent event = new TimelineEvent();
        String eventId = "YARN_APPLICATION_CREATED";
        event.setId(eventId);
        Long expTs = 1436512802000L;
        event.setTimestamp(expTs.longValue());
        String expKey = "foo_event";
        String expVal = "test";
        event.addInfo(expKey, (Object)expVal);
        ApplicationEntity entity = new ApplicationEntity();
        entity.setId(HBaseTimelineSchemaUtils.convertApplicationIdToString((ApplicationId)ApplicationId.newInstance((long)0L, (int)1)));
        entity.addEvent(event);
        TimelineEntities entities = new TimelineEntities();
        entities.addEntity((TimelineEntity)entity);
        HBaseTimelineWriterImpl hbi = null;
        try {
            Configuration c1 = util.getConfiguration();
            hbi = new HBaseTimelineWriterImpl();
            hbi.init(c1);
            hbi.start();
            String cluster = "cluster_test_events";
            String user = "user2";
            String flow = "other_flow_name";
            String flowVersion = "1111F01C2287BA";
            long runid = 1009876543218L;
            String appName = "application_123465899910_1001";
            hbi.write(new TimelineCollectorContext(cluster, user, flow, flowVersion, Long.valueOf(runid), appName), entities, UserGroupInformation.createRemoteUser((String)user));
            hbi.stop();
            ApplicationRowKey applicationRowKey = new ApplicationRowKey(cluster, user, flow, Long.valueOf(runid), appName);
            byte[] rowKey = applicationRowKey.getRowKey();
            Get get = new Get(rowKey);
            get.setMaxVersions(Integer.MAX_VALUE);
            Connection conn = ConnectionFactory.createConnection((Configuration)c1);
            Result result = new ApplicationTableRW().getResult(c1, conn, get);
            Assertions.assertTrue((result != null ? 1 : 0) != 0);
            byte[] row1 = result.getRow();
            Assertions.assertTrue((boolean)this.isApplicationRowKeyCorrect(row1, cluster, user, flow, runid, appName));
            Map eventsResult = ColumnRWHelper.readResults((Result)result, (ColumnPrefix)ApplicationColumnPrefix.EVENT, (KeyConverter)new EventColumnNameConverter());
            Assertions.assertEquals((int)1, (int)eventsResult.size());
            for (Map.Entry e : eventsResult.entrySet()) {
                EventColumnName eventColumnName = (EventColumnName)e.getKey();
                Assertions.assertEquals((Object)eventId, (Object)eventColumnName.getId());
                Assertions.assertEquals((Long)expTs, (Long)eventColumnName.getTimestamp());
                Assertions.assertEquals((Object)expKey, (Object)eventColumnName.getInfoKey());
                Object value = e.getValue();
                Assertions.assertEquals((Object)expVal, (Object)value.toString());
            }
            TimelineEntity e1 = this.reader.getEntity(new TimelineReaderContext(cluster, user, flow, Long.valueOf(runid), appName, entity.getType(), entity.getId()), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.ALL), null, null, null));
            TimelineEntity e2 = this.reader.getEntity(new TimelineReaderContext(cluster, user, null, null, appName, entity.getType(), entity.getId()), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.ALL), null, null, null));
            Assertions.assertNotNull((Object)e1);
            Assertions.assertNotNull((Object)e2);
            Assertions.assertEquals((Object)e1, (Object)e2);
            NavigableSet events = e1.getEvents();
            Assertions.assertEquals((int)1, (int)events.size());
            for (TimelineEvent e : events) {
                Assertions.assertEquals((Object)eventId, (Object)e.getId());
                Assertions.assertEquals((Long)expTs, (Long)e.getTimestamp());
                Map info = e.getInfo();
                Assertions.assertEquals((int)1, (int)info.size());
                for (Map.Entry infoEntry : info.entrySet()) {
                    Assertions.assertEquals((Object)expKey, infoEntry.getKey());
                    Assertions.assertEquals((Object)expVal, infoEntry.getValue());
                }
            }
        }
        finally {
            if (hbi != null) {
                hbi.stop();
                hbi.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonIntegralMetricValues() throws IOException {
        TimelineEntities teApp = new TimelineEntities();
        ApplicationEntity entityApp = new ApplicationEntity();
        String appId = "application_1000178881110_2002";
        entityApp.setId(appId);
        entityApp.setCreatedTime(Long.valueOf(1425016501000L));
        HashSet<TimelineMetric> metricsApp = new HashSet<TimelineMetric>();
        TimelineMetric mApp = new TimelineMetric();
        mApp.setId("MAP_SLOT_MILLIS");
        HashMap<Long, Double> metricAppValues = new HashMap<Long, Double>();
        long ts = System.currentTimeMillis();
        metricAppValues.put(ts - 20L, 10.5);
        metricAppValues.put(ts - 10L, 20.5);
        mApp.setType(TimelineMetric.Type.TIME_SERIES);
        mApp.setValues(metricAppValues);
        metricsApp.add(mApp);
        entityApp.addMetrics(metricsApp);
        teApp.addEntity((TimelineEntity)entityApp);
        TimelineEntities teEntity = new TimelineEntities();
        TimelineEntity entity = new TimelineEntity();
        entity.setId("hello");
        entity.setType("world");
        entity.setCreatedTime(Long.valueOf(1425016501000L));
        HashSet<TimelineMetric> metricsEntity = new HashSet<TimelineMetric>();
        TimelineMetric mEntity = new TimelineMetric();
        mEntity.setId("MAP_SLOT_MILLIS");
        mEntity.addValue(ts - 20L, (Number)10.5);
        metricsEntity.add(mEntity);
        entity.addMetrics(metricsEntity);
        teEntity.addEntity(entity);
        HBaseTimelineWriterImpl hbi = null;
        try {
            Configuration c1 = util.getConfiguration();
            hbi = new HBaseTimelineWriterImpl();
            hbi.init(c1);
            hbi.start();
            TimelineCollectorContext context = new TimelineCollectorContext("c1", "u1", "f1", "v1", Long.valueOf(1002345678919L), appId);
            UserGroupInformation user = UserGroupInformation.createRemoteUser((String)"u1");
            try {
                hbi.write(context, teApp, user);
                Assertions.fail((String)"Expected an exception as metric values are non integral");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                hbi.write(context, teEntity, user);
                Assertions.fail((String)"Expected an exception as metric values are non integral");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            hbi.stop();
        }
        finally {
            if (hbi != null) {
                hbi.stop();
                hbi.close();
            }
        }
    }

    @Test
    public void testReadApps() throws Exception {
        TimelineEntity entity = this.reader.getEntity(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), "application_1111111111_2222", TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.ALL), null, null, null));
        Assertions.assertNotNull((Object)entity);
        Assertions.assertEquals((int)3, (int)entity.getConfigs().size());
        Assertions.assertEquals((int)1, (int)entity.getIsRelatedToEntities().size());
        Set entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.ALL), null, null, null));
        Assertions.assertEquals((int)3, (int)entities.size());
        int cfgCnt = 0;
        int metricCnt = 0;
        int infoCnt = 0;
        int eventCnt = 0;
        int relatesToCnt = 0;
        int isRelatedToCnt = 0;
        for (TimelineEntity timelineEntity : entities) {
            cfgCnt += timelineEntity.getConfigs() == null ? 0 : timelineEntity.getConfigs().size();
            metricCnt += timelineEntity.getMetrics() == null ? 0 : timelineEntity.getMetrics().size();
            infoCnt += timelineEntity.getInfo() == null ? 0 : timelineEntity.getInfo().size();
            eventCnt += timelineEntity.getEvents() == null ? 0 : timelineEntity.getEvents().size();
            relatesToCnt += timelineEntity.getRelatesToEntities() == null ? 0 : timelineEntity.getRelatesToEntities().size();
            isRelatedToCnt += timelineEntity.getIsRelatedToEntities() == null ? 0 : timelineEntity.getIsRelatedToEntities().size();
        }
        Assertions.assertEquals((int)5, (int)cfgCnt);
        Assertions.assertEquals((int)3, (int)metricCnt);
        Assertions.assertEquals((int)8, (int)infoCnt);
        Assertions.assertEquals((int)4, (int)eventCnt);
        Assertions.assertEquals((int)4, (int)relatesToCnt);
        Assertions.assertEquals((int)4, (int)isRelatedToCnt);
    }

    @Test
    public void testFilterAppsByCreatedTime() throws Exception {
        Set entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().createdTimeBegin(Long.valueOf(1425016502000L)).createTimeEnd(Long.valueOf(1425016502040L)).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)3, (int)entities.size());
        for (TimelineEntity entity : entities) {
            if (entity.getId().equals("application_1111111111_2222") || entity.getId().equals("application_1111111111_3333") || entity.getId().equals("application_1111111111_4444")) continue;
            Assertions.fail((String)"Entities with ids' application_1111111111_2222, application_1111111111_3333 and application_1111111111_4444 should be present");
        }
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().createdTimeBegin(Long.valueOf(1425016502015L)).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)2, (int)entities.size());
        for (TimelineEntity entity : entities) {
            if (entity.getId().equals("application_1111111111_3333") || entity.getId().equals("application_1111111111_4444")) continue;
            Assertions.fail((String)"Apps with ids' application_1111111111_3333 and application_1111111111_4444 should be present");
        }
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().createTimeEnd(Long.valueOf(1425016502015L)).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)1, (int)entities.size());
        for (TimelineEntity entity : entities) {
            if (entity.getId().equals("application_1111111111_2222")) continue;
            Assertions.fail((String)"App with id application_1111111111_2222 should be present");
        }
    }

    @Test
    public void testReadAppsDefaultView() throws Exception {
        TimelineEntity e1 = this.reader.getEntity(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), "application_1111111111_2222", TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineDataToRetrieve());
        Assertions.assertNotNull((Object)e1);
        Assertions.assertEquals((int)1, (int)e1.getInfo().size());
        Assertions.assertTrue((e1.getConfigs().isEmpty() && e1.getMetrics().isEmpty() && e1.getIsRelatedToEntities().isEmpty() && e1.getRelatesToEntities().isEmpty() ? 1 : 0) != 0);
        Set es1 = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)3, (int)es1.size());
        for (TimelineEntity e : es1) {
            Assertions.assertEquals((int)1, (int)e1.getInfo().size());
            Assertions.assertTrue((e.getConfigs().isEmpty() && e.getMetrics().isEmpty() && e.getIsRelatedToEntities().isEmpty() && e.getRelatesToEntities().isEmpty() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testReadAppsByFields() throws Exception {
        TimelineEntity e1 = this.reader.getEntity(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), "application_1111111111_2222", TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.INFO, TimelineReader.Field.CONFIGS), null, null, null));
        Assertions.assertNotNull((Object)e1);
        Assertions.assertEquals((int)3, (int)e1.getConfigs().size());
        Assertions.assertEquals((int)0, (int)e1.getIsRelatedToEntities().size());
        Set es1 = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.IS_RELATED_TO, TimelineReader.Field.METRICS), null, null, null));
        Assertions.assertEquals((int)3, (int)es1.size());
        int metricsCnt = 0;
        int isRelatedToCnt = 0;
        int infoCnt = 0;
        for (TimelineEntity entity : es1) {
            metricsCnt += entity.getMetrics().size();
            isRelatedToCnt += entity.getIsRelatedToEntities().size();
            infoCnt += entity.getInfo().size();
        }
        Assertions.assertEquals((int)3, (int)infoCnt);
        Assertions.assertEquals((int)4, (int)isRelatedToCnt);
        Assertions.assertEquals((int)3, (int)metricsCnt);
    }

    @Test
    public void testReadAppsIsRelatedTo() throws Exception {
        TimelineFilterList irt = new TimelineFilterList(TimelineFilterList.Operator.OR);
        irt.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "task", new HashSet<String>(Arrays.asList("relatedto1"))));
        irt.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "task2", new HashSet<String>(Arrays.asList("relatedto4"))));
        Set entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().isRelatedTo(irt).build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.ALL), null, null, null));
        Assertions.assertEquals((int)2, (int)entities.size());
        int isRelatedToCnt = 0;
        for (Object timelineEntity : entities) {
            isRelatedToCnt += timelineEntity.getIsRelatedToEntities().size();
            if (timelineEntity.getId().equals("application_1111111111_2222") || timelineEntity.getId().equals("application_1111111111_3333")) continue;
            Assertions.fail((String)"Entity ids' should have been application_1111111111_2222 and application_1111111111_3333");
        }
        Assertions.assertEquals((int)3, (int)isRelatedToCnt);
        TimelineFilterList irt1 = new TimelineFilterList();
        irt1.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "task1", new HashSet<String>(Arrays.asList("relatedto3"))));
        irt1.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.NOT_EQUAL, "task1", new HashSet<String>(Arrays.asList("relatedto5"))));
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().isRelatedTo(irt1).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)1, (int)entities.size());
        isRelatedToCnt = 0;
        for (Object timelineEntity : entities) {
            isRelatedToCnt += timelineEntity.getIsRelatedToEntities().size();
            if (timelineEntity.getId().equals("application_1111111111_4444")) continue;
            Assertions.fail((String)"Entity id should have been application_1111111111_4444");
        }
        Assertions.assertEquals((int)0, (int)isRelatedToCnt);
        TimelineFilterList irt2 = new TimelineFilterList(TimelineFilterList.Operator.OR);
        irt2.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "task", new HashSet<String>(Arrays.asList("relatedto1"))));
        irt2.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "task2", new HashSet<String>(Arrays.asList("relatedto4"))));
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().isRelatedTo(irt2).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)2, (int)entities.size());
        isRelatedToCnt = 0;
        for (Object timelineEntity : entities) {
            isRelatedToCnt += timelineEntity.getIsRelatedToEntities().size();
            if (timelineEntity.getId().equals("application_1111111111_2222") || timelineEntity.getId().equals("application_1111111111_3333")) continue;
            Assertions.fail((String)"Entity ids' should have been application_1111111111_2222 and application_1111111111_3333");
        }
        Assertions.assertEquals((int)0, (int)isRelatedToCnt);
        TimelineFilterList irt3 = new TimelineFilterList();
        irt3.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "task1", new HashSet<String>(Arrays.asList("relatedto3", "relatedto5"))));
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().isRelatedTo(irt3).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)1, (int)entities.size());
        isRelatedToCnt = 0;
        for (TimelineEntity timelineEntity : entities) {
            isRelatedToCnt += timelineEntity.getIsRelatedToEntities().size();
            if (timelineEntity.getId().equals("application_1111111111_3333")) continue;
            Assertions.fail((String)"Entity id should have been application_1111111111_3333");
        }
        Assertions.assertEquals((int)0, (int)isRelatedToCnt);
        TimelineFilterList irt4 = new TimelineFilterList();
        irt4.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "task1", new HashSet<String>(Arrays.asList("relatedto3"))));
        irt4.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "dummy_task", new HashSet<String>(Arrays.asList("relatedto5"))));
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().isRelatedTo(irt4).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)0, (int)entities.size());
        TimelineFilterList irt5 = new TimelineFilterList();
        irt5.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "task1", new HashSet<String>(Arrays.asList("relatedto3", "relatedto7"))));
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().isRelatedTo(irt5).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)0, (int)entities.size());
        TimelineFilterList list1 = new TimelineFilterList();
        list1.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "task", new HashSet<String>(Arrays.asList("relatedto1"))));
        list1.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "dummy_task", new HashSet<String>(Arrays.asList("relatedto4"))));
        TimelineFilterList list2 = new TimelineFilterList();
        list2.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "task2", new HashSet<String>(Arrays.asList("relatedto4"))));
        TimelineFilterList irt6 = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{list1, list2});
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().isRelatedTo(irt6).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)1, (int)entities.size());
        isRelatedToCnt = 0;
        for (TimelineEntity timelineEntity : entities) {
            isRelatedToCnt += timelineEntity.getIsRelatedToEntities().size();
            if (timelineEntity.getId().equals("application_1111111111_3333")) continue;
            Assertions.fail((String)"Entity id should have been application_1111111111_3333");
        }
        Assertions.assertEquals((int)0, (int)isRelatedToCnt);
    }

    @Test
    public void testReadAppsRelatesTo() throws Exception {
        TimelineFilterList rt = new TimelineFilterList(TimelineFilterList.Operator.OR);
        rt.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "container2", new HashSet<String>(Arrays.asList("relatesto7"))));
        rt.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "container1", new HashSet<String>(Arrays.asList("relatesto4"))));
        Set entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().relatesTo(rt).build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.ALL), null, null, null));
        Assertions.assertEquals((int)2, (int)entities.size());
        int relatesToCnt = 0;
        for (Object timelineEntity : entities) {
            relatesToCnt += timelineEntity.getRelatesToEntities().size();
            if (timelineEntity.getId().equals("application_1111111111_2222") || timelineEntity.getId().equals("application_1111111111_4444")) continue;
            Assertions.fail((String)"Entity ids' should have been application_1111111111_2222 and application_1111111111_4444");
        }
        Assertions.assertEquals((int)3, (int)relatesToCnt);
        TimelineFilterList rt1 = new TimelineFilterList();
        rt1.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "container", new HashSet<String>(Arrays.asList("relatesto1"))));
        rt1.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.NOT_EQUAL, "container", new HashSet<String>(Arrays.asList("relatesto3"))));
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().relatesTo(rt1).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)1, (int)entities.size());
        relatesToCnt = 0;
        for (Object timelineEntity : entities) {
            relatesToCnt += timelineEntity.getRelatesToEntities().size();
            if (timelineEntity.getId().equals("application_1111111111_3333")) continue;
            Assertions.fail((String)"Entity id should have been application_1111111111_3333");
        }
        Assertions.assertEquals((int)0, (int)relatesToCnt);
        TimelineFilterList rt2 = new TimelineFilterList(TimelineFilterList.Operator.OR);
        rt2.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "container2", new HashSet<String>(Arrays.asList("relatesto7"))));
        rt2.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "container1", new HashSet<String>(Arrays.asList("relatesto4"))));
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().relatesTo(rt2).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)2, (int)entities.size());
        relatesToCnt = 0;
        for (Object timelineEntity : entities) {
            relatesToCnt += timelineEntity.getRelatesToEntities().size();
            if (timelineEntity.getId().equals("application_1111111111_2222") || timelineEntity.getId().equals("application_1111111111_4444")) continue;
            Assertions.fail((String)"Entity ids' should have been application_1111111111_2222 and application_1111111111_4444");
        }
        Assertions.assertEquals((int)0, (int)relatesToCnt);
        TimelineFilterList rt3 = new TimelineFilterList();
        rt3.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "container", new HashSet<String>(Arrays.asList("relatesto1", "relatesto3"))));
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().relatesTo(rt3).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)1, (int)entities.size());
        relatesToCnt = 0;
        for (TimelineEntity timelineEntity : entities) {
            relatesToCnt += timelineEntity.getRelatesToEntities().size();
            if (timelineEntity.getId().equals("application_1111111111_2222")) continue;
            Assertions.fail((String)"Entity id should have been application_1111111111_2222");
        }
        Assertions.assertEquals((int)0, (int)relatesToCnt);
        TimelineFilterList rt4 = new TimelineFilterList();
        rt4.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "container", new HashSet<String>(Arrays.asList("relatesto1"))));
        rt4.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "dummy_container", new HashSet<String>(Arrays.asList("relatesto5"))));
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().relatesTo(rt4).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)0, (int)entities.size());
        TimelineFilterList rt5 = new TimelineFilterList();
        rt5.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "container", new HashSet<String>(Arrays.asList("relatedto1", "relatesto8"))));
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().relatesTo(rt5).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)0, (int)entities.size());
        TimelineFilterList list1 = new TimelineFilterList();
        list1.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "container2", new HashSet<String>(Arrays.asList("relatesto7"))));
        list1.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "dummy_container", new HashSet<String>(Arrays.asList("relatesto4"))));
        TimelineFilterList list2 = new TimelineFilterList();
        list2.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "container1", new HashSet<String>(Arrays.asList("relatesto4"))));
        TimelineFilterList rt6 = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{list1, list2});
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().relatesTo(rt6).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)1, (int)entities.size());
        relatesToCnt = 0;
        for (TimelineEntity timelineEntity : entities) {
            relatesToCnt += timelineEntity.getRelatesToEntities().size();
            if (timelineEntity.getId().equals("application_1111111111_2222")) continue;
            Assertions.fail((String)"Entity id should have been application_1111111111_2222");
        }
        Assertions.assertEquals((int)0, (int)relatesToCnt);
        TimelineFilterList list3 = new TimelineFilterList();
        list3.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "container", new HashSet<String>(Arrays.asList("relatesto1"))));
        list3.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "container1", new HashSet<String>(Arrays.asList("relatesto4"))));
        TimelineFilterList list4 = new TimelineFilterList();
        list4.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "container", new HashSet<String>(Arrays.asList("relatesto1"))));
        list4.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "container", new HashSet<String>(Arrays.asList("relatesto2"))));
        TimelineFilterList combinedList = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{list3, list4});
        TimelineFilterList rt7 = new TimelineFilterList(TimelineFilterList.Operator.AND, new TimelineFilter[]{combinedList, new TimelineKeyValuesFilter(TimelineCompareOp.NOT_EQUAL, "container", new HashSet<String>(Arrays.asList("relatesto3")))});
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().relatesTo(rt7).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)1, (int)entities.size());
        relatesToCnt = 0;
        for (TimelineEntity timelineEntity : entities) {
            relatesToCnt += timelineEntity.getRelatesToEntities().size();
            if (timelineEntity.getId().equals("application_1111111111_3333")) continue;
            Assertions.fail((String)"Entity id should have been application_1111111111_3333");
        }
        Assertions.assertEquals((int)0, (int)relatesToCnt);
    }

    @Test
    public void testReadAppsRelationsAndEventFiltersDefaultView() throws Exception {
        TimelineFilterList eventFilter = new TimelineFilterList();
        eventFilter.addFilter((TimelineFilter)new TimelineExistsFilter(TimelineCompareOp.NOT_EQUAL, "end_event"));
        TimelineFilterList relatesTo = new TimelineFilterList(TimelineFilterList.Operator.OR);
        relatesTo.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "container2", new HashSet<String>(Arrays.asList("relatesto7"))));
        relatesTo.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "container1", new HashSet<String>(Arrays.asList("relatesto4"))));
        TimelineFilterList isRelatedTo = new TimelineFilterList();
        isRelatedTo.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.EQUAL, "task1", new HashSet<String>(Arrays.asList("relatedto3"))));
        isRelatedTo.addFilter((TimelineFilter)new TimelineKeyValuesFilter(TimelineCompareOp.NOT_EQUAL, "task1", new HashSet<String>(Arrays.asList("relatedto5"))));
        Set entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().relatesTo(relatesTo).isRelatedTo(isRelatedTo).eventFilters(eventFilter).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)1, (int)entities.size());
        int eventCnt = 0;
        int isRelatedToCnt = 0;
        int relatesToCnt = 0;
        for (TimelineEntity timelineEntity : entities) {
            eventCnt += timelineEntity.getEvents().size();
            isRelatedToCnt += timelineEntity.getIsRelatedToEntities().size();
            relatesToCnt += timelineEntity.getRelatesToEntities().size();
            if (timelineEntity.getId().equals("application_1111111111_4444")) continue;
            Assertions.fail((String)"Entity id should have been application_1111111111_4444");
        }
        Assertions.assertEquals((int)0, (int)eventCnt);
        Assertions.assertEquals((int)0, (int)isRelatedToCnt);
        Assertions.assertEquals((int)0, (int)relatesToCnt);
    }

    @Test
    public void testReadAppsConfigFilters() throws Exception {
        TimelineFilterList list1 = new TimelineFilterList();
        list1.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "cfg_param1", (Object)"value1"));
        list1.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "cfg_param2", (Object)"value2"));
        TimelineFilterList list2 = new TimelineFilterList();
        list2.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "cfg_param1", (Object)"value3"));
        list2.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "config_param2", (Object)"value2"));
        TimelineFilterList confFilterList = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{list1, list2});
        Set entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().configFilters(confFilterList).build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.CONFIGS), null, null, null));
        Assertions.assertEquals((int)2, (int)entities.size());
        int cfgCnt = 0;
        for (Object entity : entities) {
            cfgCnt += entity.getConfigs().size();
        }
        Assertions.assertEquals((int)5, (int)cfgCnt);
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().configFilters(confFilterList).build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.ALL), null, null, null));
        Assertions.assertEquals((int)2, (int)entities.size());
        cfgCnt = 0;
        for (Object entity : entities) {
            cfgCnt += entity.getConfigs().size();
        }
        Assertions.assertEquals((int)5, (int)cfgCnt);
        TimelineFilterList confFilterList1 = new TimelineFilterList(new TimelineFilter[]{new TimelineKeyValueFilter(TimelineCompareOp.NOT_EQUAL, "cfg_param1", (Object)"value1")});
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().configFilters(confFilterList1).build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.CONFIGS), null, null, null));
        Assertions.assertEquals((int)1, (int)entities.size());
        cfgCnt = 0;
        for (TimelineEntity entity : entities) {
            cfgCnt += entity.getConfigs().size();
        }
        Assertions.assertEquals((int)3, (int)cfgCnt);
        TimelineFilterList confFilterList2 = new TimelineFilterList(new TimelineFilter[]{new TimelineKeyValueFilter(TimelineCompareOp.NOT_EQUAL, "cfg_param1", (Object)"value1"), new TimelineKeyValueFilter(TimelineCompareOp.NOT_EQUAL, "config_param2", (Object)"value2")});
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().configFilters(confFilterList2).build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.CONFIGS), null, null, null));
        Assertions.assertEquals((int)0, (int)entities.size());
        TimelineFilterList confFilterList3 = new TimelineFilterList(new TimelineFilter[]{new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "dummy_config", (Object)"value1")});
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().configFilters(confFilterList3).build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.CONFIGS), null, null, null));
        Assertions.assertEquals((int)0, (int)entities.size());
        TimelineFilterList confFilterList4 = new TimelineFilterList(new TimelineFilter[]{new TimelineKeyValueFilter(TimelineCompareOp.NOT_EQUAL, "dummy_config", (Object)"value1")});
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().configFilters(confFilterList4).build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.CONFIGS), null, null, null));
        Assertions.assertEquals((int)0, (int)entities.size());
        TimelineFilterList confFilterList5 = new TimelineFilterList(new TimelineFilter[]{new TimelineKeyValueFilter(TimelineCompareOp.NOT_EQUAL, "dummy_config", (Object)"value1", false)});
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().configFilters(confFilterList5).build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.CONFIGS), null, null, null));
        Assertions.assertEquals((int)3, (int)entities.size());
    }

    @Test
    public void testReadAppsEventFilters() throws Exception {
        TimelineFilterList ef = new TimelineFilterList();
        ef.addFilter((TimelineFilter)new TimelineExistsFilter(TimelineCompareOp.EQUAL, "update_event"));
        ef.addFilter((TimelineFilter)new TimelineExistsFilter(TimelineCompareOp.NOT_EQUAL, "end_event"));
        Set entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().eventFilters(ef).build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.ALL), null, null, null));
        Assertions.assertEquals((int)1, (int)entities.size());
        int eventCnt = 0;
        for (Object timelineEntity : entities) {
            eventCnt += timelineEntity.getEvents().size();
            if (timelineEntity.getId().equals("application_1111111111_4444")) continue;
            Assertions.fail((String)"Entity id should have been application_1111111111_4444");
        }
        Assertions.assertEquals((int)1, (int)eventCnt);
        TimelineFilterList ef1 = new TimelineFilterList();
        ef1.addFilter((TimelineFilter)new TimelineExistsFilter(TimelineCompareOp.EQUAL, "update_event"));
        ef1.addFilter((TimelineFilter)new TimelineExistsFilter(TimelineCompareOp.NOT_EQUAL, "end_event"));
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().eventFilters(ef1).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)1, (int)entities.size());
        eventCnt = 0;
        for (Object timelineEntity : entities) {
            eventCnt += timelineEntity.getEvents().size();
            if (timelineEntity.getId().equals("application_1111111111_4444")) continue;
            Assertions.fail((String)"Entity id should have been application_1111111111_4444");
        }
        Assertions.assertEquals((int)0, (int)eventCnt);
        TimelineFilterList ef2 = new TimelineFilterList();
        ef2.addFilter((TimelineFilter)new TimelineExistsFilter(TimelineCompareOp.NOT_EQUAL, "end_event"));
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().eventFilters(ef2).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)2, (int)entities.size());
        eventCnt = 0;
        for (TimelineEntity timelineEntity : entities) {
            eventCnt += timelineEntity.getEvents().size();
            if (timelineEntity.getId().equals("application_1111111111_2222") || timelineEntity.getId().equals("application_1111111111_4444")) continue;
            Assertions.fail((String)"Entity ids' should have been application_1111111111_2222 and application_1111111111_4444");
        }
        Assertions.assertEquals((int)0, (int)eventCnt);
        TimelineFilterList ef3 = new TimelineFilterList();
        ef3.addFilter((TimelineFilter)new TimelineExistsFilter(TimelineCompareOp.EQUAL, "update_event"));
        ef3.addFilter((TimelineFilter)new TimelineExistsFilter(TimelineCompareOp.EQUAL, "dummy_event"));
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().eventFilters(ef3).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)0, (int)entities.size());
        TimelineFilterList list1 = new TimelineFilterList();
        list1.addFilter((TimelineFilter)new TimelineExistsFilter(TimelineCompareOp.EQUAL, "update_event"));
        list1.addFilter((TimelineFilter)new TimelineExistsFilter(TimelineCompareOp.EQUAL, "dummy_event"));
        TimelineFilterList list2 = new TimelineFilterList();
        list2.addFilter((TimelineFilter)new TimelineExistsFilter(TimelineCompareOp.EQUAL, "start_event"));
        TimelineFilterList ef4 = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{list1, list2});
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().eventFilters(ef4).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)1, (int)entities.size());
        eventCnt = 0;
        for (TimelineEntity timelineEntity : entities) {
            eventCnt += timelineEntity.getEvents().size();
            if (timelineEntity.getId().equals("application_1111111111_2222")) continue;
            Assertions.fail((String)"Entity id should have been application_1111111111_2222");
        }
        Assertions.assertEquals((int)0, (int)eventCnt);
        TimelineFilterList ef5 = new TimelineFilterList();
        ef5.addFilter((TimelineFilter)new TimelineExistsFilter(TimelineCompareOp.NOT_EQUAL, "update_event"));
        ef5.addFilter((TimelineFilter)new TimelineExistsFilter(TimelineCompareOp.NOT_EQUAL, "end_event"));
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().eventFilters(ef5).build(), new TimelineDataToRetrieve());
        Assertions.assertEquals((int)1, (int)entities.size());
        eventCnt = 0;
        for (TimelineEntity timelineEntity : entities) {
            eventCnt += timelineEntity.getEvents().size();
            if (timelineEntity.getId().equals("application_1111111111_2222")) continue;
            Assertions.fail((String)"Entity id should have been application_1111111111_2222");
        }
        Assertions.assertEquals((int)0, (int)eventCnt);
    }

    @Test
    public void testReadAppsConfigPrefix() throws Exception {
        TimelineFilterList list = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelinePrefixFilter(TimelineCompareOp.EQUAL, "cfg_")});
        TimelineEntity e1 = this.reader.getEntity(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), "application_1111111111_2222", TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineDataToRetrieve(list, null, null, null, null, null));
        Assertions.assertNotNull((Object)e1);
        Assertions.assertEquals((int)1, (int)e1.getConfigs().size());
        Set es1 = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().build(), new TimelineDataToRetrieve(list, null, null, null, null, null));
        int cfgCnt = 0;
        for (TimelineEntity entity : es1) {
            cfgCnt += entity.getConfigs().size();
            for (String confKey : entity.getConfigs().keySet()) {
                Assertions.assertTrue((boolean)confKey.startsWith("cfg_"), (String)"Config key returned should start with cfg_");
            }
        }
        Assertions.assertEquals((int)3, (int)cfgCnt);
    }

    @Test
    public void testReadAppsConfigFilterPrefix() throws Exception {
        TimelineFilterList confFilterList = new TimelineFilterList();
        confFilterList.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "cfg_param1", (Object)"value1"));
        TimelineFilterList list = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelinePrefixFilter(TimelineCompareOp.EQUAL, "cfg_")});
        Set entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().configFilters(confFilterList).build(), new TimelineDataToRetrieve(list, null, null, null, null, null));
        Assertions.assertEquals((int)1, (int)entities.size());
        int cfgCnt = 0;
        for (TimelineEntity entity : entities) {
            cfgCnt += entity.getConfigs().size();
            for (String confKey : entity.getConfigs().keySet()) {
                Assertions.assertTrue((boolean)confKey.startsWith("cfg_"), (String)"Config key returned should start with cfg_");
            }
        }
        Assertions.assertEquals((int)2, (int)cfgCnt);
        TimelineFilterList list1 = new TimelineFilterList();
        list1.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "cfg_param1", (Object)"value1"));
        list1.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "cfg_param2", (Object)"value2"));
        TimelineFilterList list2 = new TimelineFilterList();
        list2.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "cfg_param1", (Object)"value3"));
        list2.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "config_param2", (Object)"value2"));
        TimelineFilterList confsToRetrieve = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelinePrefixFilter(TimelineCompareOp.EQUAL, "config_")});
        TimelineFilterList confFilterList1 = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{list1, list2});
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().configFilters(confFilterList1).build(), new TimelineDataToRetrieve(confsToRetrieve, null, null, null, null, null));
        Assertions.assertEquals((int)2, (int)entities.size());
        cfgCnt = 0;
        for (TimelineEntity entity : entities) {
            cfgCnt += entity.getConfigs().size();
            for (String confKey : entity.getConfigs().keySet()) {
                Assertions.assertTrue((boolean)confKey.startsWith("config_"), (String)"Config key returned should start with config_");
            }
        }
        Assertions.assertEquals((int)2, (int)cfgCnt);
    }

    @Test
    public void testReadAppsMetricFilters() throws Exception {
        TimelineFilterList list1 = new TimelineFilterList();
        list1.addFilter((TimelineFilter)new TimelineCompareFilter(TimelineCompareOp.GREATER_OR_EQUAL, "MAP1_SLOT_MILLIS", (Object)50000000900L));
        TimelineFilterList list2 = new TimelineFilterList();
        list2.addFilter((TimelineFilter)new TimelineCompareFilter(TimelineCompareOp.LESS_THAN, "MAP_SLOT_MILLIS", (Object)80000000000L));
        list2.addFilter((TimelineFilter)new TimelineCompareFilter(TimelineCompareOp.EQUAL, "MAP1_BYTES", (Object)50));
        TimelineFilterList metricFilterList = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{list1, list2});
        Set entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().metricFilters(metricFilterList).build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.METRICS), null, null, null));
        Assertions.assertEquals((int)2, (int)entities.size());
        int metricCnt = 0;
        for (Object entity : entities) {
            metricCnt += entity.getMetrics().size();
        }
        Assertions.assertEquals((int)3, (int)metricCnt);
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().metricFilters(metricFilterList).build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.ALL), null, null, null));
        Assertions.assertEquals((int)2, (int)entities.size());
        metricCnt = 0;
        for (Object entity : entities) {
            metricCnt += entity.getMetrics().size();
        }
        Assertions.assertEquals((int)3, (int)metricCnt);
        TimelineFilterList metricFilterList1 = new TimelineFilterList(new TimelineFilter[]{new TimelineCompareFilter(TimelineCompareOp.LESS_OR_EQUAL, "MAP_SLOT_MILLIS", (Object)80000000000L), new TimelineCompareFilter(TimelineCompareOp.NOT_EQUAL, "MAP1_BYTES", (Object)30)});
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().metricFilters(metricFilterList1).build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.METRICS), null, null, null));
        Assertions.assertEquals((int)1, (int)entities.size());
        metricCnt = 0;
        for (TimelineEntity entity : entities) {
            metricCnt += entity.getMetrics().size();
        }
        Assertions.assertEquals((int)2, (int)metricCnt);
        TimelineFilterList metricFilterList2 = new TimelineFilterList(new TimelineFilter[]{new TimelineCompareFilter(TimelineCompareOp.LESS_THAN, "MAP_SLOT_MILLIS", (Object)40000000000L), new TimelineCompareFilter(TimelineCompareOp.NOT_EQUAL, "MAP1_BYTES", (Object)30)});
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().metricFilters(metricFilterList2).build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.METRICS), null, null, null));
        Assertions.assertEquals((int)0, (int)entities.size());
        TimelineFilterList metricFilterList3 = new TimelineFilterList(new TimelineFilter[]{new TimelineCompareFilter(TimelineCompareOp.EQUAL, "dummy_metric", (Object)5)});
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().metricFilters(metricFilterList3).build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.METRICS), null, null, null));
        Assertions.assertEquals((int)0, (int)entities.size());
        TimelineFilterList metricFilterList4 = new TimelineFilterList(new TimelineFilter[]{new TimelineCompareFilter(TimelineCompareOp.NOT_EQUAL, "dummy_metric", (Object)5)});
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().metricFilters(metricFilterList4).build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.METRICS), null, null, null));
        Assertions.assertEquals((int)0, (int)entities.size());
        TimelineFilterList metricFilterList5 = new TimelineFilterList(new TimelineFilter[]{new TimelineCompareFilter(TimelineCompareOp.NOT_EQUAL, "dummy_metric", (Object)5, false)});
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().metricFilters(metricFilterList5).build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.METRICS), null, null, null));
        Assertions.assertEquals((int)3, (int)entities.size());
    }

    @Test
    public void testReadAppsMetricPrefix() throws Exception {
        TimelineFilterList list = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelinePrefixFilter(TimelineCompareOp.EQUAL, "MAP1_")});
        TimelineEntity e1 = this.reader.getEntity(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), "application_1111111111_2222", TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineDataToRetrieve(null, list, null, null, null, null));
        Assertions.assertNotNull((Object)e1);
        Assertions.assertEquals((int)1, (int)e1.getMetrics().size());
        Set es1 = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().build(), new TimelineDataToRetrieve(null, list, null, null, null, null));
        int metricCnt = 0;
        for (TimelineEntity entity : es1) {
            metricCnt += entity.getMetrics().size();
            for (TimelineMetric metric : entity.getMetrics()) {
                Assertions.assertTrue((boolean)metric.getId().startsWith("MAP1_"), (String)"Metric Id returned should start with MAP1_");
            }
        }
        Assertions.assertEquals((int)2, (int)metricCnt);
    }

    @Test
    public void testReadAppsMetricFilterPrefix() throws Exception {
        TimelineFilterList list = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelinePrefixFilter(TimelineCompareOp.EQUAL, "MAP1_")});
        TimelineFilterList metricFilterList = new TimelineFilterList();
        metricFilterList.addFilter((TimelineFilter)new TimelineCompareFilter(TimelineCompareOp.GREATER_OR_EQUAL, "MAP1_SLOT_MILLIS", (Object)0L));
        Set entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().metricFilters(metricFilterList).build(), new TimelineDataToRetrieve(null, list, null, null, null, null));
        int metricCnt = 0;
        Assertions.assertEquals((int)1, (int)entities.size());
        for (TimelineEntity entity : entities) {
            metricCnt += entity.getMetrics().size();
        }
        Assertions.assertEquals((int)1, (int)metricCnt);
        TimelineFilterList list1 = new TimelineFilterList();
        list1.addFilter((TimelineFilter)new TimelineCompareFilter(TimelineCompareOp.GREATER_OR_EQUAL, "MAP1_SLOT_MILLIS", (Object)50000000900L));
        TimelineFilterList list2 = new TimelineFilterList();
        list2.addFilter((TimelineFilter)new TimelineCompareFilter(TimelineCompareOp.LESS_THAN, "MAP_SLOT_MILLIS", (Object)80000000000L));
        list2.addFilter((TimelineFilter)new TimelineCompareFilter(TimelineCompareOp.EQUAL, "MAP1_BYTES", (Object)50));
        TimelineFilterList metricsToRetrieve = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{new TimelinePrefixFilter(TimelineCompareOp.EQUAL, "MAP1_")});
        TimelineFilterList metricFilterList1 = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{list1, list2});
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().metricFilters(metricFilterList1).build(), new TimelineDataToRetrieve(null, metricsToRetrieve, null, null, null, null));
        metricCnt = 0;
        Assertions.assertEquals((int)2, (int)entities.size());
        for (TimelineEntity entity : entities) {
            metricCnt += entity.getMetrics().size();
            for (TimelineMetric metric : entity.getMetrics()) {
                Assertions.assertTrue((boolean)metric.getId().startsWith("MAP1_"), (String)"Metric Id returned should start with MAP1_");
            }
        }
        Assertions.assertEquals((int)2, (int)metricCnt);
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().metricFilters(metricFilterList1).build(), new TimelineDataToRetrieve(null, metricsToRetrieve, EnumSet.of(TimelineReader.Field.METRICS), Integer.valueOf(Integer.MAX_VALUE), null, null));
        metricCnt = 0;
        int metricValCnt = 0;
        Assertions.assertEquals((int)2, (int)entities.size());
        for (TimelineEntity entity : entities) {
            metricCnt += entity.getMetrics().size();
            for (TimelineMetric metric : entity.getMetrics()) {
                metricValCnt += metric.getValues().size();
                Assertions.assertTrue((boolean)metric.getId().startsWith("MAP1_"), (String)"Metric Id returned should start with MAP1_");
            }
        }
        Assertions.assertEquals((int)2, (int)metricCnt);
        Assertions.assertEquals((int)7, (int)metricValCnt);
    }

    @Test
    public void testReadAppsMetricTimeRange() throws Exception {
        Set entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.METRICS), Integer.valueOf(100), null, null));
        Assertions.assertEquals((int)3, (int)entities.size());
        int metricTimeSeriesCnt = 0;
        int metricCnt = 0;
        for (TimelineEntity entity : entities) {
            metricCnt += entity.getMetrics().size();
            for (TimelineMetric m : entity.getMetrics()) {
                metricTimeSeriesCnt += m.getValues().size();
            }
        }
        Assertions.assertEquals((int)3, (int)metricCnt);
        Assertions.assertEquals((int)13, (int)metricTimeSeriesCnt);
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.METRICS), Integer.valueOf(100), Long.valueOf(CURRENT_TIME - 40000L), Long.valueOf(CURRENT_TIME)));
        Assertions.assertEquals((int)3, (int)entities.size());
        metricCnt = 0;
        metricTimeSeriesCnt = 0;
        for (TimelineEntity entity : entities) {
            metricCnt += entity.getMetrics().size();
            for (TimelineMetric m : entity.getMetrics()) {
                for (Long ts : m.getValues().keySet()) {
                    Assertions.assertTrue((ts >= CURRENT_TIME - 40000L && ts <= CURRENT_TIME ? 1 : 0) != 0);
                }
                metricTimeSeriesCnt += m.getValues().size();
            }
        }
        Assertions.assertEquals((int)3, (int)metricCnt);
        Assertions.assertEquals((int)5, (int)metricTimeSeriesCnt);
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.METRICS), null, Long.valueOf(CURRENT_TIME - 40000L), Long.valueOf(CURRENT_TIME)));
        Assertions.assertEquals((int)3, (int)entities.size());
        metricCnt = 0;
        metricTimeSeriesCnt = 0;
        for (TimelineEntity entity : entities) {
            metricCnt += entity.getMetrics().size();
            for (TimelineMetric m : entity.getMetrics()) {
                for (Long ts : m.getValues().keySet()) {
                    Assertions.assertTrue((ts >= CURRENT_TIME - 40000L && ts <= CURRENT_TIME ? 1 : 0) != 0);
                }
                metricTimeSeriesCnt += m.getValues().size();
            }
        }
        Assertions.assertEquals((int)3, (int)metricCnt);
        Assertions.assertEquals((int)3, (int)metricTimeSeriesCnt);
        TimelineEntity entity = this.reader.getEntity(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), "application_1111111111_2222", TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.METRICS), Integer.valueOf(100), Long.valueOf(CURRENT_TIME - 40000L), Long.valueOf(CURRENT_TIME)));
        Assertions.assertNotNull((Object)entity);
        Assertions.assertEquals((int)2, (int)entity.getMetrics().size());
        metricTimeSeriesCnt = 0;
        for (TimelineMetric m : entity.getMetrics()) {
            for (Long ts : m.getValues().keySet()) {
                Assertions.assertTrue((ts >= CURRENT_TIME - 40000L && ts <= CURRENT_TIME ? 1 : 0) != 0);
            }
            metricTimeSeriesCnt += m.getValues().size();
        }
        Assertions.assertEquals((int)3, (int)metricTimeSeriesCnt);
    }

    @Test
    public void testReadAppsInfoFilters() throws Exception {
        TimelineFilterList list1 = new TimelineFilterList();
        list1.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "infoMapKey3", (Object)85.85));
        list1.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "infoMapKey1", (Object)"infoMapValue2"));
        TimelineFilterList list2 = new TimelineFilterList();
        list2.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "infoMapKey1", (Object)"infoMapValue1"));
        list2.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "infoMapKey2", (Object)10));
        TimelineFilterList infoFilterList = new TimelineFilterList(TimelineFilterList.Operator.OR, new TimelineFilter[]{list1, list2});
        Set entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().infoFilters(infoFilterList).build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.INFO), null, null, null));
        Assertions.assertEquals((int)2, (int)entities.size());
        int infoCnt = 0;
        for (Object entity : entities) {
            infoCnt += entity.getInfo().size();
        }
        Assertions.assertEquals((int)7, (int)infoCnt);
        TimelineFilterList infoFilterList1 = new TimelineFilterList(new TimelineFilter[]{new TimelineKeyValueFilter(TimelineCompareOp.NOT_EQUAL, "infoMapKey1", (Object)"infoMapValue1")});
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().infoFilters(infoFilterList1).build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.INFO), null, null, null));
        Assertions.assertEquals((int)1, (int)entities.size());
        infoCnt = 0;
        for (TimelineEntity entity : entities) {
            infoCnt += entity.getInfo().size();
        }
        Assertions.assertEquals((int)4, (int)infoCnt);
        TimelineFilterList infoFilterList2 = new TimelineFilterList(new TimelineFilter[]{new TimelineKeyValueFilter(TimelineCompareOp.NOT_EQUAL, "infoMapKey1", (Object)"infoMapValue2"), new TimelineKeyValueFilter(TimelineCompareOp.NOT_EQUAL, "infoMapKey3", (Object)85.85)});
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().infoFilters(infoFilterList2).build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.INFO), null, null, null));
        Assertions.assertEquals((int)0, (int)entities.size());
        TimelineFilterList infoFilterList3 = new TimelineFilterList(new TimelineFilter[]{new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "dummy_info", (Object)"some_value")});
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().infoFilters(infoFilterList3).build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.INFO), null, null, null));
        Assertions.assertEquals((int)0, (int)entities.size());
        TimelineFilterList infoFilterList4 = new TimelineFilterList(new TimelineFilter[]{new TimelineKeyValueFilter(TimelineCompareOp.NOT_EQUAL, "dummy_info", (Object)"some_value")});
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().infoFilters(infoFilterList4).build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.INFO), null, null, null));
        Assertions.assertEquals((int)0, (int)entities.size());
        TimelineFilterList infoFilterList5 = new TimelineFilterList(new TimelineFilter[]{new TimelineKeyValueFilter(TimelineCompareOp.NOT_EQUAL, "dummy_info", (Object)"some_value", false)});
        entities = this.reader.getEntities(new TimelineReaderContext("cluster1", "user1", "some_flow_name", Long.valueOf(1002345678919L), null, TimelineEntityType.YARN_APPLICATION.toString(), null), new TimelineEntityFilters.Builder().infoFilters(infoFilterList5).build(), new TimelineDataToRetrieve(null, null, EnumSet.of(TimelineReader.Field.INFO), null, null, null));
        Assertions.assertEquals((int)3, (int)entities.size());
    }

    @AfterAll
    public static void tearDownAfterClass() throws Exception {
        if (util != null) {
            util.shutdownMiniCluster();
        }
    }

    static {
        CURRENT_TIME = System.currentTimeMillis();
    }
}

