/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;

@Provider
@Consumes(value={"application/json"})
public class TimelineEntityListReader
implements MessageBodyReader<List<TimelineEntity>> {
    private ObjectMapper objectMapper = new ObjectMapper();
    private String timelineEntityType = "java.util.List<org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity>";

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.timelineEntityType.equals(genericType.getTypeName());
    }

    public List<TimelineEntity> readFrom(Class<List<TimelineEntity>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        ArrayList<TimelineEntity> timelineEntityList = new ArrayList<TimelineEntity>();
        JsonNode jsonNode = this.objectMapper.readTree(entityStream);
        if (jsonNode.isArray()) {
            for (JsonNode jNode : jsonNode) {
                JsonNode jnInfos;
                TimelineEntity entity = new TimelineEntity();
                JsonNode jnIdentifier = jNode.get("identifier");
                JsonNode jnType = jnIdentifier.get("type");
                JsonNode jnId = jnIdentifier.get("id");
                TimelineEntity.Identifier identifier = new TimelineEntity.Identifier(jnType.asText(), jnId.asText());
                entity.setIdentifier(identifier);
                JsonNode jnAppType = jNode.get("type");
                entity.setType(jnAppType.asText());
                JsonNode jnCreatedTime = jNode.get("createdtime");
                entity.setCreatedTime(Long.valueOf(jnCreatedTime.asLong()));
                JsonNode jnMetrics = jNode.get("metrics");
                HashSet<TimelineMetric> metricSet = new HashSet<TimelineMetric>();
                if (jnMetrics.isArray()) {
                    for (JsonNode metric : jnMetrics) {
                        TimelineMetric timelineMetric = (TimelineMetric)this.objectMapper.treeToValue((TreeNode)metric, TimelineMetric.class);
                        metricSet.add(timelineMetric);
                        System.out.println(metric);
                    }
                }
                entity.setMetrics(metricSet);
                JsonNode jnConfigs = jNode.get("configs");
                if (jnConfigs != null) {
                    Map configInfos = (Map)this.objectMapper.treeToValue((TreeNode)jnConfigs, Map.class);
                    entity.setConfigs(configInfos);
                }
                if ((jnInfos = jNode.get("info")) != null) {
                    Map entityInfos = (Map)this.objectMapper.treeToValue((TreeNode)jnInfos, Map.class);
                    entity.setInfo(entityInfos);
                }
                JsonNode jnIdprefix = jNode.get("idprefix");
                entity.setIdPrefix(jnIdprefix.asLong());
                timelineEntityList.add(entity);
            }
        }
        return timelineEntityList;
    }
}

