/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.hadoop.yarn.api.records.timelineservice.FlowRunEntity;

@Provider
@Consumes(value={"application/json"})
public class FlowRunEntitySetReader
implements MessageBodyReader<Set<FlowRunEntity>> {
    private ObjectMapper objectMapper = new ObjectMapper();
    private String timelineEntityType = "java.util.Set<org.apache.hadoop.yarn.api.records.timelineservice.FlowRunEntity>";

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.timelineEntityType.equals(genericType.getTypeName());
    }

    public Set<FlowRunEntity> readFrom(Class<Set<FlowRunEntity>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        HashSet<FlowRunEntity> flowRunEntitySet = new HashSet<FlowRunEntity>();
        JsonNode jsonNode = this.objectMapper.readTree(entityStream);
        if (jsonNode.isArray()) {
            for (JsonNode jNode : jsonNode) {
                FlowRunEntity flowRunEntity = (FlowRunEntity)this.objectMapper.treeToValue((TreeNode)jNode, FlowRunEntity.class);
                flowRunEntitySet.add(flowRunEntity);
            }
        }
        return flowRunEntitySet;
    }
}

