/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.hadoop.yarn.api.records.timelineservice.FlowActivityEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.FlowRunEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;

@Provider
@Consumes(value={"application/json"})
public class FlowActivityEntityListReader
implements MessageBodyReader<List<FlowActivityEntity>> {
    private ObjectMapper objectMapper = new ObjectMapper();
    private String timelineEntityType = "java.util.List<org.apache.hadoop.yarn.api.records.timelineservice.FlowActivityEntity>";

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.timelineEntityType.equals(genericType.getTypeName());
    }

    public List<FlowActivityEntity> readFrom(Class<List<FlowActivityEntity>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        ArrayList<FlowActivityEntity> flowActivityEntityList = new ArrayList<FlowActivityEntity>();
        JsonNode jsonNode = this.objectMapper.readTree(entityStream);
        if (jsonNode.isArray()) {
            for (JsonNode jNode : jsonNode) {
                JsonNode jnInfos;
                FlowActivityEntity entity = new FlowActivityEntity();
                JsonNode jnIdentifier = jNode.get("identifier");
                JsonNode jnType = jnIdentifier.get("type");
                JsonNode jnId = jnIdentifier.get("id");
                TimelineEntity.Identifier identifier = new TimelineEntity.Identifier(jnType.asText(), jnId.asText());
                entity.setIdentifier(identifier);
                JsonNode jnAppType = jNode.get("type");
                entity.setType(jnAppType.asText());
                JsonNode jnCreatedTime = jNode.get("createdtime");
                entity.setCreatedTime(Long.valueOf(jnCreatedTime.asLong()));
                JsonNode jnConfigs = jNode.get("configs");
                if (jnConfigs != null) {
                    Map configInfos = (Map)this.objectMapper.treeToValue((TreeNode)jnConfigs, Map.class);
                    entity.setConfigs(configInfos);
                }
                if ((jnInfos = jNode.get("info")) != null) {
                    Map entityInfos = (Map)this.objectMapper.treeToValue((TreeNode)jnInfos, Map.class);
                    entity.setInfo(entityInfos);
                }
                entity.setDate(jNode.get("date").asLong());
                entity.setCluster(jNode.get("cluster").asText());
                entity.setUser(jNode.get("user").asText());
                entity.setFlowName(jNode.get("flowName").asText());
                JsonNode jnflowRuns = jNode.get("flowRuns");
                if (jnflowRuns != null) {
                    for (JsonNode jnflow : jnflowRuns) {
                        FlowRunEntity flowRunEntity = (FlowRunEntity)this.objectMapper.treeToValue((TreeNode)jnflow, FlowRunEntity.class);
                        entity.addFlowRun(flowRunEntity);
                    }
                }
                flowActivityEntityList.add(entity);
            }
        }
        return flowActivityEntityList;
    }
}

