/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.yarn.api.records.timelineservice.FlowActivityEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.reader.TimelineEntityReader;
import org.apache.hadoop.yarn.server.timelineservice.reader.FlowActivityEntityListReader;
import org.apache.hadoop.yarn.server.timelineservice.reader.FlowActivityEntityReader;
import org.apache.hadoop.yarn.server.timelineservice.reader.FlowActivityEntitySetReader;
import org.apache.hadoop.yarn.server.timelineservice.reader.FlowRunEntityReader;
import org.apache.hadoop.yarn.server.timelineservice.reader.FlowRunEntitySetReader;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineEntityListReader;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineEntitySetReader;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderServer;
import org.apache.hadoop.yarn.server.timelineservice.storage.DataGeneratorForTest;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.HttpUrlConnectorProvider;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;

public abstract class AbstractTimelineReaderHBaseTestBase {
    private static int serverPort;
    private static TimelineReaderServer server;
    private static HBaseTestingUtility util;

    public static void setup() throws Exception {
        util = new HBaseTestingUtility();
        org.apache.hadoop.conf.Configuration conf = util.getConfiguration();
        conf.setInt("hfile.format.version", 3);
        try {
            util.startMiniCluster();
        }
        catch (Exception e) {
            if (e.getClass().getSimpleName().equals("InaccessibleObjectException")) {
                Assumptions.assumeTrue((boolean)false, (String)"Could not start HBase because of HBASE-29234");
            }
            throw e;
        }
        DataGeneratorForTest.createSchema(util.getConfiguration());
    }

    public static void tearDown() throws Exception {
        if (server != null) {
            server.stop();
            server = null;
        }
        if (util != null) {
            util.shutdownMiniCluster();
        }
    }

    protected static void initialize() throws Exception {
        try {
            org.apache.hadoop.conf.Configuration config = util.getConfiguration();
            config.setBoolean("yarn.timeline-service.enabled", true);
            config.setFloat("yarn.timeline-service.version", 2.0f);
            config.set("yarn.timeline-service.reader.webapp.address", "localhost:0");
            config.set("yarn.resourcemanager.cluster-id", "cluster1");
            config.set("yarn.timeline-service.reader.class", "org.apache.hadoop.yarn.server.timelineservice.storage.HBaseTimelineReaderImpl");
            config.setInt("hfile.format.version", 3);
            server = new TimelineReaderServer(){

                protected void addFilters(org.apache.hadoop.conf.Configuration conf) {
                }
            };
            server.init(config);
            server.start();
            serverPort = server.getWebServerPort();
        }
        catch (Exception e) {
            Assertions.fail((String)"Web server failed to start");
        }
    }

    protected Client createClient() {
        ClientConfig cc = new ClientConfig();
        cc.connectorProvider((ConnectorProvider)this.getHttpURLConnectionFactory());
        return (Client)((Client)((Client)((Client)((Client)((Client)((Client)((Client)ClientBuilder.newClient((Configuration)cc).register(TimelineEntityReader.class)).register(TimelineEntitySetReader.class)).register(TimelineEntityListReader.class)).register(FlowActivityEntityReader.class)).register(FlowRunEntityReader.class)).register(FlowActivityEntitySetReader.class)).register(FlowActivityEntityListReader.class)).register(FlowRunEntitySetReader.class);
    }

    protected Response getResponse(Client client, URI uri) throws Exception {
        Response resp = client.target(uri).request(new String[]{"application/json"}).get();
        if (resp == null || resp.getStatusInfo().getStatusCode() != 200) {
            String msg = "";
            if (resp != null) {
                msg = String.valueOf(resp.getStatusInfo().getStatusCode());
            }
            throw new IOException("Incorrect response from timeline reader. Status=" + msg);
        }
        return resp;
    }

    protected void verifyHttpResponse(Client client, URI uri, Response.Status status) {
        Response resp = client.target(uri).request(new String[]{"application/json"}).get();
        Assertions.assertNotNull((Object)resp);
        Assertions.assertTrue((resp.getStatusInfo().getStatusCode() == status.getStatusCode() ? 1 : 0) != 0, (String)("Response from server should have been " + status));
        System.out.println("Response is: " + (String)resp.readEntity(String.class));
    }

    protected List<FlowActivityEntity> verifyFlowEntites(Client client, URI uri, int noOfEntities) throws Exception {
        Response resp = this.getResponse(client, uri);
        List entities = (List)resp.readEntity((GenericType)new GenericType<List<FlowActivityEntity>>(){});
        Assertions.assertNotNull((Object)entities);
        Assertions.assertEquals((int)noOfEntities, (int)entities.size());
        return entities;
    }

    @VisibleForTesting
    protected HttpUrlConnectorProvider getHttpURLConnectionFactory() {
        return new HttpUrlConnectorProvider().connectionFactory(url -> {
            HttpURLConnection conn;
            try {
                conn = (HttpURLConnection)url.openConnection();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            return conn;
        });
    }

    protected static HBaseTestingUtility getHBaseTestingUtility() {
        return util;
    }

    public static int getServerPort() {
        return serverPort;
    }
}

