/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import java.io.IOException;
import java.net.URI;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MediaType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.timelineservice.ApplicationEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.FlowActivityEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.FlowRunEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.SubApplicationEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollectorContext;
import org.apache.hadoop.yarn.server.timelineservice.reader.AbstractTimelineReaderHBaseTestBase;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderWebServices;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineUIDConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.HBaseTimelineWriterImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.HBaseTimelineSchemaUtils;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestTimelineReaderWebServicesHBaseStorage
extends AbstractTimelineReaderHBaseTestBase {
    private static long ts = System.currentTimeMillis();
    private static long dayTs = HBaseTimelineSchemaUtils.getTopOfTheDayTimestamp((long)ts);
    private static String doAsUser = "remoteuser";

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        TestTimelineReaderWebServicesHBaseStorage.setup();
        TestTimelineReaderWebServicesHBaseStorage.loadData();
        TestTimelineReaderWebServicesHBaseStorage.initialize();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TestTimelineReaderWebServicesHBaseStorage.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadData() throws Exception {
        String cluster = "cluster1";
        String user = "user1";
        String flow = "flow_name";
        String flowVersion = "CF7022C10F1354";
        Long runid = 1002345678919L;
        Long runid1 = 1002345678920L;
        TimelineEntities te = new TimelineEntities();
        TimelineEntity entity = new TimelineEntity();
        String id = "application_1111111111_1111";
        String type = TimelineEntityType.YARN_APPLICATION.toString();
        entity.setId(id);
        entity.setType(type);
        Long cTime = 1425016501000L;
        entity.setCreatedTime(cTime);
        entity.addConfig("cfg2", "value1");
        HashSet<TimelineMetric> metrics = new HashSet<TimelineMetric>();
        TimelineMetric m1 = new TimelineMetric();
        m1.setId("MAP_SLOT_MILLIS");
        Object metricValues = ImmutableMap.of((Object)(ts - 100000L), (Object)2, (Object)(ts - 90000L), (Object)7, (Object)(ts - 80000L), (Object)40);
        m1.setType(TimelineMetric.Type.TIME_SERIES);
        m1.setValues((Map)metricValues);
        metrics.add(m1);
        m1 = new TimelineMetric();
        m1.setId("MAP1_SLOT_MILLIS");
        metricValues = ImmutableMap.of((Object)(ts - 100000L), (Object)2, (Object)(ts - 90000L), (Object)9, (Object)(ts - 80000L), (Object)40);
        m1.setType(TimelineMetric.Type.TIME_SERIES);
        m1.setValues((Map)metricValues);
        metrics.add(m1);
        m1 = new TimelineMetric();
        m1.setId("HDFS_BYTES_READ");
        metricValues = ImmutableMap.of((Object)(ts - 100000L), (Object)31, (Object)(ts - 80000L), (Object)57);
        m1.setType(TimelineMetric.Type.TIME_SERIES);
        m1.setValues((Map)metricValues);
        metrics.add(m1);
        entity.addMetrics(metrics);
        TimelineEvent event = new TimelineEvent();
        event.setId("YARN_APPLICATION_CREATED");
        event.setTimestamp(cTime.longValue());
        String expKey = "foo_event";
        String expVal = "test";
        event.addInfo(expKey, (Object)expVal);
        entity.addEvent(event);
        TimelineEvent event11 = new TimelineEvent();
        event11.setId("YARN_APPLICATION_FINISHED");
        Long expTs = 1425019501000L;
        event11.setTimestamp(expTs.longValue());
        entity.addEvent(event11);
        te.addEntity(entity);
        TimelineEntities te1 = new TimelineEntities();
        TimelineEntity entity1 = new TimelineEntity();
        id = "application_1111111111_2222";
        type = TimelineEntityType.YARN_APPLICATION.toString();
        entity1.setId(id);
        entity1.setType(type);
        cTime = 1425016501000L;
        entity1.setCreatedTime(cTime);
        entity1.addConfig("cfg1", "value1");
        metrics.clear();
        TimelineMetric m2 = new TimelineMetric();
        m2.setId("MAP_SLOT_MILLIS");
        metricValues = new HashMap();
        metricValues.put(ts - 100000L, 5L);
        metricValues.put(ts - 80000L, 101L);
        m2.setType(TimelineMetric.Type.TIME_SERIES);
        m2.setValues((Map)metricValues);
        metrics.add(m2);
        entity1.addMetrics(metrics);
        TimelineEvent event1 = new TimelineEvent();
        event1.setId("YARN_APPLICATION_CREATED");
        event1.setTimestamp(cTime.longValue());
        event1.addInfo(expKey, (Object)expVal);
        entity1.addEvent(event1);
        te1.addEntity(entity1);
        String flow2 = "flow_name2";
        String flowVersion2 = "CF7022C10F1454";
        Long runid2 = 2102356789046L;
        TimelineEntities te3 = new TimelineEntities();
        TimelineEntity entity3 = new TimelineEntity();
        id = "application_11111111111111_2223";
        entity3.setId(id);
        entity3.setType(type);
        cTime = 1425016501037L;
        entity3.setCreatedTime(cTime);
        TimelineEvent event2 = new TimelineEvent();
        event2.setId("YARN_APPLICATION_CREATED");
        event2.setTimestamp(cTime.longValue());
        event2.addInfo("foo_event", (Object)"test");
        entity3.addEvent(event2);
        te3.addEntity(entity3);
        TimelineEntities te4 = new TimelineEntities();
        TimelineEntity entity4 = new TimelineEntity();
        id = "application_1111111111_2224";
        entity4.setId(id);
        entity4.setType(type);
        cTime = 1425016501034L;
        entity4.setCreatedTime(cTime);
        TimelineEvent event4 = new TimelineEvent();
        event4.setId("YARN_APPLICATION_CREATED");
        event4.setTimestamp(cTime.longValue());
        event4.addInfo("foo_event", (Object)"test");
        entity4.addEvent(event4);
        metrics.clear();
        m2 = new TimelineMetric();
        m2.setId("MAP_SLOT_MILLIS");
        metricValues = ImmutableMap.of((Object)(ts - 100000L), (Object)5L, (Object)(ts - 80000L), (Object)101L);
        m2.setType(TimelineMetric.Type.TIME_SERIES);
        m2.setValues((Map)metricValues);
        metrics.add(m2);
        entity4.addMetrics(metrics);
        te4.addEntity(entity4);
        TimelineEntities userEntities = new TimelineEntities();
        TimelineEntity entity5 = new TimelineEntity();
        entity5.setId("entity1");
        entity5.setType("type1");
        entity5.setCreatedTime(Long.valueOf(1425016501034L));
        entity5.addConfigs((Map)ImmutableMap.of((Object)"config_param1", (Object)"value1", (Object)"config_param2", (Object)"value2", (Object)"cfg_param1", (Object)"value3"));
        entity5.addInfo((Map)ImmutableMap.of((Object)"info1", (Object)"cluster1", (Object)"info2", (Object)2.0, (Object)"info3", (Object)35000, (Object)"info4", (Object)36000));
        metrics = new HashSet();
        m1 = new TimelineMetric();
        m1.setId("MAP_SLOT_MILLIS");
        metricValues = ImmutableMap.of((Object)(ts - 100000L), (Object)2, (Object)(ts - 80000L), (Object)40);
        m1.setType(TimelineMetric.Type.TIME_SERIES);
        m1.setValues((Map)metricValues);
        metrics.add(m1);
        m1 = new TimelineMetric();
        m1.setId("HDFS_BYTES_READ");
        metricValues = ImmutableMap.of((Object)(ts - 100000L), (Object)31, (Object)(ts - 80000L), (Object)57);
        m1.setType(TimelineMetric.Type.TIME_SERIES);
        m1.setValues((Map)metricValues);
        metrics.add(m1);
        entity5.addMetrics(metrics);
        TimelineEvent event51 = new TimelineEvent();
        event51.setId("event1");
        event51.setTimestamp(cTime.longValue());
        entity5.addEvent(event51);
        TimelineEvent event52 = new TimelineEvent();
        event52.setId("event2");
        event52.setTimestamp(cTime.longValue());
        entity5.addEvent(event52);
        TimelineEvent event53 = new TimelineEvent();
        event53.setId("event3");
        event53.setTimestamp(cTime.longValue());
        entity5.addEvent(event53);
        TimelineEvent event54 = new TimelineEvent();
        event54.setId("event4");
        event54.setTimestamp(cTime.longValue());
        entity5.addEvent(event54);
        HashMap<String, HashSet<String>> isRelatedTo1 = new HashMap<String, HashSet<String>>();
        isRelatedTo1.put("type2", new HashSet<String>(Arrays.asList("entity21", "entity22", "entity23", "entity24")));
        isRelatedTo1.put("type4", new HashSet<String>(Arrays.asList("entity41", "entity42")));
        isRelatedTo1.put("type1", new HashSet<String>(Arrays.asList("entity14", "entity15")));
        isRelatedTo1.put("type3", new HashSet<String>(Arrays.asList("entity31", "entity35", "entity32", "entity33")));
        entity5.addIsRelatedToEntities(isRelatedTo1);
        HashMap<String, HashSet<String>> relatesTo1 = new HashMap<String, HashSet<String>>();
        relatesTo1.put("type2", new HashSet<String>(Arrays.asList("entity21", "entity22", "entity23", "entity24")));
        relatesTo1.put("type4", new HashSet<String>(Arrays.asList("entity41", "entity42")));
        relatesTo1.put("type1", new HashSet<String>(Arrays.asList("entity14", "entity15")));
        relatesTo1.put("type3", new HashSet<String>(Arrays.asList("entity31", "entity35", "entity32", "entity33")));
        entity5.addRelatesToEntities(relatesTo1);
        userEntities.addEntity((TimelineEntity)new SubApplicationEntity(entity5));
        TimelineEntity entity6 = new TimelineEntity();
        entity6.setId("entity2");
        entity6.setType("type1");
        entity6.setCreatedTime(Long.valueOf(1425016501034L));
        entity6.addConfigs((Map)ImmutableMap.of((Object)"cfg_param3", (Object)"value1", (Object)"configuration_param2", (Object)"value2", (Object)"config_param1", (Object)"value3"));
        entity6.addInfo((Map)ImmutableMap.of((Object)"info1", (Object)"cluster2", (Object)"info2", (Object)2.0, (Object)"info4", (Object)35000));
        metrics = new HashSet();
        m1 = new TimelineMetric();
        m1.setId("MAP1_SLOT_MILLIS");
        metricValues = ImmutableMap.of((Object)(ts - 100000L), (Object)12, (Object)(ts - 80000L), (Object)140);
        m1.setType(TimelineMetric.Type.TIME_SERIES);
        m1.setValues((Map)metricValues);
        metrics.add(m1);
        m1 = new TimelineMetric();
        m1.setId("HDFS_BYTES_READ");
        metricValues = ImmutableMap.of((Object)(ts - 100000L), (Object)78, (Object)(ts - 80000L), (Object)157);
        m1.setType(TimelineMetric.Type.TIME_SERIES);
        m1.setValues((Map)metricValues);
        metrics.add(m1);
        m1 = new TimelineMetric();
        m1.setId("MAP11_SLOT_MILLIS");
        m1.setType(TimelineMetric.Type.SINGLE_VALUE);
        m1.addValue(ts - 100000L, (Number)122);
        metrics.add(m1);
        entity6.addMetrics(metrics);
        TimelineEvent event61 = new TimelineEvent();
        event61.setId("event1");
        event61.setTimestamp(cTime.longValue());
        entity6.addEvent(event61);
        TimelineEvent event62 = new TimelineEvent();
        event62.setId("event5");
        event62.setTimestamp(cTime.longValue());
        entity6.addEvent(event62);
        TimelineEvent event63 = new TimelineEvent();
        event63.setId("event3");
        event63.setTimestamp(cTime.longValue());
        entity6.addEvent(event63);
        TimelineEvent event64 = new TimelineEvent();
        event64.setId("event6");
        event64.setTimestamp(cTime.longValue());
        entity6.addEvent(event64);
        HashMap<String, HashSet<String>> isRelatedTo2 = new HashMap<String, HashSet<String>>();
        isRelatedTo2.put("type2", new HashSet<String>(Arrays.asList("entity21", "entity22", "entity23", "entity24")));
        isRelatedTo2.put("type5", new HashSet<String>(Arrays.asList("entity51", "entity52")));
        isRelatedTo2.put("type6", new HashSet<String>(Arrays.asList("entity61", "entity66")));
        isRelatedTo2.put("type3", new HashSet<String>(Collections.singletonList("entity31")));
        entity6.addIsRelatedToEntities(isRelatedTo2);
        HashMap<String, HashSet<String>> relatesTo2 = new HashMap<String, HashSet<String>>();
        relatesTo2.put("type2", new HashSet<String>(Arrays.asList("entity21", "entity22", "entity23", "entity24")));
        relatesTo2.put("type5", new HashSet<String>(Arrays.asList("entity51", "entity52")));
        relatesTo2.put("type6", new HashSet<String>(Arrays.asList("entity61", "entity66")));
        relatesTo2.put("type3", new HashSet<String>(Collections.singletonList("entity31")));
        entity6.addRelatesToEntities(relatesTo2);
        userEntities.addEntity((TimelineEntity)new SubApplicationEntity(entity6));
        for (long i = 1L; i <= 10L; ++i) {
            TimelineEntity userEntity = new TimelineEntity();
            userEntity.setType("entitytype");
            userEntity.setId("entityid-" + i);
            userEntity.setIdPrefix(11L - i);
            userEntity.setCreatedTime(Long.valueOf(ts));
            userEntities.addEntity((TimelineEntity)new SubApplicationEntity(userEntity));
        }
        HBaseTimelineWriterImpl hbi = null;
        Configuration c1 = TestTimelineReaderWebServicesHBaseStorage.getHBaseTestingUtility().getConfiguration();
        UserGroupInformation remoteUser = UserGroupInformation.createRemoteUser((String)doAsUser);
        try {
            hbi = new HBaseTimelineWriterImpl();
            hbi.init(c1);
            hbi.write(new TimelineCollectorContext(cluster, user, flow, flowVersion, runid, entity.getId()), te, remoteUser);
            hbi.write(new TimelineCollectorContext(cluster, user, flow, flowVersion, runid, entity1.getId()), te1, remoteUser);
            hbi.write(new TimelineCollectorContext(cluster, user, flow, flowVersion, runid1, entity4.getId()), te4, remoteUser);
            hbi.write(new TimelineCollectorContext(cluster, user, flow2, flowVersion2, runid2, entity3.getId()), te3, remoteUser);
            hbi.write(new TimelineCollectorContext(cluster, user, flow, flowVersion, runid, "application_1111111111_1111"), userEntities, remoteUser);
            TestTimelineReaderWebServicesHBaseStorage.writeApplicationEntities(hbi, ts);
            hbi.flush();
        }
        finally {
            if (hbi != null) {
                hbi.close();
            }
        }
    }

    static void writeApplicationEntities(HBaseTimelineWriterImpl hbi, long timestamp) throws IOException {
        int count = 1;
        for (long i = 1L; i <= 3L; ++i) {
            for (int j = 1; j <= 5; ++j) {
                TimelineEntities te = new TimelineEntities();
                ApplicationId appId = BuilderUtils.newApplicationId((long)timestamp, (int)count++);
                ApplicationEntity appEntity = new ApplicationEntity();
                appEntity.setId(HBaseTimelineSchemaUtils.convertApplicationIdToString((ApplicationId)appId));
                appEntity.setCreatedTime(Long.valueOf(timestamp));
                TimelineEvent created = new TimelineEvent();
                created.setId("YARN_APPLICATION_CREATED");
                created.setTimestamp(timestamp);
                appEntity.addEvent(created);
                TimelineEvent finished = new TimelineEvent();
                finished.setId("YARN_APPLICATION_FINISHED");
                finished.setTimestamp(timestamp + i * (long)j);
                appEntity.addEvent(finished);
                te.addEntity((TimelineEntity)appEntity);
                hbi.write(new TimelineCollectorContext("cluster1", "user1", "flow1", "CF7022C10F1354", Long.valueOf(i), appEntity.getId()), te, UserGroupInformation.createRemoteUser((String)"user1"));
            }
        }
    }

    private static TimelineEntity newEntity(String type, String id) {
        TimelineEntity entity = new TimelineEntity();
        entity.setIdentifier(new TimelineEntity.Identifier(type, id));
        return entity;
    }

    private static TimelineMetric newMetric(TimelineMetric.Type type, String id, long t, Number value) {
        TimelineMetric metric = new TimelineMetric(type);
        metric.setId(id);
        metric.addValue(t, value);
        return metric;
    }

    private static boolean verifyMetricValues(Map<Long, Number> m1, Map<Long, Number> m2) {
        for (Map.Entry<Long, Number> entry : m1.entrySet()) {
            if (!m2.containsKey(entry.getKey())) {
                return false;
            }
            if (!m2.get(entry.getKey()).equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private static boolean verifyMetrics(TimelineMetric m, TimelineMetric ... metrics) {
        for (TimelineMetric metric : metrics) {
            if (!metric.equals((Object)m) || !TestTimelineReaderWebServicesHBaseStorage.verifyMetricValues(metric.getValues(), m.getValues())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFlowRun() throws Exception {
        Client client = this.createClient();
        try {
            URI uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/users/user1/flows/flow_name/runs/1002345678919");
            ClientResponse resp = this.getResponse(client, uri);
            FlowRunEntity entity = (FlowRunEntity)resp.getEntity(FlowRunEntity.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; charset=utf-8"), (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entity);
            Assert.assertEquals((Object)"user1@flow_name/1002345678919", (Object)entity.getId());
            Assert.assertEquals((long)3L, (long)entity.getMetrics().size());
            TimelineMetric m1 = TestTimelineReaderWebServicesHBaseStorage.newMetric(TimelineMetric.Type.SINGLE_VALUE, "HDFS_BYTES_READ", ts - 80000L, 57L);
            TimelineMetric m2 = TestTimelineReaderWebServicesHBaseStorage.newMetric(TimelineMetric.Type.SINGLE_VALUE, "MAP_SLOT_MILLIS", ts - 80000L, 141L);
            TimelineMetric m3 = TestTimelineReaderWebServicesHBaseStorage.newMetric(TimelineMetric.Type.SINGLE_VALUE, "MAP1_SLOT_MILLIS", ts - 80000L, 40L);
            for (TimelineMetric metric : entity.getMetrics()) {
                Assert.assertTrue((boolean)TestTimelineReaderWebServicesHBaseStorage.verifyMetrics(metric, m1, m2, m3));
            }
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/users/user1/flows/flow_name/runs/1002345678919");
            resp = this.getResponse(client, uri);
            entity = (FlowRunEntity)resp.getEntity(FlowRunEntity.class);
            Assert.assertNotNull((Object)entity);
            Assert.assertEquals((Object)"user1@flow_name/1002345678919", (Object)entity.getId());
            Assert.assertEquals((long)3L, (long)entity.getMetrics().size());
            m1 = TestTimelineReaderWebServicesHBaseStorage.newMetric(TimelineMetric.Type.SINGLE_VALUE, "HDFS_BYTES_READ", ts - 80000L, 57L);
            m2 = TestTimelineReaderWebServicesHBaseStorage.newMetric(TimelineMetric.Type.SINGLE_VALUE, "MAP_SLOT_MILLIS", ts - 80000L, 141L);
            m3 = TestTimelineReaderWebServicesHBaseStorage.newMetric(TimelineMetric.Type.SINGLE_VALUE, "MAP1_SLOT_MILLIS", ts - 80000L, 40L);
            for (TimelineMetric metric : entity.getMetrics()) {
                Assert.assertTrue((boolean)TestTimelineReaderWebServicesHBaseStorage.verifyMetrics(metric, m1, m2, m3));
            }
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFlowRuns() throws Exception {
        Client client = this.createClient();
        try {
            URI uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/users/user1/flows/flow_name/runs");
            ClientResponse resp = this.getResponse(client, uri);
            Set entities = (Set)resp.getEntity((GenericType)new GenericType<Set<FlowRunEntity>>(){});
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; charset=utf-8"), (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            for (FlowRunEntity entity : entities) {
                Assert.assertTrue((String)"Id, run id or start time does not match.", (entity.getId().equals("user1@flow_name/1002345678919") && entity.getRunId() == 1002345678919L && entity.getStartTime() == 1425016501000L || entity.getId().equals("user1@flow_name/1002345678920") && entity.getRunId() == 1002345678920L && entity.getStartTime() == 1425016501034L ? 1 : 0) != 0);
                Assert.assertEquals((long)0L, (long)entity.getMetrics().size());
            }
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/users/user1/flows/flow_name/runs?limit=1");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<FlowRunEntity>>(){});
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; charset=utf-8"), (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)1L, (long)entities.size());
            for (FlowRunEntity entity : entities) {
                Assert.assertTrue((String)"Id, run id or start time does not match.", (entity.getId().equals("user1@flow_name/1002345678920") && entity.getRunId() == 1002345678920L && entity.getStartTime() == 1425016501034L ? 1 : 0) != 0);
                Assert.assertEquals((long)0L, (long)entity.getMetrics().size());
            }
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/users/user1/flows/flow_name/runs?createdtimestart=1425016501030");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<FlowRunEntity>>(){});
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; charset=utf-8"), (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)1L, (long)entities.size());
            for (FlowRunEntity entity : entities) {
                Assert.assertTrue((String)"Id, run id or start time does not match.", (entity.getId().equals("user1@flow_name/1002345678920") && entity.getRunId() == 1002345678920L && entity.getStartTime() == 1425016501034L ? 1 : 0) != 0);
                Assert.assertEquals((long)0L, (long)entity.getMetrics().size());
            }
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/users/user1/flows/flow_name/runs?createdtimestart=1425016500999&createdtimeend=1425016501035");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<FlowRunEntity>>(){});
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; charset=utf-8"), (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            for (FlowRunEntity entity : entities) {
                Assert.assertTrue((String)"Id, run id or start time does not match.", (entity.getId().equals("user1@flow_name/1002345678919") && entity.getRunId() == 1002345678919L && entity.getStartTime() == 1425016501000L || entity.getId().equals("user1@flow_name/1002345678920") && entity.getRunId() == 1002345678920L && entity.getStartTime() == 1425016501034L ? 1 : 0) != 0);
                Assert.assertEquals((long)0L, (long)entity.getMetrics().size());
            }
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/users/user1/flows/flow_name/runs?createdtimeend=1425016501030");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<FlowRunEntity>>(){});
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; charset=utf-8"), (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)1L, (long)entities.size());
            for (FlowRunEntity entity : entities) {
                Assert.assertTrue((String)"Id, run id or start time does not match.", (entity.getId().equals("user1@flow_name/1002345678919") && entity.getRunId() == 1002345678919L && entity.getStartTime() == 1425016501000L ? 1 : 0) != 0);
                Assert.assertEquals((long)0L, (long)entity.getMetrics().size());
            }
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/users/user1/flows/flow_name/runs?fields=metrics");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<FlowRunEntity>>(){});
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; charset=utf-8"), (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            for (FlowRunEntity entity : entities) {
                Assert.assertTrue((String)"Id, run id or start time does not match.", (entity.getId().equals("user1@flow_name/1002345678919") && entity.getRunId() == 1002345678919L && entity.getStartTime() == 1425016501000L && entity.getMetrics().size() == 3 || entity.getId().equals("user1@flow_name/1002345678920") && entity.getRunId() == 1002345678920L && entity.getStartTime() == 1425016501034L && entity.getMetrics().size() == 1 ? 1 : 0) != 0);
            }
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/users/user1/flows/flow_name/runs?fields=CONFIGS");
            this.verifyHttpResponse(client, uri, ClientResponse.Status.BAD_REQUEST);
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFlowRunsMetricsToRetrieve() throws Exception {
        Client client = this.createClient();
        try {
            URI uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/users/user1/flows/flow_name/runs?metricstoretrieve=MAP_,HDFS_");
            ClientResponse resp = this.getResponse(client, uri);
            Set entities = (Set)resp.getEntity((GenericType)new GenericType<Set<FlowRunEntity>>(){});
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; charset=utf-8"), (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            int metricCnt = 0;
            for (FlowRunEntity entity : entities) {
                metricCnt += entity.getMetrics().size();
                for (TimelineMetric metric : entity.getMetrics()) {
                    Assert.assertTrue((metric.getId().startsWith("MAP_") || metric.getId().startsWith("HDFS_") ? 1 : 0) != 0);
                }
            }
            Assert.assertEquals((long)3L, (long)metricCnt);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/users/user1/flows/flow_name/runs?metricstoretrieve=!(MAP_,HDFS_)");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<FlowRunEntity>>(){});
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; charset=utf-8"), (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            metricCnt = 0;
            for (FlowRunEntity entity : entities) {
                metricCnt += entity.getMetrics().size();
                for (TimelineMetric metric : entity.getMetrics()) {
                    Assert.assertTrue((boolean)metric.getId().startsWith("MAP1_"));
                }
            }
            Assert.assertEquals((long)1L, (long)metricCnt);
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntitiesByUID() throws Exception {
        Client client = this.createClient();
        try {
            URI uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/flows");
            ClientResponse resp = this.getResponse(client, uri);
            Set flowEntities = (Set)resp.getEntity((GenericType)new GenericType<Set<FlowActivityEntity>>(){});
            Assert.assertNotNull((Object)flowEntities);
            Assert.assertEquals((long)3L, (long)flowEntities.size());
            ArrayList<String> listFlowUIDs = new ArrayList<String>();
            for (Object entity : flowEntities) {
                String string = (String)entity.getInfo().get("UID");
                listFlowUIDs.add(string);
                Assert.assertEquals((Object)TimelineUIDConverter.FLOW_UID.encodeUID(new TimelineReaderContext(entity.getCluster(), entity.getUser(), entity.getFlowName(), null, null, null, null)), (Object)string);
                Assert.assertTrue((entity.getId().endsWith("@flow_name") && entity.getFlowRuns().size() == 2 || entity.getId().endsWith("@flow_name2") && entity.getFlowRuns().size() == 1 || entity.getId().endsWith("@flow1") && entity.getFlowRuns().size() == 3 ? 1 : 0) != 0);
            }
            ArrayList<String> listFlowRunUIDs = new ArrayList<String>();
            for (String string : listFlowUIDs) {
                uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/flow-uid/" + string + "/runs");
                resp = this.getResponse(client, uri);
                Set frEntities = (Set)resp.getEntity((GenericType)new GenericType<Set<FlowRunEntity>>(){});
                Assert.assertNotNull((Object)frEntities);
                for (FlowRunEntity entity : frEntities) {
                    String flowRunUID = (String)entity.getInfo().get("UID");
                    listFlowRunUIDs.add(flowRunUID);
                    Assert.assertEquals((Object)TimelineUIDConverter.FLOWRUN_UID.encodeUID(new TimelineReaderContext("cluster1", entity.getUser(), entity.getName(), Long.valueOf(entity.getRunId()), null, null, null)), (Object)flowRunUID);
                }
            }
            Assert.assertEquals((long)6L, (long)listFlowRunUIDs.size());
            for (String string : listFlowRunUIDs) {
                uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/run-uid/" + string);
                resp = this.getResponse(client, uri);
                FlowRunEntity entity = (FlowRunEntity)resp.getEntity(FlowRunEntity.class);
                Assert.assertNotNull((Object)entity);
            }
            ArrayList<String> listAppUIDs = new ArrayList<String>();
            for (String flowRunUID : listFlowRunUIDs) {
                TimelineReaderContext context = TimelineUIDConverter.FLOWRUN_UID.decodeUID(flowRunUID);
                uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/run-uid/" + flowRunUID + "/apps");
                resp = this.getResponse(client, uri);
                Set appEntities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
                Assert.assertNotNull((Object)appEntities);
                for (TimelineEntity entity : appEntities) {
                    String appUID = (String)entity.getInfo().get("UID");
                    listAppUIDs.add(appUID);
                    Assert.assertEquals((Object)TimelineUIDConverter.APPLICATION_UID.encodeUID(new TimelineReaderContext(context.getClusterId(), context.getUserId(), context.getFlowName(), context.getFlowRunId(), entity.getId(), null, null)), (Object)appUID);
                }
            }
            Assert.assertEquals((long)19L, (long)listAppUIDs.size());
            for (String appUID : listAppUIDs) {
                uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/app-uid/" + appUID);
                resp = this.getResponse(client, uri);
                TimelineEntity entity = (TimelineEntity)resp.getEntity(TimelineEntity.class);
                Assert.assertNotNull((Object)entity);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String appUID : listAppUIDs) {
                TimelineReaderContext context = TimelineUIDConverter.APPLICATION_UID.decodeUID(appUID);
                uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/app-uid/" + appUID + "/entities/type1");
                resp = this.getResponse(client, uri);
                Set entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
                Assert.assertNotNull((Object)entities);
                for (TimelineEntity entity : entities) {
                    String entityUID = (String)entity.getInfo().get("UID");
                    arrayList.add(entityUID);
                    Assert.assertEquals((Object)TimelineUIDConverter.GENERIC_ENTITY_UID.encodeUID(new TimelineReaderContext(context.getClusterId(), context.getUserId(), context.getFlowName(), context.getFlowRunId(), context.getAppId(), "type1", Long.valueOf(entity.getIdPrefix()), entity.getId())), (Object)entityUID);
                }
            }
            Assert.assertEquals((long)2L, (long)arrayList.size());
            for (String entityUID : arrayList) {
                FlowRunEntity entity;
                uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/entity-uid/" + entityUID);
                resp = this.getResponse(client, uri);
                entity = (TimelineEntity)resp.getEntity(TimelineEntity.class);
                Assert.assertNotNull((Object)entity);
            }
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/flow-uid/dummy:flow/runs");
            this.verifyHttpResponse(client, uri, ClientResponse.Status.BAD_REQUEST);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/run-uid/dummy:flowrun");
            this.verifyHttpResponse(client, uri, ClientResponse.Status.BAD_REQUEST);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/run-uid/some:dummy:flow:123v456");
            this.verifyHttpResponse(client, uri, ClientResponse.Status.BAD_REQUEST);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/run-uid/dummy:flowrun/apps");
            this.verifyHttpResponse(client, uri, ClientResponse.Status.BAD_REQUEST);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/app-uid/dummy:app");
            this.verifyHttpResponse(client, uri, ClientResponse.Status.BAD_REQUEST);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/app-uid/dummy:app/entities/type1");
            this.verifyHttpResponse(client, uri, ClientResponse.Status.BAD_REQUEST);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/entity-uid/dummy:entity");
            this.verifyHttpResponse(client, uri, ClientResponse.Status.BAD_REQUEST);
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUIDQueryWithAndWithoutFlowContextInfo() throws Exception {
        Client client = this.createClient();
        try {
            String appUIDWithFlowInfo = "cluster1!user1!flow_name!1002345678919!application_1111111111_1111";
            URI uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/app-uid/" + appUIDWithFlowInfo);
            ClientResponse resp = this.getResponse(client, uri);
            TimelineEntity appEntity1 = (TimelineEntity)resp.getEntity(TimelineEntity.class);
            Assert.assertNotNull((Object)appEntity1);
            Assert.assertEquals((Object)TimelineEntityType.YARN_APPLICATION.toString(), (Object)appEntity1.getType());
            Assert.assertEquals((Object)"application_1111111111_1111", (Object)appEntity1.getId());
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/app-uid/" + appUIDWithFlowInfo + "/entities/type1");
            resp = this.getResponse(client, uri);
            Set entities1 = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities1);
            Assert.assertEquals((long)2L, (long)entities1.size());
            for (TimelineEntity entity : entities1) {
                Assert.assertNotNull((Object)entity.getInfo());
                Assert.assertEquals((long)2L, (long)entity.getInfo().size());
                String uid = (String)entity.getInfo().get("UID");
                Assert.assertNotNull((Object)uid);
                Assert.assertTrue((uid.equals(appUIDWithFlowInfo + "!type1!0!entity1") || uid.equals(appUIDWithFlowInfo + "!type1!0!entity2") ? 1 : 0) != 0);
            }
            String appUIDWithoutFlowInfo = "cluster1!application_1111111111_1111";
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/app-uid/" + appUIDWithoutFlowInfo);
            resp = this.getResponse(client, uri);
            TimelineEntity appEntity2 = (TimelineEntity)resp.getEntity(TimelineEntity.class);
            Assert.assertNotNull((Object)appEntity2);
            Assert.assertEquals((Object)TimelineEntityType.YARN_APPLICATION.toString(), (Object)appEntity2.getType());
            Assert.assertEquals((Object)"application_1111111111_1111", (Object)appEntity2.getId());
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/app-uid/" + appUIDWithoutFlowInfo + "/entities/type1");
            resp = this.getResponse(client, uri);
            Set entities2 = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities2);
            Assert.assertEquals((long)2L, (long)entities2.size());
            for (TimelineEntity entity : entities2) {
                Assert.assertNotNull((Object)entity.getInfo());
                Assert.assertEquals((long)2L, (long)entity.getInfo().size());
                String uid = (String)entity.getInfo().get("UID");
                Assert.assertNotNull((Object)uid);
                Assert.assertTrue((uid.equals(appUIDWithoutFlowInfo + "!type1!0!entity1") || uid.equals(appUIDWithoutFlowInfo + "!type1!0!entity2") ? 1 : 0) != 0);
            }
            String entityUIDWithFlowInfo = appUIDWithFlowInfo + "!type1!0!entity1";
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/entity-uid/" + entityUIDWithFlowInfo);
            resp = this.getResponse(client, uri);
            TimelineEntity singleEntity1 = (TimelineEntity)resp.getEntity(TimelineEntity.class);
            Assert.assertNotNull((Object)singleEntity1);
            Assert.assertEquals((Object)"type1", (Object)singleEntity1.getType());
            Assert.assertEquals((Object)"entity1", (Object)singleEntity1.getId());
            String entityUIDWithoutFlowInfo = appUIDWithoutFlowInfo + "!type1!0!entity1";
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/entity-uid/" + entityUIDWithoutFlowInfo);
            resp = this.getResponse(client, uri);
            TimelineEntity singleEntity2 = (TimelineEntity)resp.getEntity(TimelineEntity.class);
            Assert.assertNotNull((Object)singleEntity2);
            Assert.assertEquals((Object)"type1", (Object)singleEntity2.getType());
            Assert.assertEquals((Object)"entity1", (Object)singleEntity2.getId());
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUIDNotProperlyEscaped() throws Exception {
        Client client = this.createClient();
        try {
            String appUID = "cluster1!user*1!flow_name!1002345678919!application_1111111111_1111";
            URI uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/app-uid/" + appUID);
            this.verifyHttpResponse(client, uri, ClientResponse.Status.BAD_REQUEST);
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFlows() throws Exception {
        Client client = this.createClient();
        try {
            URI uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/flows");
            this.verifyFlowEntites(client, uri, 3, new int[]{3, 2, 1}, new String[]{"flow1", "flow_name", "flow_name2"});
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/flows/");
            this.verifyFlowEntites(client, uri, 3, new int[]{3, 2, 1}, new String[]{"flow1", "flow_name", "flow_name2"});
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/flows?limit=1");
            this.verifyFlowEntites(client, uri, 1, new int[]{3}, new String[]{"flow1"});
            long firstFlowActivity = HBaseTimelineSchemaUtils.getTopOfTheDayTimestamp((long)1425016501000L);
            DateFormat fmt = (DateFormat)TimelineReaderWebServices.DATE_FORMAT.get();
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/flows?daterange=" + fmt.format(firstFlowActivity) + "-" + fmt.format(dayTs));
            this.verifyFlowEntites(client, uri, 3, new int[]{3, 2, 1}, new String[]{"flow1", "flow_name", "flow_name2"});
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/flows?daterange=" + fmt.format(dayTs + 345600000L));
            this.verifyFlowEntites(client, uri, 0, new int[0], new String[0]);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/flows?daterange=-" + fmt.format(dayTs));
            this.verifyFlowEntites(client, uri, 3, new int[]{3, 2, 1}, new String[]{"flow1", "flow_name", "flow_name2"});
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/flows?daterange=" + fmt.format(firstFlowActivity) + "-");
            this.verifyFlowEntites(client, uri, 3, new int[]{3, 2, 1}, new String[]{"flow1", "flow_name", "flow_name2"});
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/flows?daterange=20150711:20150714");
            this.verifyHttpResponse(client, uri, ClientResponse.Status.BAD_REQUEST);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/flows?daterange=20150714-20150711");
            this.verifyHttpResponse(client, uri, ClientResponse.Status.BAD_REQUEST);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/flows?daterange=2015071129-20150712");
            this.verifyHttpResponse(client, uri, ClientResponse.Status.BAD_REQUEST);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/flows?daterange=20150711-2015071243");
            this.verifyHttpResponse(client, uri, ClientResponse.Status.BAD_REQUEST);
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFlowsForPagination() throws Exception {
        Client client = this.createClient();
        int noOfEntities = 3;
        int limit = 2;
        try {
            String flowURI = "http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/flows";
            URI uri = URI.create(flowURI);
            List<FlowActivityEntity> flowEntites = this.verifyFlowEntites(client, uri, 3, new int[]{3, 2, 1}, new String[]{"flow1", "flow_name", "flow_name2"});
            FlowActivityEntity fEntity1 = flowEntites.get(0);
            FlowActivityEntity fEntity3 = flowEntites.get(noOfEntities - 1);
            uri = URI.create(flowURI + "?limit=" + limit);
            flowEntites = this.verifyFlowEntites(client, uri, limit);
            Assert.assertEquals((Object)fEntity1, (Object)flowEntites.get(0));
            FlowActivityEntity fEntity2 = flowEntites.get(limit - 1);
            uri = URI.create(flowURI + "?limit=" + limit + "&fromid=" + fEntity2.getInfo().get("FROM_ID"));
            flowEntites = this.verifyFlowEntites(client, uri, noOfEntities - limit + 1);
            Assert.assertEquals((Object)fEntity2, (Object)flowEntites.get(0));
            Assert.assertEquals((Object)fEntity3, (Object)flowEntites.get(noOfEntities - limit));
            uri = URI.create(flowURI + "?limit=" + limit + "&fromid=" + fEntity3.getInfo().get("FROM_ID"));
            flowEntites = this.verifyFlowEntites(client, uri, 1);
            Assert.assertEquals((Object)fEntity3, (Object)flowEntites.get(0));
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetApp() throws Exception {
        Client client = this.createClient();
        try {
            URI uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111?userid=user1&fields=ALL&flowname=flow_name&flowrunid=1002345678919");
            ClientResponse resp = this.getResponse(client, uri);
            TimelineEntity entity = (TimelineEntity)resp.getEntity(TimelineEntity.class);
            Assert.assertNotNull((Object)entity);
            Assert.assertEquals((Object)"application_1111111111_1111", (Object)entity.getId());
            Assert.assertEquals((long)3L, (long)entity.getMetrics().size());
            TimelineMetric m1 = TestTimelineReaderWebServicesHBaseStorage.newMetric(TimelineMetric.Type.SINGLE_VALUE, "HDFS_BYTES_READ", ts - 80000L, 57L);
            TimelineMetric m2 = TestTimelineReaderWebServicesHBaseStorage.newMetric(TimelineMetric.Type.SINGLE_VALUE, "MAP_SLOT_MILLIS", ts - 80000L, 40L);
            TimelineMetric m3 = TestTimelineReaderWebServicesHBaseStorage.newMetric(TimelineMetric.Type.SINGLE_VALUE, "MAP1_SLOT_MILLIS", ts - 80000L, 40L);
            for (TimelineMetric metric : entity.getMetrics()) {
                Assert.assertTrue((boolean)TestTimelineReaderWebServicesHBaseStorage.verifyMetrics(metric, m1, m2, m3));
            }
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/apps/application_1111111111_2222?userid=user1&fields=metrics&flowname=flow_name&flowrunid=1002345678919");
            resp = this.getResponse(client, uri);
            entity = (TimelineEntity)resp.getEntity(TimelineEntity.class);
            Assert.assertNotNull((Object)entity);
            Assert.assertEquals((Object)"application_1111111111_2222", (Object)entity.getId());
            Assert.assertEquals((long)1L, (long)entity.getMetrics().size());
            TimelineMetric m4 = TestTimelineReaderWebServicesHBaseStorage.newMetric(TimelineMetric.Type.SINGLE_VALUE, "MAP_SLOT_MILLIS", ts - 80000L, 101L);
            for (TimelineMetric metric : entity.getMetrics()) {
                Assert.assertTrue((boolean)TestTimelineReaderWebServicesHBaseStorage.verifyMetrics(metric, m4));
            }
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAppWithoutFlowInfo() throws Exception {
        Client client = this.createClient();
        try {
            URI uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111?fields=ALL");
            ClientResponse resp = this.getResponse(client, uri);
            TimelineEntity entity = (TimelineEntity)resp.getEntity(TimelineEntity.class);
            Assert.assertNotNull((Object)entity);
            Assert.assertEquals((Object)"application_1111111111_1111", (Object)entity.getId());
            Assert.assertEquals((long)1L, (long)entity.getConfigs().size());
            Assert.assertEquals((long)3L, (long)entity.getMetrics().size());
            TimelineMetric m1 = TestTimelineReaderWebServicesHBaseStorage.newMetric(TimelineMetric.Type.SINGLE_VALUE, "HDFS_BYTES_READ", ts - 80000L, 57L);
            TimelineMetric m2 = TestTimelineReaderWebServicesHBaseStorage.newMetric(TimelineMetric.Type.SINGLE_VALUE, "MAP_SLOT_MILLIS", ts - 80000L, 40L);
            TimelineMetric m3 = TestTimelineReaderWebServicesHBaseStorage.newMetric(TimelineMetric.Type.SINGLE_VALUE, "MAP1_SLOT_MILLIS", ts - 80000L, 40L);
            for (TimelineMetric metric : entity.getMetrics()) {
                Assert.assertTrue((boolean)TestTimelineReaderWebServicesHBaseStorage.verifyMetrics(metric, m1, m2, m3));
            }
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111?fields=ALL&metricslimit=10");
            resp = this.getResponse(client, uri);
            entity = (TimelineEntity)resp.getEntity(TimelineEntity.class);
            Assert.assertNotNull((Object)entity);
            Assert.assertEquals((Object)"application_1111111111_1111", (Object)entity.getId());
            Assert.assertEquals((long)1L, (long)entity.getConfigs().size());
            Assert.assertEquals((long)3L, (long)entity.getMetrics().size());
            m1 = TestTimelineReaderWebServicesHBaseStorage.newMetric(TimelineMetric.Type.TIME_SERIES, "HDFS_BYTES_READ", ts - 100000L, 31L);
            m1.addValue(ts - 80000L, (Number)57L);
            m2 = TestTimelineReaderWebServicesHBaseStorage.newMetric(TimelineMetric.Type.TIME_SERIES, "MAP_SLOT_MILLIS", ts - 100000L, 2L);
            m2.addValue(ts - 80000L, (Number)40L);
            m3 = TestTimelineReaderWebServicesHBaseStorage.newMetric(TimelineMetric.Type.TIME_SERIES, "MAP1_SLOT_MILLIS", ts - 100000L, 2L);
            m3.addValue(ts - 80000L, (Number)40L);
            for (TimelineMetric metric : entity.getMetrics()) {
                Assert.assertTrue((boolean)TestTimelineReaderWebServicesHBaseStorage.verifyMetrics(metric, m1, m2, m3));
            }
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntityWithoutFlowInfo() throws Exception {
        Client client = this.createClient();
        try {
            URI uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1/entity1");
            ClientResponse resp = this.getResponse(client, uri);
            TimelineEntity entity = (TimelineEntity)resp.getEntity(TimelineEntity.class);
            Assert.assertNotNull((Object)entity);
            Assert.assertEquals((Object)"entity1", (Object)entity.getId());
            Assert.assertEquals((Object)"type1", (Object)entity.getType());
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntitiesWithoutFlowInfo() throws Exception {
        Client client = this.createClient();
        try {
            URI uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1");
            ClientResponse resp = this.getResponse(client, uri);
            Set entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            for (TimelineEntity entity : entities) {
                Assert.assertTrue((entity.getId().equals("entity1") || entity.getId().equals("entity2") ? 1 : 0) != 0);
            }
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntitiesDataToRetrieve() throws Exception {
        Client client = this.createClient();
        try {
            URI uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?confstoretrieve=cfg_");
            ClientResponse resp = this.getResponse(client, uri);
            Set entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            int cfgCnt = 0;
            for (TimelineEntity entity : entities) {
                cfgCnt += entity.getConfigs().size();
                for (String configKey : entity.getConfigs().keySet()) {
                    Assert.assertTrue((boolean)configKey.startsWith("cfg_"));
                }
            }
            Assert.assertEquals((long)2L, (long)cfgCnt);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?confstoretrieve=cfg_,config_");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            cfgCnt = 0;
            for (TimelineEntity entity : entities) {
                cfgCnt += entity.getConfigs().size();
                for (String configKey : entity.getConfigs().keySet()) {
                    Assert.assertTrue((configKey.startsWith("cfg_") || configKey.startsWith("config_") ? 1 : 0) != 0);
                }
            }
            Assert.assertEquals((long)5L, (long)cfgCnt);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?confstoretrieve=!(cfg_,config_)");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            cfgCnt = 0;
            for (TimelineEntity entity : entities) {
                cfgCnt += entity.getConfigs().size();
                for (String configKey : entity.getConfigs().keySet()) {
                    Assert.assertTrue((boolean)configKey.startsWith("configuration_"));
                }
            }
            Assert.assertEquals((long)1L, (long)cfgCnt);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?metricstoretrieve=MAP_");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            int metricCnt = 0;
            for (TimelineEntity entity : entities) {
                metricCnt += entity.getMetrics().size();
                for (TimelineMetric metric : entity.getMetrics()) {
                    Assert.assertTrue((boolean)metric.getId().startsWith("MAP_"));
                }
            }
            Assert.assertEquals((long)1L, (long)metricCnt);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?metricstoretrieve=MAP1_,HDFS_");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            metricCnt = 0;
            for (TimelineEntity entity : entities) {
                metricCnt += entity.getMetrics().size();
                for (TimelineMetric metric : entity.getMetrics()) {
                    Assert.assertTrue((metric.getId().startsWith("MAP1_") || metric.getId().startsWith("HDFS_") ? 1 : 0) != 0);
                }
            }
            Assert.assertEquals((long)3L, (long)metricCnt);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?metricstoretrieve=!(MAP1_,HDFS_)");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            metricCnt = 0;
            for (TimelineEntity entity : entities) {
                metricCnt += entity.getMetrics().size();
                for (TimelineMetric metric : entity.getMetrics()) {
                    Assert.assertTrue((metric.getId().startsWith("MAP_") || metric.getId().startsWith("MAP11_") ? 1 : 0) != 0);
                }
            }
            Assert.assertEquals((long)2L, (long)metricCnt);
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntitiesConfigFilters() throws Exception {
        Client client = this.createClient();
        try {
            URI uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?conffilters=config_param1%20eq%20value1%20OR%20config_param1%20eq%20value3");
            ClientResponse resp = this.getResponse(client, uri);
            Set entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            for (TimelineEntity entity : entities) {
                Assert.assertTrue((entity.getId().equals("entity1") || entity.getId().equals("entity2") ? 1 : 0) != 0);
            }
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?conffilters=config_param1%20eq%20value1%20AND%20configuration_param2%20eq%20value2");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)0L, (long)entities.size());
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?conffilters=(config_param1%20eq%20value1%20AND%20configuration_param2%20eq%20value2)%20OR%20(config_param1%20eq%20value3%20AND%20cfg_param3%20eq%20value1)");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)1L, (long)entities.size());
            int cfgCnt = 0;
            for (TimelineEntity entity : entities) {
                cfgCnt += entity.getConfigs().size();
                Assert.assertEquals((Object)"entity2", (Object)entity.getId());
            }
            Assert.assertEquals((long)0L, (long)cfgCnt);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?conffilters=(config_param1%20eq%20value1%20AND%20configuration_param2%20eq%20value2)%20OR%20(config_param1%20eq%20value3%20AND%20cfg_param3%20eq%20value1)&fields=CONFIGS");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)1L, (long)entities.size());
            cfgCnt = 0;
            for (TimelineEntity entity : entities) {
                cfgCnt += entity.getConfigs().size();
                Assert.assertEquals((Object)"entity2", (Object)entity.getId());
            }
            Assert.assertEquals((long)3L, (long)cfgCnt);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?conffilters=(config_param1%20eq%20value1%20AND%20configuration_param2%20eq%20value2)%20OR%20(config_param1%20eq%20value3%20AND%20cfg_param3%20eq%20value1)&confstoretrieve=cfg_,configuration_");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)1L, (long)entities.size());
            cfgCnt = 0;
            for (TimelineEntity entity : entities) {
                cfgCnt += entity.getConfigs().size();
                Assert.assertEquals((Object)"entity2", (Object)entity.getId());
                for (String configKey : entity.getConfigs().keySet()) {
                    Assert.assertTrue((configKey.startsWith("cfg_") || configKey.startsWith("configuration_") ? 1 : 0) != 0);
                }
            }
            Assert.assertEquals((long)2L, (long)cfgCnt);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?conffilters=configuration_param2%20ne%20value3");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            for (TimelineEntity entity : entities) {
                Assert.assertTrue((entity.getId().equals("entity1") || entity.getId().equals("entity2") ? 1 : 0) != 0);
            }
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?conffilters=configuration_param2%20ene%20value3");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)1L, (long)entities.size());
            for (TimelineEntity entity : entities) {
                Assert.assertEquals((Object)"entity2", (Object)entity.getId());
            }
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntitiesInfoFilters() throws Exception {
        Client client = this.createClient();
        try {
            URI uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?infofilters=info1%20eq%20cluster1%20OR%20info1%20eq%20cluster2");
            ClientResponse resp = this.getResponse(client, uri);
            Set entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            for (TimelineEntity entity : entities) {
                Assert.assertTrue((entity.getId().equals("entity1") || entity.getId().equals("entity2") ? 1 : 0) != 0);
            }
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?infofilters=info1%20eq%20cluster1%20AND%20info4%20eq%2035000");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)0L, (long)entities.size());
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?infofilters=info4%20eq%2035000%20OR%20info4%20eq%2036000");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            for (TimelineEntity entity : entities) {
                Assert.assertTrue((entity.getId().equals("entity1") || entity.getId().equals("entity2") ? 1 : 0) != 0);
            }
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?infofilters=(info1%20eq%20cluster1%20AND%20info4%20eq%2035000)%20OR%20(info1%20eq%20cluster2%20AND%20info2%20eq%202.0)");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)1L, (long)entities.size());
            int infoCnt = 0;
            for (TimelineEntity entity : entities) {
                infoCnt += entity.getInfo().size();
                Assert.assertEquals((Object)"entity2", (Object)entity.getId());
            }
            Assert.assertEquals((long)2L, (long)infoCnt);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?infofilters=(info1%20eq%20cluster1%20AND%20info4%20eq%2035000)%20OR%20(info1%20eq%20cluster2%20AND%20info2%20eq%202.0)&fields=INFO");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)1L, (long)entities.size());
            infoCnt = 0;
            for (TimelineEntity entity : entities) {
                infoCnt += entity.getInfo().size();
                Assert.assertEquals((Object)"entity2", (Object)entity.getId());
            }
            Assert.assertEquals((long)5L, (long)infoCnt);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?infofilters=info3%20ne%2039000");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            for (TimelineEntity entity : entities) {
                Assert.assertTrue((entity.getId().equals("entity1") || entity.getId().equals("entity2") ? 1 : 0) != 0);
            }
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?infofilters=info3%20ene%2039000");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)1L, (long)entities.size());
            for (TimelineEntity entity : entities) {
                Assert.assertEquals((Object)"entity1", (Object)entity.getId());
            }
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntitiesMetricFilters() throws Exception {
        Client client = this.createClient();
        try {
            URI uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?metricfilters=HDFS_BYTES_READ%20lt%2060%20OR%20HDFS_BYTES_READ%20eq%20157");
            ClientResponse resp = this.getResponse(client, uri);
            Set entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            for (TimelineEntity entity : entities) {
                Assert.assertTrue((entity.getId().equals("entity1") || entity.getId().equals("entity2") ? 1 : 0) != 0);
            }
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?metricfilters=HDFS_BYTES_READ%20lt%2060%20AND%20MAP_SLOT_MILLIS%20gt%2040");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)0L, (long)entities.size());
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?metricfilters=(HDFS_BYTES_READ%20lt%2060%20AND%20MAP_SLOT_MILLIS%20gt%2040)%20OR%20(MAP1_SLOT_MILLIS%20ge%20140%20AND%20MAP11_SLOT_MILLIS%20le%20122)");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)1L, (long)entities.size());
            int metricCnt = 0;
            for (TimelineEntity entity : entities) {
                metricCnt += entity.getMetrics().size();
                Assert.assertEquals((Object)"entity2", (Object)entity.getId());
            }
            Assert.assertEquals((long)0L, (long)metricCnt);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?metricfilters=(HDFS_BYTES_READ%20lt%2060%20AND%20MAP_SLOT_MILLIS%20gt%2040)%20OR%20(MAP1_SLOT_MILLIS%20ge%20140%20AND%20MAP11_SLOT_MILLIS%20le%20122)&fields=METRICS");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)1L, (long)entities.size());
            metricCnt = 0;
            for (TimelineEntity entity : entities) {
                metricCnt += entity.getMetrics().size();
                Assert.assertEquals((Object)"entity2", (Object)entity.getId());
            }
            Assert.assertEquals((long)3L, (long)metricCnt);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?metricfilters=(HDFS_BYTES_READ%20lt%2060%20AND%20MAP_SLOT_MILLIS%20gt%2040)%20OR%20(MAP1_SLOT_MILLIS%20ge%20140%20AND%20MAP11_SLOT_MILLIS%20le%20122)&metricstoretrieve=!(HDFS)");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)1L, (long)entities.size());
            metricCnt = 0;
            for (TimelineEntity entity : entities) {
                metricCnt += entity.getMetrics().size();
                Assert.assertEquals((Object)"entity2", (Object)entity.getId());
                for (TimelineMetric metric : entity.getMetrics()) {
                    Assert.assertTrue((boolean)metric.getId().startsWith("MAP1"));
                    Assert.assertEquals((Object)TimelineMetric.Type.SINGLE_VALUE, (Object)metric.getType());
                }
            }
            Assert.assertEquals((long)2L, (long)metricCnt);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?metricfilters=(HDFS_BYTES_READ%20lt%2060%20AND%20MAP_SLOT_MILLIS%20gt%2040)%20OR%20(MAP1_SLOT_MILLIS%20ge%20140%20AND%20MAP11_SLOT_MILLIS%20le%20122)&metricstoretrieve=!(HDFS)&metricslimit=10");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)1L, (long)entities.size());
            metricCnt = 0;
            for (TimelineEntity entity : entities) {
                metricCnt += entity.getMetrics().size();
                Assert.assertEquals((Object)"entity2", (Object)entity.getId());
                for (TimelineMetric metric : entity.getMetrics()) {
                    Assert.assertTrue((boolean)metric.getId().startsWith("MAP1"));
                    if (metric.getId().equals("MAP1_SLOT_MILLIS")) {
                        Assert.assertEquals((long)2L, (long)metric.getValues().size());
                        Assert.assertEquals((Object)TimelineMetric.Type.TIME_SERIES, (Object)metric.getType());
                        continue;
                    }
                    if (metric.getId().equals("MAP11_SLOT_MILLIS")) {
                        Assert.assertEquals((Object)TimelineMetric.Type.SINGLE_VALUE, (Object)metric.getType());
                        continue;
                    }
                    Assert.fail((String)"Unexpected metric id");
                }
            }
            Assert.assertEquals((long)2L, (long)metricCnt);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?metricfilters=MAP11_SLOT_MILLIS%20ne%20100");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            for (TimelineEntity entity : entities) {
                Assert.assertTrue((entity.getId().equals("entity1") || entity.getId().equals("entity2") ? 1 : 0) != 0);
            }
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?metricfilters=MAP11_SLOT_MILLIS%20ene%20100");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)1L, (long)entities.size());
            for (TimelineEntity entity : entities) {
                Assert.assertEquals((Object)"entity2", (Object)entity.getId());
            }
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntitiesEventFilters() throws Exception {
        Client client = this.createClient();
        try {
            URI uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?eventfilters=event1,event3");
            ClientResponse resp = this.getResponse(client, uri);
            Set entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            for (TimelineEntity entity : entities) {
                Assert.assertTrue((entity.getId().equals("entity1") || entity.getId().equals("entity2") ? 1 : 0) != 0);
            }
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?eventfilters=!(event1,event3)");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)0L, (long)entities.size());
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?eventfilters=!(event1,event3)%20OR%20event5,event6");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)1L, (long)entities.size());
            for (TimelineEntity entity : entities) {
                Assert.assertEquals((Object)"entity2", (Object)entity.getId());
            }
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?eventfilters=(!(event1,event3)%20OR%20event5,event6)%20OR%20(event1,event2%20AND%20(event3,event4))");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            for (TimelineEntity entity : entities) {
                Assert.assertTrue((entity.getId().equals("entity1") || entity.getId().equals("entity2") ? 1 : 0) != 0);
            }
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntitiesRelationFilters() throws Exception {
        Client client = this.createClient();
        try {
            URI uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?isrelatedto=type3:entity31,type2:entity21:entity22");
            ClientResponse resp = this.getResponse(client, uri);
            Set entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            for (TimelineEntity entity : entities) {
                Assert.assertTrue((entity.getId().equals("entity1") || entity.getId().equals("entity2") ? 1 : 0) != 0);
            }
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?isrelatedto=!(type3:entity31,type2:entity21:entity22)");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)0L, (long)entities.size());
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?isrelatedto=!(type3:entity31,type2:entity21:entity22)%20OR%20type5:entity51,type6:entity61:entity66");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)1L, (long)entities.size());
            for (TimelineEntity entity : entities) {
                Assert.assertEquals((Object)"entity2", (Object)entity.getId());
            }
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?isrelatedto=(!(type3:entity31,type2:entity21:entity22)%20OR%20type5:entity51,type6:entity61:entity66)%20OR%20(type1:entity14,type2:entity21:entity22%20AND%20(type3:entity32:entity35,type4:entity42))");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            for (TimelineEntity entity : entities) {
                Assert.assertTrue((entity.getId().equals("entity1") || entity.getId().equals("entity2") ? 1 : 0) != 0);
            }
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?relatesto=!%20(type3:entity31,type2:entity21:entity22%20)%20OR%20type5:entity51,type6:entity61:entity66");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)1L, (long)entities.size());
            for (TimelineEntity entity : entities) {
                Assert.assertEquals((Object)"entity2", (Object)entity.getId());
            }
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?relatesto=(!(%20type3:entity31,type2:entity21:entity22)%20OR%20type5:entity51,type6:entity61:entity66%20)%20OR%20(type1:entity14,type2:entity21:entity22%20AND%20(type3:entity32:entity35%20,%20type4:entity42))");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            for (TimelineEntity entity : entities) {
                Assert.assertTrue((entity.getId().equals("entity1") || entity.getId().equals("entity2") ? 1 : 0) != 0);
            }
        }
        finally {
            client.destroy();
        }
    }

    private static void verifyMetricCount(TimelineEntity entity, int expectedMetricsCnt, int expectedMeticsValCnt) {
        int metricsValCnt = 0;
        for (TimelineMetric m : entity.getMetrics()) {
            metricsValCnt += m.getValues().size();
        }
        Assert.assertEquals((long)expectedMetricsCnt, (long)entity.getMetrics().size());
        Assert.assertEquals((long)expectedMeticsValCnt, (long)metricsValCnt);
    }

    private static void verifyMetricsCount(Set<TimelineEntity> entities, int expectedMetricsCnt, int expectedMeticsValCnt) {
        int metricsCnt = 0;
        int metricsValCnt = 0;
        for (TimelineEntity entity : entities) {
            metricsCnt += entity.getMetrics().size();
            for (TimelineMetric m : entity.getMetrics()) {
                metricsValCnt += m.getValues().size();
            }
        }
        Assert.assertEquals((long)expectedMetricsCnt, (long)metricsCnt);
        Assert.assertEquals((long)expectedMeticsValCnt, (long)metricsValCnt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntitiesMetricsTimeRange() throws Exception {
        Client client = this.createClient();
        try {
            URI uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?fields=ALL&metricslimit=100&metricstimestart=" + (ts - 90000L) + "&metricstimeend=" + (ts - 80000L));
            ClientResponse resp = this.getResponse(client, uri);
            Set entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            TestTimelineReaderWebServicesHBaseStorage.verifyMetricsCount(entities, 4, 4);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?fields=ALL&metricslimit=100&metricstimestart=" + (ts - 100000L) + "&metricstimeend=" + (ts - 80000L));
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            TestTimelineReaderWebServicesHBaseStorage.verifyMetricsCount(entities, 5, 9);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?fields=ALL&metricslimit=100&metricstimestart=" + (ts - 100000L));
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            TestTimelineReaderWebServicesHBaseStorage.verifyMetricsCount(entities, 5, 9);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?fields=ALL&metricslimit=100&metricstimeend=" + (ts - 90000L));
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            TestTimelineReaderWebServicesHBaseStorage.verifyMetricsCount(entities, 5, 5);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?fields=ALL&metricstimestart=" + (ts - 100000L));
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            TestTimelineReaderWebServicesHBaseStorage.verifyMetricsCount(entities, 5, 5);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1/entity2?fields=ALL&metricstimestart=" + (ts - 100000L) + "&metricstimeend=" + (ts - 80000L));
            resp = this.getResponse(client, uri);
            TimelineEntity entity = (TimelineEntity)resp.getEntity(TimelineEntity.class);
            Assert.assertNotNull((Object)entity);
            TestTimelineReaderWebServicesHBaseStorage.verifyMetricCount(entity, 3, 3);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1/entity2?fields=ALL&metricslimit=5&metricstimestart=" + (ts - 100000L) + "&metricstimeend=" + (ts - 80000L));
            resp = this.getResponse(client, uri);
            entity = (TimelineEntity)resp.getEntity(TimelineEntity.class);
            Assert.assertNotNull((Object)entity);
            TestTimelineReaderWebServicesHBaseStorage.verifyMetricCount(entity, 3, 5);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1?fields=ALL&metricslimit=100&metricstimestart=" + (ts - 80000L) + "&metricstimeend=" + (ts - 90000L));
            this.verifyHttpResponse(client, uri, ClientResponse.Status.BAD_REQUEST);
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntityDataToRetrieve() throws Exception {
        Client client = this.createClient();
        try {
            URI uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1/entity2?confstoretrieve=cfg_,configuration_");
            ClientResponse resp = this.getResponse(client, uri);
            TimelineEntity entity = (TimelineEntity)resp.getEntity(TimelineEntity.class);
            Assert.assertNotNull((Object)entity);
            Assert.assertEquals((Object)"entity2", (Object)entity.getId());
            Assert.assertEquals((Object)"type1", (Object)entity.getType());
            Assert.assertEquals((long)2L, (long)entity.getConfigs().size());
            for (String configKey : entity.getConfigs().keySet()) {
                Assert.assertTrue((configKey.startsWith("configuration_") || configKey.startsWith("cfg_") ? 1 : 0) != 0);
            }
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1/entity2?confstoretrieve=!(cfg_,configuration_)");
            resp = this.getResponse(client, uri);
            entity = (TimelineEntity)resp.getEntity(TimelineEntity.class);
            Assert.assertNotNull((Object)entity);
            Assert.assertEquals((Object)"entity2", (Object)entity.getId());
            Assert.assertEquals((Object)"type1", (Object)entity.getType());
            Assert.assertEquals((long)1L, (long)entity.getConfigs().size());
            for (String configKey : entity.getConfigs().keySet()) {
                Assert.assertTrue((boolean)configKey.startsWith("config_"));
            }
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1/entity2?metricstoretrieve=MAP1_,HDFS_");
            resp = this.getResponse(client, uri);
            entity = (TimelineEntity)resp.getEntity(TimelineEntity.class);
            Assert.assertNotNull((Object)entity);
            Assert.assertEquals((Object)"entity2", (Object)entity.getId());
            Assert.assertEquals((Object)"type1", (Object)entity.getType());
            Assert.assertEquals((long)2L, (long)entity.getMetrics().size());
            for (TimelineMetric metric : entity.getMetrics()) {
                Assert.assertTrue((metric.getId().startsWith("MAP1_") || metric.getId().startsWith("HDFS_") ? 1 : 0) != 0);
            }
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1/entity2?metricstoretrieve=!(MAP1_,HDFS_)");
            resp = this.getResponse(client, uri);
            entity = (TimelineEntity)resp.getEntity(TimelineEntity.class);
            Assert.assertNotNull((Object)entity);
            Assert.assertEquals((Object)"entity2", (Object)entity.getId());
            Assert.assertEquals((Object)"type1", (Object)entity.getType());
            Assert.assertEquals((long)1L, (long)entity.getMetrics().size());
            for (TimelineMetric metric : entity.getMetrics()) {
                Assert.assertTrue((boolean)metric.getId().startsWith("MAP11_"));
                Assert.assertEquals((Object)TimelineMetric.Type.SINGLE_VALUE, (Object)metric.getType());
                Assert.assertEquals((long)1L, (long)metric.getValues().size());
            }
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/type1/entity2?metricstoretrieve=!(MAP1_,HDFS_)&metricslimit=5");
            resp = this.getResponse(client, uri);
            entity = (TimelineEntity)resp.getEntity(TimelineEntity.class);
            Assert.assertNotNull((Object)entity);
            Assert.assertEquals((Object)"entity2", (Object)entity.getId());
            Assert.assertEquals((Object)"type1", (Object)entity.getType());
            Assert.assertEquals((long)1L, (long)entity.getMetrics().size());
            for (TimelineMetric metric : entity.getMetrics()) {
                Assert.assertTrue((boolean)metric.getId().startsWith("MAP11_"));
                Assert.assertEquals((Object)TimelineMetric.Type.SINGLE_VALUE, (Object)metric.getType());
            }
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFlowRunApps() throws Exception {
        Client client = this.createClient();
        try {
            URI uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/users/user1/flows/flow_name/runs/1002345678919/apps?fields=ALL");
            ClientResponse resp = this.getResponse(client, uri);
            Set entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            for (TimelineEntity entity : entities) {
                Assert.assertTrue((String)"Unexpected app in result", (entity.getId().equals("application_1111111111_1111") && entity.getMetrics().size() == 3 || entity.getId().equals("application_1111111111_2222") && entity.getMetrics().size() == 1 ? 1 : 0) != 0);
                for (TimelineMetric metric : entity.getMetrics()) {
                    Assert.assertEquals((Object)TimelineMetric.Type.SINGLE_VALUE, (Object)metric.getType());
                    Assert.assertEquals((long)1L, (long)metric.getValues().size());
                }
            }
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/users/user1/flows/flow_name/runs/1002345678919/apps?fields=ALL&metricslimit=2");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            for (TimelineEntity entity : entities) {
                Assert.assertTrue((String)"Unexpected app in result", (entity.getId().equals("application_1111111111_1111") && entity.getMetrics().size() == 3 || entity.getId().equals("application_1111111111_2222") && entity.getMetrics().size() == 1 ? 1 : 0) != 0);
                for (TimelineMetric metric : entity.getMetrics()) {
                    Assert.assertTrue((metric.getValues().size() <= 2 ? 1 : 0) != 0);
                    Assert.assertEquals((Object)TimelineMetric.Type.TIME_SERIES, (Object)metric.getType());
                }
            }
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/users/user1/flows/flow_name/runs/1002345678919/apps");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/users/user1/flows/flow_name/runs/1002345678919/apps?limit=1");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)1L, (long)entities.size());
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFlowApps() throws Exception {
        Client client = this.createClient();
        try {
            TimelineMetric m3;
            TimelineMetric m2;
            TimelineMetric m1;
            URI uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/users/user1/flows/flow_name/apps?fields=ALL");
            ClientResponse resp = this.getResponse(client, uri);
            Set entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)3L, (long)entities.size());
            for (TimelineEntity entity : entities) {
                Assert.assertTrue((String)"Unexpected app in result", (entity.getId().equals("application_1111111111_1111") && entity.getConfigs().size() == 1 && entity.getConfigs().equals(ImmutableMap.of((Object)"cfg2", (Object)"value1")) || entity.getId().equals("application_1111111111_2222") && entity.getConfigs().size() == 1 && entity.getConfigs().equals(ImmutableMap.of((Object)"cfg1", (Object)"value1")) || entity.getId().equals("application_1111111111_2224") && entity.getConfigs().size() == 0 ? 1 : 0) != 0);
                for (TimelineMetric metric : entity.getMetrics()) {
                    if (entity.getId().equals("application_1111111111_1111")) {
                        m1 = TestTimelineReaderWebServicesHBaseStorage.newMetric(TimelineMetric.Type.SINGLE_VALUE, "HDFS_BYTES_READ", ts - 80000L, 57L);
                        m2 = TestTimelineReaderWebServicesHBaseStorage.newMetric(TimelineMetric.Type.SINGLE_VALUE, "MAP_SLOT_MILLIS", ts - 80000L, 40L);
                        m3 = TestTimelineReaderWebServicesHBaseStorage.newMetric(TimelineMetric.Type.SINGLE_VALUE, "MAP1_SLOT_MILLIS", ts - 80000L, 40L);
                        Assert.assertTrue((boolean)TestTimelineReaderWebServicesHBaseStorage.verifyMetrics(metric, m1, m2, m3));
                        continue;
                    }
                    if (entity.getId().equals("application_1111111111_2222")) {
                        m1 = TestTimelineReaderWebServicesHBaseStorage.newMetric(TimelineMetric.Type.SINGLE_VALUE, "MAP_SLOT_MILLIS", ts - 80000L, 101L);
                        Assert.assertTrue((boolean)TestTimelineReaderWebServicesHBaseStorage.verifyMetrics(metric, m1));
                        continue;
                    }
                    if (!entity.getId().equals("application_1111111111_2224")) continue;
                    m1 = TestTimelineReaderWebServicesHBaseStorage.newMetric(TimelineMetric.Type.SINGLE_VALUE, "MAP_SLOT_MILLIS", ts - 80000L, 101L);
                    Assert.assertTrue((boolean)TestTimelineReaderWebServicesHBaseStorage.verifyMetrics(metric, m1));
                }
            }
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/users/user1/flows/flow_name/apps?fields=ALL&metricslimit=6");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)3L, (long)entities.size());
            for (TimelineEntity entity : entities) {
                Assert.assertTrue((String)"Unexpected app in result", (entity.getId().equals("application_1111111111_1111") && entity.getConfigs().size() == 1 && entity.getConfigs().equals(ImmutableMap.of((Object)"cfg2", (Object)"value1")) || entity.getId().equals("application_1111111111_2222") && entity.getConfigs().size() == 1 && entity.getConfigs().equals(ImmutableMap.of((Object)"cfg1", (Object)"value1")) || entity.getId().equals("application_1111111111_2224") && entity.getConfigs().size() == 0 ? 1 : 0) != 0);
                for (TimelineMetric metric : entity.getMetrics()) {
                    if (entity.getId().equals("application_1111111111_1111")) {
                        m1 = TestTimelineReaderWebServicesHBaseStorage.newMetric(TimelineMetric.Type.TIME_SERIES, "HDFS_BYTES_READ", ts - 80000L, 57L);
                        m1.addValue(ts - 100000L, (Number)31L);
                        m2 = TestTimelineReaderWebServicesHBaseStorage.newMetric(TimelineMetric.Type.TIME_SERIES, "MAP_SLOT_MILLIS", ts - 80000L, 40L);
                        m2.addValue(ts - 100000L, (Number)2L);
                        m3 = TestTimelineReaderWebServicesHBaseStorage.newMetric(TimelineMetric.Type.TIME_SERIES, "MAP1_SLOT_MILLIS", ts - 80000L, 40L);
                        m3.addValue(ts - 100000L, (Number)2L);
                        Assert.assertTrue((boolean)TestTimelineReaderWebServicesHBaseStorage.verifyMetrics(metric, m1, m2, m3));
                        continue;
                    }
                    if (entity.getId().equals("application_1111111111_2222")) {
                        m1 = TestTimelineReaderWebServicesHBaseStorage.newMetric(TimelineMetric.Type.TIME_SERIES, "MAP_SLOT_MILLIS", ts - 80000L, 101L);
                        m1.addValue(ts - 100000L, (Number)5L);
                        Assert.assertTrue((boolean)TestTimelineReaderWebServicesHBaseStorage.verifyMetrics(metric, m1));
                        continue;
                    }
                    if (!entity.getId().equals("application_1111111111_2224")) continue;
                    m1 = TestTimelineReaderWebServicesHBaseStorage.newMetric(TimelineMetric.Type.TIME_SERIES, "MAP_SLOT_MILLIS", ts - 80000L, 101L);
                    m1.addValue(ts - 100000L, (Number)5L);
                    Assert.assertTrue((boolean)TestTimelineReaderWebServicesHBaseStorage.verifyMetrics(metric, m1));
                }
            }
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/users/user1/flows/flow_name/apps");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)3L, (long)entities.size());
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/users/user1/flows/flow_name/apps?limit=1");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)1L, (long)entities.size());
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFlowAppsFilters() throws Exception {
        Client client = this.createClient();
        try {
            String entityType = TimelineEntityType.YARN_APPLICATION.toString();
            URI uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/users/user1/flows/flow_name/apps?eventfilters=" + "YARN_APPLICATION_FINISHED");
            ClientResponse resp = this.getResponse(client, uri);
            Set entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)1L, (long)entities.size());
            Assert.assertTrue((String)"Unexpected app in result", (boolean)entities.contains(TestTimelineReaderWebServicesHBaseStorage.newEntity(entityType, "application_1111111111_1111")));
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/users/user1/flows/flow_name/apps?metricfilters=HDFS_BYTES_READ%20ge%200");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)1L, (long)entities.size());
            Assert.assertTrue((String)"Unexpected app in result", (boolean)entities.contains(TestTimelineReaderWebServicesHBaseStorage.newEntity(entityType, "application_1111111111_1111")));
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/users/user1/flows/flow_name/apps?conffilters=cfg1%20eq%20value1");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)1L, (long)entities.size());
            Assert.assertTrue((String)"Unexpected app in result", (boolean)entities.contains(TestTimelineReaderWebServicesHBaseStorage.newEntity(entityType, "application_1111111111_2222")));
        }
        finally {
            client.destroy();
        }
    }

    @Test
    public void testGetFlowRunNotPresent() throws Exception {
        Client client = this.createClient();
        try {
            URI uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/users/user1/flows/flow_name/runs/1002345678929");
            this.verifyHttpResponse(client, uri, ClientResponse.Status.NOT_FOUND);
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFlowsNotPresent() throws Exception {
        Client client = this.createClient();
        try {
            URI uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster2/flows");
            ClientResponse resp = this.getResponse(client, uri);
            Set entities = (Set)resp.getEntity((GenericType)new GenericType<Set<FlowActivityEntity>>(){});
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; charset=utf-8"), (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)0L, (long)entities.size());
        }
        finally {
            client.destroy();
        }
    }

    @Test
    public void testGetAppNotPresent() throws Exception {
        Client client = this.createClient();
        try {
            URI uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1378");
            this.verifyHttpResponse(client, uri, ClientResponse.Status.NOT_FOUND);
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFlowRunAppsNotPresent() throws Exception {
        Client client = this.createClient();
        try {
            URI uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster2/users/user1/flows/flow_name/runs/1002345678919/apps");
            ClientResponse resp = this.getResponse(client, uri);
            Set entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; charset=utf-8"), (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)0L, (long)entities.size());
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFlowAppsNotPresent() throws Exception {
        Client client = this.createClient();
        try {
            URI uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster2/users/user1/flows/flow_name55/apps");
            ClientResponse resp = this.getResponse(client, uri);
            Set entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; charset=utf-8"), (Object)resp.getType().toString());
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)0L, (long)entities.size());
        }
        finally {
            client.destroy();
        }
    }

    @Test
    public void testGenericEntitiesForPagination() throws Exception {
        Client client = this.createClient();
        try {
            String resourceUri = "http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/apps/application_1111111111_1111/entities/entitytype";
            this.verifyEntitiesForPagination(client, resourceUri);
            resourceUri = "http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/users/" + doAsUser + "/entities/entitytype";
            this.verifyEntitiesForPagination(client, resourceUri);
        }
        finally {
            client.destroy();
        }
    }

    private void verifyEntitiesForPagination(Client client, String resourceUri) throws Exception {
        int limit = 10;
        String queryParam = "?limit=" + limit;
        URI uri = URI.create(resourceUri + queryParam);
        ClientResponse resp = this.getResponse(client, uri);
        List entities = (List)resp.getEntity((GenericType)new GenericType<List<TimelineEntity>>(){});
        this.verifyPaginatedEntites(entities, limit, limit);
        limit = 4;
        queryParam = "?limit=" + limit;
        uri = URI.create(resourceUri + queryParam);
        resp = this.getResponse(client, uri);
        entities = (List)resp.getEntity((GenericType)new GenericType<List<TimelineEntity>>(){});
        TimelineEntity entity = this.verifyPaginatedEntites(entities, limit, 10);
        queryParam = "?limit=" + limit + "&fromid=" + entity.getInfo().get("FROM_ID");
        uri = URI.create(resourceUri + queryParam);
        resp = this.getResponse(client, uri);
        entities = (List)resp.getEntity((GenericType)new GenericType<List<TimelineEntity>>(){});
        entity = this.verifyPaginatedEntites(entities, limit, 7);
        queryParam = "?limit=" + limit + "&fromid=" + entity.getInfo().get("FROM_ID");
        uri = URI.create(resourceUri + queryParam);
        resp = this.getResponse(client, uri);
        entities = (List)resp.getEntity((GenericType)new GenericType<List<TimelineEntity>>(){});
        entity = this.verifyPaginatedEntites(entities, limit, 4);
        queryParam = "?limit=" + limit + "&fromid=" + entity.getInfo().get("FROM_ID");
        uri = URI.create(resourceUri + queryParam);
        resp = this.getResponse(client, uri);
        entities = (List)resp.getEntity((GenericType)new GenericType<List<TimelineEntity>>(){});
        entity = this.verifyPaginatedEntites(entities, 1, 1);
    }

    private TimelineEntity verifyPaginatedEntites(List<TimelineEntity> entities, int limit, int startFrom) {
        Assert.assertNotNull(entities);
        Assert.assertEquals((long)limit, (long)entities.size());
        TimelineEntity entity = null;
        for (TimelineEntity timelineEntity : entities) {
            Assert.assertEquals((Object)"entitytype", (Object)timelineEntity.getType());
            Assert.assertEquals((Object)("entityid-" + startFrom), (Object)timelineEntity.getId());
            Assert.assertEquals((long)(11 - startFrom--), (long)timelineEntity.getIdPrefix());
            entity = timelineEntity;
        }
        return entity;
    }

    private List<FlowActivityEntity> verifyFlowEntites(Client client, URI uri, int noOfEntities, int[] a, String[] flowsInSequence) throws Exception {
        ClientResponse resp = this.getResponse(client, uri);
        List entities = (List)resp.getEntity((GenericType)new GenericType<List<FlowActivityEntity>>(){});
        Assert.assertNotNull((Object)entities);
        Assert.assertEquals((long)noOfEntities, (long)entities.size());
        Assert.assertEquals((long)noOfEntities, (long)flowsInSequence.length);
        Assert.assertEquals((long)noOfEntities, (long)a.length);
        int count = 0;
        for (FlowActivityEntity timelineEntity : entities) {
            Assert.assertEquals((Object)flowsInSequence[count], timelineEntity.getInfo().get("SYSTEM_INFO_FLOW_NAME"));
            Assert.assertEquals((long)a[count++], (long)timelineEntity.getFlowRuns().size());
        }
        return entities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testForFlowAppsPagination() throws Exception {
        Client client = this.createClient();
        try {
            int totalAppEntities = 15;
            String resourceUri = "http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/users/user1/flows/flow1/apps";
            URI uri = URI.create(resourceUri);
            ClientResponse resp = this.getResponse(client, uri);
            List entities = (List)resp.getEntity((GenericType)new GenericType<List<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)totalAppEntities, (long)entities.size());
            TimelineEntity entity1 = (TimelineEntity)entities.get(0);
            TimelineEntity entity15 = (TimelineEntity)entities.get(totalAppEntities - 1);
            int limit = 10;
            String queryParam = "?limit=" + limit;
            uri = URI.create(resourceUri + queryParam);
            resp = this.getResponse(client, uri);
            entities = (List)resp.getEntity((GenericType)new GenericType<List<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)limit, (long)entities.size());
            Assert.assertEquals((Object)entity1, entities.get(0));
            TimelineEntity entity10 = (TimelineEntity)entities.get(limit - 1);
            uri = URI.create(resourceUri + queryParam + "&fromid=" + entity10.getInfo().get("FROM_ID"));
            resp = this.getResponse(client, uri);
            entities = (List)resp.getEntity((GenericType)new GenericType<List<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)6L, (long)entities.size());
            Assert.assertEquals((Object)entity10, entities.get(0));
            Assert.assertEquals((Object)entity15, entities.get(5));
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testForFlowRunAppsPagination() throws Exception {
        Client client = this.createClient();
        try {
            int totalAppEntities = 5;
            String resourceUri = "http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/users/user1/flows/flow1/runs/1/apps";
            URI uri = URI.create(resourceUri);
            ClientResponse resp = this.getResponse(client, uri);
            List entities = (List)resp.getEntity((GenericType)new GenericType<List<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)totalAppEntities, (long)entities.size());
            TimelineEntity entity1 = (TimelineEntity)entities.get(0);
            TimelineEntity entity5 = (TimelineEntity)entities.get(totalAppEntities - 1);
            int limit = 3;
            String queryParam = "?limit=" + limit;
            uri = URI.create(resourceUri + queryParam);
            resp = this.getResponse(client, uri);
            entities = (List)resp.getEntity((GenericType)new GenericType<List<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)limit, (long)entities.size());
            Assert.assertEquals((Object)entity1, entities.get(0));
            TimelineEntity entity3 = (TimelineEntity)entities.get(limit - 1);
            uri = URI.create(resourceUri + queryParam + "&fromid=" + entity3.getInfo().get("FROM_ID"));
            resp = this.getResponse(client, uri);
            entities = (List)resp.getEntity((GenericType)new GenericType<List<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)3L, (long)entities.size());
            Assert.assertEquals((Object)entity3, entities.get(0));
            Assert.assertEquals((Object)entity5, entities.get(2));
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testForFlowRunsPagination() throws Exception {
        Client client = this.createClient();
        try {
            int totalRuns = 3;
            String resourceUri = "http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/users/user1/flows/flow1/runs";
            URI uri = URI.create(resourceUri);
            ClientResponse resp = this.getResponse(client, uri);
            List entities = (List)resp.getEntity((GenericType)new GenericType<List<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)totalRuns, (long)entities.size());
            TimelineEntity entity1 = (TimelineEntity)entities.get(0);
            TimelineEntity entity3 = (TimelineEntity)entities.get(totalRuns - 1);
            int limit = 2;
            String queryParam = "?limit=" + limit;
            uri = URI.create(resourceUri + queryParam);
            resp = this.getResponse(client, uri);
            entities = (List)resp.getEntity((GenericType)new GenericType<List<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)limit, (long)entities.size());
            Assert.assertEquals((Object)entity1, entities.get(0));
            TimelineEntity entity2 = (TimelineEntity)entities.get(limit - 1);
            uri = URI.create(resourceUri + queryParam + "&fromid=" + entity2.getInfo().get("FROM_ID"));
            resp = this.getResponse(client, uri);
            entities = (List)resp.getEntity((GenericType)new GenericType<List<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)limit, (long)entities.size());
            Assert.assertEquals((Object)entity2, entities.get(0));
            Assert.assertEquals((Object)entity3, entities.get(1));
            uri = URI.create(resourceUri + queryParam + "&fromid=" + entity3.getInfo().get("FROM_ID"));
            resp = this.getResponse(client, uri);
            entities = (List)resp.getEntity((GenericType)new GenericType<List<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)1L, (long)entities.size());
            Assert.assertEquals((Object)entity3, entities.get(0));
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAppsMetricsRange() throws Exception {
        Client client = this.createClient();
        try {
            URI uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/users/user1/flows/flow_name/runs/1002345678919/apps?fields=ALL&metricslimit=100&metricstimestart=" + (ts - 200000L) + "&metricstimeend=" + (ts - 100000L));
            ClientResponse resp = this.getResponse(client, uri);
            Set entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            TestTimelineReaderWebServicesHBaseStorage.verifyMetricsCount(entities, 4, 4);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/users/user1/flows/flow_name/runs/1002345678919/apps?fields=ALL&metricslimit=100");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            TestTimelineReaderWebServicesHBaseStorage.verifyMetricsCount(entities, 4, 10);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/users/user1/flows/flow_name/apps?fields=ALL&metricslimit=100&metricstimestart=" + (ts - 200000L) + "&metricstimeend=" + (ts - 100000L));
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)3L, (long)entities.size());
            TestTimelineReaderWebServicesHBaseStorage.verifyMetricsCount(entities, 5, 5);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/users/user1/flows/flow_name/apps?fields=ALL&metricslimit=100");
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)3L, (long)entities.size());
            TestTimelineReaderWebServicesHBaseStorage.verifyMetricsCount(entities, 5, 12);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/users/user1/flows/flow_name/runs/1002345678919/apps?fields=ALL&metricslimit=100&metricstimestart=" + (ts - 200000L));
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            TestTimelineReaderWebServicesHBaseStorage.verifyMetricsCount(entities, 4, 10);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/users/user1/flows/flow_name/runs/1002345678919/apps?fields=ALL&metricslimit=100&metricstimeend=" + (ts - 100000L));
            resp = this.getResponse(client, uri);
            entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertNotNull((Object)entities);
            Assert.assertEquals((long)2L, (long)entities.size());
            TestTimelineReaderWebServicesHBaseStorage.verifyMetricsCount(entities, 4, 4);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/apps/application_1111111111_1111?userid=user1&fields=ALL&flowname=flow_name&flowrunid=1002345678919&metricslimit=100&metricstimestart=" + (ts - 200000L) + "&metricstimeend=" + (ts - 100000L));
            resp = this.getResponse(client, uri);
            TimelineEntity entity = (TimelineEntity)resp.getEntity(TimelineEntity.class);
            Assert.assertNotNull((Object)entity);
            TestTimelineReaderWebServicesHBaseStorage.verifyMetricCount(entity, 3, 3);
            uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/clusters/cluster1/users/user1/flows/flow_name/apps?fields=ALL&metricslimit=100&metricstimestart=" + (ts - 100000L) + "&metricstimeend=" + (ts - 200000L));
            this.verifyHttpResponse(client, uri, ClientResponse.Status.BAD_REQUEST);
        }
        finally {
            client.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntityWithSystemEntityType() throws Exception {
        Client client = this.createClient();
        try {
            URI uri = URI.create("http://localhost:" + TestTimelineReaderWebServicesHBaseStorage.getServerPort() + "/ws/v2/timeline/apps/application_1111111111_1111/entities/YARN_APPLICATION");
            ClientResponse resp = this.getResponse(client, uri);
            Set entities = (Set)resp.getEntity((GenericType)new GenericType<Set<TimelineEntity>>(){});
            Assert.assertEquals((long)0L, (long)entities.size());
        }
        finally {
            client.destroy();
        }
    }
}

