/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.common;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.TagUtil;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.AggregationCompactionDimension;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.AggregationOperation;

public final class HBaseTimelineServerUtils {
    private HBaseTimelineServerUtils() {
    }

    public static Tag getTagFromAttribute(Map.Entry<String, byte[]> attribute) {
        AggregationOperation aggOp = AggregationOperation.getAggregationOperation((String)attribute.getKey());
        if (aggOp != null) {
            Tag t = HBaseTimelineServerUtils.createTag(aggOp.getTagType(), attribute.getValue());
            return t;
        }
        AggregationCompactionDimension aggCompactDim = AggregationCompactionDimension.getAggregationCompactionDimension((String)attribute.getKey());
        if (aggCompactDim != null) {
            Tag t = HBaseTimelineServerUtils.createTag(aggCompactDim.getTagType(), attribute.getValue());
            return t;
        }
        return null;
    }

    public static Cell createNewCell(Cell origCell, byte[] newValue) throws IOException {
        return CellUtil.createCell((byte[])CellUtil.cloneRow((Cell)origCell), (byte[])CellUtil.cloneFamily((Cell)origCell), (byte[])CellUtil.cloneQualifier((Cell)origCell), (long)origCell.getTimestamp(), (byte)KeyValue.Type.Put.getCode(), (byte[])newValue);
    }

    public static Cell createNewCell(byte[] row, byte[] family, byte[] qualifier, long ts, byte[] newValue, byte[] tags) throws IOException {
        return CellUtil.createCell((byte[])row, (byte[])family, (byte[])qualifier, (long)ts, (KeyValue.Type)KeyValue.Type.Put, (byte[])newValue, (byte[])tags);
    }

    public static Tag createTag(byte tagType, byte[] tag) {
        return new ArrayBackedTag(tagType, tag);
    }

    public static Tag createTag(byte tagType, String tag) {
        return HBaseTimelineServerUtils.createTag(tagType, Bytes.toBytes((String)tag));
    }

    public static List<Tag> convertCellAsTagList(Cell cell) {
        return TagUtil.asList((byte[])cell.getTagsArray(), (int)cell.getTagsOffset(), (int)cell.getTagsLength());
    }

    public static byte[] convertTagListToByteArray(List<Tag> tags) {
        return TagUtil.fromList(tags);
    }

    public static String getAggregationCompactionDimension(List<Tag> tags) {
        String appId = null;
        for (Tag t : tags) {
            if (AggregationCompactionDimension.APPLICATION_ID.getTagType() != t.getType()) continue;
            appId = Bytes.toString((byte[])Tag.cloneValue((Tag)t));
            return appId;
        }
        return appId;
    }

    public static AggregationOperation getAggregationOperationFromTagsList(List<Tag> tags) {
        for (AggregationOperation aggOp : AggregationOperation.values()) {
            for (Tag tag : tags) {
                if (tag.getType() != aggOp.getTagType()) continue;
                return aggOp;
            }
        }
        return null;
    }

    public static int flushCompactTableRegions(HRegionServer server, TableName table) throws IOException {
        List regions = server.getRegions(table);
        for (HRegion region : regions) {
            region.flush(true);
            region.compact(true);
        }
        return regions.size();
    }

    public static void validateFlowRunCoprocessor(HRegionServer server, TableName table, boolean existenceExpected) throws Exception {
        List regions = server.getRegions(table);
        for (HRegion region : regions) {
            boolean found = false;
            Set coprocs = region.getCoprocessorHost().getCoprocessors();
            for (String coprocName : coprocs) {
                if (!coprocName.contains("FlowRunCoprocessor")) continue;
                found = true;
            }
            if (found == existenceExpected) continue;
            throw new Exception("FlowRunCoprocessor is" + (existenceExpected ? " not " : " ") + "loaded in table " + table);
        }
    }
}

