/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.thirdparty.com.google.common.collect.Iterables;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSeparator {
    private static String villain = "Dr. Heinz Doofenshmirtz";
    private static String special = ".   *   |   ?   +   \t   (   )   [   ]   {   }   ^   $  \\ \"  %";

    @Test
    void testEncodeDecodeString() {
        for (Separator separator : Separator.values()) {
            this.testEncodeDecode(separator, "");
            this.testEncodeDecode(separator, " ");
            this.testEncodeDecode(separator, "!");
            this.testEncodeDecode(separator, "?");
            this.testEncodeDecode(separator, "&");
            this.testEncodeDecode(separator, "+");
            this.testEncodeDecode(separator, "\t");
            this.testEncodeDecode(separator, "Dr.");
            this.testEncodeDecode(separator, "Heinz");
            this.testEncodeDecode(separator, "Doofenshmirtz");
            this.testEncodeDecode(separator, villain);
            this.testEncodeDecode(separator, special);
            Assertions.assertNull((Object)separator.encode(null));
        }
    }

    private void testEncodeDecode(Separator separator, String token) {
        String encoded = separator.encode(token);
        String decoded = separator.decode(encoded);
        String msg = "token:" + token + " separator:" + separator + ".";
        Assertions.assertEquals((Object)token, (Object)decoded, (String)msg);
    }

    @Test
    void testEncodeDecode() {
        TestSeparator.testEncodeDecode("Dr.", Separator.QUALIFIERS);
        TestSeparator.testEncodeDecode("Heinz", Separator.QUALIFIERS, Separator.QUALIFIERS);
        TestSeparator.testEncodeDecode("Doofenshmirtz", Separator.QUALIFIERS, null, Separator.QUALIFIERS);
        TestSeparator.testEncodeDecode("&Perry", Separator.QUALIFIERS, Separator.VALUES, null);
        TestSeparator.testEncodeDecode("the ", Separator.QUALIFIERS, Separator.SPACE);
        TestSeparator.testEncodeDecode("Platypus...", new Separator[]{null});
        TestSeparator.testEncodeDecode("The what now ?!?", Separator.QUALIFIERS, Separator.VALUES, Separator.SPACE);
    }

    @Test
    void testEncodedValues() {
        TestSeparator.testEncodeDecode("Double-escape %2$ and %9$ or %%2$ or %%3$, nor  %%%2$= no problem!", Separator.QUALIFIERS, Separator.VALUES, Separator.SPACE, Separator.TAB);
    }

    @Test
    void testSplits() {
        byte[] maxLongBytes = Bytes.toBytes((long)Long.MAX_VALUE);
        byte[] maxIntBytes = Bytes.toBytes((int)Integer.MAX_VALUE);
        for (Separator separator : Separator.values()) {
            int[] sizes22;
            String str1 = "cl" + separator.getValue() + "us";
            String str2 = separator.getValue() + "rst";
            byte[] sepByteArr = Bytes.toBytes((String)separator.getValue());
            byte[] longVal1Arr = Bytes.add((byte[])sepByteArr, (byte[])Bytes.copy((byte[])maxLongBytes, (int)sepByteArr.length, (int)(8 - sepByteArr.length)));
            byte[] intVal1Arr = Bytes.add((byte[])sepByteArr, (byte[])Bytes.copy((byte[])maxIntBytes, (int)sepByteArr.length, (int)(4 - sepByteArr.length)));
            byte[] arr = separator.join((byte[][])new byte[][]{Bytes.toBytes((String)separator.encode(str1)), longVal1Arr, Bytes.toBytes((String)separator.encode(str2)), intVal1Arr});
            int[] sizes = new int[]{0, 8, 0, 4};
            byte[][] splits = separator.split(arr, sizes);
            Assertions.assertEquals((int)4, (int)splits.length);
            Assertions.assertEquals((Object)str1, (Object)separator.decode(Bytes.toString((byte[])splits[0])));
            Assertions.assertEquals((long)Bytes.toLong((byte[])longVal1Arr), (long)Bytes.toLong((byte[])splits[1]));
            Assertions.assertEquals((Object)str2, (Object)separator.decode(Bytes.toString((byte[])splits[2])));
            Assertions.assertEquals((int)Bytes.toInt((byte[])intVal1Arr), (int)Bytes.toInt((byte[])splits[3]));
            longVal1Arr = Bytes.add((byte[])Bytes.copy((byte[])maxLongBytes, (int)0, (int)(8 - sepByteArr.length)), (byte[])sepByteArr);
            intVal1Arr = Bytes.add((byte[])Bytes.copy((byte[])maxIntBytes, (int)0, (int)(4 - sepByteArr.length)), (byte[])sepByteArr);
            arr = separator.join((byte[][])new byte[][]{Bytes.toBytes((String)separator.encode(str1)), longVal1Arr, Bytes.toBytes((String)separator.encode(str2)), intVal1Arr});
            splits = separator.split(arr, sizes);
            Assertions.assertEquals((int)4, (int)splits.length);
            Assertions.assertEquals((Object)str1, (Object)separator.decode(Bytes.toString((byte[])splits[0])));
            Assertions.assertEquals((long)Bytes.toLong((byte[])longVal1Arr), (long)Bytes.toLong((byte[])splits[1]));
            Assertions.assertEquals((Object)str2, (Object)separator.decode(Bytes.toString((byte[])splits[2])));
            Assertions.assertEquals((int)Bytes.toInt((byte[])intVal1Arr), (int)Bytes.toInt((byte[])splits[3]));
            longVal1Arr = Bytes.add((byte[])sepByteArr, (byte[])Bytes.copy((byte[])maxLongBytes, (int)sepByteArr.length, (int)(4 - sepByteArr.length)), (byte[])sepByteArr);
            longVal1Arr = Bytes.add((byte[])longVal1Arr, (byte[])Bytes.copy((byte[])maxLongBytes, (int)4, (int)(3 - sepByteArr.length)), (byte[])sepByteArr);
            arr = separator.join((byte[][])new byte[][]{Bytes.toBytes((String)separator.encode(str1)), longVal1Arr, Bytes.toBytes((String)separator.encode(str2)), intVal1Arr});
            splits = separator.split(arr, sizes);
            Assertions.assertEquals((int)4, (int)splits.length);
            Assertions.assertEquals((Object)str1, (Object)separator.decode(Bytes.toString((byte[])splits[0])));
            Assertions.assertEquals((long)Bytes.toLong((byte[])longVal1Arr), (long)Bytes.toLong((byte[])splits[1]));
            Assertions.assertEquals((Object)str2, (Object)separator.decode(Bytes.toString((byte[])splits[2])));
            Assertions.assertEquals((int)Bytes.toInt((byte[])intVal1Arr), (int)Bytes.toInt((byte[])splits[3]));
            arr = separator.join((byte[][])new byte[][]{Bytes.toBytes((String)separator.encode(str1)), Bytes.toBytes((String)separator.encode(str2)), intVal1Arr, longVal1Arr});
            int[] sizes1 = new int[]{0, 0, 4, 8};
            splits = separator.split(arr, sizes1);
            Assertions.assertEquals((int)4, (int)splits.length);
            Assertions.assertEquals((Object)str1, (Object)separator.decode(Bytes.toString((byte[])splits[0])));
            Assertions.assertEquals((Object)str2, (Object)separator.decode(Bytes.toString((byte[])splits[1])));
            Assertions.assertEquals((int)Bytes.toInt((byte[])intVal1Arr), (int)Bytes.toInt((byte[])splits[2]));
            Assertions.assertEquals((long)Bytes.toLong((byte[])longVal1Arr), (long)Bytes.toLong((byte[])splits[3]));
            try {
                sizes22 = new int[]{0, 0, 4, 7};
                splits = separator.split(arr, sizes22);
                Assertions.fail((String)"Exception should have been thrown.");
            }
            catch (IllegalArgumentException sizes22) {
                // empty catch block
            }
            try {
                sizes22 = new int[]{0, 0, 2, 8};
                splits = separator.split(arr, sizes22);
                Assertions.fail((String)"Exception should have been thrown.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private static void testEncodeDecode(String token, Separator ... separators) {
        byte[] encoded = Separator.encode((String)token, (Separator[])separators);
        String decoded = Separator.decode((byte[])encoded, (Separator[])separators);
        Assertions.assertEquals((Object)token, (Object)decoded);
    }

    @Test
    void testJoinStripped() {
        ArrayList<String> stringList = new ArrayList<String>(0);
        stringList.add("nothing");
        String joined = Separator.VALUES.joinEncoded(stringList);
        Collection split = Separator.VALUES.splitEncoded(joined);
        Assertions.assertTrue((boolean)Iterables.elementsEqual(stringList, (Iterable)split));
        stringList = new ArrayList(3);
        stringList.add("a");
        stringList.add("b?");
        stringList.add("c");
        joined = Separator.VALUES.joinEncoded(stringList);
        split = Separator.VALUES.splitEncoded(joined);
        Assertions.assertTrue((boolean)Iterables.elementsEqual(stringList, (Iterable)split));
        String[] stringArray1 = new String[]{"else"};
        joined = Separator.VALUES.joinEncoded(stringArray1);
        split = Separator.VALUES.splitEncoded(joined);
        Assertions.assertTrue((boolean)Iterables.elementsEqual(Arrays.asList(stringArray1), (Iterable)split));
        String[] stringArray2 = new String[]{"d", "e?", "f"};
        joined = Separator.VALUES.joinEncoded(stringArray2);
        split = Separator.VALUES.splitEncoded(joined);
        Assertions.assertTrue((boolean)Iterables.elementsEqual(Arrays.asList(stringArray2), (Iterable)split));
        ArrayList empty = new ArrayList(0);
        split = Separator.VALUES.splitEncoded(null);
        Assertions.assertTrue((boolean)Iterables.elementsEqual(empty, (Iterable)split));
    }
}

