/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineDataToRetrieve;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineEntityFilters;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineStorageMonitor;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.HBaseTimelineStorageUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.reader.TimelineEntityReader;
import org.apache.hadoop.yarn.server.timelineservice.storage.reader.TimelineEntityReaderFactory;

public class HBaseStorageMonitor
extends TimelineStorageMonitor {
    protected static final TimelineEntityFilters MONITOR_FILTERS = new TimelineEntityFilters.Builder().entityLimit(Long.valueOf(1L)).build();
    protected static final TimelineDataToRetrieve DATA_TO_RETRIEVE = new TimelineDataToRetrieve(null, null, null, null, null, null);
    private Configuration monitorHBaseConf;
    private Connection monitorConn;
    private TimelineEntityReader reader;

    public HBaseStorageMonitor(Configuration conf) throws Exception {
        super(conf, TimelineStorageMonitor.Storage.HBase);
        this.initialize(conf);
    }

    private void initialize(Configuration conf) throws Exception {
        this.monitorHBaseConf = HBaseTimelineStorageUtils.getTimelineServiceHBaseConf(conf);
        this.monitorHBaseConf.setInt("hbase.client.retries.number", 3);
        this.monitorHBaseConf.setLong("hbase.client.pause", 1000L);
        long monitorInterval = conf.getLong("yarn.timeline-service.reader.storage-monitor.interval-ms", 60000L);
        this.monitorHBaseConf.setLong("hbase.rpc.timeout", monitorInterval);
        this.monitorHBaseConf.setLong("hbase.client.scanner.timeout.period", monitorInterval);
        this.monitorHBaseConf.setInt("zookeeper.recovery.retry", 1);
        this.monitorConn = ConnectionFactory.createConnection((Configuration)this.monitorHBaseConf);
        String clusterId = conf.get("yarn.resourcemanager.cluster-id", "yarn_cluster");
        TimelineReaderContext monitorContext = new TimelineReaderContext(clusterId, null, null, null, null, TimelineEntityType.YARN_FLOW_ACTIVITY.toString(), null, null);
        this.reader = TimelineEntityReaderFactory.createMultipleEntitiesReader(monitorContext, MONITOR_FILTERS, DATA_TO_RETRIEVE);
    }

    public void healthCheck() throws Exception {
        this.reader.readEntities(this.monitorHBaseConf, this.monitorConn);
    }

    public void start() {
        super.start();
    }

    public void stop() throws Exception {
        super.stop();
        this.monitorConn.close();
    }
}

