/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.documentstore.lib;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.DocumentStoreUtils;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.TimelineDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.lib.DocumentStoreNotSupportedException;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.lib.DocumentStoreVendor;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.reader.DocumentStoreReader;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.reader.cosmosdb.CosmosDBDocumentStoreReader;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.writer.DocumentStoreWriter;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.writer.cosmosdb.CosmosDBDocumentStoreWriter;

public final class DocumentStoreFactory {
    private DocumentStoreFactory() {
    }

    public static <Document extends TimelineDocument> DocumentStoreWriter<Document> createDocumentStoreWriter(Configuration conf) throws YarnException {
        DocumentStoreVendor storeType = DocumentStoreUtils.getStoreVendor(conf);
        switch (storeType) {
            case COSMOS_DB: {
                DocumentStoreUtils.validateCosmosDBConf(conf);
                return new CosmosDBDocumentStoreWriter(conf);
            }
        }
        throw new DocumentStoreNotSupportedException("Unable to create DocumentStoreWriter for type : " + storeType);
    }

    public static <Document extends TimelineDocument> DocumentStoreReader<Document> createDocumentStoreReader(Configuration conf) throws YarnException {
        DocumentStoreVendor storeType = DocumentStoreUtils.getStoreVendor(conf);
        switch (storeType) {
            case COSMOS_DB: {
                DocumentStoreUtils.validateCosmosDBConf(conf);
                return new CosmosDBDocumentStoreReader(conf);
            }
        }
        throw new DocumentStoreNotSupportedException("Unable to create DocumentStoreReader for type : " + storeType);
    }
}

