/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.documentstore.writer.cosmosdb;

import com.microsoft.azure.cosmosdb.rx.AsyncDocumentClient;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.DocumentStoreTestUtils;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.DocumentStoreUtils;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.CollectionType;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.TimelineDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.entity.TimelineEntityDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.writer.cosmosdb.MockedCosmosDBDocumentStoreWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class TestCosmosDBDocumentStoreWriter {
    @BeforeEach
    public void setUp() {
        AsyncDocumentClient asyncDocumentClient = (AsyncDocumentClient)Mockito.mock(AsyncDocumentClient.class);
        Configuration conf = (Configuration)Mockito.mock(Configuration.class);
        Mockito.mockStatic(DocumentStoreUtils.class);
        Mockito.when((Object)DocumentStoreUtils.getCosmosDBDatabaseName((Configuration)conf)).thenReturn((Object)"FooBar");
        Mockito.when((Object)DocumentStoreUtils.createCosmosDBAsyncClient((Configuration)conf)).thenReturn((Object)asyncDocumentClient);
    }

    @Test
    public void applyingUpdatesOnPrevDocTest() throws IOException {
        MockedCosmosDBDocumentStoreWriter documentStoreWriter = new MockedCosmosDBDocumentStoreWriter(null);
        TimelineEntityDocument actualEntityDoc = new TimelineEntityDocument();
        TimelineEntityDocument expectedEntityDoc = DocumentStoreTestUtils.bakeTimelineEntityDoc();
        Assertions.assertEquals((int)1, (int)actualEntityDoc.getInfo().size());
        Assertions.assertEquals((int)0, (int)actualEntityDoc.getMetrics().size());
        Assertions.assertEquals((int)0, (int)actualEntityDoc.getEvents().size());
        Assertions.assertEquals((int)0, (int)actualEntityDoc.getConfigs().size());
        Assertions.assertEquals((int)0, (int)actualEntityDoc.getIsRelatedToEntities().size());
        Assertions.assertEquals((int)0, (int)actualEntityDoc.getRelatesToEntities().size());
        actualEntityDoc = (TimelineEntityDocument)documentStoreWriter.applyUpdatesOnPrevDoc(CollectionType.ENTITY, (TimelineDocument)actualEntityDoc, null);
        Assertions.assertEquals((int)expectedEntityDoc.getInfo().size(), (int)actualEntityDoc.getInfo().size());
        Assertions.assertEquals((int)expectedEntityDoc.getMetrics().size(), (int)actualEntityDoc.getMetrics().size());
        Assertions.assertEquals((int)expectedEntityDoc.getEvents().size(), (int)actualEntityDoc.getEvents().size());
        Assertions.assertEquals((int)expectedEntityDoc.getConfigs().size(), (int)actualEntityDoc.getConfigs().size());
        Assertions.assertEquals((int)expectedEntityDoc.getRelatesToEntities().size(), (int)actualEntityDoc.getIsRelatedToEntities().size());
        Assertions.assertEquals((int)expectedEntityDoc.getRelatesToEntities().size(), (int)actualEntityDoc.getRelatesToEntities().size());
    }
}

