/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.documentstore.reader.cosmosdb;

import com.microsoft.azure.cosmosdb.rx.AsyncDocumentClient;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.DocumentStoreUtils;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.reader.cosmosdb.CosmosDBDocumentStoreReader;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class TestCosmosDBDocumentStoreReader {
    @BeforeEach
    public void setUp() {
        AsyncDocumentClient asyncDocumentClient = (AsyncDocumentClient)Mockito.mock(AsyncDocumentClient.class);
        Configuration conf = (Configuration)Mockito.mock(Configuration.class);
        Mockito.mockStatic(DocumentStoreUtils.class);
        Mockito.when((Object)DocumentStoreUtils.getCosmosDBDatabaseName((Configuration)conf)).thenReturn((Object)"FooBar");
        Mockito.when((Object)DocumentStoreUtils.createCosmosDBAsyncClient((Configuration)conf)).thenReturn((Object)asyncDocumentClient);
    }

    @Test
    public void testFailureFOnEmptyPredicates() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Mockito.when((Object)DocumentStoreUtils.isNullOrEmpty((String[])((String[])ArgumentMatchers.any()))).thenReturn((Object)Boolean.TRUE);
            CosmosDBDocumentStoreReader cosmosDBDocumentStoreReader = new CosmosDBDocumentStoreReader(null);
            cosmosDBDocumentStoreReader.addPredicates(new TimelineReaderContext(null, "", "", null, "", "", null), "DummyCollection", new StringBuilder());
        });
    }
}

